/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.XSSecureIdI;
import oracle.jdbc.internal.XSSecureId;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
final class T4CTTIoxsdet
extends T4CTTIfun {
    private int opcode;
    private byte[] sessionId;
    private XSSecureId secureId;

    T4CTTIoxsdet(T4CConnection t4CConnection) {
        super(t4CConnection, (byte)3);
        this.setFunCode((short)181);
    }

    void doOXSDET(int n2, byte[] byArray, XSSecureId xSSecureId, boolean bl) throws IOException, SQLException {
        if (bl) {
            this.setTTCCode((byte)3);
        } else {
            this.setTTCCode((byte)17);
        }
        this.opcode = n2;
        this.sessionId = byArray;
        this.secureId = xSSecureId;
        if (bl) {
            this.doRPC();
        } else {
            this.doPigRPC();
        }
    }

    @Override
    void marshal() throws IOException {
        this.meg.marshalUB4(this.opcode);
        boolean bl = false;
        if (this.sessionId != null && this.sessionId.length > 0) {
            bl = true;
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.sessionId.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        if (this.secureId == null) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        if (bl) {
            this.meg.marshalB1Array(this.sessionId);
        }
        if (this.secureId != null) {
            ((XSSecureIdI)this.secureId).marshal(this.meg);
        }
    }
}

