/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.net.resolver.EnvVariableResolver;

public class EZConnectResolver {
    private static final String DESCRIPTION_FORMAT = "(DESCRIPTION=%s%s%s%s)";
    private static final String ADDRESS_LIST_FORMAT = "(ADDRESS_LIST=(LOAD_BALANCE=%s)%s)";
    private static final String ADDRESS_FORMAT = "(ADDRESS=(PROTOCOL=%s)(HOST=%s)(PORT=%s)%s)";
    private static final String HTTPS_PROXY_FORMAT = "(HTTPS_PROXY=%s)";
    private static final String HTTPS_PROXY_PORT_FORMAT = "(HTTPS_PROXY_PORT=%s)";
    private static final String CONNECT_DATA_FORMAT = "(CONNECT_DATA=%s%s%s%s)";
    private static final String SERVICE_NAME_FORMAT = "(SERVICE_NAME=%s)";
    private static final String SERVER_MODE_FORMAT = "(SERVER=%s)";
    private static final String INSTANCE_NAME_FORMAT = "(INSTANCE_NAME=%s)";
    private static final String SERVICE_TAG_FORMAT = "(SERVICE_TAG=%s)";
    private static final String SECURITY_FORMAT = "(SECURITY=%s)";
    private static final String SERVER_DN_MATCH_FORMAT = "(SSL_SERVER_DN_MATCH=%s)";
    private static final String SERVER_DN_FORMAT = "(SSL_SERVER_CERT_DN=%s)";
    private static final String MY_WALLET_DIR_FORMAT = "(MY_WALLET_DIRECTORY=%s)";
    private static final String ENCRYPTION_CLIENT_FORMAT = "(ENCRYPTION_CLIENT=%s)";
    private static final String ENCRYPTION_TYPES_CLIENT_FORMAT = "(ENCRYPTION_TYPES_CLIENT=%s)";
    private static final String CRYPTO_CHECKSUM_CLIENT_FORMAT = "(CRYPTO_CHECKSUM_CLIENT=%s)";
    private static final String CRYPTO_CHECKSUM_TYPES_CLIENT_FORMAT = "(CRYPTO_CHECKSUM_TYPES_CLIENT=%s)";
    private static final String EMPTY_STRING = "";
    private static final String KEY_VALUE_FORMAT = "(%s=%s)";
    private static final Pattern HOST_INFO_PATTERN = Pattern.compile("(?<hostnames>(((\\[[A-z0-9:]+\\])|([A-z0-9][A-z0-9._-]+)),?)+)(:(?<port>\\d+))?");
    private static final Pattern EZ_URL_PATTERN = Pattern.compile("((?<protocol>tcp|tcps):)?(//)?(?<hostinfo>(" + HOST_INFO_PATTERN.pattern() + ")+)(/(?<servicename>[A-z][A-z0-9,-.]+))?(:(?<servermode>dedicated|shared|pooled))?(/(?<instance>[A-z][A-z0-9]+))?", 2);
    private static final String EXT_TNS_ADMIN_KEYWORD = "TNS_ADMIN";
    private static final char EXT_DOUBLE_QT = '\"';
    private static final char EXT_KEY_VAL_SEP = '=';
    private static final char EXT_PARAM_SEP = '&';
    private static final char EXT_ESCAPE_CHAR = '\\';
    private static final Map<String, String> URL_PROPS_ALIAS = EZConnectResolver.initializeUrlAlias();
    private static final Map<String, String> CONNECTION_PROPS_ALIAS = EZConnectResolver.initializeConnectionPropertiesAlias();
    private static final List<String> DESCRIPTION_PARAMS = Collections.unmodifiableList(Arrays.asList("ENABLE", "FAILOVER", "LOAD_BALANCE", "RECV_BUF_SIZE", "SEND_BUF_SIZE", "SDU", "SOURCE_ROUTE", "RETRY_COUNT", "RETRY_DELAY", "CONNECT_TIMEOUT", "TRANSPORT_CONNECT_TIMEOUT", "POOL_CONNECTION_CLASS", "POOL_PURITY"));
    private final String url;
    private String resolvedUrl;
    private final Properties connectionProps = new Properties();
    private final Properties urlProps = new Properties();
    private final String urlPrefix;

    private EZConnectResolver(String string) {
        int n2 = string.indexOf(64);
        if (n2 != -1) {
            this.url = string.substring(n2 + 1);
            this.urlPrefix = string.substring(0, n2 + 1);
        } else {
            this.url = string;
            this.urlPrefix = EMPTY_STRING;
        }
        this.parse();
    }

    public static EZConnectResolver newInstance(String string) {
        return new EZConnectResolver(string);
    }

    public String getResolvedUrl() {
        return this.resolvedUrl;
    }

    @Blind(value=PropertiesBlinder.class)
    public Properties getProperties() {
        return this.connectionProps;
    }

    private void parse() {
        String string = this.parseExtendedSettings(this.url);
        if (this.connectionProps.isEmpty() && this.urlProps.isEmpty()) {
            string = this.url;
        }
        this.resolvedUrl = string.startsWith("(") ? this.urlPrefix + string : this.urlPrefix + this.resolveToLongURLFormat(string);
    }

    private String resolveToLongURLFormat(String string) {
        String string2;
        String string3 = string.replaceAll("\\s+", EMPTY_STRING);
        Matcher matcher = EZ_URL_PATTERN.matcher(string3);
        if (!matcher.matches()) {
            return string;
        }
        String string4 = matcher.group("protocol");
        String string5 = matcher.group("hostinfo");
        String string6 = matcher.group("servicename");
        String string7 = matcher.group("servermode");
        String string8 = matcher.group("instance");
        if (string5 == null) {
            return string;
        }
        if (string4 == null && string6 == null && string7 == null && string8 == null) {
            return string;
        }
        String string9 = this.urlProps.getProperty("HTTPS_PROXY");
        String string10 = this.buildAddressList(string5, string4, string9, string2 = this.urlProps.getProperty("HTTPS_PROXY_PORT"));
        if (string10 == null) {
            return string;
        }
        return String.format(DESCRIPTION_FORMAT, this.buildDescriptionParams(), string10, this.buildConnectData(string6, string7, string8), this.buildSecurityInfo(string4));
    }

    private String buildConnectData(String string, String string2, String string3) {
        String string4 = this.urlProps.getProperty("SERVICE_TAG");
        return String.format(CONNECT_DATA_FORMAT, String.format(SERVICE_NAME_FORMAT, string == null ? EMPTY_STRING : string), string2 == null ? EMPTY_STRING : String.format(SERVER_MODE_FORMAT, string2), string3 == null ? EMPTY_STRING : String.format(INSTANCE_NAME_FORMAT, string3), string4 == null ? EMPTY_STRING : String.format(SERVICE_TAG_FORMAT, string4));
    }

    private String buildAddressList(String string, String string2, String string3, String string4) {
        Matcher matcher = HOST_INFO_PATTERN.matcher(string);
        StringBuilder stringBuilder = new StringBuilder();
        Object object = EMPTY_STRING;
        if (string3 != null && string4 != null) {
            object = String.format(HTTPS_PROXY_FORMAT, string3) + String.format(HTTPS_PROXY_PORT_FORMAT, string4);
        }
        if (string2 == null) {
            string2 = "TCP";
        }
        int n2 = 0;
        while (matcher.find()) {
            String[] stringArray = matcher.group("hostnames").split(",");
            String string5 = matcher.group("port");
            if (string5 == null) {
                string5 = "1521";
            }
            for (String string6 : stringArray) {
                if ((string6 = string6.trim()).length() == 0) continue;
                if (string6.startsWith("[") && string6.endsWith("]")) {
                    string6 = string6.substring(1, string6.length() - 1);
                }
                stringBuilder.append(String.format(ADDRESS_FORMAT, string2, string6, string5, object));
                ++n2;
            }
        }
        if (n2 == 1) {
            return stringBuilder.toString();
        }
        if (n2 > 1) {
            return String.format(ADDRESS_LIST_FORMAT, this.urlProps.getProperty("LOAD_BALANCE", "ON"), stringBuilder.toString());
        }
        return null;
    }

    private String buildDescriptionParams() {
        if (this.urlProps.isEmpty()) {
            return EMPTY_STRING;
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.urlProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(object, object2) -> {
            if (DESCRIPTION_PARAMS.contains(object)) {
                stringBuilder.append(String.format(KEY_VALUE_FORMAT, object, object2));
            }
        }));
        return stringBuilder.toString();
    }

    private String buildSecurityInfo(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null && string.equalsIgnoreCase("tcps")) {
            String string2 = this.connectionProps.getProperty("oracle.net.ssl_server_dn_match", "TRUE");
            String string3 = this.urlProps.getProperty("SSL_SERVER_CERT_DN");
            String string4 = this.urlProps.getProperty("MY_WALLET_DIRECTORY");
            stringBuilder.append(String.format(SERVER_DN_MATCH_FORMAT, string2));
            this.connectionProps.setProperty("oracle.net.ssl_server_dn_match", string2);
            if (string3 != null) {
                stringBuilder.append(String.format(SERVER_DN_FORMAT, string3));
            }
            if (string4 != null) {
                stringBuilder.append(String.format(MY_WALLET_DIR_FORMAT, string4));
            }
        } else {
            String string5 = this.urlProps.getProperty("ENCRYPTION_CLIENT");
            String string6 = this.urlProps.getProperty("ENCRYPTION_TYPES_CLIENT");
            String string7 = this.urlProps.getProperty("CRYPTO_CHECKSUM_CLIENT");
            String string8 = this.urlProps.getProperty("CRYPTO_CHECKSUM_TYPES_CLIENT");
            if (string5 != null) {
                stringBuilder.append(String.format(ENCRYPTION_CLIENT_FORMAT, string5));
            }
            if (string6 != null) {
                stringBuilder.append(String.format(ENCRYPTION_TYPES_CLIENT_FORMAT, string6));
            }
            if (string7 != null) {
                stringBuilder.append(String.format(CRYPTO_CHECKSUM_CLIENT_FORMAT, string7));
            }
            if (string8 != null) {
                stringBuilder.append(String.format(CRYPTO_CHECKSUM_TYPES_CLIENT_FORMAT, string8));
            }
        }
        return stringBuilder.length() == 0 ? EMPTY_STRING : String.format(SECURITY_FORMAT, stringBuilder.toString());
    }

    private String parseExtendedSettings(String string) {
        char[] cArray = string.trim().toCharArray();
        int n2 = this.findExtendedSettingPosition(cArray);
        if (n2 == -1) {
            return string;
        }
        this.parseExtendedProperties(cArray, n2 + 1);
        return string.substring(0, n2);
    }

    private void parseExtendedProperties(char[] cArray, int n2) {
        try {
            String string = null;
            String string2 = null;
            char[] cArray2 = new char[cArray.length];
            int n3 = 0;
            block8: for (int i2 = n2; i2 < cArray.length; ++i2) {
                if (Character.isWhitespace(cArray[i2])) continue;
                switch (cArray[i2]) {
                    case '\\': {
                        if (i2 + 1 < cArray.length && this.isValidEscapeChar(cArray[i2 + 1])) {
                            cArray2[n3++] = cArray[++i2];
                            continue block8;
                        }
                        throw new RuntimeException("Invalid character at " + i2 + " : " + cArray[i2]);
                    }
                    case '\"': {
                        int[] nArray = this.parseQuotedString(i2, cArray, n3, cArray2);
                        n3 = nArray[1];
                        i2 = nArray[0];
                        continue block8;
                    }
                    case '=': {
                        if (string != null) {
                            String string3 = "Unable to parse url \"" + new String(cArray2, 0, n3) + "\"";
                            throw new RuntimeException(string3);
                        }
                        string = new String(cArray2, 0, n3).trim();
                        n3 = 0;
                        continue block8;
                    }
                    case '&': {
                        if (string == null) {
                            String string4 = "Unable to parse url \"" + new String(cArray2, 0, n3) + "\"";
                            throw new RuntimeException(string4);
                        }
                        string2 = new String(cArray2, 0, n3).trim();
                        this.addParam(string, string2);
                        string = null;
                        string2 = null;
                        n3 = 0;
                        continue block8;
                    }
                    default: {
                        cArray2[n3++] = cArray[i2];
                    }
                }
            }
            if (string != null) {
                string2 = new String(cArray2, 0, n3).trim();
                this.addParam(string, string2);
            }
        }
        catch (Exception exception) {
            Logger.getLogger("oracle.jdbc.driver").log(Level.SEVERE, "Extended settings parsing failed.", exception);
        }
    }

    private int[] parseQuotedString(int n2, char[] cArray, int n3, char[] cArray2) {
        for (int i2 = n2 + 1; i2 < cArray.length; ++i2) {
            char c2 = cArray[i2];
            if (c2 == '\\') {
                if (i2 + 1 < cArray.length && this.isValidEscapeChar(cArray[i2 + 1])) {
                    cArray2[n3++] = cArray[++i2];
                    continue;
                }
                throw new RuntimeException("Invalid character at " + i2 + " : " + cArray[i2]);
            }
            if (c2 == '\"') {
                return new int[]{i2, n3};
            }
            cArray2[n3++] = c2;
        }
        throw new RuntimeException("Quote at " + n2 + " not closed.");
    }

    private boolean isValidEscapeChar(char c2) {
        return c2 == '\\' || c2 == '\"';
    }

    private void addParam(String string, String string2) {
        if (string.equalsIgnoreCase(EXT_TNS_ADMIN_KEYWORD)) {
            this.addTNSAdmin(string2);
        } else {
            String string3 = string.toLowerCase();
            String string4 = URL_PROPS_ALIAS.get(string3);
            if (string4 != null) {
                this.urlProps.put(string4, string2);
            } else {
                string4 = CONNECTION_PROPS_ALIAS.getOrDefault(string3, string);
                this.connectionProps.put(string4, string2);
            }
        }
    }

    private void addTNSAdmin(String string) {
        if (!new File(string).exists()) {
            string = EnvVariableResolver.resolveEnvPlaceHolders(string, this.connectionProps);
        }
        this.connectionProps.put("oracle.net.tns_admin", string);
    }

    private int findExtendedSettingPosition(char[] cArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] == '(') {
                ++n2;
                continue;
            }
            if (cArray[i2] == ')') {
                --n2;
                continue;
            }
            if (cArray[i2] != '?' || n2 != 0) continue;
            return i2;
        }
        return -1;
    }

    private static final Map<String, String> initializeUrlAlias() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("enable", "ENABLE");
        hashMap.put("failover", "FAILOVER");
        hashMap.put("load_balance", "LOAD_BALANCE");
        hashMap.put("recv_buf_size", "RECV_BUF_SIZE");
        hashMap.put("send_buf_size", "SEND_BUF_SIZE");
        hashMap.put("sdu", "SDU");
        hashMap.put("source_route", "SOURCE_ROUTE");
        hashMap.put("retry_count", "RETRY_COUNT");
        hashMap.put("retry_delay", "RETRY_DELAY");
        hashMap.put("https_proxy", "HTTPS_PROXY");
        hashMap.put("https_proxy_port", "HTTPS_PROXY_PORT");
        hashMap.put("connect_timeout", "CONNECT_TIMEOUT");
        hashMap.put("transport_connect_timeout", "TRANSPORT_CONNECT_TIMEOUT");
        hashMap.put("ssl_server_cert_dn", "SSL_SERVER_CERT_DN");
        hashMap.put("wallet_location", "MY_WALLET_DIRECTORY");
        hashMap.put("encryption_client", "ENCRYPTION_CLIENT");
        hashMap.put("encryption_types_client", "ENCRYPTION_TYPES_CLIENT");
        hashMap.put("crypto_checksum_client", "CRYPTO_CHECKSUM_CLIENT");
        hashMap.put("crypto_checksum_types_client", "CRYPTO_CHECKSUM_TYPES_CLIENT");
        hashMap.put("pool_connection_class", "POOL_CONNECTION_CLASS");
        hashMap.put("pool_purity", "POOL_PURITY");
        hashMap.put("service_tag", "SERVICE_TAG");
        return hashMap;
    }

    private static final Map<String, String> initializeConnectionPropertiesAlias() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("keystore_type", "javax.net.ssl.keyStoreType");
        hashMap.put("keystore_password", "javax.net.ssl.keyStorePassword");
        hashMap.put("keystore", "javax.net.ssl.keyStore");
        hashMap.put("truststore_type", "javax.net.ssl.trustStoreType");
        hashMap.put("truststore_password", "javax.net.ssl.trustStorePassword");
        hashMap.put("truststore", "javax.net.ssl.trustStore");
        hashMap.put("ssl_version", "oracle.net.ssl_version");
        hashMap.put("ssl_ciphers", "oracle.net.ssl_cipher_suites");
        hashMap.put("ssl_server_dn_match", "oracle.net.ssl_server_dn_match");
        hashMap.put("allow_weak_crypto", "oracle.net.allow_weak_crypto");
        return hashMap;
    }
}

