# =============================================================================
# Semarchy xDM Sample Startup Configuration
# Version : 5.3.0
# Updated : 03-May-2021
# -----------------------------------------------------------------------------
# This file contains samples for the Startup Configuration using environment
# variables.
# It does not work as is and should be adapted to your configuration.
# See *Startup Configuration* in the Semarchy xDM documentation 
# for more information and a detailed description of each variable.
# -----------------------------------------------------------------------------
# CONTENTS
#   - Repository Datasources
#     - PostgreSQL
#     - Microsoft SQL Server
#     - Oracle
#   - Key Management Services (KMS)
#     - Current Key Management Service
#     - Local key
#     - Local Keystore file
#     - Amazon Web Services Key Management Service
#     - Azure Key Vault
#     - Google Cloud Key Management
#   - Secrets Manager
#     - Amazon Web Services Secrets Manager.
#     - Azure Key Vault
#     - Google Cloud Secrets Manager
# =============================================================================

# The following line(s) should be copied from Tomcat's default setenv.sh file.
CATALINA_OPTS="$CATALINA_OPTS -server -XX:+UseG1GC -Dorg.apache.cxf.Logger=org.apache.cxf.common.logging.Slf4jLogger -Dorg.ops4j.pax.logging.property.file=$CATALINA_BASE/conf/log4j2.semarchy.xml -Dgroovy.GStringTemplateEngine.reuseClassLoader=true -Duser.language=en -Duser.country=US -Djava.awt.headless=true --add-opens=java.base/java.nio=ALL-UNNAMED -Dnet.snowflake.jdbc.enableBouncyCastle=true -Dspring.jdbc.getParameterType.ignore=false"

# =============================================================================
# USE A CONFIGURATION FILE
# -----------------------------------------------------------------------------
# To use a configuration file that contains all the startup configuration, set 
# the location of this file using the XDM_CONFIG_FILE property.
# See config_sample.properties for a sample configuration file.
# You can also define each startup property as an environment variable
# export XDM_CONFIG_FILE=configuration_file_location

# =============================================================================
# REPOSITORY DATASOURCES
# -----------------------------------------------------------------------------
# The repository datasources are required by the Semarchy xDM to 
# connect the repository database. 
#   - The XDM_REPOSITORY_* variables configure the connection to the 
#     repository schema with read-write privileges.
#   - The XDM_REPOSITORY_READONLY_* variables configure the credentials to  
#     connect the repository schema with read-only privileges.
# =============================================================================

# -----------------------------------------------------------------------------
# PostgreSQL
# Comment this section if you do not use this technology.
# -----------------------------------------------------------------------------
# Repository datasource
export XDM_REPOSITORY_DRIVER=org.postgresql.Driver
export XDM_REPOSITORY_URL=jdbc:postgresql://localhost:5432/postgres
export XDM_REPOSITORY_USERNAME=repository_user
export XDM_REPOSITORY_PASSWORD=repository_password
# Repository read-only datasource credentials
export XDM_REPOSITORY_READONLY_USERNAME=repository_readonly_user
export XDM_REPOSITORY_READONLY_PASSWORD=repository_readonly_password

# -----------------------------------------------------------------------------
# Microsoft SQL Server
# Uncomment this section to use this technology.
# -----------------------------------------------------------------------------
# # Repository datasource
# export XDM_REPOSITORY_DRIVER=com.microsoft.sqlserver.jdbc.SQLServerDriver
# export XDM_REPOSITORY_URL=jdbc:sqlserver://localhost:1433;databaseName=REPOSITORY;encrypt=false
# export XDM_REPOSITORY_USERNAME=repository_user
# export XDM_REPOSITORY_PASSWORD=repository_password
# # Repository read-only datasource credentials
# export XDM_REPOSITORY_READONLY_USERNAME=repository_readonly_user
# export XDM_REPOSITORY_READONLY_PASSWORD=repository_readonly_password

# -----------------------------------------------------------------------------
# Oracle
# Uncomment this section to use this technology.
# -----------------------------------------------------------------------------
# # Repository datasource
# export XDM_REPOSITORY_DRIVER=oracle.jdbc.OracleDriver
# export XDM_REPOSITORY_URL=jdbc:oracle:thin:@localhost:1521:XE
# export XDM_REPOSITORY_USERNAME=repository_user
# export XDM_REPOSITORY_PASSWORD=repository_password
# # Repository read-only datasource credentials
# export XDM_REPOSITORY_READONLY_USERNAME=repository_readonly_user
# export XDM_REPOSITORY_READONLY_PASSWORD=repository_readonly_password
# # Set the current schema of the readonly user to the repository
# export XDM_REPOSITORY_READONLY_CONNECTIONINITSQL="ALTER SESSION SET CURRENT_SCHEMA = '$XDM_REPOSITORY_USERNAME'"
# =============================================================================

# =============================================================================
# SECRETS MANAGEMENT: KEY MANAGEMENT SERVICES
# -----------------------------------------------------------------------------
# To encrypt secrets stored in the repository (passwords, keys, etc), you can 
# configure multiple Key Management Services (KMS). One of these must be 
# set as the *Current KMS*. Others are only used to decrypt previously 
# encrypted secrets.
# 
# Note that the KMS *alias* appears in the variable name in uppercase. For exemple, 
# export XDM_SECRETS_INTERNAL_KMS_LOCALKEY_TYPE configures the type of the KMS which
# alias is *localkey*.
# =============================================================================

# -----------------------------------------------------------------------------
# Current Key Management Service (KMS)
# Uncomment the following line and update it to set the current KMS' alias.
# export XDM_SECRETS_INTERNAL_KMS_CURRENT=localkey
# -----------------------------------------------------------------------------

# -----------------------------------------------------------------------------
# Sample KMS: localkey
# Local KMS using a key (Base64 encoded, AES-256 bit) passed as a value.
# Uncomment this section to configure and use this KMS technology.
# -----------------------------------------------------------------------------
# export XDM_SECRETS_INTERNAL_KMS_LOCALKEY_TYPE=LOCAL
# export XDM_SECRETS_INTERNAL_KMS_LOCALKEY_KEY=your_base_64_key

# -----------------------------------------------------------------------------
# Sample KMS: localkeystore
# Local KMS using a keystore file storing a Base64 encoded AES-256 bit key.
# Uncomment this section to configure and use this KMS technology.
# -----------------------------------------------------------------------------
# export XDM_SECRETS_INTERNAL_KMS_LOCALKEYSTORE_TYPE=LOCAL
# export XDM_SECRETS_INTERNAL_KMS_LOCALKEYSTORE_KEYSTORE_FILE=keystore_file_location
# export XDM_SECRETS_INTERNAL_KMS_LOCALKEYSTORE_KEYSTORE_PASSWORD=keystore_password
# export XDM_SECRETS_INTERNAL_KMS_LOCALKEYSTORE_KEYSTORE_KEY=key_alias
# export XDM_SECRETS_INTERNAL_KMS_LOCALKEYSTORE_KEYSTORE_KEYPASSWORD=optional_key_password
# export XDM_SECRETS_INTERNAL_KMS_LOCALKEYSTORE_KEYSTORE_TYPE=pkcs12

# -----------------------------------------------------------------------------
# Sample KMS: aws
# KMS using the Amazon Web Services Key Management Service.
# Uncomment this section to configure and use this KMS technology.
# -----------------------------------------------------------------------------
# export XDM_SECRETS_INTERNAL_KMS_AWS_TYPE=AWS
# export XDM_SECRETS_INTERNAL_KMS_AWS_KEYID=customer_master_key_alias
# export XDM_SECRETS_INTERNAL_KMS_AWS_REGION=us-west-1
# # Optional credentials using an access key and a secret access key.
# export XDM_SECRETS_INTERNAL_KMS_AWS_CREDENTIALS_BASIC_ACCESSKEY=aws_access_key
# export XDM_SECRETS_INTERNAL_KMS_AWS_CREDENTIALS_BASIC_SECRETKEY=aws_secret_key

# -----------------------------------------------------------------------------
# Sample KMS: azure
# KMS using Azure Key Vault.
# Uncomment this section to configure and use this KMS technology.
# -----------------------------------------------------------------------------
# export XDM_SECRETS_INTERNAL_KMS_AZURE_TYPE=AZURE
# export XDM_SECRETS_INTERNAL_KMS_AZURE_VAULTURL=azure_key_vault_base_url
# export XDM_SECRETS_INTERNAL_KMS_AZURE_KEYNAME=azure_key_vault_key_name
# export XDM_SECRETS_INTERNAL_KMS_AZURE_WRAPALGORITHM=RSA1_5
# export XDM_SECRETS_INTERNAL_KMS_AZURE_KEYVERSION=optional_key_version
# # Optional credentials using a clientid and client secret.
# export XDM_SECRETS_INTERNAL_KMS_AZURE_CREDENTIALS_TENANTID=tenant_id
# export XDM_SECRETS_INTERNAL_KMS_AZURE_CREDENTIALS_CLIENTID=client_id
# export XDM_SECRETS_INTERNAL_KMS_AZURE_CREDENTIALS_CLIENTSECRET=client_secret
# # Optional credentials using a username and password
# export XDM_SECRETS_INTERNAL_KMS_AZURE_CREDENTIALS_USERNAME=user_name
# export XDM_SECRETS_INTERNAL_KMS_AZURE_CREDENTIALS_PASSWORD=password

# -----------------------------------------------------------------------------
# Sample KMS: google
# KMS using Google Cloud Key Management.
# Uncomment this section to configure and use this KMS technology.
# -----------------------------------------------------------------------------
# export XDM_SECRETS_INTERNAL_KMS_GOOGLE_TYPE=GCP
# export XDM_SECRETS_INTERNAL_KMS_GOOGLE_PROJECTID=project_id
# export XDM_SECRETS_INTERNAL_KMS_GOOGLE_KEYRINGNAME=keyring_name
# export XDM_SECRETS_INTERNAL_KMS_GOOGLE_LOCATION=keyring_location
# export XDM_SECRETS_INTERNAL_KMS_GOOGLE_KEYNAME=crypto_key_resource_name
# # Credentials using a service account key file
# export XDM_SECRETS_INTERNAL_KMS_GOOGLE_CREDENTIALS_FILE=key_file
# # Credentials using the service account key file contents
# export XDM_SECRETS_INTERNAL_KMS_GOOGLE_CREDENTIALS_VALUE=key_file_contents


# =============================================================================
# SECRETS MANAGEMENT: SECRETS MANAGERS
# -----------------------------------------------------------------------------
# You can access secrets (passwords, keys, etc) stored in one or more external 
# secrets manager.
# 
# Note that the secrets manager *alias* appears in the variable name in uppercase.
# For exemple, XDM_SECRETS_EXTERNAL_AWSSECRETS_TYPE configures the type of the
# secrets manager which alias is *awssecrets*.
# =============================================================================

# -----------------------------------------------------------------------------
# Sample Secrets Manager: awssecrets
# External secrets manager using the Amazon Web Services Secrets Manager.
# Uncomment this section to configure and use this secrets manager technology.
# -----------------------------------------------------------------------------
# export XDM_SECRETS_EXTERNAL_AWSSECRETS_TYPE=AWS
# export XDM_SECRETS_EXTERNAL_AWSSECRETS_REGION=us-west-1
# # Optional credentials using an access key and a secret access key.
# export XDM_SECRETS_EXTERNAL_AWSSECRETS_CREDENTIALS_BASIC_ACCESSKEY=aws_access_key
# export XDM_SECRETS_EXTERNAL_AWSSECRETS_CREDENTIALS_BASIC_SECRETKEY=aws_secret_key

# -----------------------------------------------------------------------------
# Sample Secrets Manager: azuresecrets
# External secrets manager using the Azure Key Vault Secrets Manager.
# Uncomment this section to configure and use this secrets manager technology.
# -----------------------------------------------------------------------------
# export XDM_SECRETS_EXTERNAL_AZURESECRETS_TYPE=AZURE
# export XDM_SECRETS_EXTERNAL_AZURESECRETS_VAULTURL=azure_key_vault_base_url
# # Optional credentials using a clientid and client secret.
# export XDM_SECRETS_EXTERNAL_AZURESECRETS_CREDENTIALS_TENANTID=tenant_id
# export XDM_SECRETS_EXTERNAL_AZURESECRETS_CREDENTIALS_CLIENTID=client_id
# export XDM_SECRETS_EXTERNAL_AZURESECRETS_CREDENTIALS_CLIENTSECRET=client_secret
# # Optional credentials using a username and password
# export XDM_SECRETS_EXTERNAL_AZURESECRETS_CREDENTIALS_USERNAME=user_name
# export XDM_SECRETS_EXTERNAL_AZURESECRETS_CREDENTIALS_PASSWORD=password

# -----------------------------------------------------------------------------
# Sample Secrets Manager: googlesecrets
# External secrets manager using the Google Cloud Secrets Manager.
# Uncomment this section to configure and use this secrets manager technology.
# -----------------------------------------------------------------------------
# export XDM_SECRETS_EXTERNAL_GOOGLESECRETS_TYPE=GCP
# export XDM_SECRETS_EXTERNAL_GOOGLESECRETS_PROJECTID=project_id
# # Credentials using a service account key file
# export XDM_SECRETS_EXTERNAL_GOOGLESECRETS_CREDENTIALS_FILE=key_file
# # Credentials using the service account key file contents
# export XDM_SECRETS_EXTERNAL_GOOGLESECRETS_CREDENTIALS_VALUE=key_file_contents
