/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.ant;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class MultiPackageConfMerger
extends Task {
    private static final String UNEXPECTED_MESSAGE = "unexpected";
    private String packageId = null;
    OutputStream fosConf = null;
    XMLStreamWriter writer = null;
    PrintWriter propsWriter = null;
    OutputStream propsFos = null;

    public void execute() throws BuildException {
        File wrk2Dir = new File(this.getProject().getProperty("work2.dir"));
        File tmpConfXml = new File(wrk2Dir, "metadata.xml");
        try {
            File[] fileArray = wrk2Dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isFile() && f.getName().endsWith(".metadata.xml")) {
                    try {
                        this.log("Merging file " + String.valueOf(f));
                        this.mergeConfXml(tmpConfXml, f);
                    }
                    catch (Exception ex) {
                        this.log(String.format("Failed to merge %s", f), ex, 1);
                    }
                }
                ++n2;
            }
        }
        finally {
            if (this.writer != null) {
                try {
                    this.writer.writeEndElement();
                    this.writer.writeEndDocument();
                    this.writer.close();
                }
                catch (XMLStreamException e) {
                    this.log(UNEXPECTED_MESSAGE, e, 0);
                }
            }
            if (this.fosConf != null) {
                try {
                    this.fosConf.close();
                }
                catch (IOException e) {
                    this.log(UNEXPECTED_MESSAGE, e, 0);
                }
            }
            if (this.propsWriter != null) {
                this.propsWriter.close();
            }
            if (this.propsFos != null) {
                try {
                    this.propsFos.close();
                }
                catch (IOException e) {
                    this.log(UNEXPECTED_MESSAGE, e, 0);
                }
            }
        }
    }

    private void mergeConfXml(File currentConf, File toInject) throws Exception {
        XMLEventReader reader = null;
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        inputFactory.setProperty("javax.xml.stream.supportDTD", false);
        inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (BufferedInputStream fisConf = new BufferedInputStream(new FileInputStream(toInject));){
                if (this.writer == null) {
                    this.fosConf = new FileOutputStream(currentConf, true);
                    BufferedOutputStream bwConf = new BufferedOutputStream(this.fosConf);
                    this.writer = XMLOutputFactory.newInstance().createXMLStreamWriter(bwConf, "UTF-8");
                    this.writer.writeStartDocument("UTF-8", "1.0");
                }
                reader = inputFactory.createXMLEventReader(fisConf);
                while (reader.hasNext()) {
                    XMLEvent ev = reader.nextEvent();
                    switch (ev.getEventType()) {
                        case 1: {
                            StartElement s = ev.asStartElement();
                            boolean isExt = false;
                            if (this.packageId == null) {
                                this.writer.writeStartElement("ex:root");
                                isExt = true;
                                Iterator<Namespace> itNm = s.getNamespaces();
                                while (itNm.hasNext()) {
                                    Namespace n = itNm.next();
                                    this.writer.writeNamespace(n.getPrefix(), n.getNamespaceURI());
                                }
                                Iterator<Attribute> itAtt = s.getAttributes();
                                while (itAtt.hasNext()) {
                                    Attribute a = itAtt.next();
                                    if (a.getName().getLocalPart().equals("processId")) continue;
                                    this.writer.writeAttribute(a.getName().toString(), a.getValue());
                                    if (!a.getName().getLocalPart().equals("packageId")) continue;
                                    this.packageId = a.getValue();
                                }
                            } else if (s.getName().getLocalPart().equals("externalize")) {
                                isExt = true;
                            }
                            if (s.getName().getPrefix() != null && !s.getName().getPrefix().isEmpty()) {
                                this.writer.writeStartElement(s.getName().getPrefix() + ":" + s.getName().getLocalPart());
                            } else {
                                this.writer.writeStartElement(s.getName().getLocalPart());
                            }
                            Iterator<Attribute> itAtt = s.getAttributes();
                            while (itAtt.hasNext()) {
                                Attribute a = itAtt.next();
                                if (isExt && a.getName().getLocalPart().equals("packageId")) {
                                    this.writer.writeAttribute(a.getName().toString(), this.packageId);
                                    continue;
                                }
                                this.writer.writeAttribute(a.getName().toString(), a.getValue());
                            }
                            if (!isExt) break;
                            this.writer.writeAttribute("processName", toInject.getName().substring(0, toInject.getName().lastIndexOf(".metadata.xml")));
                            break;
                        }
                        case 4: {
                            Characters ch = ev.asCharacters();
                            this.writer.writeCharacters(ch.getData());
                            break;
                        }
                        case 2: {
                            this.writer.writeEndElement();
                        }
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }
}

