/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.ant;

import com.semarchy.xdi.designer.generation.ant.Messages;
import com.semarchy.xdi.designer.generation.ant.XSLGeneratorUDFCallback;
import com.semarchy.xdi.designer.generation.ant.XslAggregatorFilter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class UDFXslGenerator {
    String[] avoidEscape = new String[]{"&#xD;", "&#xA;", "&#x9;"};
    private static final XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();

    static String formatCode(Map<String, String> prefix, String udfCode) throws Exception {
        Lexer l = new Lexer(prefix.keySet(), udfCode);
        Token token = null;
        Node root = new Node(token);
        Stack<Node> stack = new Stack<Node>();
        stack.push(root);
        while ((token = l.read()) != null) {
            Node n = new Node(token);
            ((Node)stack.peek()).addChildren(n);
            if (token.event == Event.END_FUNCTION) {
                stack.pop();
                continue;
            }
            if (token.event != Event.START_FUNCTION && token.event != Event.UDF) continue;
            stack.push(n);
        }
        Visitor v = new Visitor(prefix);
        v.accept(root);
        return v.getResult();
    }

    public void generateXsl(List<XSLGeneratorUDFCallback.LightUDF> udfs, File userXslFile, boolean append) throws Exception {
        HashMap<String, String> udfPrefixReplacements = new HashMap<String, String>();
        HashMap<XSLGeneratorUDFCallback.LightUDF, String> udfPRefix = new HashMap<XSLGeneratorUDFCallback.LightUDF, String>();
        ArrayList<XSLGeneratorUDFCallback.LightUDF> implementedUDF = new ArrayList<XSLGeneratorUDFCallback.LightUDF>();
        for (XSLGeneratorUDFCallback.LightUDF u : udfs) {
            if (u.implPerCode.isEmpty()) continue;
            implementedUDF.add(u);
            String prefix = u.prefix;
            if (prefix == null || prefix.trim().isEmpty()) {
                prefix = "udf";
            }
            Object libId = u.libId;
            libId = ((String)libId).replace("-", "_");
            libId = (String)libId + "_";
            udfPrefixReplacements.put(prefix, (String)libId);
            udfPRefix.put(u, "udf:" + (String)libId);
        }
        if (append && userXslFile.exists()) {
            if (implementedUDF.isEmpty()) {
                return;
            }
            TransformerFactory f = TransformerFactory.newInstance();
            try {
                f.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                f.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            TransformerHandler serializer = ((SAXTransformerFactory)f).newTransformerHandler();
            File tmpFile = new File(userXslFile.getAbsolutePath() + ".agg");
            Object object = null;
            Object var11_14 = null;
            try (EscapingBufferedOutputStream os = new EscapingBufferedOutputStream(new FileOutputStream(tmpFile));){
                StreamResult res = new StreamResult(os);
                serializer.setResult(res);
                XslAggregatorFilter filter = new XslAggregatorFilter(os, implementedUDF, udfPRefix, udfPrefixReplacements);
                filter.setContentHandler(serializer);
                SAXParserFactory parserFactory = SAXParserFactory.newInstance();
                parserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                parserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                parserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                parserFactory.setFeature("http://xml.org/sax/features/validation", false);
                parserFactory.setNamespaceAware(true);
                SAXParser parser = parserFactory.newSAXParser();
                XMLReader reader = parser.getXMLReader();
                reader.setContentHandler(filter);
                Throwable throwable = null;
                Object var19_35 = null;
                try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(userXslFile));){
                    reader.parse(new InputSource(is));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
            Files.move(tmpFile.toPath(), userXslFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return;
        }
        FilterOutputStream os = null;
        XMLStreamWriter xmlWriter = null;
        try {
            userXslFile.getParentFile().mkdirs();
            os = new EscapingBufferedOutputStream(new FileOutputStream(userXslFile));
            xmlWriter = outputFactory.createXMLStreamWriter(os, "UTF-8");
            xmlWriter.writeStartDocument("UTF-8", "1.0");
            xmlWriter.writeStartElement("xsl", "stylesheet", "http://www.w3.org/1999/XSL/Transform");
            xmlWriter.writeNamespace("xsl", "http://www.w3.org/1999/XSL/Transform");
            xmlWriter.writeNamespace("fn", "http://www.w3.org/2005/02/xpath-functions");
            xmlWriter.writeNamespace("md", "http://www.stambia.com/md");
            xmlWriter.writeNamespace("mdj", "java:com.semarchy.xdi.designer.generation.xsl.global.Functions");
            xmlWriter.writeNamespace("mds", "java:com.semarchy.xdi.designer.generation.xsl.global.Strings");
            xmlWriter.writeNamespace("mdv", "java:com.semarchy.xdi.designer.generation.xsl.global.Variables");
            xmlWriter.writeNamespace("proc", "http://www.example.org/proc");
            xmlWriter.writeNamespace("saxon", "http://saxon.sf.net/");
            xmlWriter.writeNamespace("sql", "java://com.semarchy.xdi.designer.generation.xsl.sql.SQLElementFactory");
            xmlWriter.writeNamespace("tech", "http://www.stambia.com/tech");
            xmlWriter.writeNamespace("udf", "http://www.stambia.com/udf");
            xmlWriter.writeNamespace("user", "http://www.stambia.com/user");
            xmlWriter.writeAttribute("extension-element-prefixes", "saxon sql");
            for (XSLGeneratorUDFCallback.LightUDF u : implementedUDF) {
                xmlWriter.writeStartElement("xsl:function");
                xmlWriter.writeAttribute("name", (String)udfPRefix.get(u) + u.name);
                xmlWriter.writeStartElement("xsl:param");
                xmlWriter.writeAttribute("name", "context");
                xmlWriter.writeEndElement();
                for (String p : u.parameters) {
                    xmlWriter.writeStartElement("xsl:param");
                    xmlWriter.writeAttribute("name", p);
                    xmlWriter.writeEndElement();
                }
                xmlWriter.writeStartElement("xsl:variable");
                xmlWriter.writeAttribute("name", "var");
                xmlWriter.writeStartElement("xsl:choose");
                String defaultCode = null;
                boolean hasImpl = false;
                for (String productCode : u.implPerCode.keySet()) {
                    String code = u.implPerCode.get(productCode);
                    if ("__default__".equals(productCode)) {
                        if (defaultCode != null) continue;
                        defaultCode = code;
                        continue;
                    }
                    if (code == null || code.trim().isEmpty()) continue;
                    hasImpl = true;
                    xmlWriter.writeStartElement("xsl:when");
                    xmlWriter.writeAttribute("test", "$context/ancestor-or-self::product/@code='" + productCode + "'");
                    xmlWriter.writeStartElement("xsl:value-of");
                    try {
                        try {
                            ((EscapingBufferedOutputStream)os).escape = true;
                            xmlWriter.writeAttribute("select", UDFXslGenerator.formatCode(udfPrefixReplacements, code));
                        }
                        catch (Exception ex) {
                            throw new Exception(String.format(Messages.UDFXslGenerator_0, productCode, u.libId), ex);
                        }
                    }
                    finally {
                        ((EscapingBufferedOutputStream)os).escape = false;
                    }
                    xmlWriter.writeEndElement();
                    xmlWriter.writeEndElement();
                }
                if (defaultCode != null && !defaultCode.isEmpty()) {
                    if (hasImpl) {
                        xmlWriter.writeStartElement("xsl:otherwise");
                    } else {
                        xmlWriter.writeStartElement("xsl:when");
                        xmlWriter.writeAttribute("test", "1=1");
                    }
                    xmlWriter.writeStartElement("xsl:value-of");
                    try {
                        try {
                            ((EscapingBufferedOutputStream)os).escape = true;
                            xmlWriter.writeAttribute("select", UDFXslGenerator.formatCode(udfPrefixReplacements, defaultCode));
                        }
                        catch (Exception ex) {
                            throw new Exception(String.format(Messages.UDFXslGenerator_3, u.libId), ex);
                        }
                    }
                    finally {
                        ((EscapingBufferedOutputStream)os).escape = false;
                    }
                    xmlWriter.writeEndElement();
                    xmlWriter.writeEndElement();
                }
                xmlWriter.writeEndElement();
                xmlWriter.writeEndElement();
                xmlWriter.writeStartElement("xsl:value-of");
                xmlWriter.writeAttribute("select", "string($var)");
                xmlWriter.writeEndElement();
                xmlWriter.writeEndElement();
            }
            xmlWriter.writeEndElement();
            xmlWriter.writeEndDocument();
            xmlWriter.flush();
        }
        finally {
            if (xmlWriter != null) {
                xmlWriter.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    protected String getImplementationCode(XSLGeneratorUDFCallback.LightUDF udf, String productCode) {
        return udf.implPerCode.get(productCode);
    }

    static class EscapingBufferedOutputStream
    extends BufferedOutputStream {
        boolean escape = false;

        public EscapingBufferedOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public synchronized void write(int b) throws IOException {
            if (!this.escape) {
                super.write(b);
            } else {
                char c = (char)b;
                String specWhiteChar = null;
                switch (c) {
                    case '\r': {
                        specWhiteChar = "&#xD;";
                        break;
                    }
                    case '\n': {
                        specWhiteChar = "&#xA;";
                        break;
                    }
                    case '\t': {
                        specWhiteChar = "&#x9;";
                    }
                }
                if (specWhiteChar != null) {
                    char[] cArray = specWhiteChar.toCharArray();
                    int n = cArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char a = cArray[n2];
                        super.write(a);
                        ++n2;
                    }
                } else {
                    super.write(b);
                }
            }
        }
    }

    private static enum Event {
        START_FUNCTION,
        END_FUNCTION,
        STRING,
        PARAMETER,
        DATA,
        SEPARATOR,
        UDF,
        WHITESPACE;

    }

    private static class Lexer {
        private Queue<Token> readTokens = new LinkedList<Token>();
        private char previousChar;
        private String data;
        private int curIndex;
        private Collection<String> prefixes;

        public Lexer(Collection<String> prefixes, String data) {
            this.data = data;
            this.prefixes = prefixes;
        }

        public Token read() throws Exception {
            if (!this.readTokens.isEmpty()) {
                return this.readTokens.poll();
            }
            StringBuilder buf = new StringBuilder();
            while (this.curIndex < this.data.length() && this.readTokens.isEmpty()) {
                char currentChar = this.data.charAt(this.curIndex++);
                block0 : switch (currentChar) {
                    case '\'': {
                        if (buf.length() > 0) {
                            this.readTokens.add(new Token(buf.toString(), Event.DATA));
                        }
                        buf = new StringBuilder();
                        buf.append(currentChar);
                        while (this.curIndex < this.data.length()) {
                            this.previousChar = currentChar;
                            currentChar = this.data.charAt(this.curIndex++);
                            if (this.previousChar != '\\' && currentChar == '\'') {
                                buf.append(currentChar);
                                this.readTokens.add(new Token(buf.toString(), Event.STRING));
                                buf = new StringBuilder();
                                break block0;
                            }
                            buf.append(currentChar);
                            if (this.curIndex != this.data.length()) continue;
                            throw new Exception(String.format(Messages.UDFXslGenerator_1, buf.toString()));
                        }
                        break;
                    }
                    case '(': {
                        buf.append(currentChar);
                        String v = buf.toString();
                        String[] p = v.split("\\s+");
                        String fName = p[p.length - 1];
                        boolean prefixed = false;
                        for (String s : this.prefixes) {
                            if (!fName.startsWith(s + "::")) continue;
                            prefixed = true;
                            break;
                        }
                        if (prefixed) {
                            this.readTokens.add(new Token(buf.toString(), Event.UDF));
                            break;
                        }
                        this.readTokens.add(new Token(buf.toString(), Event.START_FUNCTION));
                        break;
                    }
                    case ')': {
                        if (buf != null && buf.length() > 0) {
                            this.readTokens.add(new Token(buf.toString(), Event.DATA));
                        }
                        buf = new StringBuilder();
                        this.readTokens.add(new Token(null, Event.END_FUNCTION));
                        break;
                    }
                    case '$': {
                        if (this.data.charAt(this.curIndex) == '{') {
                            int i = this.data.indexOf("}$", this.curIndex - 1);
                            buf.append(this.data.substring(this.curIndex - 1, i + 2));
                            this.curIndex = i + 2;
                            this.readTokens.add(new Token(buf.toString(), Event.DATA));
                            buf = new StringBuilder();
                            break;
                        }
                        if (buf != null && buf.length() > 0) {
                            this.readTokens.add(new Token(buf.toString(), Event.DATA));
                        }
                        buf = new StringBuilder();
                        while (this.curIndex < this.data.length()) {
                            if (Character.isJavaIdentifierPart(currentChar = this.data.charAt(this.curIndex++))) {
                                buf.append(currentChar);
                                continue;
                            }
                            --this.curIndex;
                            break;
                        }
                        this.readTokens.add(new Token(buf.toString(), Event.PARAMETER));
                        buf = new StringBuilder();
                        break;
                    }
                    case ',': {
                        if (buf != null && buf.length() > 0) {
                            this.readTokens.add(new Token(buf.toString(), Event.DATA));
                        }
                        this.readTokens.add(new Token(null, Event.SEPARATOR));
                        buf = new StringBuilder();
                        break;
                    }
                    default: {
                        if (!Character.isWhitespace(currentChar)) {
                            buf.append(currentChar);
                            break;
                        }
                        this.readTokens.add(new Token(buf.toString(), Event.DATA));
                        this.readTokens.add(new Token("" + currentChar, Event.WHITESPACE));
                        buf = new StringBuilder();
                    }
                }
                this.previousChar = currentChar;
            }
            if (this.curIndex >= this.data.length() && buf.length() > 0) {
                this.readTokens.add(new Token(buf.toString(), Event.DATA));
            }
            return this.readTokens.isEmpty() ? null : this.readTokens.poll();
        }
    }

    private static class Node {
        Token token;
        Node parent = null;
        List<Node> children = new ArrayList<Node>();

        Node(Token token) {
            this.token = token;
        }

        void addChildren(Node child) {
            if (this.token != null && this.token.event == Event.UDF) {
                if (child.token.event == Event.WHITESPACE || child.token.event == Event.SEPARATOR) {
                    return;
                }
                if (child.token.event == Event.DATA && child.token.val.isEmpty()) {
                    return;
                }
            }
            child.parent = this;
            this.children.add(child);
        }
    }

    private static class Token {
        String val;
        Event event;

        Token(String val, Event event) {
            this.val = val;
            this.event = event;
        }
    }

    private static class Visitor {
        StringBuilder buf = new StringBuilder();
        Map<String, String> prefix;

        Visitor(Map<String, String> prefix) {
            this.prefix = prefix;
        }

        void accept(Node root) {
            if (root.children.isEmpty()) {
                return;
            }
            this.buf.append("concat(");
            if (root.children.size() == 1) {
                this.buf.append("'', ");
            }
            for (Node n : root.children) {
                this.visit(n);
            }
            this.buf.append(")");
        }

        void visit(Node n) {
            boolean needComa = false;
            if (n.parent.token != null && n.parent.token.event == Event.UDF && n.parent.children.indexOf(n) == n.parent.children.size() - 1) {
                needComa = false;
            } else if (n.parent.children.indexOf(n) > 0 || n.parent.token != null && n.parent.token.event == Event.START_FUNCTION) {
                needComa = true;
            }
            if (needComa) {
                this.buf.append(", ");
            }
            switch (n.token.event) {
                case DATA: {
                    this.buf.append("'" + n.token.val + "'");
                    break;
                }
                case STRING: {
                    this.buf.append("'" + n.token.val.replace("'", "''") + "'");
                    break;
                }
                case PARAMETER: {
                    this.buf.append("$" + n.token.val);
                    break;
                }
                case SEPARATOR: {
                    this.buf.append("','");
                    break;
                }
                case UDF: {
                    for (String s : this.prefix.keySet()) {
                        if (!n.token.val.startsWith(s + "::")) continue;
                        this.buf.append(n.token.val.replace(s + "::", "udf:" + this.prefix.get(s)) + "$context");
                        break;
                    }
                    if (n.children.size() <= 1) break;
                    this.buf.append(",");
                    break;
                }
                case START_FUNCTION: {
                    this.buf.append("'" + n.token.val + "'");
                    break;
                }
                case END_FUNCTION: {
                    if (n.parent.token != null && n.parent.token.event == Event.START_FUNCTION) {
                        this.buf.append("')'");
                        break;
                    }
                    this.buf.append(")");
                    break;
                }
                case WHITESPACE: {
                    Object sss = "";
                    char[] cArray = n.token.val.toCharArray();
                    int n2 = cArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        char currentChar = cArray[n3];
                        sss = (String)sss + currentChar;
                        ++n3;
                    }
                    this.buf.append("'" + (String)sss + "'");
                }
            }
            for (Node c : n.children) {
                this.visit(c);
            }
        }

        String getResult() {
            return this.buf.toString();
        }
    }
}

