/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.mapping.internal;

import com.indy.gmf.proc.ActionProcess;
import com.indy.gmf.proc.AltId;
import com.indy.gmf.proc.ProcFactory;
import com.indy.gmf.proc.ProcPackage;
import com.indy.gmf.proc.util.custom.StbProcResourceFactoryImpl;
import com.indy.map.Template;
import com.semarchy.xdi.designer.core.models.BuiltPlatformResourceURIHandler;
import com.semarchy.xdi.designer.core.models.EMFResourceOptions;
import com.semarchy.xdi.designer.core.models.IndyResourceUtil;
import com.semarchy.xdi.designer.core.models.InternalResourceURIConverter;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.XDIModelURIResolver;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import com.semarchy.xdi.designer.generation.mapping.StageMdGenerator;
import com.semarchy.xdi.designer.generation.mapping.internal.MappingBuildException;
import com.semarchy.xdi.designer.generation.mapping.internal.MdModelBuilder;
import com.semarchy.xdi.designer.generation.mapping.internal.MdNodeFactory;
import com.semarchy.xdi.designer.generation.mapping.internal.ModelToMdConverter;
import com.semarchy.xdi.designer.generation.mapping.internal.ProcessBuilder;
import com.semarchy.xdi.designer.generation.mapping.internal.TemporaryFolderOutputURIConverter;
import com.semarchy.xdi.designer.generation.model.xdg.internal.MappingVisitor;
import com.stambia.md.DocumentRoot;
import com.stambia.md.MdFactory;
import com.stambia.md.MdNode;
import com.stambia.md.MdPackage;
import com.stambia.md.MdRootNode;
import com.stambia.md.util.MdFactoryHelper;
import com.stambia.md.util.StbMdResourceFactoryImpl;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;

public class MappingBuilderV2 {
    com.indy.map.Map mapModel;
    boolean intoWorkspace;
    ResourceSet resourceSet;
    Resource mdResource;
    Resource procResource;
    MdRootNode mainMd;
    ActionProcess mainProcess;
    private boolean compareMode;
    private boolean extractXdgMd;

    public MappingBuilderV2(com.indy.map.Map mapModel, boolean intoWorkspace, boolean compareMode, boolean extractXdgMd) {
        this.mapModel = mapModel;
        this.intoWorkspace = intoWorkspace;
        this.compareMode = compareMode;
        this.extractXdgMd = extractXdgMd;
        this.init();
    }

    private void init() {
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.setURIConverter((URIConverter)new InternalResourceURIConverter(){
            URIHandler builtFileHandler = new BuiltPlatformResourceURIHandler();

            public URIHandler getURIHandler(URI uri) {
                if (uri.isPlatformResource() && uri.segment(2).equals("indy.build") && this.builtFileHandler.canHandle(uri)) {
                    return this.builtFileHandler;
                }
                return super.getURIHandler(uri);
            }
        });
        if (!this.intoWorkspace) {
            this.resourceSet.setURIConverter((URIConverter)new TemporaryFolderOutputURIConverter(this.resourceSet.getURIConverter()));
        }
        this.resourceSet.getLoadOptions().put(EMFResourceOptions.LOAD_OPTION_NO_EXTERNAIZATION_LOADING, true);
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("proc", new StbProcResourceFactoryImpl());
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("md", new StbMdResourceFactoryImpl());
        this.resourceSet.getPackageRegistry().put((Object)"http://www.example.org/proc", (Object)ProcPackage.eINSTANCE);
        this.resourceSet.getPackageRegistry().put((Object)"http://www.stambia.com/md", (Object)MdPackage.eINSTANCE);
        this.createMdResource();
        this.createProcResource();
    }

    private void createProcResource() {
        URI procURI = null;
        String procID = this.mapModel.getId() + "-proc";
        procURI = this.intoWorkspace ? URIUtils.getMappingBuiltProcFile((URI)this.mapModel.eResource().getURI()) : URI.createPlatformPluginURI((String)("com.indy.gmf.map/" + this.mapModel.getId() + ".proc"), (boolean)true);
        if (this.compareMode) {
            procURI = procURI.trimFileExtension().trimSegments(1).appendSegment(this.mapModel.eResource().getURI().trimFileExtension().trimFragment().lastSegment() + ".new.proc");
            procID = procID + "2";
        }
        this.procResource = this.resourceSet.createResource(procURI);
        this.mainProcess = ProcFactory.eINSTANCE.createActionProcess();
        this.mainProcess.setId(procID);
        AltId altId = ProcFactory.eINSTANCE.createAltId();
        altId.setOrigin("mapping");
        altId.setValue(this.mapModel.getId());
        this.mainProcess.getAltId().add((Object)altId);
        altId = ProcFactory.eINSTANCE.createAltId();
        altId.setOrigin("flow");
        altId.setValue(this.mainMd.getId());
        this.mainProcess.getAltId().add((Object)altId);
        com.indy.gmf.proc.DocumentRoot mdDocumentRoot = ProcFactory.eINSTANCE.createDocumentRoot();
        mdDocumentRoot.setProcess(this.mainProcess);
        this.procResource.getContents().add((Object)mdDocumentRoot);
    }

    private void createMdResource() {
        URI mdURI = null;
        String mdID = this.mapModel.getId() + "-flow";
        mdURI = this.intoWorkspace ? URIUtils.getMappingBuiltMdFile((URI)this.mapModel.eResource().getURI()) : URI.createPlatformPluginURI((String)("com.indy.gmf.map/" + this.mapModel.getId() + ".md"), (boolean)true);
        if (this.compareMode) {
            mdURI = mdURI.trimFileExtension().trimSegments(1).appendSegment(this.mapModel.eResource().getURI().trimFileExtension().trimFragment().lastSegment() + ".new.md");
            mdID = mdID + "2";
        }
        this.mdResource = this.resourceSet.createResource(mdURI);
        this.mainMd = MdFactoryHelper.createMdRootNode((String)"com.stambia.flow");
        this.mainMd.setId(mdID);
        MdNode mdAltId = MdFactoryHelper.createMdNode((String)"com.stambia.flow.altId");
        MdNodeFactory.addStringAttribute(mdAltId, "origin", "mapping");
        MdNodeFactory.addStringAttribute(mdAltId, "value", this.mapModel.getId());
        this.mainMd.getNode().add((Object)mdAltId);
        String uriFragment = this.mapModel.getTech().eResource().getURIFragment(this.mapModel.getTech());
        Object objectId = null;
        objectId = uriFragment.contains("?") ? uriFragment.substring(0, uriFragment.indexOf("?")) : uriFragment;
        if (((String)objectId).contains("#")) {
            objectId = ((String)objectId).substring(((String)objectId).indexOf("#") + 1);
        }
        File f = ((XDIModelURIResolver)E4InjectorHelper.getService(XDIModelURIResolver.class)).resolve(((ICacheService)E4InjectorHelper.getService(ICacheService.class)).findResourceURIByFileId((String)objectId));
        String uri = f.toURI().toString();
        AnyType dummyTech = XMLTypeFactory.eINSTANCE.createAnyType();
        ((InternalEObject)dummyTech).eSetProxyURI(URI.createURI((String)(uri + "#" + uriFragment)));
        this.mainMd.setRef((EObject)dummyTech);
        DocumentRoot mdDocumentRoot = MdFactory.eINSTANCE.createDocumentRoot();
        mdDocumentRoot.setNode(this.mainMd);
        this.mdResource.getContents().add((Object)mdDocumentRoot);
    }

    public URI[] build() {
        StageMdGenerator gen = new StageMdGenerator(this.resourceSet);
        StageMdGenerator.MdResources stageObjectTypeMdNode = null;
        try {
            stageObjectTypeMdNode = gen.generateMdResources(this.mapModel, this.intoWorkspace);
        }
        catch (Exception ex) {
            throw new MappingBuildException("Failed to generate datatypes md", ex);
        }
        MdModelBuilder modelBuilder = MdModelBuilder.of(this.mapModel, stageObjectTypeMdNode);
        modelBuilder.buildModel();
        ModelToMdConverter converter = ModelToMdConverter.of(modelBuilder);
        converter.appendStepsModel((MdNode)this.mainMd, modelBuilder.getSteps());
        if (this.extractXdgMd) {
            MappingVisitor visitor = new MappingVisitor();
            SafeRunner.run(() -> {
                try {
                    URI xdgURI = visitor.createMdResource(this.mapModel, this.resourceSet);
                    AnyType proxy = XMLTypeFactory.eINSTANCE.createAnyType();
                    ((InternalEObject)proxy).eSetProxyURI(xdgURI);
                    MdNodeFactory.addRefAttribute((MdNode)this.mainMd, "xdgHarvestRef", (EObject)proxy);
                }
                catch (Exception e) {
                    throw new MappingBuildException(String.format("Failed to harvest XDG from %s", this.mapModel.eResource().getURI()), e);
                }
            });
        }
        stageObjectTypeMdNode.saveAll();
        HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("ENCODING", "UTF-8");
        ((IndyResourceUtil.IndyResource)this.mdResource).setId(this.mainMd.getId());
        try {
            this.mdResource.save(saveOptions);
        }
        catch (Exception ex) {
            throw new MappingBuildException("Failed to save md", ex);
        }
        ProcessBuilder processBuilder = ProcessBuilder.of(modelBuilder);
        Map<Template, MdNode> stepNodePerTpl = modelBuilder.steps.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> modelToMdConverter.mdNodePerStep.get(e.getValue())));
        processBuilder.buildProcess(stepNodePerTpl, this.mainProcess);
        try {
            this.procResource.save(saveOptions);
        }
        catch (Exception ex) {
            throw new MappingBuildException("Failed to save md", ex);
        }
        return new URI[]{this.mdResource.getURI(), this.procResource.getURI()};
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }
}

