/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.mapping.internal;

import com.indy.gmf.proc.Action;
import com.indy.gmf.proc.ActionProcess;
import com.indy.gmf.proc.ActionProcessRef;
import com.indy.gmf.proc.AltId;
import com.indy.gmf.proc.MetaDataLink;
import com.indy.gmf.proc.Parameter;
import com.indy.gmf.proc.ProcFactory;
import com.indy.gmf.proc.SubActionProcess;
import com.indy.map.Template;
import com.indy.map.ref.RTemplate;
import com.semarchy.xdi.designer.core.collections.BidiMap;
import com.semarchy.xdi.designer.generation.mapping.internal.MdModel;
import com.stambia.md.MdNode;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;

class ProcModelFactoryHelper {
    BidiMap<Parameter, Parameter> duplicatedActionProcessRefParameters = new BidiMap();

    ProcModelFactoryHelper() {
    }

    private void addParamters(ActionProcessRef process, Template tpl) {
        ActionProcess ref = (ActionProcess)process.getTargetName();
        while (ref instanceof SubActionProcess) {
            ref = (ActionProcess)ref.eContainer();
        }
        if (ref != null) {
            for (Parameter param : ref.getParameter()) {
                Parameter copy = ProcFactory.eINSTANCE.createParameter();
                com.indy.map.Parameter oParam = tpl.getParameter(param.getName());
                copy.setName(param.getName());
                copy.setType(param.getType());
                copy.setMetaInf(param.getMetaInf());
                copy.setFault(param.isFault());
                copy.setInput(param.isInput());
                copy.setLabel(param.getLabel());
                copy.setOutput(param.isOutput());
                if (oParam != null) {
                    copy.setValue(oParam.getValue());
                } else {
                    copy.setValue(param.getValue());
                }
                process.getParameter().add((Object)copy);
                this.duplicatedActionProcessRefParameters.put((Object)copy, (Object)param);
            }
        }
    }

    MetaDataLink addMdLlink(Action owner, String mdLinkName, URI refURI) {
        MetaDataLink l = ProcFactory.eINSTANCE.createMetaDataLink();
        l.setName(new QName(mdLinkName));
        AnyType ref = XMLTypeFactory.eINSTANCE.createAnyType();
        ((InternalEObject)ref).eSetProxyURI(refURI);
        l.setTarget((EObject)ref);
        owner.getMetaDataLink().add((Object)l);
        return l;
    }

    private String truncate(String name) {
        if (name.length() > 30) {
            return name.substring(0, 30);
        }
        return name;
    }

    String formatStepName(MdModel.MdStep step, Template tpl, String suffix) {
        String prefix = step.name.substring(0, step.name.indexOf("_"));
        String name = this.truncate(tpl.getName().substring(tpl.getName().indexOf("_") + 1));
        return String.format("%s-%s%s%s", prefix, name, suffix == null || suffix.isEmpty() ? "" : "-", suffix);
    }

    public ActionProcessRef createProcessRef(ActionProcess targetRef, MdModel.MdStep step, Template tpl, MdNode refMd, String mapModelId, int stepTypeIndex, String suffix, int idSuffixIndex) {
        ActionProcessRef process = ProcFactory.eINSTANCE.createActionProcessRef();
        process.setTargetName((EObject)targetRef);
        process.setName(this.formatStepName(step, tpl, suffix));
        process.setId(String.format("%s-proc%d_%s%d", mapModelId, stepTypeIndex, ((RTemplate)tpl.getMapReference()).getTemplateType().getProcessStepNamePrefix(), idSuffixIndex));
        this.addParamters(process, tpl);
        if (refMd != null) {
            this.addMdLlink((Action)process, "REF", EcoreUtil.getURI((EObject)refMd));
        }
        return process;
    }

    void addAltId(Action owner, String origin, String value) {
        AltId altId = ProcFactory.eINSTANCE.createAltId();
        altId.setOrigin(origin);
        altId.setValue(value);
        owner.getAltId().add((Object)altId);
    }

    void handleParameters() {
        for (Object k : this.duplicatedActionProcessRefParameters.keySet()) {
            Parameter origin = (Parameter)this.duplicatedActionProcessRefParameters.getTo(k);
            if (origin.getRef() == null) continue;
            Parameter ref = (Parameter)this.duplicatedActionProcessRefParameters.getFrom((Object)origin.getRef());
            ((Parameter)k).setRef(ref);
        }
    }
}

