/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.xsl.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.tinytree.TinyNodeImpl;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.ObjectValue;

public class ResultSetManager {
    Map<String, IndyResultSet> resultSets;
    Map<String, IndySourceSet> sourceSets;
    private Connection connection;
    public IndyElement root;
    static ResultSetManager INSTANCE = new ResultSetManager();

    public ResultSetManager() {
    }

    public ResultSetManager(Connection connection, Map<String, String> querys, Map<String, String> sourceSetMap) {
        this.connection = connection;
        this.resultSets = new TreeMap<String, IndyResultSet>();
        this.sourceSets = new HashMap<String, IndySourceSet>();
        for (Map.Entry<String, String> entry : querys.entrySet()) {
            String sourceSetName = sourceSetMap.get(entry.getKey());
            this.sourceSets.computeIfAbsent(sourceSetName, string -> new IndySourceSet((String)string));
        }
    }

    public static boolean testFilter(XPathContext context, ValueRepresentation v, String resultSetName) throws SQLException {
        ResultSetManager rsm = null;
        boolean result = false;
        if (v instanceof ObjectValue) {
            rsm = (ResultSetManager)((ObjectValue)v).getObject();
        }
        if (rsm != null) {
            IndyResultSet irs = rsm.resultSets.get(resultSetName);
            if (!irs.started) {
                irs.initResultSet();
                irs.next();
            }
            result = irs.filtersOk();
        }
        return result;
    }

    public static boolean testFilter(XPathContext context, ValueRepresentation v, String resultSetName, ValueRepresentation filters) throws SQLException {
        ResultSetManager rsm = null;
        boolean result = false;
        if (v instanceof ObjectValue) {
            rsm = (ResultSetManager)((ObjectValue)v).getObject();
        }
        if (rsm != null) {
            IndyResultSet irs = rsm.resultSets.get(resultSetName);
            if (!irs.started) {
                irs.initResultSet();
                irs.next();
            }
            irs.applyFilter(context, filters);
            result = irs.filtersOk();
        }
        return result;
    }

    public static IndyElement createElement(XPathContext context, String name, String alias, String id, boolean isKey, String resultSet, IndyElement parent) throws SQLException {
        ResultSetManager resultSetManager = INSTANCE;
        resultSetManager.getClass();
        IndyElement ie = resultSetManager.new IndyElement(isKey, name, alias, id, resultSet, parent);
        return ie;
    }

    public static void addAttribute(XPathContext context, String name, String alias, String id, String resultSet, IndyElement parent) throws SQLException {
        ResultSetManager resultSetManager = INSTANCE;
        resultSetManager.getClass();
        parent.addAttribute(resultSetManager.new IndyAttribute(name, alias, id, parent, resultSet));
    }

    public static IndyElement createRoot(XPathContext context, ResultSetManager rsm) throws SQLException {
        IndyElement ie = INSTANCE.new IndyElement();
        rsm.setRoot(ie);
        ie.setResulSetManager(rsm);
        return ie;
    }

    private void setRoot(IndyElement ie) {
        this.root = ie;
    }

    public static boolean next(XPathContext context, ValueRepresentation v, String resultSetName) throws XPathException, SQLException {
        boolean result = false;
        ResultSetManager rsm = null;
        if (v instanceof ObjectValue) {
            rsm = (ResultSetManager)((ObjectValue)v).getObject();
        }
        if (rsm != null) {
            IndyResultSet irs = rsm.resultSets.get(resultSetName);
            result = irs.next();
        }
        return result;
    }

    public static boolean hasCurrent(XPathContext context, ValueRepresentation v, String resultSetName) {
        ResultSetManager rsm = null;
        if (v instanceof ObjectValue) {
            rsm = (ResultSetManager)((ObjectValue)v).getObject();
        }
        if (rsm != null) {
            IndyResultSet irs = rsm.resultSets.get(resultSetName);
            return irs.hasCurrent();
        }
        return false;
    }

    public static void addFilter(XPathContext context, ValueRepresentation v, String resultSetName, String filterName) throws SQLException {
        ResultSetManager rsm = null;
        if (v instanceof ObjectValue) {
            rsm = (ResultSetManager)((ObjectValue)v).getObject();
        }
        if (rsm != null) {
            IndyResultSet irs = rsm.resultSets.get(resultSetName);
            String value = irs.getValue(filterName);
            irs.sourceSet.addFilter(filterName, value);
        }
    }

    public static void removeFilter(XPathContext context, ValueRepresentation v, String resultSetName, String filterName) {
        ResultSetManager rsm = null;
        if (v instanceof ObjectValue) {
            rsm = (ResultSetManager)((ObjectValue)v).getObject();
        }
        if (rsm != null) {
            IndyResultSet irs = rsm.resultSets.get(resultSetName);
            irs.sourceSet.removeFilter(filterName);
        }
    }

    public static Object getField(XPathContext context, ValueRepresentation v, String resultSetName, String name) throws SQLException {
        String result = null;
        ResultSetManager rsm = null;
        if (v instanceof ObjectValue) {
            rsm = (ResultSetManager)((ObjectValue)v).getObject();
        }
        if (rsm != null) {
            IndyResultSet irs = rsm.resultSets.get(resultSetName);
            result = irs.getValue(name);
        }
        return result;
    }

    static boolean equals(Object value1, Object value2) {
        if (value1 == null) {
            return value2 == null;
        }
        if (value2 == null) {
            return value1 == null;
        }
        String str1 = value1.toString();
        String str2 = value2.toString();
        return str1.equals(str2);
    }

    class IndyAttribute {
        String name;
        String id;
        String alias;
        private IndyElement parent;
        private IndyResultSet resultSet;

        public IndyAttribute(String name, String alias, String id, IndyElement parent, String resultSet) {
            this.alias = alias;
            this.id = id;
            this.name = name;
            this.parent = parent;
            ResultSetManager rsm = parent.getResultSetManager();
            if (rsm != null) {
                this.resultSet = rsm.resultSets.get(resultSet);
            }
        }

        public void go(Receiver out, NamePool pool) throws SQLException, XPathException {
            String value = this.resultSet.getValue(this.alias);
            if (value != null) {
                int attrCode = pool.allocate("", "", this.name);
                out.attribute(attrCode, 631, (CharSequence)value, 0, 0);
            }
        }
    }

    class IndyElement {
        String name;
        IndyResultSet resultSet;
        boolean isKey = false;
        List<IndyAttribute> attributes = new ArrayList<IndyAttribute>();
        List<IndyElement> elements = new ArrayList<IndyElement>();
        private String id;
        private IndyElement parent;
        private ResultSetManager resultSetManager;
        private String alias;

        public ResultSetManager getResultSetManager() {
            if (this.parent != null) {
                return this.parent.getResultSetManager();
            }
            return this.resultSetManager;
        }

        public IndyElement(boolean isKey, String name, String alias, String id, String resultSet, IndyElement parent) {
            this.isKey = isKey;
            this.name = name;
            this.id = id;
            this.alias = alias;
            this.setParent(parent);
            ResultSetManager rsm = this.getResultSetManager();
            if (rsm != null) {
                this.resultSet = rsm.resultSets.get(resultSet);
            }
        }

        public IndyElement() {
        }

        public void go(XPathContext context) throws SQLException, XPathException {
            if (this.parent == null) {
                for (IndyElement elt : this.elements) {
                    elt.go(context);
                }
            }
            Controller controller = context.getController();
            NamePool pool = controller.getNamePool();
            SequenceReceiver out = context.getReceiver();
            int eltCode = pool.allocate("", "", this.name);
            while (this.resultSet.filtersOk()) {
                if (this.isKey) {
                    String keyVal = this.resultSet.getValue(this.alias);
                    this.resultSet.sourceSet.addFilter(this.alias, keyVal);
                }
                out.startElement(eltCode, 630, 0, 0);
                for (IndyAttribute attribute : this.attributes) {
                    attribute.go((Receiver)out, pool);
                }
                if (this.elements.isEmpty()) {
                    this.resultSet.next();
                } else {
                    for (IndyElement elt : this.elements) {
                        elt.go(context);
                    }
                }
                out.endElement();
                if (!this.isKey) continue;
                this.resultSet.sourceSet.removeFilter(this.alias);
            }
        }

        public void setParent(IndyElement parent) {
            if (parent != null) {
                this.parent = parent;
                parent.elements.add(this);
            }
        }

        public void setResulSetManager(ResultSetManager rsm) {
            this.resultSetManager = rsm;
        }

        public void addAttribute(IndyAttribute attr) {
            this.attributes.add(attr);
        }
    }

    class IndyResultSet {
        ResultSet rs;
        int position = 0;
        boolean ended = false;
        boolean started = false;
        boolean neverExecuted = true;
        String query;
        private Map<String, String> filtersMap;
        private Connection connection;
        private IndySourceSet sourceSet;

        public IndyResultSet(String query, IndySourceSet sourceSet, Connection connection) {
            this.query = query;
            this.sourceSet = sourceSet;
            this.connection = connection;
        }

        void initResultSet() throws SQLException {
            Throwable throwable = null;
            Object var2_3 = null;
            try (PreparedStatement st = this.connection.prepareStatement(this.query);){
                this.rs = st.executeQuery();
                this.rs.setFetchSize(1000);
                this.neverExecuted = false;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        private boolean next() throws SQLException {
            if (this.neverExecuted) {
                this.initResultSet();
            }
            boolean result = this.rs.next();
            ++this.position;
            if (result) {
                ++this.position;
                this.started = true;
            } else {
                this.ended = true;
            }
            return result;
        }

        boolean keyOk(String keyName, String keyValye) throws SQLException {
            if (keyName != null) {
                Object valueToCompare = this.rs.getObject(keyName);
                boolean compare = ResultSetManager.equals(valueToCompare, keyValye);
                return !compare;
            }
            return true;
        }

        boolean filtersOk() throws SQLException {
            if (this.neverExecuted) {
                this.next();
            }
            Map<String, String> localFiltersMap = this.sourceSet.currentFilters;
            if (this.started && !this.ended) {
                if (localFiltersMap != null) {
                    for (Map.Entry<String, String> entry : localFiltersMap.entrySet()) {
                        Object str = this.rs.getObject(entry.getKey());
                        boolean compare = ResultSetManager.equals(str, entry.getValue());
                        if (compare) continue;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }

        public void applyFilter(XPathContext context, ValueRepresentation filters) {
            this.filtersMap = new HashMap<String, String>();
            if (filters instanceof TinyNodeImpl) {
                AxisIterator ai = ((TinyNodeImpl)filters).iterateAxis((byte)3);
                while (ai.next() != null) {
                    Item item = ai.current();
                    String alias = Navigator.getAttributeValue((NodeInfo)((NodeInfo)item), null, (String)"alias");
                    String value = Navigator.getAttributeValue((NodeInfo)((NodeInfo)item), null, (String)"value");
                    this.filtersMap.put(alias, value);
                }
            }
        }

        public boolean next(XPathContext context, boolean first) throws SQLException, XPathException {
            XPathException de = null;
            if (this.neverExecuted) {
                this.initResultSet();
            }
            try {
                if (!this.ended) {
                    boolean next = false;
                    if (!this.started && !this.ended) {
                        next = this.next();
                    } else if (this.started && !this.ended) {
                        next = first ? true : this.next();
                    }
                    boolean filtersOk = this.filtersOk();
                    while (next && !filtersOk) {
                        next = this.next();
                        if (!next) continue;
                        filtersOk = this.filtersOk();
                    }
                    if (filtersOk) {
                        return true;
                    }
                }
            }
            catch (SQLException ex) {
                de = new XPathException("(SQL) " + ex.getMessage());
                de.setXPathContext(context);
                throw de;
            }
            return false;
        }

        public boolean hasCurrent() {
            return this.started && !this.ended;
        }

        public String getValue(String name) throws SQLException {
            if (this.started && !this.ended) {
                return this.rs.getString(name);
            }
            return null;
        }
    }

    class IndySourceSet {
        String name;
        Map<String, String> currentFilters = new HashMap<String, String>();

        public IndySourceSet(String name) {
            this.name = name;
        }

        public void addFilter(String keyName, String keyVal) {
            if (keyName != null && keyVal != null) {
                this.currentFilters.put(keyName, keyVal);
            }
        }

        public void removeFilter(String keyName) {
            this.currentFilters.remove(keyName);
        }
    }
}

