/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.utils;

import java.text.MessageFormat;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class MultiLineTextAndDialogCellEditor
extends DialogCellEditor {
    protected Text textField;
    protected String dialogMessage;
    protected String dialogTitle;

    public MultiLineTextAndDialogCellEditor(Composite parent) {
        super(parent);
    }

    public Control getText() {
        return this.textField;
    }

    protected Control createContents(Composite cell) {
        this.textField = new Text(cell, this.isReadOnly() ? 8 : 0);
        this.textField.setFont(cell.getFont());
        this.textField.setBackground(cell.getBackground());
        this.textField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                MultiLineTextAndDialogCellEditor.this.setValueToModel();
            }
        });
        this.textField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                MultiLineTextAndDialogCellEditor.this.keyReleaseOccured(event);
            }
        });
        return this.textField;
    }

    private boolean isReadOnly() {
        return false;
    }

    public void setDialogMessage(String dialogMessage) {
        this.dialogMessage = dialogMessage;
    }

    public void setDialogTitle(String dialogTitle) {
        this.dialogTitle = dialogTitle;
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.keyCode == 13 || keyEvent.keyCode == 0x1000050) {
            this.setValueToModel();
        }
        super.keyReleaseOccured(keyEvent);
    }

    protected void setValueToModel() {
        String newValue = this.textField.getText();
        boolean newValidState = this.isCorrect(newValue);
        if (newValidState) {
            this.markDirty();
            this.doSetValue(newValue);
        } else {
            this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), newValue));
        }
    }

    protected void updateContents(Object value) {
        if (this.textField == null) {
            return;
        }
        String text = "";
        if (value != null) {
            text = value.toString();
        }
        this.textField.setText(text);
    }

    protected void doSetFocus() {
        this.textField.setFocus();
        this.textField.selectAll();
    }

    protected String getDialogInitialValue() {
        Object value = this.getValue();
        return value == null ? null : value.toString();
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        return null;
    }
}

