/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.tools;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;

public class DataBindingUtils {
    private static final Logger logger = LogManager.getLogger(DataBindingUtils.class);

    public static EMFUpdateValueStrategy modelToTargetTexoDateStrategy() {
        EMFUpdateValueStrategy modelToTarget = new EMFUpdateValueStrategy();
        modelToTarget.setConverter(DataBindingUtils.modelToTargetTexoDateConverter());
        return modelToTarget;
    }

    public static EMFUpdateValueStrategy targetToModelTexoDateStrategy() {
        EMFUpdateValueStrategy targetToModel = new EMFUpdateValueStrategy();
        targetToModel.setConverter(new IConverter(){

            public Object convert(Object fromObject) {
                return null;
            }

            public Object getFromType() {
                return null;
            }

            public Object getToType() {
                return null;
            }
        });
        return targetToModel;
    }

    public static IConverter modelToTargetTexoDateConverter() {
        return new IConverter(){
            SimpleDateFormat sdf = new SimpleDateFormat("YYYY-MM-DD HH:mm:ss");

            public Object getToType() {
                return null;
            }

            public Object getFromType() {
                return null;
            }

            public Object convert(Object fromObject) {
                if (fromObject != null) {
                    try {
                        Date d = (Date)fromObject;
                        return this.sdf.format(d);
                    }
                    catch (Exception ex) {
                        logger.warn("unexpected", (Throwable)ex);
                    }
                }
                return "";
            }
        };
    }
}

