/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.tools;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MultiStringInputDialog
extends Dialog {
    private List<String> input;
    private Text addText;
    private final transient Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());

    public MultiStringInputDialog(Shell parentShell, String input) {
        super(parentShell);
        this.input = new ArrayList<String>();
        String[] stringArray = input.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (!str.isEmpty()) {
                this.input.add(str);
            }
            ++n2;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Composite addComposite = new Composite(container, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(addComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)addComposite);
        this.addText = new Text(addComposite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.addText);
        Button addBtn = new Button(addComposite, 8);
        Button removeBtn = new Button(addComposite, 8);
        final ListViewer listViewer = new ListViewer(container);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo(listViewer.getControl());
        try {
            removeBtn.setImage(ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.eclipse.rap.ui/icons/full/elcl16/collapseall.gif")).createImage());
            addBtn.setImage(ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.eclipse.rap.ui/icons/full/elcl16/expandall.gif")).createImage());
        }
        catch (MalformedURLException e1) {
            this.logger.warn("unexpected", (Throwable)e1);
        }
        addBtn.setFocus();
        addBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!MultiStringInputDialog.this.addText.getText().isEmpty() && !MultiStringInputDialog.this.input.contains(MultiStringInputDialog.this.addText.getText())) {
                    MultiStringInputDialog.this.input.add(MultiStringInputDialog.this.addText.getText());
                    listViewer.refresh();
                }
            }
        });
        removeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String oldValue = (String)((IStructuredSelection)listViewer.getSelection()).getFirstElement();
                if (oldValue != null) {
                    MultiStringInputDialog.this.input.remove(oldValue);
                    listViewer.refresh();
                    MultiStringInputDialog.this.addText.setText(oldValue);
                }
            }
        });
        listViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    IStructuredSelection selection = (IStructuredSelection)listViewer.getSelection();
                    if (selection.isEmpty()) {
                        return;
                    }
                    for (Object str : selection.toList()) {
                        MultiStringInputDialog.this.input.remove(str);
                    }
                    listViewer.refresh();
                }
            }
        });
        listViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        listViewer.setInput(this.input);
        listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                return element.toString();
            }
        });
        listViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                String oldValue = (String)((IStructuredSelection)event.getSelection()).getFirstElement();
                MultiStringInputDialog.this.input.remove(oldValue);
                event.getViewer().refresh();
                MultiStringInputDialog.this.addText.setText(oldValue);
            }
        });
        return container;
    }

    protected void okPressed() {
        super.okPressed();
    }

    protected Point getInitialSize() {
        return new Point(300, 400);
    }

    public String getElements() {
        String elements = "";
        for (String element : this.input) {
            elements = String.valueOf(elements) + element + ",";
        }
        if (elements.endsWith(",")) {
            elements = elements.substring(0, elements.length() - 1);
        }
        return elements;
    }
}

