/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.tools.table;

import com.stambia.ui.tools.table.ColumnInfo;
import com.stambia.ui.tools.table.GroupInfo;
import com.stambia.ui.tools.table.ISessionViewer;
import com.stambia.ui.tools.table.StbTableLabelProvider;
import com.stambia.ui.widget.StambiaWidget;
import com.stambia.ui.widget.StambiaWidgetUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IWorkbenchPartSite;

public abstract class StbTreeTable
extends Tree
implements StambiaWidget {
    private ISerializer serializer;
    private Menu headerMenu;
    private Menu treeItemMenu;
    private boolean headerMenuItemHasBeenSelected;
    private Listener addRemoveColumnListener;
    Map<String, ColumnInfo> columns = new HashMap<String, ColumnInfo>();
    Map<TreeColumn, ColumnInfo> visibleColumns = new HashMap<TreeColumn, ColumnInfo>();
    private boolean initMenu;
    private TreeViewer viewer;
    public Map<String, GroupInfo> toGroup = new LinkedHashMap<String, GroupInfo>();
    private List<WrappedContentProvider.Group> groups;
    SelectionListener sortListener;

    protected void checkSubclass() {
    }

    public void setSerializer(ISerializer serializer) {
        this.serializer = serializer;
    }

    public Collection<ColumnInfo> getColumnsInfo() {
        return this.columns.values();
    }

    public void setHideColumn(String id, boolean hide) {
        ColumnInfo col = this.columns.get(id);
        if (col != null) {
            col.hide = hide;
            this.savePreference();
        }
    }

    public StbTreeTable(final Composite parent, int style, SelectionListener sortListener) {
        super(parent, style);
        StambiaWidgetUtils.addDisposeListener(this);
        this.sortListener = sortListener;
        this.initMenu = true;
        this.headerMenu = new Menu((Decorations)parent.getShell(), 8);
        this.headerMenu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
            }

            public void menuHidden(MenuEvent event) {
                if (StbTreeTable.this.headerMenuItemHasBeenSelected) {
                    StbTreeTable.this.headerMenu.setVisible(true);
                    StbTreeTable.this.headerMenuItemHasBeenSelected = false;
                }
            }
        });
        this.addRemoveColumnListener = new Listener(){

            public void handleEvent(Event event) {
                StbTreeTable.this.setMenu(null);
                Point pt = parent.getDisplay().map(null, (Control)StbTreeTable.this, new Point(event.x, event.y));
                Rectangle clientArea = StbTreeTable.this.getClientArea();
                if (clientArea.y <= pt.y && pt.y < clientArea.y + StbTreeTable.this.getHeaderHeight()) {
                    StbTreeTable.this.refreshMenu();
                    StbTreeTable.this.headerMenu.setLocation(event.x, event.y);
                    if (StbTreeTable.this.treeItemMenu != null) {
                        StbTreeTable.this.treeItemMenu.setVisible(false);
                    }
                    StbTreeTable.this.headerMenu.setVisible(true);
                } else if (StbTreeTable.this.treeItemMenu != null) {
                    StbTreeTable.this.treeItemMenu.setLocation(event.x, event.y);
                    StbTreeTable.this.headerMenu.setVisible(false);
                    StbTreeTable.this.treeItemMenu.setVisible(true);
                }
            }
        };
        this.addListener(35, this.addRemoveColumnListener);
        this.initColumns();
        this.sortColums(this.columns);
    }

    public void createContextMenu(IWorkbenchPartSite site) {
        if (this.viewer != null) {
            MenuManager menuManager = new MenuManager("#PopUp");
            this.treeItemMenu = menuManager.createContextMenu(this.viewer.getControl());
            this.viewer.getControl().setMenu(this.treeItemMenu);
            site.registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
        }
    }

    public int getColumnIndex(TreeColumn treeColumn) {
        int i = 0;
        while (i < this.getColumnCount()) {
            if (this.getColumn(i) == treeColumn) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getColumnIndex(ColumnInfo col) {
        if (col.treeColumn != null) {
            return this.getColumnIndex(col.treeColumn);
        }
        return -1;
    }

    public ColumnInfo getColumnInfo(String id) {
        return this.columns.get(id);
    }

    public abstract void initColumns();

    private void reset() {
        this.columns.clear();
        this.initColumns();
        this.sortColums(this.columns);
    }

    public void add(ColumnInfo column) {
        column.position = this.columns.size();
        this.columns.put(column.getId(), column);
    }

    public void sortColums(Map<String, ColumnInfo> cols) {
        ArrayList<ColumnInfo> tmp = new ArrayList<ColumnInfo>(cols.values());
        List<String> listOrder = Arrays.asList("Start", "Name", "Status", "ElapsedTime", "Configuration", "Insert", "Update", "Delete", "Reject", "Rows", "OutFileCount", "OutFileSize", "WsdlSuccess", "WsdlError");
        for (String c : this.columns.keySet()) {
            int newPos = listOrder.indexOf(c) + 1;
            if (newPos != 0) {
                this.columns.get(c).setPosition(listOrder.indexOf(c) + 1);
                continue;
            }
            this.columns.get(c).setPosition(this.columns.size());
        }
    }

    public ColumnInfo getColumnInfo(int index) {
        return this.getColumnInfo(this.getColumn(index));
    }

    public ColumnInfo getColumnInfo(TreeColumn tc) {
        return this.visibleColumns.get(tc);
    }

    public WrappedContentProvider.Group getParentGroup(WrappedContentProvider.Group parent, Object element) {
        for (Object group : parent.childrens) {
            if (!(group instanceof WrappedContentProvider.Group)) continue;
            if (((WrappedContentProvider.Group)group).childrens.contains(element)) {
                return (WrappedContentProvider.Group)group;
            }
            WrappedContentProvider.Group parentGroup = this.getParentGroup((WrappedContentProvider.Group)group, element);
            if (parentGroup == null) continue;
            return parentGroup;
        }
        return null;
    }

    public boolean groupsHasStatusGroup() {
        for (String str : this.toGroup.keySet()) {
            if (!str.equals("Status")) continue;
            return true;
        }
        return false;
    }

    public void setGroups(List<GroupInfo> groups) {
        if (this.toGroup == null || !this.isEqualGroups(new ArrayList<GroupInfo>(this.toGroup.values()), groups)) {
            this.clearGroups();
            for (GroupInfo gi : groups) {
                this.toGroup.put(gi.columnId, gi);
            }
            this.refreshColumns();
        }
    }

    public boolean isEqualGroups(List<GroupInfo> a, List<GroupInfo> b) {
        if (a.size() != b.size() || a == null && b != null || a != null && b == null) {
            return false;
        }
        if (a == null && b == null) {
            return true;
        }
        Collections.sort(a);
        Collections.sort(b);
        int i = 0;
        while (i < a.size()) {
            if (!a.get((int)0).columnId.equals(b.get((int)0).columnId) || a.get((int)0).hide != b.get((int)0).hide) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getColumnIndex(String id) {
        ColumnInfo col = this.columns.get(id);
        if (col != null) {
            return this.getColumnIndex(col);
        }
        return -1;
    }

    private void clearGroups() {
        if (this.groups != null) {
            for (WrappedContentProvider.Group grp : this.groups) {
                grp.clear();
            }
        }
        this.toGroup.clear();
        for (ColumnInfo ci : this.getColumnsInfo()) {
            ci.isHideGroupColumn = false;
        }
    }

    public void setContentProvider(ITreeContentProvider tcp) {
        this.viewer.setContentProvider((IContentProvider)new WrappedContentProvider(tcp));
    }

    private void savePreference() {
        if (this.serializer != null) {
            this.serializer.saveColumnPreference(this.columns.values());
        }
    }

    public void loadTablePreference() {
        if (this.serializer != null) {
            String[] colPrefs;
            String[] stringArray = colPrefs = this.serializer.getColumnPreference();
            int n = colPrefs.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnInfo col;
                String[] prefs;
                String pref = stringArray[n2];
                if (!pref.isEmpty() && (prefs = pref.split(";")).length == 4 && (col = this.getColumnInfo(prefs[0])) != null) {
                    col.setHide(Boolean.valueOf(prefs[1]));
                    col.setWidth(Integer.parseInt(prefs[2]));
                    col.setPosition(Integer.parseInt(prefs[3]));
                }
                ++n2;
            }
        }
    }

    private void synchronizeColumnInfoWithTreeColumn() {
        int k = 0;
        int[] orders = this.getColumnOrder();
        while (this.getColumnCount() > k) {
            TreeColumn tc = this.getColumns()[k++];
            int i = this.getColumnIndex(tc);
            ColumnInfo col = this.visibleColumns.get(tc);
            col.width = tc.getWidth();
            int colIdx = 0;
            while (colIdx < orders.length) {
                if (orders[colIdx] == i) {
                    col.setPosition(colIdx);
                }
                ++colIdx;
            }
        }
    }

    public void refreshColumns() {
        this.setRedraw(false);
        while (this.getColumnCount() > 0) {
            TreeColumn tc = this.getColumns()[0];
            if (this.sortListener != null) {
                tc.removeSelectionListener(this.sortListener);
            }
            tc.dispose();
        }
        this.visibleColumns.clear();
        ArrayList<ColumnInfo> cols = new ArrayList<ColumnInfo>(this.columns.values());
        Collections.sort(cols);
        for (final ColumnInfo col : cols) {
            GroupInfo gi = this.toGroup.get(col.getId());
            if (!(col.hide || gi != null && gi.hide)) {
                TreeColumn tableColumn = new TreeColumn((Tree)this, 0);
                TreeViewerColumn columnViewer = new TreeViewerColumn(this.viewer, tableColumn);
                columnViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                    public String getToolTipText(Object element) {
                        return col.getToolTipText(element);
                    }

                    public Image getImage(Object element) {
                        if (StbTreeTable.this.viewer.getLabelProvider() instanceof StbTableLabelProvider) {
                            return ((StbTableLabelProvider)StbTreeTable.this.viewer.getLabelProvider()).getColumnImage(element, StbTreeTable.this.getColumnIndex(col));
                        }
                        return null;
                    }

                    public String getText(Object element) {
                        if (StbTreeTable.this.viewer.getLabelProvider() instanceof StbTableLabelProvider) {
                            return ((StbTableLabelProvider)StbTreeTable.this.viewer.getLabelProvider()).getColumnText(element, StbTreeTable.this.getColumnIndex(col));
                        }
                        return null;
                    }
                });
                tableColumn.setWidth(col.width);
                tableColumn.setText(col.label != null ? col.label : "");
                tableColumn.setMoveable(true);
                tableColumn.addControlListener((ControlListener)new ControlAdapter(){

                    public void controlMoved(ControlEvent e) {
                        ITreeContentProvider wrappedContentProvider;
                        StbTreeTable.this.synchronizeColumnInfoWithTreeColumn();
                        if (e.getSource() instanceof TreeColumn && StbTreeTable.this.getColumnIndex((TreeColumn)e.getSource()) == 0 && StbTreeTable.this.viewer.getContentProvider() instanceof WrappedContentProvider && (wrappedContentProvider = ((WrappedContentProvider)StbTreeTable.this.viewer.getContentProvider()).getWrapped()) instanceof ISessionViewer) {
                            ((ISessionViewer)wrappedContentProvider).refreshHeader();
                        }
                    }
                });
                if (this.sortListener != null) {
                    tableColumn.addSelectionListener(this.sortListener);
                }
                this.visibleColumns.put(tableColumn, col);
                col.treeColumn = tableColumn;
                continue;
            }
            col.treeColumn = null;
        }
        this.synchronizeColumnInfoWithTreeColumn();
        this.setRedraw(true);
        this.initMenu();
    }

    private void refreshMenu() {
        for (ColumnInfo column : this.getColumnsInfo()) {
            MenuItem[] menuItemArray = this.headerMenu.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem currentItem = menuItemArray[n2];
                if (currentItem.getText().equals(column.label)) {
                    if (column.isHide()) {
                        currentItem.setSelection(false);
                    } else {
                        currentItem.setSelection(true);
                    }
                }
                ++n2;
            }
        }
    }

    public void initMenu() {
        if (this.initMenu) {
            ArrayList<ColumnInfo> sortedcolumns = new ArrayList<ColumnInfo>();
            sortedcolumns.addAll(this.getColumnsInfo());
            Collections.sort(sortedcolumns);
            for (ColumnInfo column : sortedcolumns) {
                MenuItem menuItem = new MenuItem(this.headerMenu, 32);
                menuItem.setText(column.label != null ? column.label : "");
                menuItem.setData((Object)column.getId());
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        StbTreeTable.this.headerMenuItemHasBeenSelected = true;
                        MenuItem selected = (MenuItem)event.widget;
                        if (selected.getSelection()) {
                            StbTreeTable.this.columns.get(selected.getData()).setHide(false);
                        } else {
                            StbTreeTable.this.columns.get(selected.getData()).setHide(true);
                        }
                        StbTreeTable.this.refreshColumns();
                        if (StbTreeTable.this.viewer != null) {
                            StbTreeTable.this.viewer.refresh();
                        }
                    }
                });
            }
            MenuItem menuItem = new MenuItem(this.headerMenu, 2);
            menuItem = new MenuItem(this.headerMenu, 0);
            menuItem.setText("Reset");
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    StbTreeTable.this.reset();
                    StbTreeTable.this.refreshColumns();
                    if (StbTreeTable.this.viewer != null) {
                        StbTreeTable.this.viewer.refresh();
                    }
                }
            });
            this.initMenu = false;
        }
    }

    public TreeViewer createTreeViewer() throws Exception {
        if (this.viewer != null) {
            throw new Exception("viewer already exists");
        }
        this.viewer = new TreeViewer((Tree)this);
        this.viewer.setUseHashlookup(true);
        return this.viewer;
    }

    @Override
    public void _dispose() {
        this.synchronizeColumnInfoWithTreeColumn();
        this.savePreference();
        this.headerMenu.dispose();
        this.removeListener(35, this.addRemoveColumnListener);
        this.addRemoveColumnListener = null;
        this.clearGroups();
        this.viewer = null;
    }

    public static interface ISerializer {
        public void saveColumnPreference(Collection<ColumnInfo> var1);

        public String[] getColumnPreference();
    }

    public class WrappedContentProvider
    implements ITreeContentProvider {
        ITreeContentProvider wrapped;
        List<Object> roots = new ArrayList<Object>();

        public ITreeContentProvider getWrapped() {
            return this.wrapped;
        }

        private WrappedContentProvider(ITreeContentProvider wrapped) {
            this.wrapped = wrapped;
            StbTreeTable.this.groups = new ArrayList<Group>();
        }

        public void dispose() {
            this.wrapped.dispose();
            this.wrapped = null;
            this.roots.clear();
            this.roots = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.wrapped.inputChanged(viewer, oldInput, newInput);
        }

        public boolean compareGroup(Group group1, Group group2) {
            return group1.label.equals(group2.label) && group1.type.equals(group2.type);
        }

        public Collection<Group> getRootGroups() {
            return StbTreeTable.this.groups;
        }

        public List<Object> getAllChildrens(Object element) {
            ArrayList<Object> childrens = new ArrayList<Object>();
            if (element instanceof Group && !((Group)element).childrens.isEmpty()) {
                Object[] objectArray = this.getChildren(element);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    if (!(child instanceof Group)) {
                        childrens.add(child);
                    } else {
                        childrens.addAll(this.getAllChildrens(child));
                    }
                    ++n2;
                }
            } else {
                childrens.add(element);
            }
            return childrens;
        }

        public void addElement(Object element, boolean isSessionChildStandalone) {
            if (StbTreeTable.this.toGroup.isEmpty()) {
                if (isSessionChildStandalone) {
                    StbTreeTable.this.viewer.add(StbTreeTable.this.viewer.getInput(), element);
                } else {
                    Object parent = this.getParent(element);
                    if (parent == null) {
                        StbTreeTable.this.viewer.add(StbTreeTable.this.viewer.getInput(), element);
                    } else {
                        StbTreeTable.this.viewer.add(parent, element);
                    }
                }
            } else if (isSessionChildStandalone || this.getParent(element) == null) {
                Object parent;
                Object object = parent = isSessionChildStandalone ? StbTreeTable.this.viewer.getInput() : this.getParent(element);
                if (parent == null) {
                    parent = StbTreeTable.this.viewer.getInput();
                }
                Group parentGroup = null;
                ArrayList<Group> toUpdate = new ArrayList<Group>();
                boolean createMode = false;
                for (String groupType : StbTreeTable.this.toGroup.keySet()) {
                    String label;
                    if (createMode) {
                        Group group = new Group(parentGroup);
                        group.label = this.getElementLabel(groupType, element);
                        group.image = this.getGroupImage(groupType, element);
                        group.type = StbTreeTable.this.toGroup.get((Object)groupType).columnId;
                        toUpdate.add(group);
                        parentGroup.addElement(group);
                        StbTreeTable.this.viewer.add((Object)parentGroup, (Object)group);
                        parentGroup = group;
                        continue;
                    }
                    if (parentGroup == null) {
                        for (Group group : StbTreeTable.this.groups) {
                            ColumnInfo columnInfo = StbTreeTable.this.columns.get(StbTreeTable.this.toGroup.get((Object)groupType).columnId);
                            String string = label = columnInfo.getGroupText(element) != null ? columnInfo.getGroupText(element) : columnInfo.getText(element);
                            if (!group.type.equals(groupType) || !group.label.equals(label)) continue;
                            parentGroup = group;
                            toUpdate.add(group);
                        }
                        if (parentGroup != null) continue;
                        Group group = new Group(null);
                        group.label = this.getElementLabel(groupType, element);
                        group.image = this.getGroupImage(groupType, element);
                        group.type = StbTreeTable.this.toGroup.get((Object)groupType).columnId;
                        StbTreeTable.this.groups.add(group);
                        toUpdate.add(group);
                        StbTreeTable.this.viewer.add(StbTreeTable.this.viewer.getInput(), (Object)group);
                        parentGroup = group;
                        createMode = true;
                        continue;
                    }
                    boolean childGroupExist = false;
                    for (Object children : parentGroup.childrens) {
                        if (!(children instanceof Group)) continue;
                        label = this.getElementLabel(groupType, element);
                        if (!((Group)children).type.equals(groupType) || !((Group)children).label.equals(label)) continue;
                        parentGroup = (Group)children;
                        toUpdate.add(parentGroup);
                        childGroupExist = true;
                    }
                    if (childGroupExist) continue;
                    Group group = new Group(parentGroup);
                    group.label = this.getElementLabel(groupType, element);
                    group.image = this.getGroupImage(groupType, element);
                    group.type = StbTreeTable.this.toGroup.get((Object)groupType).columnId;
                    parentGroup.addElement(group);
                    StbTreeTable.this.viewer.add((Object)parentGroup, (Object)group);
                    toUpdate.add(group);
                    createMode = true;
                    parentGroup = group;
                }
                parentGroup.addElement(element);
                StbTreeTable.this.viewer.add((Object)parentGroup, element);
                for (Group group : toUpdate) {
                    StbTreeTable.this.viewer.refresh((Object)group);
                }
            }
        }

        public Image getGroupImage(String groupType, Object element) {
            ColumnInfo columnInfo = StbTreeTable.this.columns.get(StbTreeTable.this.toGroup.get((Object)groupType).columnId);
            return columnInfo.getGroupImage(element);
        }

        public String getElementLabel(String groupType, Object element) {
            String label;
            ColumnInfo columnInfo = StbTreeTable.this.columns.get(StbTreeTable.this.toGroup.get((Object)groupType).columnId);
            String string = label = columnInfo.getGroupText(element) != null ? columnInfo.getGroupText(element) : columnInfo.getText(element);
            if (label == null) {
                label = "unknown";
            }
            return label;
        }

        public Object removeElement(Object element) {
            Object toRefresh = element;
            if (!StbTreeTable.this.toGroup.isEmpty()) {
                ArrayList<Group> toUpdate = new ArrayList<Group>();
                Group parentGroup = null;
                block0: for (String groupType : StbTreeTable.this.toGroup.keySet()) {
                    String label;
                    if (parentGroup == null) {
                        for (Group group : StbTreeTable.this.groups) {
                            label = this.getElementLabel(groupType, element);
                            if (!group.type.equals(groupType) || !group.label.equals(label)) continue;
                            parentGroup = group;
                            toUpdate.add(parentGroup);
                            continue block0;
                        }
                        continue;
                    }
                    for (Object children : parentGroup.childrens) {
                        if (!(children instanceof Group)) continue;
                        label = this.getElementLabel(groupType, element);
                        if (!((Group)children).type.equals(groupType) || !((Group)children).label.equals(label)) continue;
                        parentGroup = (Group)children;
                        toUpdate.add(parentGroup);
                        continue block0;
                    }
                }
                if (parentGroup != null) {
                    parentGroup.removeElement(element);
                    toUpdate.add(parentGroup);
                    boolean updateParent = parentGroup.childrens.isEmpty();
                    while (updateParent) {
                        if (parentGroup.getParentGroup() == null) {
                            StbTreeTable.this.groups.remove(parentGroup);
                            StbTreeTable.this.viewer.remove((Object)parentGroup);
                            updateParent = false;
                            continue;
                        }
                        parentGroup.getParentGroup().removeElement(parentGroup);
                        parentGroup = parentGroup.getParentGroup();
                        updateParent = parentGroup.childrens.isEmpty();
                    }
                }
                for (Group group : toUpdate) {
                    StbTreeTable.this.viewer.refresh((Object)group);
                }
            } else {
                StbTreeTable.this.viewer.remove(element);
            }
            return toRefresh;
        }

        public Object[] getElements(Object inputElement) {
            if (StbTreeTable.this.toGroup.size() > 0) {
                return StbTreeTable.this.groups.toArray();
            }
            return this.wrapped.getElements(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Group) {
                return ((Group)parentElement).childrens.toArray();
            }
            return this.wrapped.getChildren(parentElement);
        }

        public Object getParent(Object element) {
            return this.wrapped.getParent(element);
        }

        public boolean hasChildren(Object element) {
            return this.wrapped.hasChildren(element);
        }

        public void updateElement(Object element, boolean isSessionChildStandalone) {
            if (StbTreeTable.this.toGroup.isEmpty()) {
                StbTreeTable.this.viewer.update(element, null);
                StbTreeTable.this.viewer.refresh(element);
            } else if (StbTreeTable.this.groupsHasStatusGroup()) {
                Group statusGroup;
                Group parentGroup = null;
                for (Group group : StbTreeTable.this.groups) {
                    if (parentGroup != null) break;
                    parentGroup = group.childrens.contains(element) ? group : StbTreeTable.this.getParentGroup(group, element);
                }
                if ((statusGroup = parentGroup) != null && !statusGroup.type.equals("Status")) {
                    boolean isStatusGroup = false;
                    while (!isStatusGroup) {
                        statusGroup = statusGroup.getParentGroup();
                        isStatusGroup = statusGroup.type.equals("Status");
                    }
                }
                if (statusGroup == null || this.getElementLabel("Status", element).equals(statusGroup.label)) {
                    StbTreeTable.this.viewer.update(element, null);
                    StbTreeTable.this.viewer.refresh(element);
                } else {
                    parentGroup.removeElement(element);
                    ArrayList<Group> toUpdate = new ArrayList<Group>();
                    toUpdate.add(parentGroup);
                    boolean updateParent = parentGroup.childrens.isEmpty();
                    while (updateParent) {
                        if (parentGroup.getParentGroup() == null) {
                            StbTreeTable.this.groups.remove(parentGroup);
                            StbTreeTable.this.viewer.remove((Object)parentGroup);
                            updateParent = false;
                            continue;
                        }
                        parentGroup.getParentGroup().removeElement(parentGroup);
                        parentGroup = parentGroup.getParentGroup();
                        updateParent = parentGroup.childrens.isEmpty();
                    }
                    this.removeElement(element);
                    for (Group group : toUpdate) {
                        StbTreeTable.this.viewer.refresh((Object)group);
                    }
                    this.addElement(element, isSessionChildStandalone);
                }
            } else {
                StbTreeTable.this.viewer.update(element, null);
                StbTreeTable.this.viewer.refresh(element);
            }
        }

        public void cleanGroup() {
            StbTreeTable.this.viewer.remove(StbTreeTable.this.groups.toArray());
            StbTreeTable.this.groups.clear();
        }

        public class Group {
            public List<Object> childrens = new ArrayList<Object>();
            List<Object> previous;
            boolean hasChildrenGroup = false;
            public String label;
            Image image;
            public String type;
            private Group parentGroup;

            public String toString() {
                return this.label;
            }

            public Group(Group parentGroup) {
                this.parentGroup = parentGroup;
            }

            public Group getParentGroup() {
                return this.parentGroup;
            }

            public int getChildren() {
                int childs = this.childrens.size();
                for (Object o : this.childrens) {
                    if (!(o instanceof Group)) continue;
                    childs += ((Group)o).getChildren() - 1;
                }
                return childs;
            }

            public void clear() {
                for (Object o : this.childrens) {
                    if (!(o instanceof Group)) continue;
                    ((Group)o).clear();
                }
                this.childrens.clear();
            }

            public void addElement(Object element) {
                if (!this.childrens.contains(element)) {
                    this.childrens.add(element);
                }
            }

            public void removeElement(Object element) {
                this.childrens.remove(element);
            }
        }
    }
}

