/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.util;

import com.stambia.md.Configuration;
import com.stambia.md.MdNode;
import com.stambia.md.util.MdAttributeReader;
import com.stambia.md.util.Messages;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.variables.VariablesPlugin;

public class MdAttributeNativeEvaluator {
    public static Pattern MD_LINK_PATTERN = Pattern.compile("(%\\{([a-zA-Z0-9_]*)\\}%)");
    public static Pattern ENV_VARIABLE_PATTERN = Pattern.compile("%(\\{env:([^\\{\\}%]+)\\})%");
    public static Pattern ALL_PATTERN = Pattern.compile("(%\\{([a-zA-Z0-9_]*)\\})%|(%(\\{env:([^\\{\\}%]+)\\})%)");

    public static String preserveNatuveEvaluationBlock(Configuration nodeCtx, String unResolvedValue, String newResolvedValue) {
        if (unResolvedValue != null && unResolvedValue.contains("%{")) {
            Matcher m = ALL_PATTERN.matcher(unResolvedValue);
            HashMap<String, CallSite> valPerExpression = new HashMap<String, CallSite>();
            boolean current = false;
            while (m.find()) {
                String val;
                String mdLinkName = m.group(2);
                if (mdLinkName != null) {
                    try {
                        Configuration mdLinkTrg = nodeCtx.evaluateMdNode("internal:getMetaDataLinkRef('" + mdLinkName + "')");
                        if (mdLinkTrg == null) {
                            throw new Exception(Messages.MdAttributeNativeEvaluator_mdLinkUnresolved);
                        }
                        val = null;
                        try {
                            val = mdLinkTrg.evaluateXpathExpressionCached("INTERNAL_NATIVE_MDLINK_RESOLUTION", null);
                            if (val == null || val.isEmpty()) continue;
                            valPerExpression.put(val, (CallSite)((Object)("%{" + mdLinkName + "}%")));
                        }
                        catch (Exception ex) {
                            throw new Exception(String.format(Messages.MdAttributeNativeEvaluator_mdLinkResolution, mdLinkName, nodeCtx.getId(), ex.getMessage()), ex);
                        }
                    }
                    catch (Throwable mdLinkTrg) {}
                    continue;
                }
                String varName = m.group(5);
                val = null;
                try {
                    val = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution("${" + varName + "}");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (val == null || val.isEmpty()) continue;
                valPerExpression.put(val, (CallSite)((Object)("%{env:" + varName + "}%")));
            }
            for (String exp : valPerExpression.keySet()) {
                newResolvedValue = newResolvedValue.replace(exp, (CharSequence)valPerExpression.get(exp));
            }
        }
        return newResolvedValue;
    }

    public static String readAttribute(String shortCode, MdNode node, IExceptionHandler handler) throws MdAttributeReader.UnknownTechPropertyException {
        String res = MdAttributeReader.readAttribute(shortCode, node);
        return MdAttributeNativeEvaluator.evaluate(res, node, handler);
    }

    public static List<String> readAttributeList(String shortCode, MdNode node, IExceptionHandler handler) throws MdAttributeReader.UnknownTechPropertyException {
        List<String> res = MdAttributeReader.readAttributeList(shortCode, node);
        if (res != null) {
            ArrayList<String> l = new ArrayList<String>();
            for (String s : res) {
                l.add(MdAttributeNativeEvaluator.evaluate(s, node, handler));
            }
        }
        return res;
    }

    public static Map<String, String> readAttributeMap(String shortCode, MdNode node, IExceptionHandler handler) throws MdAttributeReader.UnknownTechPropertyException {
        Map<String, String> res = MdAttributeReader.readAttributeMap(shortCode, node);
        if (res != null) {
            HashMap<String, String> l = new HashMap<String, String>();
            for (String s : res.keySet()) {
                l.put(MdAttributeNativeEvaluator.evaluate(s, node, handler), MdAttributeNativeEvaluator.evaluate(res.get(s), node, handler));
            }
        }
        return res;
    }

    public static String evaluate(String value, Configuration nodeCtx, IExceptionHandler handler) {
        if (value != null) {
            block16: {
                if (value.contains("%{env:")) {
                    String s = value.replaceAll("\\$\\{([^\\}]+)\\}\\$", "\u00a3{$1}\u00a3");
                    s = s.replaceAll("%(\\{env:([^\\{\\}%]+)\\})%", "\\${$2}");
                    try {
                        String v;
                        s = v = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(s);
                        value = s = s.replaceAll("\u00a3\\{([^\\}]+)\\}\u00a3", "\\${$1}\\$");
                    }
                    catch (Exception ex) {
                        if (handler == null) break block16;
                        handler.handleException(new Exception(String.format(Messages.MdAttributeNativeEvaluator_1, ex.getMessage()), ex));
                    }
                }
            }
            if (value.contains("%{") && nodeCtx != null) {
                Matcher m = MD_LINK_PATTERN.matcher(value);
                StringBuffer buf = new StringBuffer();
                int current = 0;
                while (m.find()) {
                    buf.append(value.substring(current, m.start(1)));
                    String mdLinkName = m.group(2);
                    try {
                        Configuration mdLinkTrg = nodeCtx.evaluateMdNode("internal:getMetaDataLinkRef('" + mdLinkName + "')");
                        if (mdLinkTrg == null) {
                            throw new Exception(Messages.MdAttributeNativeEvaluator_mdLinkUnresolved);
                        }
                        String val = null;
                        try {
                            val = mdLinkTrg.evaluateXpathExpressionCached("INTERNAL_NATIVE_MDLINK_RESOLUTION", null);
                        }
                        catch (Exception ex) {
                            throw new Exception(String.format(Messages.MdAttributeNativeEvaluator_mdLinkResolution, mdLinkName, nodeCtx.getId(), ex.getMessage()), ex);
                        }
                        if (val != null && !val.isEmpty()) {
                            buf.append(val);
                        } else {
                            buf.append(value.substring(m.start(1), m.end(1)));
                        }
                    }
                    catch (Throwable ex) {
                        if (handler != null) {
                            handler.handleException(ex);
                        }
                        buf.append(value.substring(m.start(1), m.end(1)));
                    }
                    current = m.end(1);
                }
                if (current < value.length()) {
                    buf.append(value.substring(current));
                }
                if (buf.length() > 0) {
                    value = buf.toString();
                }
            }
        }
        return value;
    }

    public static interface IExceptionHandler {
        public void handleException(Throwable var1);
    }
}

