/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.common.editor.input;

import com.indy.ui.common.resource.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class ScheduleEditorInput
implements IEditorInput {
    private String host;
    private IResource delivery;
    private int port;
    private String triggerName;
    private String scheduleEditorId;
    private String scheduleName;
    private boolean isNew;
    private IResource schedule;
    private String user;
    private String password;
    private String repoDir;
    private String logLevel;

    public String getTriggerName() {
        return this.triggerName;
    }

    public String getRepoDir() {
        return this.repoDir;
    }

    public ScheduleEditorInput(String triggerName, IResource schedule, IResource delivery, String host, int port, String user, String password, boolean isNew, String repoDir, String logLevel) {
        this.triggerName = triggerName;
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
        this.delivery = delivery;
        this.schedule = schedule;
        this.isNew = isNew;
        this.repoDir = repoDir;
        this.scheduleEditorId = String.valueOf(delivery.getResourceId()) + "/" + triggerName;
        this.logLevel = logLevel;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScheduleEditorInput other = (ScheduleEditorInput)obj;
        return this.scheduleEditorId.equals(other.scheduleEditorId);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public IResource getDelivery() {
        return this.delivery;
    }

    public IResource getSchedule() {
        return this.schedule;
    }

    public void setScheduleEditorId(String scheduleEditorId) {
        this.scheduleEditorId = scheduleEditorId;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.scheduleName != null ? this.scheduleName : this.triggerName;
    }

    public String getScheduleEditorId() {
        return this.scheduleEditorId;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.getTriggerName();
    }

    public String getPassword() {
        return this.password;
    }

    public String getUser() {
        return this.user;
    }

    public String getLogLevel() {
        return this.logLevel;
    }
}

