/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ftp.commands;

import com.stambia.ftp.commands.FtpCommand;
import com.stambia.ftp.exceptions.BadSyntaxException;
import com.stambia.ftp.exceptions.FtpCommandException;
import com.stambia.ftp.utils.FtpCommandHandler;
import com.stambia.ftp.utils.FtpCommandResponses;
import com.stambia.ftp.utils.FtpStatisticListener;
import com.stambia.ftp.utils.FtpUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;

public class FtpCommand_STOU
extends FtpCommand<FTPClient> {
    public FtpCommand_STOU(String command, String[] parameters) {
        super(command, parameters);
    }

    public FtpCommand_STOU(FtpCommand<FTPClient> ftpCmd) {
        super(ftpCmd);
    }

    @Override
    public void executeCommand(FTPClient ftpCli, String localPath, boolean verbose, FtpCommandHandler commandHandler, List<FtpStatisticListener> statisticsListeners) throws IOException, FtpCommandException {
        if (this.getParameters()[0] != null) {
            FileInputStream ism;
            File file = new File(FtpUtils.buildPath(this.getParameters()[0], localPath) + FtpUtils.getFileName(this.getParameters()[0]));
            this.fireStatiscitEvent(statisticsListeners, FtpStatisticListener.Statistic.STORED_FILES_SIZE, file.length());
            if (this.getParameters()[1] == null) {
                ism = new FileInputStream(file);
                ftpCli.storeUniqueFile(FtpUtils.addQuotes(file.getName()), (InputStream)ism);
            } else {
                ism = new FileInputStream(file);
                if (FtpUtils.isDirectory(FtpUtils.removeFirstAndLastQuotes(this.getParameters()[1]))) {
                    ((InputStream)ism).close();
                    BadSyntaxException exception = new BadSyntaxException(FtpCommandResponses.STOU_RESPONSE_ISDIRECTORY);
                    commandHandler.handleError("", exception);
                    return;
                }
                ftpCli.storeUniqueFile(FtpUtils.addQuotes(this.getParameters()[1]), (InputStream)ism);
            }
            ((InputStream)ism).close();
            this.defaultResponseManager(ftpCli, verbose, commandHandler);
        } else {
            BadSyntaxException exception = new BadSyntaxException(FtpCommandResponses.MISSING_PARAMETER);
            commandHandler.handleError("", exception);
        }
    }
}

