/*
 * Decompiled with CFR 0.152.
 */
package com.indy.md.ui.diagram.custom;

import com.stambia.md.diagram.navigator.MdDomainNavigatorItem;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.navigator.CommonViewer;

public class UISelector<T> {
    protected CommonViewer viewer;
    private Function<IStructuredSelection, T> selectionAdapterFunction;
    private Predicate<IFile> validateFileCondition;
    private Consumer<T> selectionHandler;
    private String fileExtension;

    public UISelector(Function<IStructuredSelection, T> selectionAdapterFunction, Predicate<IFile> validateFileCondition, String fileExtension) {
        this.selectionAdapterFunction = selectionAdapterFunction;
        this.validateFileCondition = validateFileCondition;
        this.fileExtension = fileExtension;
    }

    public void createControl(Composite parent) {
        this.viewer = new CommonViewer("org.eclipse.ui.navigator.ProjectExplorer", parent, 2816);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.viewer.getNavigatorContentService().getActivationService().activateExtensions(new String[]{"org.eclipse.ui.navigator.resourceContent", "com.indy.md.ui.diagram.domainResourceContent"}, true);
        this.viewer.getNavigatorContentService().update();
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFile) {
                    return UISelector.this.validateFileCondition.test((IFile)element);
                }
                if (element instanceof IContainer) {
                    return UISelector.this.checkFolder((IContainer)element, UISelector.this.fileExtension);
                }
                boolean cfr_ignored_0 = element instanceof MdDomainNavigatorItem;
                return true;
            }
        });
        this.viewer.refresh();
        this.viewer.addSelectionChangedListener(event -> this.selectionHandler.accept(this.getSelectedObject()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean checkFolder(IContainer f, String fileExtension) {
        if (f.getName().equals("indy.build")) return false;
        if (f.getName().equals("indy.diagram")) {
            return false;
        }
        try {
            IResource[] iResourceArray = f.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IResource m = iResourceArray[n2];
                if (m instanceof IFile && fileExtension.equals(((IFile)m).getFileExtension())) {
                    return true;
                }
                if (m instanceof IContainer && this.checkFolder((IContainer)m, fileExtension)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            return false;
        }
    }

    public T getSelectedObject() {
        return this.selectionAdapterFunction.apply((IStructuredSelection)this.viewer.getStructuredSelection());
    }

    public void setConsumer(Consumer<T> selectionHandler) {
        this.selectionHandler = selectionHandler;
    }

    public Consumer<T> getConsumer() {
        return this.selectionHandler;
    }
}

