/*
 * Decompiled with CFR 0.152.
 */
package com.indy.md.ui.diagram.custom.move;

import com.indy.md.ui.diagram.Messages;
import com.indy.md.ui.diagram.custom.move.MdNodeReplacer;
import com.indy.md.ui.diagram.custom.move.MoveDialog;
import com.indy.md.ui.diagram.custom.move.ReplaceFilter;
import com.indy.ui.custom.out.CustomInternalWorksapceJob;
import com.indy.ui.custom.out.HistoryRestorationHelper;
import com.indy.ui.custom.out.Util;
import com.semarchy.xdi.designer.core.models.InternalResourceURIConverter;
import com.stambia.md.MdNode;
import com.stambia.md.diagram.navigator.MdDomainNavigatorItem;
import com.stambia.tech.Level;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;

public class ReplaceInUsageHandler
extends AbstractHandler {
    private Logger logger = LogManager.getLogger(ReplaceInUsageHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection s = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        ArrayList<EObject> selectedMdNode = new ArrayList<EObject>();
        Level lvl = null;
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.setURIConverter((URIConverter)new InternalResourceURIConverter());
        if (s instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)s;
            for (Object o : ss.toList()) {
                EObject node = rs.getEObject(EcoreUtil.getURI((EObject)((MdDomainNavigatorItem)((Object)o)).getEObject()), true);
                selectedMdNode.add(node);
                if (lvl == null) {
                    lvl = ((MdNode)node).getLevel();
                    continue;
                }
                if (lvl == ((MdNode)node).getLevel()) continue;
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.MoveHandler_6, (String)Messages.ReplaceInUsageHandler_1);
                return null;
            }
        }
        selectedMdNode = new ArrayList(EcoreUtil.filterDescendants(selectedMdNode));
        MoveDialog d = new MoveDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), lvl);
        d.setFilter(new ReplaceFilter((MdNode)selectedMdNode.get(0), true));
        if (d.open() == 0) {
            final ArrayList<EObject> toMove = selectedMdNode;
            final URI targetURI = d.getResourceUri().appendFragment(d.getTargetURIFragment());
            AbstractOperation op = new AbstractOperation(Messages.ReplaceInUsageHandler_2, (ResourceSet)rs){
                private HashSet<URI> modifiedResourceURI;
                private final /* synthetic */ ResourceSet val$rs;
                {
                    this.val$rs = resourceSet;
                    super($anonymous0);
                    this.modifiedResourceURI = new HashSet();
                }

                public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    this.modifiedResourceURI.clear();
                    monitor.beginTask(Messages.ReplaceInUsageHandler_3, toMove.size());
                    if (monitor != null && monitor.isCanceled()) {
                        this.undo(monitor, info);
                    }
                    URI movingNodeURI = null;
                    for (EObject n : toMove) {
                        movingNodeURI = EcoreUtil.getURI((EObject)n);
                    }
                    boolean autoBuild = HistoryRestorationHelper.setWorkspaceAutoBuild((boolean)false);
                    try {
                        try {
                            MdNodeReplacer ref = new MdNodeReplacer(movingNodeURI, targetURI);
                            for (URI movedURI : ref.execute()) {
                                if (movedURI != null) {
                                    this.modifiedResourceURI.add(movedURI);
                                    continue;
                                }
                                this.undo(monitor, info);
                            }
                        }
                        catch (Exception ex) {
                            this.undo(monitor, info);
                            Status status = new Status(4, "com.indy.md.ui.diagram", Messages.ReplaceInUsageHandler_4 + ":" + ex.getMessage(), (Throwable)ex);
                            HistoryRestorationHelper.setWorkspaceAutoBuild((boolean)autoBuild);
                            return status;
                        }
                    }
                    finally {
                        HistoryRestorationHelper.setWorkspaceAutoBuild((boolean)autoBuild);
                    }
                    for (Resource r : this.val$rs.getResources()) {
                        if (r == null || !r.isLoaded()) continue;
                        r.unload();
                    }
                    return new Status(0, "com.indy.md.ui.diagram", Messages.ReplaceInUsageHandler_6);
                }

                public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    return this.execute(monitor, info);
                }

                public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    HistoryRestorationHelper.scheduleRestoreFromHistory((String)"Cancel Replace Metadata", this.modifiedResourceURI.stream().map(Util::convertEMFURIToFile).filter(f -> f != null).toList(), (Logger)ReplaceInUsageHandler.this.logger);
                    return new Status(0, "com.indy.md.ui.diagram", Messages.ReplaceInUsageHandler_6);
                }
            };
            op.addContext(WorkspaceUndoUtil.getWorkspaceUndoContext());
            CustomInternalWorksapceJob job = new CustomInternalWorksapceJob("Replace Metadata", op);
            job.setUser(true);
            job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            job.schedule();
        }
        return null;
    }
}

