/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.diagram.custom;

import com.stambia.md.Attribute;
import com.stambia.md.MdNode;
import java.util.ArrayList;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class MdNodeContentAssistProcessor
implements IContentAssistProcessor {
    private ICompletionProposal[] NO_COMPLETIONS = new ICompletionProposal[0];
    private final char[] PROPOSAL_ACTIVATION_CHARS = new char[]{'/', '@'};
    private MdNode node;

    public MdNodeContentAssistProcessor(MdNode mdNode) {
        this.node = mdNode;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        String text = viewer.getDocument().get();
        String string = text.substring(0, offset);
        if (string.equals("")) {
            return this.NO_COMPLETIONS;
        }
        ArrayList<CompletionProposal> propList = new ArrayList<CompletionProposal>();
        int length = string.length();
        if (length < 1) {
            return this.NO_COMPLETIONS;
        }
        if (string.charAt(length - 1) == ' ' || string.charAt(length - 1) == '/' || string.charAt(length - 1) == '(' || string.charAt(length - 1) == ')') {
            for (Attribute n : this.node.getAttribute()) {
                CompletionProposal cmp = new CompletionProposal(n.getTechProperty().getCode(), offset, 0, n.getTechProperty().getCode().length());
                propList.add(cmp);
            }
        } else {
            int lastEscapeIndex = string.lastIndexOf(32);
            if (lastEscapeIndex == -1) {
                lastEscapeIndex = Math.max(string.lastIndexOf(41), string.lastIndexOf(40));
            }
            String copy = new String(string);
            if (lastEscapeIndex != 1) {
                copy = string.substring(lastEscapeIndex + 1);
            }
            for (Attribute n : this.node.getAttribute()) {
                if (!n.getTechProperty().getCode().startsWith(copy)) continue;
                CompletionProposal cmp = new CompletionProposal(n.getTechProperty().getCode(), offset - copy.length(), copy.length(), n.getTechProperty().getCode().length());
                propList.add(cmp);
            }
        }
        string = string.toLowerCase();
        int lastEscapeIndex = string.lastIndexOf(32);
        if (lastEscapeIndex == -1) {
            lastEscapeIndex = Math.max(string.lastIndexOf(41), string.lastIndexOf(40));
        }
        if (lastEscapeIndex != 1) {
            string = string.substring(lastEscapeIndex + 1);
        }
        return propList.toArray(new ICompletionProposal[propList.size()]);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.PROPOSAL_ACTIVATION_CHARS;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return this.PROPOSAL_ACTIVATION_CHARS;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }
}

