/*
 * Decompiled with CFR 0.152.
 */
package com.indy.product;

import com.indy.product.UserAgreementWizard;
import com.indy.ui.custom.out.services.IUserPreferencesStorageService;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

@Component(property={"event.topics=org/eclipse/e4/ui/LifeCycle/activate"}, scope=ServiceScope.PROTOTYPE)
public class UserAgreementComponent
implements EventHandler {
    private static final String PREF_LICENSE_ACCEPTED = "license.accepted";
    private static final String PROP_LICENSE_ACCEPTED = "com.indy.product.license.accepted";
    ComponentContext context;
    @Reference(service=EnvironmentInfo.class)
    EnvironmentInfo info;
    @Reference(service=IUserPreferencesStorageService.class)
    IUserPreferencesStorageService userPreferencesStorageService;

    private void unregisterInstance() {
        this.context.disableComponent(UserAgreementComponent.class.getName());
    }

    private String getLicense() {
        String license = null;
        try {
            String homeLocation = this.info.getProperty("eclipse.home.location");
            URL licenseURL = new URL(homeLocation + "license/license.html");
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader is = new BufferedReader(new InputStreamReader(licenseURL.openStream()));){
                license = is.lines().collect(Collectors.joining("\n"));
                license = license.replace("href=\"notice.html\"", "href=\"" + homeLocation + "license/notice.html\"");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            license = "could not find license";
        }
        return license;
    }

    public void handleEvent(Event event) {
        IEclipsePreferences preferences = ConfigurationScope.INSTANCE.getNode("com.indy.product");
        boolean accepted = preferences.getBoolean(PREF_LICENSE_ACCEPTED, false);
        if (!accepted) {
            accepted = Boolean.valueOf(this.info.getProperty(PROP_LICENSE_ACCEPTED));
        }
        if (accepted) {
            this.unregisterInstance();
        } else {
            Display.getCurrent().syncExec(new Runnable((Preferences)preferences){
                private final /* synthetic */ Preferences val$preferences;
                {
                    this.val$preferences = preferences;
                }

                @Override
                public void run() {
                    UserAgreementComponent.this.unregisterInstance();
                    Dialog d = UserAgreementComponent.this.createUI();
                    int res = d.open();
                    if (res == 0) {
                        this.val$preferences.putBoolean(UserAgreementComponent.PREF_LICENSE_ACCEPTED, true);
                        try {
                            this.val$preferences.flush();
                        }
                        catch (BackingStoreException e) {
                            e.printStackTrace();
                        }
                    } else {
                        System.exit(0);
                    }
                }
            });
        }
    }

    private Dialog createUI() {
        String mode = this.userPreferencesStorageService.read("LicenseMode");
        boolean isTrial = mode == null || "TRIAL".equals(mode);
        UserAgreementWizard wizard = new UserAgreementWizard(this.getLicense(), isTrial);
        WizardDialog d = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        d.setPageSize(600, 700);
        d.setHelpAvailable(false);
        return d;
    }

    @Activate
    public void activate(ComponentContext context) {
        this.context = context;
    }
}

