/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.action.ant;

import com.indy.engine.action.ant.Messages;
import com.indy.engine.core.objects.data.baseobjects.StringOperations;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileOperationsI {
    private static final Logger LOGGER = LogManager.getLogger(FileOperationsI.class);

    private FileOperationsI() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyOneFile(File in, File out, boolean overwrite) throws EngineExceptionI {
        try {
            if (!overwrite) {
                if (out.exists()) return;
            }
            try {
                Throwable throwable = null;
                Object var4_7 = null;
                try {
                    FileInputStream inputStream = new FileInputStream(in);
                    try {
                        block29: {
                            FileChannel inChannel = inputStream.getChannel();
                            try {
                                block28: {
                                    FileOutputStream outputStream = new FileOutputStream(out);
                                    try {
                                        try (FileChannel outChannel = outputStream.getChannel();){
                                            inChannel.transferTo(0L, inChannel.size(), outChannel);
                                        }
                                        if (outputStream == null) break block28;
                                    }
                                    catch (Throwable throwable2) {
                                        if (throwable == null) {
                                            throwable = throwable2;
                                        } else if (throwable != throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                        if (outputStream == null) throw throwable;
                                        outputStream.close();
                                        throw throwable;
                                    }
                                    outputStream.close();
                                }
                                if (inChannel == null) break block29;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                if (inChannel == null) throw throwable;
                                inChannel.close();
                                throw throwable;
                            }
                            inChannel.close();
                        }
                        if (inputStream == null) return;
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        if (inputStream == null) throw throwable;
                        inputStream.close();
                        throw throwable;
                    }
                    inputStream.close();
                    return;
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                        throw throwable;
                    }
                    if (throwable == throwable5) throw throwable;
                    throwable.addSuppressed(throwable5);
                    throw throwable;
                }
            }
            catch (IOException | SecurityException e1) {
                throw new EngineExceptionI((Throwable)e1);
            }
        }
        catch (SecurityException e) {
            throw new EngineExceptionI((Throwable)e);
        }
    }

    public static void recursiveDelete(File fFile) throws EngineExceptionI {
        File[] lstFiles = fFile.listFiles();
        if (lstFiles != null && lstFiles.length != 0) {
            int i = 0;
            while (i < lstFiles.length) {
                if (lstFiles[i].isDirectory()) {
                    FileOperationsI.recursiveDelete(lstFiles[i]);
                } else {
                    try {
                        Files.delete(lstFiles[i].toPath());
                    }
                    catch (IOException e) {
                        LOGGER.warn("Error deleting file", (Throwable)e);
                    }
                    catch (Exception e) {
                        throw new EngineExceptionI((Throwable)e);
                    }
                }
                ++i;
            }
        }
        try {
            Files.delete(fFile.toPath());
        }
        catch (IOException e) {
            LOGGER.warn("Error deleting file", (Throwable)e);
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
    }

    public static void moveOneFile(File srcFile, File trgFile, boolean overwrite) throws EngineExceptionI {
        try {
            boolean b;
            LOGGER.debug("Move One file FROM {} TO {}", (Object)srcFile.getPath(), (Object)trgFile.getPath());
            if (overwrite && trgFile.exists()) {
                LOGGER.debug("Trying to delete file");
                FileOperationsI.recursiveDelete(trgFile);
            }
            if (!(b = srcFile.renameTo(trgFile))) {
                throw new EngineExceptionI(Messages.getString("FileOperationsI.3") + trgFile.getPath() + Messages.getString("FileOperationsI.4"));
            }
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
    }

    public static void createFolder(String folderName) throws EngineExceptionI {
        try {
            File f = new File(folderName);
            f.mkdirs();
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
    }

    public static int moveOrCopyFiles(String sSrcFile, String sTrgDir, String sTrgFile, boolean autoCreateFolders, boolean overwrite, boolean recurseMode, boolean deepResearch, String mode) throws EngineExceptionI {
        File trgFile;
        File srcFile;
        boolean bSrcIsDir = false;
        boolean bSrcIsPattern = false;
        String sSrcFolder = "";
        String srcFilePattern = "";
        boolean bTrgIsDir = false;
        boolean bTrgIsPattern = false;
        String sTrgFolder = "";
        String trgFilePattern = "";
        LOGGER.debug("Creating src File");
        try {
            srcFile = new File(sSrcFile);
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
        if (srcFile.isDirectory()) {
            bSrcIsDir = true;
            sSrcFolder = srcFile.getPath();
        } else {
            sSrcFolder = srcFile.getParent();
            srcFilePattern = srcFile.getPath().substring(sSrcFolder.length() + 1);
            if (StringOperations.countMatchingGroup((String)srcFilePattern) > 0) {
                bSrcIsPattern = true;
            }
        }
        LOGGER.debug("Creating trg File");
        try {
            trgFile = new File(sTrgDir, sTrgFile);
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
        LOGGER.debug("TrgFile :{}", (Object)trgFile.getPath());
        if (sTrgFile.isEmpty()) {
            bTrgIsDir = true;
            sTrgFolder = trgFile.getPath();
        } else {
            sTrgFolder = trgFile.getParent();
            trgFilePattern = trgFile.getPath().substring(sTrgFolder.length() + 1);
            if (StringOperations.countMatchingGroup((String)trgFilePattern) > 0) {
                bTrgIsPattern = true;
            }
        }
        LOGGER.debug("Files OK");
        LOGGER.debug("bSrcIsDir = {}", (Object)bSrcIsDir);
        LOGGER.debug("bSrcIsPattern = {}", (Object)bSrcIsPattern);
        LOGGER.debug("sSrcFolder = {}", (Object)sSrcFolder);
        LOGGER.debug("srcFilePattern {}", (Object)srcFilePattern);
        LOGGER.debug("bTrgIsDir = {}", (Object)bTrgIsDir);
        LOGGER.debug("bTrgIsPattern = {}", (Object)bTrgIsPattern);
        LOGGER.debug("sTrgFolder = {}", (Object)sTrgFolder);
        LOGGER.debug("trgFilePattern {}", (Object)trgFilePattern);
        if (bSrcIsDir && !bTrgIsDir) {
            throw new EngineExceptionI(Messages.getString("FileOperationsI.9"));
        }
        int nbCopyOrMove = 0;
        if (bSrcIsDir && mode.equals("copy") || bSrcIsPattern) {
            File fSrcFolder;
            LOGGER.debug("Cas 1 : fichiers multiples en source");
            try {
                fSrcFolder = new File(sSrcFolder);
            }
            catch (Exception e) {
                throw new EngineExceptionI((Throwable)e);
            }
            File[] lstSrcFiles = fSrcFolder.listFiles();
            if (lstSrcFiles != null && lstSrcFiles.length != 0) {
                int i = 0;
                while (i < lstSrcFiles.length) {
                    String trgFileName;
                    boolean deepResearchOn = false;
                    if (!bSrcIsPattern) {
                        trgFileName = lstSrcFiles[i].getName();
                    } else {
                        LOGGER.debug("Match ? {}", (Object)lstSrcFiles[i].getName());
                        boolean matched = StringOperations.matchPattern((String)StringOperations.replaceWildCharsWithGroups((String)srcFilePattern), (String)lstSrcFiles[i].getName());
                        if (matched || deepResearch && lstSrcFiles[i].isDirectory()) {
                            if (matched) {
                                LOGGER.debug("Match !!! ");
                            } else if (deepResearch) {
                                LOGGER.debug("Deep Research !!! ");
                                deepResearchOn = true;
                            }
                            if (bTrgIsDir) {
                                trgFileName = lstSrcFiles[i].getName();
                            } else if (bTrgIsPattern && !deepResearchOn) {
                                trgFileName = StringOperations.getMatchingTargetString((String)srcFilePattern, (String)trgFilePattern, (String)lstSrcFiles[i].getName());
                                LOGGER.debug("Match Target = {}}", (Object)trgFileName);
                                if (trgFileName.equals("")) {
                                    trgFileName = lstSrcFiles[i].getName();
                                }
                            } else {
                                trgFileName = lstSrcFiles[i].getName();
                            }
                        } else {
                            trgFileName = null;
                        }
                    }
                    if (trgFileName != null) {
                        if (!lstSrcFiles[i].isDirectory()) {
                            if (mode.equals("move")) {
                                if (autoCreateFolders) {
                                    FileOperationsI.createFolder(sTrgFolder);
                                }
                                FileOperationsI.moveOneFile(lstSrcFiles[i], new File(sTrgFolder, trgFileName), overwrite);
                                ++nbCopyOrMove;
                            } else if (mode.equals("copy")) {
                                if (autoCreateFolders) {
                                    FileOperationsI.createFolder(sTrgFolder);
                                }
                                FileOperationsI.copyOneFile(lstSrcFiles[i], new File(sTrgFolder, trgFileName), overwrite);
                                ++nbCopyOrMove;
                            }
                        } else if (recurseMode) {
                            if (mode.equals("move")) {
                                if (deepResearchOn) {
                                    nbCopyOrMove += FileOperationsI.moveOrCopyFiles(new File(lstSrcFiles[i].getPath(), srcFilePattern).getPath(), new File(sTrgFolder, trgFileName).getPath(), trgFilePattern, autoCreateFolders, overwrite, recurseMode, deepResearch, mode);
                                } else {
                                    FileOperationsI.moveOneFile(lstSrcFiles[i], new File(sTrgFolder, trgFileName), overwrite);
                                    ++nbCopyOrMove;
                                }
                            } else if (mode.equals("copy")) {
                                try {
                                    nbCopyOrMove = deepResearchOn ? (nbCopyOrMove += FileOperationsI.moveOrCopyFiles(new File(lstSrcFiles[i].getPath(), srcFilePattern).getPath(), new File(sTrgFolder, trgFileName).getPath(), trgFilePattern, autoCreateFolders, overwrite, recurseMode, deepResearch, mode)) : (nbCopyOrMove += FileOperationsI.moveOrCopyFiles(lstSrcFiles[i].getPath(), new File(sTrgFolder, trgFileName).getPath(), "", autoCreateFolders, overwrite, recurseMode, deepResearch, mode));
                                }
                                catch (Exception e) {
                                    throw new EngineExceptionI((Throwable)e);
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
            LOGGER.debug("nbCopyOrMove : {}", (Object)nbCopyOrMove);
        } else {
            LOGGER.debug("Cas 2 : fichier unique en source");
            if (bTrgIsPattern) {
                throw new EngineExceptionI(Messages.getString("FileOperationsI.12"));
            }
            if (autoCreateFolders) {
                FileOperationsI.createFolder(sTrgFolder);
            }
            if (mode.equals("move")) {
                if (bTrgIsDir) {
                    FileOperationsI.moveOneFile(srcFile, new File(trgFile, srcFilePattern), overwrite);
                } else {
                    FileOperationsI.moveOneFile(srcFile, trgFile, overwrite);
                }
                ++nbCopyOrMove;
            } else if (mode.equals("copy")) {
                if (bTrgIsDir) {
                    FileOperationsI.copyOneFile(srcFile, new File(trgFile, srcFilePattern), overwrite);
                } else {
                    FileOperationsI.copyOneFile(srcFile, trgFile, overwrite);
                }
                ++nbCopyOrMove;
            }
        }
        return nbCopyOrMove;
    }
}

