/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.core.IScriptContext;
import com.indy.engine.core.IScriptingEngineProvider;
import com.indy.engine.core.common.VariableType;
import com.indy.engine.core.module.classloader.ClassLoaderServiceProvider;
import com.indy.engine.resolver.manager.secure.ICertifiable;
import com.indy.engine.secret.ISecretContext;
import com.indy.engine.secret.ISecretStatement;
import com.indy.engine.secret.ISecretValue;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;

public class BeanScriptingActionCodeI
extends ActionCodeTypeI
implements ICertifiable {
    BSFManager bsfManager;
    String connectionName = "";
    String language = "";
    private boolean certified = false;

    public BeanScriptingActionCodeI() {
        this.actionCodeName = "BSF Class";
        this.actionClassName = "BeanScriptingActionCodeI";
    }

    public void stopAction(Thread th) {
        this.write(this.sessionName, Messages.getString("BeanScriptingActionCodeI.0"), this.actionName + Messages.getString("BeanScriptingActionCodeI.1"), 1, this.actionLevel, "ERROR");
        this.setStoppingAction(true);
        if (this.bsfManager != null) {
            this.bsfManager.terminate();
        }
        if (th != null) {
            th.interrupt();
        }
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws EngineExceptionI {
        return this.executeCodewithRSet(sourceRSet);
    }

    public int setConnection(ResultSet sourceRSet, ClassLoader cl) throws EngineExceptionI {
        try {
            this.connectionName = this.getLocalStringBindedParameter(sourceRSet, "SCRIPTING_CONNECTION");
        }
        catch (EngineExceptionI e) {
            this.connectionName = "DEFAULT_CONNECTION";
        }
        this.bsfManager = (BSFManager)this.engineContext.getScriptingProvider().createScriptingEngine(IScriptingEngineProvider.EngineRuntime.BEANSHELL, this.language, this.connectionName, (ActionCodeTypeI)this, cl).getScriptingEngine();
        return 0;
    }

    public int executeCodewithRSet(ResultSet sourceRSet) throws EngineExceptionI {
        int ret = 0;
        this.language = this.getLocalStringBindedParameter(sourceRSet, "SCRIPTING_LANGUAGE").toLowerCase();
        String library = this.getLocalStringBindedParameter(sourceRSet, "MODULE", null);
        if (!this.language.equals("beanshell") && !this.language.equals("javascript") && library != null) {
            throw new EngineExceptionI(Messages.getString("BeanScriptingActionCodeI.2") + this.language + Messages.getString("BeanScriptingActionCodeI.3"));
        }
        ClassLoader bindedClassLoader = null;
        try {
            this.setConnection(sourceRSet, null);
            ClassLoader clExecution = null;
            clExecution = library != null ? ClassLoaderServiceProvider.instance().getClassLoader(library) : ClassLoaderServiceProvider.instance().getClassLoader("default");
            bindedClassLoader = (ClassLoader)this.bsfManager.lookupBean("__cl__");
            if (bindedClassLoader != null) {
                if (bindedClassLoader != clExecution && library != null) {
                    throw new EngineExceptionI(Messages.getString("BeanScriptingActionCodeI.4"));
                }
                clExecution = bindedClassLoader;
            } else {
                this.bsfManager.registerBean("__cl__", (Object)clExecution);
            }
            final ISecretValue strFinalActionCode = this.getLocalFinalSecretBindedCode(sourceRSet, this.actionTxtCode);
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            IScriptContext ctx = this.actionContext.createScriptContext(this.isEncrypted() ? "s" : "e");
            boolean beanAdded = false;
            try {
                this.bsfManager.declareBean("__ctx__", (Object)ctx, IScriptContext.class);
                beanAdded = true;
            }
            catch (Exception ex) {
                this.logger.debug("unexpected", (Throwable)ex);
            }
            ClassLoader cl2 = null;
            try {
                if (clExecution != null) {
                    cl2 = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(clExecution);
                }
                if (this.isCertified()) {
                    this.secret((ISecretStatement)new ISecretStatement<Object>(){

                        public Object execute(ISecretContext context) throws Throwable {
                            BeanScriptingActionCodeI.this.bsfManager.exec(BeanScriptingActionCodeI.this.language, "String", -1, -1, (Object)strFinalActionCode.getString(context));
                            return null;
                        }
                    });
                } else {
                    this.bsfManager.exec(this.language, "String", -1, -1, (Object)strFinalActionCode.getString(null));
                }
            }
            finally {
                if (cl2 != null) {
                    Thread.currentThread().setContextClassLoader(cl2);
                }
            }
            if (beanAdded) {
                this.bsfManager.undeclareBean("__ctx__");
            }
            ctx.close();
        }
        catch (BSFException e) {
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), "BSFException : " + e.getMessage(), "String", false);
            this.debugLog("executeSimpleCode", "BSFException : " + e.getMessage(), 1, "ERROR");
            ret = -1;
            if (this.language.equals("javascript") && bindedClassLoader != null && e.getMessage().contains("__ctx__")) {
                throw new EngineExceptionI(Messages.getString("BeanScriptingActionCodeI.5"));
            }
            throw new EngineExceptionI((Throwable)e);
        }
        catch (EngineExceptionI e) {
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), "EngineExceptionI : " + e.getMessage(), "String", false);
            this.debugLog("executeSimpleCode", Messages.getString("BeanScriptingActionCodeI.6") + e.getMessage(), 1, "ERROR");
            ret = -1;
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), "Killed by Engine, " + e.getMessage(), "String", false);
            this.debugLog("executeSimpleCode", Messages.getString("BeanScriptingActionCodeI.7") + e.getMessage(), 1, "ERROR");
            throw new EngineExceptionI(Messages.getString("BeanScriptingActionCodeI.8"), (Throwable)e);
        }
        catch (Exception e) {
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), "Exception : " + e.getMessage(), "String", false);
            this.debugLog("executeSimpleCode", Messages.getString("BeanScriptingActionCodeI.9") + e.getMessage(), 1, "ERROR");
            ret = -1;
            throw new EngineExceptionI((Throwable)e);
        }
        return ret;
    }

    public int executeSimpleCode() throws EngineExceptionI {
        return this.executeCodewithRSet(null);
    }

    public boolean isCertified() {
        return this.certified;
    }

    public void setCertified(boolean certified) {
        this.certified = certified;
    }
}

