/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.action.ant.AntActionCodeTypeI;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.core.common.VariableType;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.File;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.GZip;

public class GZipActionCodeI
extends AntActionCodeTypeI {
    GZip antZipManager;
    String sToFile = null;
    String sFromFile = null;

    public GZipActionCodeI() {
        this.actionCodeName = "Zip File Class";
        this.actionClassName = "ZipActionCodeI";
        this.bNullCodeAllowed = true;
    }

    public int prepare(ResultSet rSet) throws EngineExceptionI {
        int ret = 0;
        this.debugLog("prepare", Messages.getString("GZipActionCodeI.0"), 3, "DEBUG");
        this.setStandardConnectionParameters(rSet);
        this.sToFile = this.getLocalStringBindedParameter(rSet, "GZIP_TO_FILE", null);
        this.sFromFile = this.getLocalStringBindedParameter(rSet, "GZIP_FROM_FILE", null);
        if (this.sToFile == null || this.sFromFile == null) {
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), this.actionClassName + Messages.getString("GZipActionCodeI.1"), "String", false);
            throw new EngineExceptionI(Messages.getString("GZipActionCodeI.2"));
        }
        this.debugLog("prepare", Messages.getString("GZipActionCodeI.3"), 3, "DEBUG");
        return ret;
    }

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        return this.prepare(null);
    }

    public int executeSimpleCode() throws EngineExceptionI {
        int ret = 0;
        this.antZipManager = new GZip();
        this.antZipManager.setProject((Project)this.project);
        if (this.connectionName != null && !this.connectionName.equals("")) {
            this.debugLog("executeSimpleCode", Messages.getString("GZipActionCodeI.4") + this.connectionName, 3, "DEBUG");
            this.jdbcConnection = this.setConnection(this.connectionName, this.sqlTransName, this.sqlTransType);
            if (!this.existsFileTable()) {
                this.debugLog("executeSimpleCode", Messages.getString("GZipActionCodeI.5"), 3, "DEBUG");
                this.createFileTable();
            }
            this.isRdbmsLinked = true;
        }
        try {
            this.antZipManager.setDestfile(new File(this.sToFile));
            this.antZipManager.setSrc(new File(this.sFromFile));
            this.antZipManager.execute();
        }
        catch (BuildException e) {
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), this.actionClassName + "=>executeSimpleCode : " + e.getMessage(), "String", false);
            throw new EngineExceptionI((Throwable)e);
        }
        return ret;
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws InterruptedException, EngineExceptionI, SQLException {
        int ret = 0;
        this.prepare(sourceRSet);
        this.executeSimpleCode();
        return ret;
    }
}

