/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.action.common.BindExpressionReplacer;
import com.indy.engine.actionCodes.Messages;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XsltActionCodeI
extends ActionCodeTypeI {
    private Transformer transformer;
    private String in;
    private String out;
    private boolean isOutDirectory;
    private String xslt;
    String code;
    private String sessionClassLoaderName;

    public XsltActionCodeI() {
        super("Xslt File Class", true);
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws InterruptedException, EngineExceptionI, SQLException {
        this.prepare(sourceRSet);
        this.executeSimpleCode();
        return 0;
    }

    public static Source createSource(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder constructeur = factory.newDocumentBuilder();
        constructeur.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (systemId.toLowerCase().endsWith(".dtd")) {
                    StringReader stringInput = new StringReader(" ");
                    return new InputSource(stringInput);
                }
                return null;
            }
        });
        Document document = constructeur.parse(in);
        return new DOMSource(document);
    }

    public static Transformer createTransformer(TransformerFactory fabriqueT, InputStream xsl) throws TransformerException, EngineExceptionI {
        final ArrayList warningException = new ArrayList();
        final ArrayList fatalErrorException = new ArrayList();
        final ArrayList errorException = new ArrayList();
        fabriqueT.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        fabriqueT.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        StreamSource stylesource = new StreamSource(xsl);
        fabriqueT.setErrorListener(new ErrorListener(){

            @Override
            public void warning(TransformerException arg0) throws TransformerException {
                warningException.add(arg0);
            }

            @Override
            public void fatalError(TransformerException arg0) throws TransformerException {
                fatalErrorException.add(arg0);
            }

            @Override
            public void error(TransformerException arg0) throws TransformerException {
                errorException.add(arg0);
            }
        });
        try {
            return fabriqueT.newTransformer(stylesource);
        }
        catch (Exception e) {
            if (!fatalErrorException.isEmpty()) {
                throw (TransformerException)fatalErrorException.get(0);
            }
            if (!errorException.isEmpty()) {
                throw (TransformerException)errorException.get(0);
            }
            throw new EngineExceptionI((Throwable)e);
        }
    }

    public static Transformer createTransformer(InputStream xsl) throws TransformerException, EngineExceptionI {
        TransformerFactory fabriqueT = TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", null);
        return XsltActionCodeI.createTransformer(fabriqueT, xsl);
    }

    int runTransform(String inputFile, String outputFile, String xslFile) throws EngineExceptionI {
        block27: {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (FileInputStream fis = new FileInputStream(inputFile.trim());){
                    File outFile = new File(outputFile.trim());
                    if (this.transformer == null) {
                        ClassLoader ncl = null;
                        ClassLoader cl = Thread.currentThread().getContextClassLoader();
                        if (this.sessionClassLoaderName != null) {
                            ncl = this.getActionContext().getSessionClassLoader(this.sessionClassLoaderName);
                            Thread.currentThread().setContextClassLoader(ncl);
                        }
                        Throwable throwable2 = null;
                        Object var11_16 = null;
                        try (InputStream xslInput = xslFile != null ? new FileInputStream(xslFile.trim()) : new ByteArrayInputStream(this.code.getBytes());){
                            TransformerFactory trans = TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", cl);
                            this.transformer = XsltActionCodeI.createTransformer(trans, xslInput);
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                        if (ncl != null) {
                            Thread.currentThread().setContextClassLoader(cl);
                        }
                    }
                    if (this.isOutDirectory) {
                        outFile.mkdirs();
                        this.transformer.transform(XsltActionCodeI.createSource(fis), new StreamResult(outFile));
                        break block27;
                    }
                    outFile.getParentFile().mkdirs();
                    Path temporaryPath = Files.createTempFile(outFile.getName(), "xsl", new FileAttribute[0]);
                    this.transformer.transform(XsltActionCodeI.createSource(fis), new StreamResult(temporaryPath.toFile()));
                    try {
                        Files.move(temporaryPath, outFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        this.logger.warn("error while copying file", (Throwable)e);
                        throw new EngineExceptionI(Messages.getString("XsltActionCodeI.1") + String.valueOf(temporaryPath) + Messages.getString("XsltActionCodeI.2") + outFile.getAbsolutePath());
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }
        return 0;
    }

    public int executeSimpleCode() throws EngineExceptionI {
        return this.runTransform(this.in, this.out, this.xslt);
    }

    public int prepare(ResultSet sourceRSet) throws EngineExceptionI {
        int ret = 0;
        try {
            this.in = this.getLocalStringBindedParameter(sourceRSet, "IN_FILE_NAME");
        }
        catch (EngineExceptionI e) {
            throw new EngineExceptionI(Messages.getString("XsltActionCodeI.3"));
        }
        try {
            this.out = this.getLocalStringBindedParameter(sourceRSet, "OUT_FILE_NAME");
        }
        catch (EngineExceptionI e) {
            this.logger.debug("Error while reading parameter", (Throwable)e);
        }
        String outDirectory = null;
        try {
            outDirectory = this.getLocalStringBindedParameter(sourceRSet, "OUT_FILE_DIR");
        }
        catch (EngineExceptionI e) {
            this.logger.debug("Error while reading parameter", (Throwable)e);
        }
        if (outDirectory != null && outDirectory.length() > 0) {
            if (this.out != null && this.out.length() > 0) {
                throw new EngineExceptionI(Messages.getString("XsltActionCodeI.4"));
            }
            this.out = outDirectory;
            this.isOutDirectory = true;
        } else if (this.out == null || this.out.length() == 0) {
            throw new EngineExceptionI(Messages.getString("XsltActionCodeI.5"));
        }
        boolean cacheXsl = this.getLocalBooleanBindedParameter(sourceRSet, "XSL_ACTIVE_CACHE", false);
        if (!cacheXsl && this.transformer != null) {
            this.transformer = null;
        }
        if (this.transformer == null) {
            try {
                this.xslt = this.getLocalStringBindedParameter(sourceRSet, "XSLT_FILE_NAME");
            }
            catch (EngineExceptionI e) {
                if (this.actionTxtCode == null || this.actionTxtCode.trim().isEmpty()) {
                    throw new EngineExceptionI(Messages.getString("XsltActionCodeI.6"));
                }
                if (sourceRSet != null) {
                    BindExpressionReplacer.BindedExpressionPlaceHolder expr = BindExpressionReplacer.replaceBindedExpressions((String)this.actionTxtCode);
                    if (expr.hasSessionVariablesToResolve()) {
                        throw new EngineExceptionI("This action does support to resolve variables on bind expressions");
                    }
                    this.code = expr.getBindedExpression();
                }
                this.code = this.actionTxtCode;
            }
        }
        this.sessionClassLoaderName = this.getLocalStringBindedParameter(sourceRSet, "SESSION_CLASS_LOADER_NAME", null);
        return ret;
    }

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        this.prepare(null);
        return 0;
    }
}

