/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.proxy;

import java.io.IOException;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.SocketFactory;

public class ProxySocketFactory
extends SocketFactory {
    private String proxyHost = null;
    private int proxyPort = 1080;
    private String userName = null;
    private String password = null;
    private Proxy.Type type;

    public ProxySocketFactory(String pSocksProxyHost, int pSocksProxyPort, Proxy.Type type) {
        this.proxyHost = pSocksProxyHost;
        this.proxyPort = pSocksProxyPort;
        this.type = type;
    }

    public ProxySocketFactory(String pSocksProxyHost, int pSocksProxyPort, String pSocksUserName, String pSocksPassword, Proxy.Type type) {
        this.proxyHost = pSocksProxyHost;
        this.proxyPort = pSocksProxyPort;
        this.userName = pSocksUserName;
        this.password = pSocksPassword;
        this.type = type;
        if (this.userName != null && this.password != null) {
            class MyAuthenticator
            extends Authenticator {
                MyAuthenticator() {
                }

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(ProxySocketFactory.this.userName, ProxySocketFactory.this.password.toCharArray());
                }
            }
            Authenticator.setDefault(new MyAuthenticator());
        }
    }

    @Override
    public Socket createSocket() throws IOException {
        return new Socket(new Proxy(this.type, new InetSocketAddress(this.proxyHost, this.proxyPort)));
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        if (this.proxyHost == null) {
            return new Socket(host, port);
        }
        Socket socket = new Socket(new Proxy(this.type, new InetSocketAddress(this.proxyHost, this.proxyPort)));
        socket.connect(new InetSocketAddress(host, port));
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port) throws IOException {
        if (this.proxyHost == null) {
            return new Socket(address, port);
        }
        Socket socket = new Socket(new Proxy(this.type, new InetSocketAddress(this.proxyHost, this.proxyPort)));
        socket.connect(new InetSocketAddress(address, port));
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddr, int localPort) throws IOException {
        if (this.proxyHost == null) {
            return new Socket(host, port, localAddr, localPort);
        }
        Socket socket = new Socket(new Proxy(this.type, new InetSocketAddress(this.proxyHost, this.proxyPort)));
        socket.connect(new InetSocketAddress(host, port));
        socket.bind(new InetSocketAddress(localAddr, localPort));
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddr, int localPort) throws IOException {
        if (this.proxyHost == null) {
            return new Socket(address, port, localAddr, localPort);
        }
        Socket socket = new Socket(new Proxy(this.type, new InetSocketAddress(this.proxyHost, this.proxyPort)));
        socket.connect(new InetSocketAddress(address, port));
        socket.bind(new InetSocketAddress(localAddr, localPort));
        return socket;
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        return new ServerSocket(port);
    }

    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        return new ServerSocket(port, backlog);
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        return new ServerSocket(port, backlog, bindAddr);
    }
}

