/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc.util.custom;

import com.indy.engine.shared.certification.IDeliveryChecksumCertifier;
import com.indy.gmf.proc.Action;
import com.indy.gmf.proc.ActionCode;
import com.indy.gmf.proc.ActionProcess;
import com.indy.gmf.proc.ActionProcessRef;
import com.indy.gmf.proc.AltId;
import com.indy.gmf.proc.DocumentRoot;
import com.indy.gmf.proc.Parameter;
import com.indy.gmf.proc.ParameterType;
import com.indy.gmf.proc.ProcFactory;
import com.indy.gmf.proc.ProcPackage;
import com.indy.gmf.proc.SubActionProcess;
import com.indy.gmf.proc.custom.ActionDefinitionHelper;
import com.indy.gmf.proc.externalization.ProcMessageProvider;
import com.indy.gmf.proc.util.custom.Messages;
import com.semarchy.xdi.designer.core.models.EMFResourceOptions;
import com.semarchy.xdi.designer.core.models.EmbeddedDiagramUpdater;
import com.semarchy.xdi.designer.core.models.IndyXMLResource;
import com.semarchy.xdi.designer.core.models.UpdateListCommand;
import com.semarchy.xdi.designer.core.services.IOverrideService;
import com.semarchy.xdi.designer.core.services.IRegistryHelper;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.XDIModelURIResolver;
import com.semarchy.xdi.designer.core.services.registry.ICrossReference;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.ClassNotFoundException;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMLLoadImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLSaveImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.xml.sax.helpers.DefaultHandler;

public class StbProcResourceImpl
extends IndyXMLResource
implements IRegistryService.IRegistrationContribution {
    public static final String SAVE_OPTS_CERTIFY = "com.indy.gmf.proc.certify";
    private static final List<String> SCRIPTING_TECHNOLOGIES = Arrays.asList("com.indy.engine.actionCodes.ScriptingActionCodeI", "com.indy.engine.actionCodes.BeanScriptingActionCodeI");
    private Logger logger = LogManager.getLogger(StbProcResourceImpl.class);

    public StbProcResourceImpl(URI uri) {
        super(uri);
    }

    protected boolean useUUIDs() {
        return false;
    }

    protected void setID(EObject obj, String newId, Map<String, String> oldIdToNewId) {
        String oldValue;
        String newValue;
        super.setID(obj, newId, oldIdToNewId);
        if (oldIdToNewId != null && obj instanceof AltId && (newValue = oldIdToNewId.get(oldValue = ((AltId)obj).getValue())) != null) {
            boolean deliver = obj.eDeliver();
            try {
                obj.eSetDeliver(false);
                ((AltId)obj).setValue(newValue);
            }
            finally {
                obj.eSetDeliver(deliver);
            }
        }
    }

    private void doCertify(ActionCode actionCode) throws IOException {
        block9: {
            String trimmedCode = actionCode.getCode().replace("\r", "").replace("\n", "");
            try {
                trimmedCode = ((IDeliveryChecksumCertifier)E4InjectorHelper.getService(IDeliveryChecksumCertifier.class)).generateCertifiedCheckSum(trimmedCode, true);
                Parameter cur = actionCode.getParameter("CERTIFICATION_CHECKSUM");
                if (cur == null) {
                    boolean deliver = actionCode.eDeliver();
                    actionCode.eSetDeliver(false);
                    Parameter p = ProcFactory.eINSTANCE.createParameter();
                    p.setName("CERTIFICATION_CHECKSUM");
                    p.setType(ParameterType.STRING);
                    p.setValue(trimmedCode);
                    try {
                        actionCode.getParameter().add((Object)p);
                        break block9;
                    }
                    finally {
                        actionCode.eSetDeliver(deliver);
                    }
                }
                boolean deliver = actionCode.eDeliver();
                try {
                    cur.eSetDeliver(false);
                    cur.setValue(trimmedCode);
                }
                finally {
                    cur.eSetDeliver(deliver);
                }
            }
            catch (Exception e) {
                throw new IOException(Messages.StbProcResourceImpl_10 + actionCode.getFullPath(), e);
            }
        }
    }

    public void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        if (Boolean.TRUE.equals(Boolean.valueOf(String.valueOf(options.get(SAVE_OPTS_CERTIFY))))) {
            ActionProcess proc = ((DocumentRoot)this.getContents().get(0)).getProcess();
            TreeIterator it = proc.eAllContents();
            while (it.hasNext()) {
                EObject o = (EObject)it.next();
                if (o instanceof ActionCode) {
                    ActionCode actionCode = (ActionCode)o;
                    String tech = actionCode.getTechnology();
                    if (actionCode.getCode() != null && !actionCode.getCode().isEmpty() && SCRIPTING_TECHNOLOGIES.contains(tech)) {
                        this.doCertify(actionCode);
                        continue;
                    }
                    it.prune();
                    continue;
                }
                if (o instanceof ActionProcessRef) {
                    it.prune();
                    continue;
                }
                if (o instanceof Action) continue;
                it.prune();
            }
        }
        super.doSave(outputStream, options);
    }

    private void loadExternalizationFile() {
        URI internalResourceURI = null;
        internalResourceURI = this.getURI().segment(1).equals("com.indy.environment") ? this.getURI() : ((IOverrideService)E4InjectorHelper.getService(IOverrideService.class)).getOverridenURI(this.uri);
        if (internalResourceURI == null) {
            return;
        }
        EObject o = (EObject)this.getContents().get(0);
        if (o instanceof DocumentRoot) {
            ActionProcess proc = ((DocumentRoot)o).getProcess();
            ProcMessageProvider messageProvider = new ProcMessageProvider(internalResourceURI);
            try {
                proc.eSetDeliver(false);
                messageProvider.setMessages(proc);
            }
            finally {
                proc.eSetDeliver(true);
            }
            TreeIterator it = proc.eAllContents();
            while (it.hasNext()) {
                EObject eo = (EObject)it.next();
                if (!(eo instanceof Parameter)) continue;
                Parameter p = (Parameter)eo;
                try {
                    p.eSetDeliver(false);
                    try {
                        messageProvider.setMessages(p);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                finally {
                    p.eSetDeliver(true);
                }
            }
        }
    }

    public void load(Map<?, ?> options) throws IOException {
        TransactionalEditingDomain domain;
        block12: {
            super.load(options);
            if (options == null || options.get(EMFResourceOptions.LOAD_OPTION_NO_EXTERNAIZATION_LOADING) != Boolean.TRUE) {
                try {
                    this.loadExternalizationFile();
                }
                catch (Exception ex) {
                    if (!this.logger.isDebugEnabled()) break block12;
                    this.logger.error("Failed to load externalization file for {}", (Object)this.getURI(), (Object)ex);
                }
            }
        }
        if ((domain = TransactionUtil.getEditingDomain((Resource)this)) != null && !this.getContents().isEmpty()) {
            if (options != null && options.get("com.indy.gmf.map.LOAD_OPTION_NO_MAP_UPDATE") == Boolean.TRUE) {
                return;
            }
            EObject o = (EObject)this.getContents().get(0);
            if (o instanceof DocumentRoot) {
                ActionProcess proc = ((DocumentRoot)o).getProcess();
                try {
                    for (ActionCode code : this.extractAllActionCode(proc)) {
                        List<EObject> newParam = ActionDefinitionHelper.INSTANCE.createAllRequiredParameter(code);
                        boolean deliver = code.eDeliver();
                        try {
                            code.eSetDeliver(false);
                            UpdateListCommand ucl = new UpdateListCommand(domain, (EObject)code, code.getParameter(), newParam, (EStructuralFeature)ProcPackage.eINSTANCE.getParameter_Name(), null);
                            ucl.executeWithoutTransaction();
                        }
                        finally {
                            code.eSetDeliver(deliver);
                        }
                    }
                }
                catch (Exception t) {
                    this.getErrors().add((Object)new XMIException(Messages.StbProcResourceImpl_11, t));
                }
            }
        }
    }

    public void save(Map<?, ?> options) throws IOException {
        block13: {
            block12: {
                Boolean skipCrossRef = (Boolean)options.get("com.indy.gmf.proc.util.ProcResourceImpl.saveOption.noCrossRefModel");
                if (!(skipCrossRef != null && skipCrossRef.booleanValue() || this.uri.segment(2).equals("indy.build") || this.uri.isPlatformPlugin())) {
                    try {
                        List<Object> l = this.createRegistryItemsFor(ICrossReference.class);
                        URI crossRefURI = this.getCrossRefResourceURI();
                        if (l != null && !l.isEmpty()) {
                            BundleContext ctx;
                            Collection sr;
                            Optional opt;
                            ICrossReference item = (ICrossReference)l.get(0);
                            if (item == null || !(opt = (sr = (ctx = Platform.getBundle((String)"com.indy.gmf.process").getBundleContext()).getServiceReferences(IRegistryHelper.class, "(&(registryItemType=com.indy.cross.CrossItem)(model.file.extension=proc))")).stream().findFirst()).isPresent()) break block12;
                            IRegistryHelper helper = (IRegistryHelper)ctx.getService((ServiceReference)opt.get());
                            try {
                                helper.persist(crossRefURI, (Object)item);
                                break block12;
                            }
                            finally {
                                ctx.ungetService((ServiceReference)opt.get());
                            }
                        }
                        ((XDIModelURIResolver)E4InjectorHelper.getService(XDIModelURIResolver.class)).deleteResource(crossRefURI);
                    }
                    catch (Exception ex) {
                        this.logger.error(Messages.StbProcResourceImpl_crossItemFailure, (Object)this.getURI(), (Object)ex);
                    }
                }
            }
            if (!this.getContents().isEmpty()) {
                ActionProcess process = null;
                process = ((DocumentRoot)this.getContents().get(0)).getProcess();
                if (process != null) {
                    try {
                        Resource r;
                        URI diagramResourceURI = URIUtils.getDiagramURI((URI)this.getURI());
                        if (diagramResourceURI != null && (r = this.getResourceSet().getResource(diagramResourceURI, false)) != null) {
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            BufferedOutputStream os = new BufferedOutputStream(bos);
                            r.save((OutputStream)os, options);
                            ((OutputStream)os).close();
                            process.eSetDeliver(false);
                            process.setDiagram(new String(bos.toByteArray(), StandardCharsets.UTF_8));
                            process.eSetDeliver(true);
                        }
                    }
                    catch (Exception ex) {
                        if (!this.logger.isDebugEnabled()) break block13;
                        this.logger.error("Failed to inject diagram {}", (Object)this.getURI(), (Object)ex);
                    }
                }
            }
        }
        super.save(options);
    }

    private URI getCrossRefResourceURI() {
        String lastSegment = this.getURI().trimFileExtension().lastSegment();
        StringBuilder b = new StringBuilder();
        int i = 1;
        while (i < this.getURI().segmentCount() - 1) {
            b.append("/");
            b.append(URI.decode((String)this.getURI().segment(i)));
            if (i == 1) {
                b.append("/indy.build");
            }
            ++i;
        }
        return URI.createPlatformResourceURI((String)b.toString(), (boolean)true).appendSegment(lastSegment).appendFileExtension("proc.cross");
    }

    private List<ActionCode> extractAllActionCode(ActionProcess proc) {
        ArrayList<ActionCode> res = new ArrayList<ActionCode>();
        res.addAll((Collection<ActionCode>)proc.getActionCode());
        for (SubActionProcess o : proc.getSubProcess()) {
            res.addAll(this.extractAllActionCode(o));
        }
        return res;
    }

    public List<Class> getContributedRegistries() {
        if (this.getURI().segment(2).equals("indy.build")) {
            return Collections.emptyList();
        }
        return Collections.singletonList(ICrossReference.class);
    }

    public List<Object> createRegistryItemsFor(Class c) throws Exception {
        block6: {
            List list;
            if (c != ICrossReference.class || this.getURI().segment(2).equals("indy.build")) {
                return Collections.emptyList();
            }
            BundleContext ctx = Platform.getBundle((String)"com.indy.gmf.process").getBundleContext();
            Collection sr = ctx.getServiceReferences(IRegistryHelper.class, "(&(registryItemType=com.indy.cross.CrossItem)(model.file.extension=proc))");
            Iterator iterator = sr.iterator();
            if (!iterator.hasNext()) break block6;
            ServiceReference ref = (ServiceReference)iterator.next();
            IRegistryHelper helper = (IRegistryHelper)ctx.getService(ref);
            try {
                list = helper.getRegistryObjects((Resource)this);
            }
            catch (Throwable throwable) {
                try {
                    ctx.ungetService(ref);
                    throw throwable;
                }
                catch (Exception ex) {
                    this.logger.error(Messages.StbProcResourceImpl_crossItemFailure, (Object)this.getURI(), (Object)ex);
                }
            }
            ctx.ungetService(ref);
            return list;
        }
        return Collections.emptyList();
    }

    public Map<String, String> reinitAllId(String rootMainId, Map<String, String> oldIdtoNewId) {
        Map res = super.reinitAllId(rootMainId, oldIdtoNewId);
        ActionProcess proc = ((DocumentRoot)this.getContents().get(0)).getProcess();
        if (proc.eIsSet((EStructuralFeature)ProcPackage.eINSTANCE.getActionProcess_Diagram())) {
            String newDiad = null;
            try {
                newDiad = EmbeddedDiagramUpdater.getRawDiagram((String)proc.getDiagram(), (Map)res);
            }
            catch (Exception ex) {
                this.logger.error("Failed to propagate ids reset to the diagram on {}. We unset the diagram to avoid issues", (Object)this.getURI(), (Object)ex);
            }
            proc.eSetDeliver(false);
            proc.setDiagram(newDiad);
            proc.eSetDeliver(true);
        }
        return res;
    }

    protected XMLSave createXMLSave() {
        return new XMLSaveImpl(this.createXMLHelper()){

            protected String getDatatypeValue(Object value, EStructuralFeature f, boolean isAttribute) {
                if (!isAttribute && f == ProcPackage.eINSTANCE.getActionProcess_Diagram() && value != null) {
                    return "<![CDATA[" + String.valueOf(value) + "]]>";
                }
                return super.getDatatypeValue(value, f, isAttribute);
            }
        };
    }

    protected XMLLoad createXMLLoad(Map<?, ?> options) {
        if (Boolean.TRUE.equals(options.get("RECORD_UNKNOWN_FEATURE"))) {
            return new XMLLoadImpl(this.createXMLHelper()){

                protected DefaultHandler makeDefaultHandler() {
                    return new IndyXMLResource.IndyXMLHandler(this.resource, this.helper, this.options){

                        protected void validateCreateObjectFromFactory(EFactory factory, String typeName, EObject newObject) {
                            if (newObject == null) {
                                this.warning((XMIException)new ClassNotFoundException(typeName, factory, this.getLocation(), this.getLineNumber(), this.getColumnNumber()));
                            }
                        }

                        protected void handleUnknownFeature(String prefix, String name, boolean isElement, EObject peekObject, String value) {
                            if (name.equals("moduleXPathExpression") && peekObject instanceof ActionCode && !value.trim().isEmpty()) {
                                ((ActionCode)peekObject).setModuleName("%x{" + value + "}x%");
                                return;
                            }
                            super.handleUnknownFeature(prefix, name, isElement, peekObject, value);
                        }
                    };
                }
            };
        }
        return super.createXMLLoad(options);
    }

    public List<ActionProcess> extractAllProc() {
        HashSet<ActionProcess> p = new HashSet<ActionProcess>();
        if (!this.getContents().isEmpty() && ((DocumentRoot)this.getContents().get(0)).getProcess() != null) {
            LinkedList<SubActionProcess> l = new LinkedList<SubActionProcess>();
            ActionProcess current = ((DocumentRoot)this.getContents().get(0)).getProcess();
            while (current != null) {
                if (p.add(current)) {
                    l.addAll((Collection<SubActionProcess>)current.getSubProcess());
                }
                ActionProcess actionProcess = current = l.isEmpty() ? null : (ActionProcess)l.poll();
            }
        }
        return new ArrayList<ActionProcess>(p);
    }
}

