/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.api.internal;

import com.indy.map.api.IMetaDataInformationsProvider;
import com.indy.map.api.internal.MdEvaluator;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.stambia.md.DocumentRoot;
import com.stambia.md.MdNode;
import com.stambia.md.MdRootNode;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class MdInfoExtractor {
    static final String CTX_DATASTORE = "datastore";
    static final String CTX_ANY = "any";
    static final String CTX_FIELD = "field";
    static final String CTX_CONTAINER = "container";
    static final String CTX_CONSTRAINT = "constraint";
    static final String CTX_SHARED = "all";
    static final String CTX_STAGE_FIELD = "stageField";
    static final String PRODUCT_CODE = "productCode";
    static final String TECH_CODE = "techCode";
    static final String CONNECTION = "connection";
    static final String COMPATIBLE_TECH_LIST = "compatibleTechList";
    static final String DYNAMIC_CRITERIA = "dynamicCriteria";
    static final String FIELD_SEPARATOR = "fieldSeparator";
    static final String TYPE = "type";
    static final String FULL_PATH = "fullPath";
    static final String OBJECT_DELIMITER_MASK = "objectDelimiterMask";
    static final String OBJECT_DELIMITER_REGEXP = "objectDelimiterRegexp";
    static final String DATA_TYPE = "dataType";
    static final String MANDATORY = "mandatory";
    static final String NAME = "name";
    static final String OBJECT_MASK = "objectMask";
    static final String PRECISION = "precision";
    static final String SIZE = "size";
    static final String VALID_DATA_TYPE = "validDataType";
    static final String STAGEABLE = "stageable";
    static final String LEVEL_CODE = "levelCode";
    static final String SOURCE_SUPPORT = "sourceSupport";
    static final String TARGET_SUPPORT = "targetSupport";
    static final String FILTER_SUPPORT = "supportFilter";
    static final String FILTER_OR_WORKSPACE_SUPPORT = "supportFilterOrWkps";
    static final String JOIN_SUPPORT = "supportJoin";
    static final String JOIN_OR_WORKSPACE_SUPPORT = "supportJoinOrWksp";
    static final String TRANSFORMATION_SUPPORT = "transformCapability";
    static final String TRANSFORMATION_OR_WORKSPACE_SUPPORT = "transformOrWkspCapability";
    static final String WARNING_ON_FILTER = "warningOnFilter";
    static final String WARNING_ON_TRANSFORMATION = "warningOnTransform";
    static final String WORKSPACE_SUPPORT = "wkspCapability";
    public static final String SUB_MD_PARENT = "subMdParent";
    public static final String ERROR_ON_DISJOINTED_DATASET = "errorOnDisjointedDataset";
    public static final String WARNING_ON_DISJOINTED_DATASET = "warningOnDisjointedDataset";
    public static final String ERROR_WHEN_DISJOINTED_DATASET_HAVE_COMMON_MAPPED_ANCESTOR = "errorWhenDisjointedDatasetHaveCommonMappedAncestor";
    public static final String ERROR_ON_LOADSET_WHEN_NO_DIRECT_PATH = "errorOnLoadSetWhenDirectPath";
    static final String STAGE_FIELD_LEVEL = "stageFieldLevel";
    static final String STAGE_FIELD_CONTAINER_LEVEL = "stageFieldContainerLevel";
    static final String SUPPORT_EXTRA_FIELD_USAGE_ON_WRK = "supportExtraFieldUsageOnWrk";
    private MdEvaluator evaluator = new MdEvaluator(true);
    private String mdModelId;
    Properties prop = new Properties();
    static long time = 0L;

    public Properties extractMdInformation(Resource r) throws Exception {
        long start = new Date().getTime();
        if (!"md".equals(r.getURI().fileExtension())) {
            throw new Exception("Invalid resource URI " + String.valueOf(r.getURI()));
        }
        MdRootNode rootNode = ((DocumentRoot)r.getContents().get(0)).getNode();
        this.mdModelId = rootNode.getId();
        String s = this.evaluator.evaluateProductCode((MdNode)rootNode);
        if (s != null) {
            this.store(this.mdModelId, CTX_SHARED, PRODUCT_CODE, s);
        }
        if ((s = this.evaluator.evaluateTechCode((MdNode)rootNode)) != null) {
            this.store(this.mdModelId, CTX_SHARED, TECH_CODE, s);
        }
        if (rootNode.isSubMetaDataChildFile()) {
            this.store(this.mdModelId, CTX_SHARED, SUB_MD_PARENT, EcoreUtil.getURI((EObject)rootNode.getRef()).fragment());
        }
        this.extract((MdNode)rootNode);
        long t = new Date().getTime() - start;
        time += t;
        return this.prop;
    }

    private void extract(MdNode node) {
        String baseKey = node.getId();
        String s = null;
        boolean b = false;
        if (this.evaluator.checkNodeType(node, MdEvaluator.Type.DATASTORE)) {
            s = this.evaluator.evaluateObjectDelimiterMask(node);
            if (s != null) {
                this.store(baseKey, CTX_DATASTORE, OBJECT_DELIMITER_MASK, s);
            }
            if ((s = this.evaluator.evaluateObjectDelimiterRegexp(node)) != null) {
                this.store(baseKey, CTX_DATASTORE, OBJECT_DELIMITER_REGEXP, s);
            }
            b = this.evaluator.supportExtraStaticFieldUsageOnWrk(node);
            this.store(baseKey, CTX_DATASTORE, SUPPORT_EXTRA_FIELD_USAGE_ON_WRK, b);
        }
        if (this.evaluator.checkNodeType(node, MdEvaluator.Type.DATASTORE, MdEvaluator.Type.STAGE)) {
            Map<IMetaDataInformationsProvider.ICriteria, String> criterias;
            EObject obj;
            s = this.evaluator.getLevel(node);
            if (s != null) {
                this.store(baseKey, CTX_ANY, LEVEL_CODE, s);
            }
            if ((obj = this.evaluator.evaluateConnection(node)) != null) {
                this.store(baseKey, CTX_CONTAINER, CONNECTION, this.toValue(obj));
            }
            if ((s = this.evaluator.evaluateFieldSeparator(node)) != null) {
                this.store(baseKey, CTX_CONTAINER, FIELD_SEPARATOR, s);
            }
            if ((s = this.evaluator.evaluateContainerFullPath(node)) != null) {
                this.store(baseKey, CTX_CONTAINER, FULL_PATH, s);
            }
            b = this.evaluator.supportContainerSourceMapping(node);
            this.store(baseKey, CTX_CONTAINER, SOURCE_SUPPORT, b);
            b = this.evaluator.supportContainerTargetMapping(node);
            this.store(baseKey, CTX_CONTAINER, TARGET_SUPPORT, b);
            b = this.evaluator.hasFilterCapability(node);
            this.store(baseKey, CTX_CONTAINER, FILTER_SUPPORT, b);
            b = this.evaluator.hasFilterOrWorkspaceCapability(node);
            this.store(baseKey, CTX_CONTAINER, FILTER_OR_WORKSPACE_SUPPORT, b);
            b = this.evaluator.hasJoinCapability(node);
            this.store(baseKey, CTX_CONTAINER, JOIN_SUPPORT, b);
            b = this.evaluator.hasJoinOrWorkspaceCapability(node);
            this.store(baseKey, CTX_CONTAINER, JOIN_OR_WORKSPACE_SUPPORT, b);
            b = this.evaluator.hasTransformCapability(node);
            this.store(baseKey, CTX_CONTAINER, TRANSFORMATION_SUPPORT, b);
            b = this.evaluator.hasTransformOrWorkspaceCapability(node);
            this.store(baseKey, CTX_CONTAINER, TRANSFORMATION_OR_WORKSPACE_SUPPORT, b);
            b = this.evaluator.hasWarningOnFilter(node);
            this.store(baseKey, CTX_CONTAINER, WARNING_ON_FILTER, b);
            b = this.evaluator.hasWarningOnTransform(node);
            this.store(baseKey, CTX_CONTAINER, WARNING_ON_TRANSFORMATION, b);
            b = this.evaluator.hasWorkspaceCapability(node);
            this.store(baseKey, CTX_CONTAINER, WORKSPACE_SUPPORT, b);
            Collection<String> c = this.evaluator.evaluateCriteriaCompatibleTechList(node);
            if (c != null) {
                this.store(baseKey, CTX_CONTAINER, COMPATIBLE_TECH_LIST, this.toValue(c));
            }
            if ((criterias = this.evaluator.evaluateDynamicCriterias(node)) != null && !criterias.isEmpty()) {
                this.store(baseKey, CTX_CONTAINER, DYNAMIC_CRITERIA, this.toValue(criterias));
            }
        }
        if (this.evaluator.checkNodeType(node, MdEvaluator.Type.STAGE)) {
            s = this.evaluator.evaluateStageFieldLevel(node);
            if (s != null) {
                this.store(baseKey, CTX_CONTAINER, STAGE_FIELD_LEVEL, s);
            }
            if ((s = this.evaluator.evaluateStageFieldContainerLevel(node)) != null) {
                this.store(baseKey, CTX_CONTAINER, STAGE_FIELD_CONTAINER_LEVEL, s);
            }
        }
        if (this.evaluator.checkNodeType(node, MdEvaluator.Type.DATASTORE, MdEvaluator.Type.STAGE)) {
            b = this.evaluator.evaluateErrorOnLoadSetWhenNoDirectPath(node);
            this.store(baseKey, CTX_CONTAINER, ERROR_ON_LOADSET_WHEN_NO_DIRECT_PATH, b);
            b = this.evaluator.evaluateErrorWhenDisjointedDataSetHaveCommonMappedAncestor(node);
            this.store(baseKey, CTX_CONTAINER, ERROR_WHEN_DISJOINTED_DATASET_HAVE_COMMON_MAPPED_ANCESTOR, b);
            b = this.evaluator.evaluateDisjointedDataSetWarning(node);
            this.store(baseKey, CTX_CONTAINER, WARNING_ON_DISJOINTED_DATASET, b);
            b = this.evaluator.evaluateDisjointedDataSetError(node);
            this.store(baseKey, CTX_CONTAINER, ERROR_ON_DISJOINTED_DATASET, b);
        }
        if (this.evaluator.checkNodeType(node, MdEvaluator.Type.CONSTRAINT)) {
            s = this.evaluator.getLevel(node);
            if (s != null) {
                this.store(baseKey, CTX_ANY, LEVEL_CODE, s);
            }
            if ((s = this.evaluator.evaluateConstraintType(node)) != null) {
                this.store(baseKey, CTX_CONSTRAINT, TYPE, s);
            }
        }
        if (this.evaluator.checkNodeType(node, MdEvaluator.Type.VARIABLE) && (s = this.evaluator.getLevel(node)) != null) {
            this.store(baseKey, CTX_ANY, LEVEL_CODE, s);
        }
        if (this.evaluator.checkNodeType(node, MdEvaluator.Type.FIELD)) {
            s = this.evaluator.getLevel(node);
            if (s != null) {
                this.store(baseKey, CTX_ANY, LEVEL_CODE, s);
            }
            if ((s = this.evaluator.evaluateDataType(node)) != null) {
                this.store(baseKey, CTX_FIELD, DATA_TYPE, s);
            }
            if ((s = this.evaluator.evaluateMandatory(node)) != null) {
                this.store(baseKey, CTX_FIELD, MANDATORY, s);
            }
            if ((s = this.evaluator.evaluateName(node)) != null) {
                this.store(baseKey, CTX_FIELD, NAME, s);
            }
            if ((s = this.evaluator.evaluateObjectMask(node)) != null) {
                this.store(baseKey, CTX_FIELD, OBJECT_MASK, s);
            }
            if ((s = this.evaluator.evaluatePrecision(node)) != null) {
                this.store(baseKey, CTX_FIELD, PRECISION, s);
            }
            if ((s = this.evaluator.evaluateSize(node)) != null) {
                this.store(baseKey, CTX_FIELD, SIZE, s);
            }
            b = this.evaluator.evaluateIsStageFieldTypeValid(node);
            this.store(baseKey, CTX_STAGE_FIELD, VALID_DATA_TYPE, b);
            b = this.evaluator.evaluateStageable(node);
            this.store(baseKey, CTX_FIELD, STAGEABLE, b);
            s = this.evaluator.evaluateStageFieldType(node);
            if (s != null) {
                this.store(baseKey, CTX_STAGE_FIELD, LEVEL_CODE, s);
            }
            b = this.evaluator.supportFieldSourceMapping(node);
            this.store(baseKey, CTX_FIELD, SOURCE_SUPPORT, b);
            b = this.evaluator.supportFieldTargetMapping(node);
            this.store(baseKey, CTX_FIELD, TARGET_SUPPORT, b);
        }
        for (MdNode n : node.getNode()) {
            this.extract(n);
        }
    }

    private String toValue(Map<IMetaDataInformationsProvider.ICriteria, String> criterias) {
        String value = criterias.keySet().stream().filter(k -> criterias.get(k) != null && !((String)criterias.get(k)).isEmpty()).map(k -> String.format("%s=%s", k.label(""), criterias.get(k))).collect(Collectors.joining(";"));
        return value;
    }

    private String toValue(Collection c) {
        StringBuffer b = new StringBuffer();
        if (c != null) {
            for (Object o : c) {
                if (!(o instanceof String)) continue;
                if (b.length() > 0) {
                    b.append(";");
                }
                b.append((String)o);
            }
        }
        return b.toString();
    }

    private String toValue(EObject obj) {
        String fileId = CacheHelper.extractFileID((EObject)obj);
        String eltId = CacheHelper.extractEltID((EObject)obj);
        return eltId + "?fileId=" + fileId + "?";
    }

    private void store(String id, String ctx, String entry, boolean b) {
        this.store(id, ctx, entry, "" + b);
    }

    private void store(String id, String ctx, String entry, String value) {
        Object old = this.prop.setProperty(id + "." + ctx + "." + entry, value);
    }
}

