/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.compute.graph;

import com.indy.map.IContainer;
import com.indy.map.compute.graph.Edge;
import com.indy.map.compute.graph.Vertice;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Graph {
    private List<Vertice> vertex = new ArrayList<Vertice>();
    private List<Edge> edges = new ArrayList<Edge>();
    private HashMap<Object, Vertice> map = new HashMap();

    public Vertice createVertice(Object modelObject) {
        Vertice v = this.map.get(modelObject);
        if (v != null) {
            return v;
        }
        v = new Vertice();
        this.map.put(modelObject, v);
        this.vertex.add(v);
        return v;
    }

    public List<Vertice> getRootVertice() {
        ArrayList<Vertice> l = new ArrayList<Vertice>(this.vertex);
        for (Edge ed : this.edges) {
            if (!l.contains(ed.getStart())) continue;
            l.remove(ed.getStart());
        }
        return l;
    }

    public void registerModel4Vertice(Object modelObject, Vertice v) {
        if (this.map.get(modelObject) == null) {
            this.map.put(modelObject, v);
        }
    }

    public void createEdge(Vertice start, Vertice end) {
        assert (start != null);
        assert (end != null);
        for (Edge e : this.getEdges()) {
            if (e.getStart() != start || e.getEnd() != end) continue;
            return;
        }
        this.getEdges().add(new Edge(start, end));
    }

    public List<Vertice> getVertex() {
        return this.vertex;
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public Vertice getVertice(Object modelObject) {
        return this.map.get(modelObject);
    }

    public void reInitGraph() {
        for (Vertice v : this.getVertex()) {
            v.reInit();
        }
    }

    public void dump(Vertice v) {
        System.out.println("{");
        for (Object o : this.map.keySet()) {
            if (this.map.get(o) != v) continue;
            if (o instanceof IContainer) {
                System.out.println("\t" + String.valueOf(((IContainer)o).getAlias()));
                continue;
            }
            System.out.println("\t" + String.valueOf(o));
        }
        System.out.println("}");
    }

    public void dump() {
        ArrayList<Vertice> l = new ArrayList<Vertice>();
        for (Edge e : this.edges) {
            System.out.println("From");
            this.dump(e.getStart());
            System.out.println("To");
            this.dump(e.getEnd());
            l.add(e.getEnd());
            l.add(e.getStart());
        }
        System.out.println("--");
        for (Vertice v : this.vertex) {
            if (l.contains(v)) continue;
            this.dump(v);
        }
    }

    public Edge getEdge(Vertice vSource, Vertice vTarget) {
        for (Edge e : this.getEdges()) {
            if (e.getStart() != vSource || e.getEnd() != vTarget) continue;
            return e;
        }
        return null;
    }

    public List<Edge> getAdjacentEdges(Vertice v) {
        ArrayList<Edge> l = new ArrayList<Edge>();
        for (Edge e : this.getEdges()) {
            if (e.getStart() != v && e.getEnd() != v) continue;
            l.add(e);
        }
        return l;
    }
}

