/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.compute.validator;

import com.indy.map.compute.graph.Graph;
import com.indy.map.compute.graph.GraphBuilderFactory;
import com.indy.map.compute.graph.Vertice;
import com.indy.map.compute.graph.tools.LoopDetector;
import com.indy.map.messages.Messages;

public abstract class AbstractGraphValidator {
    protected boolean hasPath(Object source, Object target, Object modelObject, GraphBuilderFactory.GraphType graphType) throws Exception {
        Graph graph = GraphBuilderFactory.INSTANCE.getGraphBuilder(graphType, modelObject);
        Vertice vSource = graph.getVertice(source);
        Vertice vTarget = graph.getVertice(target);
        if (vSource == null || vTarget == null) {
            throw new Exception(Messages.AbstractGraphValidator_0);
        }
        LoopDetector detector = new LoopDetector(graph);
        return detector.hasLoop_undirected(vSource, vTarget);
    }

    protected boolean hasLoop(Object source, Object target, Object modelObject, GraphBuilderFactory.GraphType graphType) throws Exception {
        Graph graph = GraphBuilderFactory.INSTANCE.getGraphBuilder(graphType, modelObject);
        Vertice vSource = graph.getVertice(source);
        Vertice vTarget = graph.getVertice(target);
        if (vSource == null || vTarget == null) {
            throw new Exception(Messages.AbstractGraphValidator_1);
        }
        graph.createEdge(vSource, vTarget);
        LoopDetector detector = new LoopDetector(graph);
        return detector.hasLoop_Tarjan();
    }
}

