/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.custom.commands;

import com.indy.map.IContainer;
import com.indy.map.api.IMetaDataInformationsProvider;
import com.indy.map.custom.commands.Messages;
import com.stambia.md.MdNode;
import com.stambia.tech.Tech;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.osgi.framework.Bundle;

class CriteriaBuilder {
    private Map<IMetaDataInformationsProvider.ICriteria, String> criteriaMap = new LinkedHashMap<IMetaDataInformationsProvider.ICriteria, String>();
    private IMetaDataInformationsProvider.EvaluationLocation mode;

    CriteriaBuilder(IMetaDataInformationsProvider.EvaluationLocation mode) {
        this.mode = mode;
    }

    CriteriaBuilder setCriteria(IMetaDataInformationsProvider.ICriteria criteria, String value) {
        this.criteriaMap.put(criteria, value);
        return this;
    }

    CriteriaBuilder extractBuiltInCriterias(IContainer c) {
        String techCode = null;
        String path = c.getAPI().getMdEvaluator().evaluateFullPath(c, this.mode);
        String productCode = null;
        boolean workspaceCapability = false;
        boolean mapCapability = false;
        boolean filterCapability = false;
        boolean joinCapability = false;
        productCode = c.getAPI().getMdEvaluator().evaluateProductCode(c, this.mode);
        techCode = c.getAPI().getMdEvaluator().evaluateTechCode(c, this.mode);
        workspaceCapability = c.getAPI().getMdEvaluator().hasWorkspaceCapability(c, this.mode);
        mapCapability = c.getAPI().getMdEvaluator().hasTransformOrWorkspaceCapability(c, this.mode);
        filterCapability = c.getAPI().getMdEvaluator().hasFilterOrWorkspaceCapability(c, this.mode);
        joinCapability = c.getAPI().getMdEvaluator().hasJoinOrWorkspaceCapability(c, this.mode);
        Collection<String> currentCompatibleTechs = null;
        try {
            currentCompatibleTechs = c.getAPI().getMdEvaluator().evaluateCriteriaCompatibleTechList(c, this.mode);
        }
        catch (Exception ex) {
            Platform.getLog((Bundle)Platform.getBundle((String)"com.indy.gmf.map")).warn(String.format(Messages.CriteriaBuilder_CriteriaEvaluationFailure, Criteria.COMPATIBLE_TECH_LIST.label), (Throwable)ex);
        }
        Collection appendedExtensions = null;
        try {
            EObject obj = c.getAPI().getMdEvaluator().evaluateConnection(c, this.mode);
            if (obj != null && obj.eIsProxy()) {
                obj = c.eResource().getResourceSet().getEObject(((InternalEObject)obj).eProxyURI(), true);
            }
            if (obj instanceof MdNode) {
                Tech tech = (Tech)((MdNode)obj).getLevel().eContainer();
                appendedExtensions = tech.getAppendedExtensions();
            }
        }
        catch (Exception ex) {
            Platform.getLog((Bundle)Platform.getBundle((String)"com.indy.gmf.map")).warn(String.format(Messages.CriteriaBuilder_CriteriaEvaluationFailure, Criteria.PRODUCT_EXTENSIONS_LIST.label), (Throwable)ex);
        }
        if (productCode != null) {
            this.setCriteria(Criteria.PRODUCT, productCode);
        }
        if (path != null) {
            this.setCriteria(Criteria.PATH, path);
        }
        if (techCode != null) {
            this.setCriteria(Criteria.TECH, techCode);
        }
        this.setCriteria(Criteria.WORKSPACE_CAPABILITY, Boolean.toString(workspaceCapability));
        this.setCriteria(Criteria.MAP_CAPABILITY, Boolean.toString(mapCapability));
        this.setCriteria(Criteria.FILTER_CAPABILITY, Boolean.toString(filterCapability));
        this.setCriteria(Criteria.JOIN_CAPABILITY, Boolean.toString(joinCapability));
        if (currentCompatibleTechs != null) {
            this.setCriteria(Criteria.COMPATIBLE_TECH_LIST, currentCompatibleTechs.stream().collect(Collectors.joining("|")));
        }
        if (appendedExtensions != null) {
            this.setCriteria(Criteria.PRODUCT_EXTENSIONS_LIST, appendedExtensions.stream().collect(Collectors.joining("|")));
        }
        Map<IMetaDataInformationsProvider.ICriteria, String> additionalCriteria = c.getAPI().getMdEvaluator().evaluateDynamicCriterias(c, this.mode);
        additionalCriteria.keySet().stream().filter(k -> additionalCriteria.get(k) != null).forEach(k -> {
            CriteriaBuilder criteriaBuilder = this.setCriteria((IMetaDataInformationsProvider.ICriteria)k, (String)additionalCriteria.get(k));
        });
        return this;
    }

    public boolean checkCriteriaValue(IMetaDataInformationsProvider.ICriteria criteria, Object value) {
        if (value == null) {
            return this.criteriaMap.get(criteria) == null;
        }
        return value.equals(this.criteriaMap.get(criteria));
    }

    public String generate(String prefix) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.criteriaMap.keySet().stream().map(criteria -> this.formatCriteria((IMetaDataInformationsProvider.ICriteria)criteria, this.criteriaMap.get(criteria), prefix)).collect(Collectors.joining(";")));
        return builder.toString();
    }

    private String formatCriteria(IMetaDataInformationsProvider.ICriteria criteria, String value, String prefix) {
        return String.format("%s=%s", criteria.label(prefix), value == null ? "" : value);
    }

    static enum Criteria implements IMetaDataInformationsProvider.ICriteria
    {
        PRODUCT(true, "Product"),
        PATH(true, "Path"),
        TECH(true, "Tech"),
        WORKSPACE_CAPABILITY(true, "WorkspaceCapability"),
        MAP_CAPABILITY(true, "MapCapability"),
        FILTER_CAPABILITY(true, "FilterCapability"),
        JOIN_CAPABILITY(true, "JoinCapability"),
        COMPATIBLE_TECH_LIST(true, "CompatibleTechList"),
        PRODUCT_EXTENSIONS_LIST(true, "ProductExtensionsList"),
        IS_TARGET(true, "IsTarget"),
        NO_LOAD(false, "NO_LOAD"),
        PRODUCT_LIST(true, "ProductList"),
        TECH_LIST(true, "TechList"),
        SERDE_OUTPUT_PRODUCT(false, "outputProduct"),
        SERDE_OUTPUT_TECH(false, "outputTech"),
        SERDE_INPUT_PRODUCT(false, "inputProduct"),
        SERDE_INPUT_TECH(false, "inputTech");

        boolean withPrefix;
        String label;

        private Criteria(boolean withPrefix, String label) {
            this.withPrefix = withPrefix;
            this.label = label;
        }

        @Override
        public String label(String prefix) {
            if (prefix == null) {
                prefix = "";
            }
            return this.withPrefix ? prefix + this.label : this.label;
        }
    }
}

