/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.custom.commands;

import com.indy.libraries.build.parser.sql.LightParser;
import com.indy.map.Clause;
import com.indy.map.ComputedField;
import com.indy.map.Expression;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.IReferencable;
import com.indy.map.MapModelItem;
import com.indy.map.ref.RSourceItem;
import com.indy.map.ref.RUsage;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class UpdateContainerAliasCommand
extends RecordingCommand {
    private IContainer datastore;
    private QName oldAlias;
    private QName newAlias;

    public UpdateContainerAliasCommand(TransactionalEditingDomain domain, IContainer datastore, QName oldAlias, QName newAlias) {
        super(domain);
        this.datastore = datastore;
        this.oldAlias = oldAlias;
        this.newAlias = newAlias;
    }

    protected void doExecute() {
        if (this.oldAlias == null) {
            return;
        }
        ArrayList<RUsage> usages = new ArrayList<RUsage>();
        for (ILogicalField iLogicalField : this.datastore.getLogicalField()) {
            usages.addAll((Collection<RUsage>)((RSourceItem)((IReferencable)((Object)iLogicalField)).getMapReference()).getUsage());
        }
        for (ComputedField computedField : this.datastore.getComputedField()) {
            usages.addAll((Collection<RUsage>)((RSourceItem)computedField.getMapReference()).getUsage());
        }
        for (RUsage rUsage : usages) {
            MapModelItem it = rUsage.getDataModel();
            String expression = null;
            if (it instanceof Clause) {
                expression = ((Clause)it).getExpression();
            } else if (it instanceof Expression) {
                expression = ((Expression)it).getExpression();
            } else if (it instanceof ComputedField) {
                expression = ((ComputedField)it).getFormula();
            }
            String ret = UpdateContainerAliasCommand.replaceInExpression(this.oldAlias, this.newAlias, expression);
            if (ret.equals(expression)) continue;
            if (it instanceof Clause) {
                ((Clause)it).setExpression(ret);
                continue;
            }
            if (it instanceof Expression) {
                ((Expression)it).setExpression(ret);
                continue;
            }
            if (!(it instanceof ComputedField)) continue;
            ((ComputedField)it).setFormula(ret);
        }
    }

    public static String replaceInExpression(QName oldAlias, QName newAlias, String expression) {
        LightParser lp = new LightParser(expression);
        lp.parse();
        StringBuilder b = new StringBuilder();
        for (Object o : lp.iterate()) {
            if (o instanceof String) {
                b.append(o);
                continue;
            }
            if (((LightParser.Field)o).getTableName().equals(oldAlias.toString())) {
                b.append(newAlias.toString());
                b.append(".");
                b.append(((LightParser.Field)o).getFieldName());
                continue;
            }
            b.append(((LightParser.Field)o).toString());
        }
        return b.toString();
    }
}

