/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.util;

import com.indy.map.Clause;
import com.indy.map.DataSet;
import com.indy.map.Expression;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.SetDescriptor;
import com.indy.map.ref.RExpression;
import com.indy.map.ref.RLogicalField;
import com.indy.map.ref.RSourceItem;
import com.indy.map.ref.RSourceSet;
import com.indy.map.util.InheritanceHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;

public class SourceSetHelper {
    public static List<SubSourceSet> computeSubSourceSets(RSourceSet ss) {
        ArrayList<SubSourceSet> res = new ArrayList<SubSourceSet>();
        for (IContainer target : ss.getTargetSet().getContainerModel()) {
            for (SetDescriptor desc : target.getSetDescriptor()) {
                HashSet<DataSet> involvedDatasets = new HashSet<DataSet>();
                for (ILogicalField f : target.getLogicalField()) {
                    Expression expr = f.getExpression(desc);
                    if (expr == null) continue;
                    for (RSourceItem i : ((RExpression)expr.getMapReference()).getSourceRef()) {
                        EObject o;
                        if (!(i instanceof RLogicalField) || !((o = i.getDataModel().eContainer()) instanceof IContainer)) continue;
                        involvedDatasets.add(((IContainer)o).getDataset());
                    }
                }
                HashSet<IContainer> involvedContainers = new HashSet<IContainer>();
                HashSet<Clause> involvedClause = new HashSet<Clause>();
                for (DataSet ds : involvedDatasets) {
                    for (DataSet p : InheritanceHelper.getDataSetHierarchy(ds)) {
                        involvedContainers.addAll((Collection<IContainer>)p.getContainer());
                        involvedClause.addAll(p.getJoin());
                        involvedClause.addAll(p.getFilter());
                    }
                }
                res.add(new SubSourceSet(ss, desc, involvedContainers, involvedClause));
            }
        }
        return res;
    }

    public static class SubSourceSet {
        private RSourceSet sourceSet;
        private SetDescriptor desc;
        private Set<IContainer> containers;
        private Set<Clause> clause;
        private Set<DataSet> dataSets = null;

        private SubSourceSet(RSourceSet sourceSet, SetDescriptor desc, Set<IContainer> containers, Set<Clause> clause) {
            this.sourceSet = sourceSet;
            this.desc = desc;
            this.containers = containers;
            this.clause = clause;
        }

        public RSourceSet getSourceSet() {
            return this.sourceSet;
        }

        public SetDescriptor getDesc() {
            return this.desc;
        }

        public Set<IContainer> getContainers() {
            return this.containers;
        }

        public Set<Clause> getClause() {
            return this.clause;
        }

        public Collection<DataSet> getDataSets() {
            if (this.dataSets == null) {
                this.dataSets = new HashSet<DataSet>();
                for (IContainer c : this.getContainers()) {
                    this.dataSets.add(c.getDataset());
                }
            }
            return this.dataSets;
        }
    }
}

