/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.util;

import com.indy.map.Template;
import com.semarchy.xdi.designer.core.capabilities.ICapability;
import com.semarchy.xdi.designer.core.capabilities.ICapabilityProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TemplateCapabilityHelper {
    private static final Logger logger = LogManager.getLogger(TemplateCapabilityHelper.class);

    private TemplateCapabilityHelper() {
    }

    public static boolean supportCapability(Template template, String category, String capabilityName, boolean defaultValue) {
        if (template == null) {
            return defaultValue;
        }
        ICapabilityProvider provider = template.getCapacityProvider(category, capabilityName);
        if (provider == null) {
            return defaultValue;
        }
        ICapability capability = provider.getCapability(category, capabilityName);
        if (capability == null) {
            return defaultValue;
        }
        try {
            return template.isSupported(capability);
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to evaluate capability ({}, {}) from template {} on {}", (Object)category, (Object)capabilityName, (Object)template.getName(), (Object)template.eResource().getURI(), (Object)e);
            }
            return defaultValue;
        }
    }
}

