/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.util.synchro.impl;

import com.indy.map.DataSet;
import com.indy.map.Expression;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.IReferencable;
import com.indy.map.ISerde;
import com.indy.map.Join;
import com.indy.map.Map;
import com.indy.map.MapPackage;
import com.indy.map.Query;
import com.indy.map.SetDescriptor;
import com.indy.map.Template;
import com.indy.map.custom.commands.UpdateContainerAliasCommand;
import com.indy.map.custom.commands.UpdateQueryFieldAliasCommand;
import com.indy.map.ensemblist.lexer.SubExpressionParser;
import com.indy.map.ref.RClause;
import com.indy.map.ref.RContainer;
import com.indy.map.ref.RExpression;
import com.indy.map.ref.RLogicalField;
import com.indy.map.ref.impl.RContainerImpl;
import com.indy.map.ref.impl.RLogicalFieldImpl;
import com.indy.map.util.IMapResource;
import com.indy.map.util.synchro.IRefUpdaterProvider;
import com.indy.map.util.synchro.impl.listeners.DataSetUpdater;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class CommitTriggerListener
implements ResourceSetListener {
    private Logger logger = LogManager.getLogger(CommitTriggerListener.class);

    public Command createCommand(Notification n) {
        DataSet ds;
        Query q;
        if (n.getEventType() == 1 && (n.getFeature() == MapPackage.eINSTANCE.getDatastore_Alias() || n.getFeature() == MapPackage.eINSTANCE.getQuery_Alias() || n.getFeature() == MapPackage.eINSTANCE.getOutliner_Alias() || n.getFeature() == MapPackage.eINSTANCE.getInliner_Alias() || n.getFeature() == MapPackage.eINSTANCE.getDatastore_ComputedAlias() || n.getFeature() == MapPackage.eINSTANCE.getQuery_ComputedAlias())) {
            CompoundCommand cc = new CompoundCommand();
            Command c = this.createUpdateContainerAliasCommand(n);
            if (c != null) {
                cc.append(c);
            }
            if (n.getOldValue() != null && (c = this.createTemplatesNameCommand(((QName)n.getOldValue()).toString(), (IContainer)n.getNotifier())) != null) {
                cc.append(c);
            }
            return cc;
        }
        if (n.getEventType() == 1 && n.getFeature() == MapPackage.eINSTANCE.getQueryField_Name() || n.getFeature() == MapPackage.eINSTANCE.getComputedField_Alias()) {
            return this.createUpdateFieldAliasCommand(n);
        }
        if (n.getEventType() == 1 && n.getFeature() == MapPackage.eINSTANCE.getClause_Expression() && n.getNotifier() instanceof Join) {
            Join j = (Join)n.getNotifier();
            return IRefUpdaterProvider.INSTANCE.getUpdater((RClause)j.getMapReference()).updateAndDomainCommand((RClause)j.getMapReference(), (EStructuralFeature)MapPackage.eINSTANCE.getClause_Expression());
        }
        if (!(n.getEventType() != 4 && n.getEventType() != 6 || n.getFeature() != MapPackage.eINSTANCE.getQuery_Field() && n.getFeature() != MapPackage.eINSTANCE.getQuery_ComputedField() || !(q = (Query)n.getNotifier()).getField().isEmpty())) {
            CompoundCommand cc = new CompoundCommand();
            for (SetDescriptor s : q.getSetDescriptor()) {
                cc.append((Command)new DataSetUpdater.SecureRemoveCommand(TransactionUtil.getEditingDomain((EObject)q), q, (EStructuralFeature)MapPackage.eINSTANCE.getQuery_SetDescriptor(), s));
            }
            return cc;
        }
        if (n.getEventType() == 1 && n.getFeature() == MapPackage.eINSTANCE.getExpression_Expression()) {
            Expression j = (Expression)n.getNotifier();
            boolean deleteSetDescriptor = false;
            if (j.eResource() != null) {
                if (!(j.eContainer().eContainer() instanceof ISerde) && (j.getExpression() == null || j.getExpression().isEmpty())) {
                    deleteSetDescriptor = true;
                    for (ILogicalField f : ((IContainer)j.eContainer().eContainer()).getLogicalField()) {
                        Expression e = f.getExpression(j.getSetDescriptorRef());
                        if (e == null || e.getExpression() == null || e.getExpression().isEmpty()) continue;
                        deleteSetDescriptor = false;
                        break;
                    }
                }
                Command cmd = IRefUpdaterProvider.INSTANCE.getUpdater((RExpression)j.getMapReference()).updateAndDomainCommand((RExpression)j.getMapReference(), (EStructuralFeature)MapPackage.eINSTANCE.getExpression_Expression());
                if (deleteSetDescriptor) {
                    CompoundCommand cc = new CompoundCommand();
                    if (cmd != null) {
                        cc.append(cmd);
                    }
                    if (!(j.eContainer().eContainer() instanceof Query)) {
                        cc.append((Command)new DestroySetDescriptorCommand(TransactionUtil.getEditingDomain((EObject)j), j.getSetDescriptorRef()));
                    }
                    return cc;
                }
                return cmd;
            }
        }
        if ((n.getEventType() == 4 || n.getEventType() == 6) && n.getFeature() == MapPackage.eINSTANCE.getDataSet_Container() && (ds = (DataSet)n.getNotifier()).getContainer().isEmpty()) {
            return this.createDestroyDataSetCommand(n);
        }
        if (n.getEventType() == 1 && n.getFeature() == MapPackage.eINSTANCE.getSetDescriptor_Label()) {
            return this.createSetDescriptorLabelUpdateCommand(n);
        }
        if (n.getFeature() == MapPackage.eINSTANCE.getDatastore_SetDescriptor() || n.getFeature() == MapPackage.eINSTANCE.getQuery_SetDescriptor()) {
            RContainer ref;
            IContainer c = (IContainer)n.getNotifier();
            if ((n.getEventType() == 4 || n.getEventType() == 6) && (ref = (RContainer)((IReferencable)((Object)c)).getMapReference()) != null) {
                return IRefUpdaterProvider.INSTANCE.getUpdater(ref).updateAndDomainCommand(ref, (EStructuralFeature)n.getFeature());
            }
        }
        return null;
    }

    private Command createTemplatesNameCommand(String oldAlias, IContainer container) {
        CompoundCommand cc = new CompoundCommand("Update Templates Names");
        if (container.eContainer() instanceof Map) {
            for (Template t : ((Map)container.eContainer()).getTemplate()) {
                int start;
                if (!t.getTargetId().contains((Object)container.getId()) || (start = t.getName().indexOf(oldAlias)) == -1) continue;
                String s = t.getName().substring(start);
                if (s.equals(oldAlias)) {
                    cc.append((Command)new SetCommand((EditingDomain)TransactionUtil.getEditingDomain((EObject)container), (EObject)t, (EStructuralFeature)MapPackage.eINSTANCE.getTemplate_Name(), (Object)t.getName().replace("_" + oldAlias, "_" + container.getAlias().toString())));
                    continue;
                }
                if (!s.substring(oldAlias.length()).startsWith("_")) continue;
                cc.append((Command)new SetCommand((EditingDomain)TransactionUtil.getEditingDomain((EObject)container), (EObject)t, (EStructuralFeature)MapPackage.eINSTANCE.getTemplate_Name(), (Object)t.getName().replace("_" + oldAlias + "_", "_" + container.getAlias().toString() + "_")));
            }
        }
        if (!cc.isEmpty()) {
            return cc;
        }
        return null;
    }

    private Command createSetDescriptorLabelUpdateCommand(final Notification n) {
        return new RecordingCommand(TransactionUtil.getEditingDomain((Object)n.getNotifier())){

            protected void doExecute() {
                SetDescriptor sd = (SetDescriptor)n.getNotifier();
                EObject o = sd.eContainer();
                if (o instanceof IContainer) {
                    IContainer c = (IContainer)sd.eContainer();
                    RContainer ref = (RContainer)((IReferencable)((Object)c)).getMapReference();
                    try {
                        SubExpressionParser parser = new SubExpressionParser();
                        SubExpressionParser.SubExpression tree = parser.parse(c);
                        ((RContainerImpl)ref).setSubExpressionTree(tree);
                    }
                    catch (Exception ex) {
                        CommitTriggerListener.this.logger.error("unexpected", (Throwable)ex);
                    }
                }
            }
        };
    }

    private Command createDestroyDataSetCommand(Notification n) {
        return new RemoveCommand((EditingDomain)TransactionUtil.getEditingDomain((Object)n.getNotifier()), (EObject)((DataSet)n.getNotifier()), (EStructuralFeature)MapPackage.eINSTANCE.getMap_DataSet(), n.getOldValue());
    }

    private Command createUpdateContainerAliasCommand(Notification n) {
        return new UpdateContainerAliasCommand(TransactionUtil.getEditingDomain((Object)n.getNotifier()), (IContainer)n.getNotifier(), (QName)n.getOldValue(), (QName)n.getNewValue());
    }

    private Command createUpdateFieldAliasCommand(Notification n) {
        return new UpdateQueryFieldAliasCommand(TransactionUtil.getEditingDomain((Object)n.getNotifier()), (ILogicalField)n.getNotifier(), (QName)n.getOldValue());
    }

    public NotificationFilter getFilter() {
        return NotificationFilter.createFeatureFilter((EStructuralFeature)MapPackage.eINSTANCE.getDatastore_Alias()).or(NotificationFilter.createFeatureFilter((EStructuralFeature)MapPackage.eINSTANCE.getQuery_Alias())).or(NotificationFilter.createFeatureFilter((EStructuralFeature)MapPackage.eINSTANCE.getDatastore_ComputedAlias())).or(NotificationFilter.createFeatureFilter((EStructuralFeature)MapPackage.eINSTANCE.getQuery_ComputedAlias())).or(NotificationFilter.createFeatureFilter((EStructuralFeature)MapPackage.eINSTANCE.getQueryField_Name())).or(NotificationFilter.createFeatureFilter((EStructuralFeature)MapPackage.eINSTANCE.getClause_Expression())).or(NotificationFilter.createFeatureFilter((EStructuralFeature)MapPackage.eINSTANCE.getDatastore_SetDescriptor())).or(NotificationFilter.createFeatureFilter((EStructuralFeature)MapPackage.eINSTANCE.getQuery_SetDescriptor())).or(NotificationFilter.createFeatureFilter((EStructuralFeature)MapPackage.eINSTANCE.getSetDescriptor_Label())).or(NotificationFilter.createFeatureFilter((EStructuralFeature)MapPackage.eINSTANCE.getQuery_Field())).or(NotificationFilter.createFeatureFilter((EStructuralFeature)MapPackage.eINSTANCE.getMap_Variable())).or(NotificationFilter.createFeatureFilter((EStructuralFeature)MapPackage.eINSTANCE.getComputedField_Alias())).or(NotificationFilter.createFeatureFilter((EStructuralFeature)MapPackage.eINSTANCE.getExpression_Expression()));
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        CompoundCommand cc = this.createCommandForNotification(event.getNotifications());
        if (cc.isEmpty()) {
            return null;
        }
        return cc;
    }

    private CompoundCommand createCommandForNotification(Collection<Notification> notifications) {
        CompoundCommand cc = new CompoundCommand();
        if (notifications != null) {
            notifications.stream().map(this::createCommand).filter(c -> c != null).forEach(arg_0 -> ((CompoundCommand)cc).append(arg_0));
        }
        return cc;
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        CompoundCommand cc;
        if (event.getTransaction() == null) {
            return;
        }
        if (Boolean.TRUE.equals(event.getTransaction().getOptions().get("is_undo_redo_transaction")) && !(cc = this.createCommandForNotification(event.getNotifications())).isEmpty()) {
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("unprotected", Boolean.TRUE);
            try {
                ((TransactionalCommandStack)event.getEditingDomain().getCommandStack()).execute((Command)cc, options);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.error("unexpected", (Throwable)e);
            }
            catch (RollbackException e) {
                this.logger.error("unexpected", (Throwable)e);
            }
        }
    }

    public boolean isAggregatePrecommitListener() {
        return true;
    }

    public boolean isPrecommitOnly() {
        return true;
    }

    public boolean isPostcommitOnly() {
        return false;
    }

    private static class DestroySetDescriptorCommand
    extends RecordingCommand {
        private WeakReference<SetDescriptor> ref;

        public DestroySetDescriptorCommand(TransactionalEditingDomain domain, SetDescriptor desc) {
            super(domain);
            this.ref = new WeakReference<SetDescriptor>(desc);
        }

        protected void doExecute() {
            if (this.ref == null) {
                return;
            }
            SetDescriptor desc = (SetDescriptor)this.ref.get();
            if (desc == null) {
                return;
            }
            IContainer container = (IContainer)desc.eContainer();
            if (container == null) {
                return;
            }
            ArrayList<IReferencable> removed = new ArrayList<IReferencable>();
            for (ILogicalField f : container.getLogicalField()) {
                Expression exp = f.getExpression(desc);
                if (exp != null) {
                    exp.eAdapters().clear();
                    f.getExpression().remove((Object)exp);
                    removed.add(exp);
                }
                RLogicalField r = (RLogicalField)((IReferencable)((Object)f)).getMapReference();
                ((RLogicalFieldImpl)r).updateStatus();
            }
            ((IMapResource)desc.eResource()).getReferenceSynchronizer().unSynchronize(removed);
            container.getSetDescriptor().remove((Object)desc);
        }

        public void dispose() {
            this.ref = null;
            super.dispose();
        }
    }
}

