/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.util.upgrade;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class MappingConvertor {
    private static final String SOURCE = "source";
    private static final String TARGET = "target";
    private static final String NAME = "name";
    private static final String ALIAS = "alias";
    private static final String MESSAGE = "message";
    private static final String DATASTORE = "datastore";
    private static final String CONNECTION = "connection";
    private static final String ANNOTATION = "annotation";
    private static final String VALUE = "value";
    private static final String CATEGORY = "category";
    private static final Object STATUS = "status";
    private static final Object TYPE = "type";
    private static final Object MANDATORY = "mandatory";
    private static final Object POSITION = "position";
    private static final Object PRECISION = "precision";
    private static final Object SIZE = "size";
    private static final Object LOCATION = "location";
    private static final Object FULL_NAME = "fullName";
    private static final QName ID = new QName("id");
    private static final QName Q_NAME = new QName("name");
    private static final QName Q_ALIAS = new QName("alias");
    private XMLEventReader reader;
    private XMLEventReader fastReader;
    private XMLStreamWriter writer;
    private int skipCount = 0;
    private boolean inTag = false;
    private String currentDataStoreId;
    private String currentTargetContainerRefId;
    private String currentTargetContainerName;
    private boolean isHierarchical = false;
    private boolean handledHierarchicalMissingRootField = false;
    private boolean incrementTargetName = false;
    private boolean inCriteria;

    public MappingConvertor(InputStream v1InputStream, InputStream copyInputStream, OutputStream v2OutputStream, String encoding) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.supportDTD", false);
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        this.reader = factory.createXMLEventReader(v1InputStream, encoding);
        this.fastReader = factory.createXMLEventReader(copyInputStream, encoding);
        XMLOutputFactory outfactory = XMLOutputFactory.newInstance();
        this.writer = encoding == null ? outfactory.createXMLStreamWriter(v2OutputStream) : outfactory.createXMLStreamWriter(v2OutputStream, encoding);
    }

    public void convert() throws XMLStreamException {
        StartElement se;
        XMLEvent event;
        String targetName = null;
        while (this.fastReader.hasNext()) {
            boolean isSource;
            event = this.fastReader.nextEvent();
            if (event.getEventType() != 1) continue;
            se = event.asStartElement();
            String s = se.getName().getLocalPart();
            boolean bl = isSource = SOURCE.equals(s) || TARGET.equals(s);
            if (!isSource) continue;
            Attribute a = se.getAttributeByName(Q_ALIAS);
            if (a == null) {
                a = se.getAttributeByName(Q_NAME);
            }
            String alias = a.getValue();
            if (!isSource) {
                targetName = alias;
                continue;
            }
            if (targetName == null || !targetName.equalsIgnoreCase(alias)) continue;
            this.incrementTargetName = true;
        }
        this.fastReader.close();
        while (this.reader.hasNext()) {
            event = this.reader.nextEvent();
            switch (event.getEventType()) {
                case 4: {
                    if (this.inCriteria) {
                        String data = event.asCharacters().getData();
                        if (data.equals("NO_LOAD")) {
                            this.writer.writeStartElement(ANNOTATION);
                            this.writer.writeAttribute(NAME, "template.load.disable");
                            this.writer.writeAttribute(VALUE, "true");
                            this.writer.writeAttribute(CATEGORY, "com.indy.map.helpers.semantic.v1");
                            this.writer.writeEndElement();
                        } else {
                            this.writer.writeStartElement("tag");
                            this.writer.writeCharacters(data);
                            this.writer.writeEndElement();
                        }
                    }
                    if (!this.inTag) break;
                    this.writer.writeCharacters(event.asCharacters().getData());
                    break;
                }
                case 7: {
                    this.handleStartDocument();
                    break;
                }
                case 8: {
                    this.handleEndDocument();
                    break;
                }
                case 1: {
                    if (this.skipCount != 0) {
                        ++this.skipCount;
                        break;
                    }
                    se = event.asStartElement();
                    if (this.handleStartEvent(se)) break;
                    ++this.skipCount;
                    break;
                }
                case 2: {
                    if (this.skipCount > 0) {
                        --this.skipCount;
                        break;
                    }
                    this.handleEndElement(event);
                }
            }
        }
        this.writer.flush();
        this.writer.close();
        this.reader.close();
    }

    private void handleEndElement(XMLEvent event) throws XMLStreamException {
        String s = event.asEndElement().getName().getLocalPart();
        if (s.equals(TARGET)) {
            this.writer.writeStartElement("setDescriptor");
            this.writer.writeAttribute("id", this.currentDataStoreId + "_setDesc");
            this.writer.writeAttribute("label", "A");
            this.writer.writeEndElement();
            this.currentTargetContainerRefId = null;
            this.isHierarchical = false;
            this.handledHierarchicalMissingRootField = false;
        }
        if (!this.inCriteria) {
            this.writer.writeEndElement();
        } else {
            this.inCriteria = false;
        }
        if (s.equals("tag")) {
            this.inTag = false;
        }
    }

    private boolean handleStartEvent(StartElement se) throws XMLStreamException {
        String s = se.getName().getLocalPart();
        if ("srcField".equals(s)) {
            this.handleSrcField(se);
        } else if ("trgField".equals(s)) {
            this.handleTrgField(se);
        } else if (SOURCE.equals(s) || TARGET.equals(s)) {
            this.handleDatastore(se);
        } else if ("variable".equals(s)) {
            this.handleVariable(se);
        } else if ("join".equals(s) || "filter".equals(s)) {
            this.handleClause(se);
        } else if ("constraint".equals(s)) {
            this.handleConstraint(se);
        } else if ("tag".equals(s)) {
            this.handleTag(se);
        } else if ("process".equals(s)) {
            this.handleProcess(se);
        } else if ("parameter".equals(s)) {
            this.handleParameter(se);
        } else if ("map".equals(s)) {
            this.handleMap(se);
        } else if ("criteria".equals(s)) {
            this.inCriteria = true;
        } else {
            return false;
        }
        return true;
    }

    private void handleMap(StartElement se) throws XMLStreamException {
        this.writer.writeStartElement(se.getName().getPrefix(), se.getName().getLocalPart(), "http://www.indy.com/v2/map");
        Iterator<Attribute> it = se.getNamespaces();
        while (it.hasNext()) {
            Namespace n = it.next();
            if (n.getPrefix().equals("map")) {
                this.writer.writeNamespace(n.getPrefix(), "http://www.indy.com/v2/map");
                continue;
            }
            this.writer.writeNamespace(n.getPrefix(), n.getNamespaceURI());
        }
        it = se.getAttributes();
        while (it.hasNext()) {
            Attribute a = it.next();
            this.writer.writeAttribute(a.getName().getPrefix(), a.getName().getNamespaceURI(), a.getName().getLocalPart(), a.getValue());
        }
    }

    private void handleParameter(StartElement s) throws XMLStreamException {
        this.writer.writeStartElement(s.getName().getPrefix(), s.getName().getLocalPart(), s.getName().getNamespaceURI());
        Iterator<Attribute> it = s.getAttributes();
        while (it.hasNext()) {
            Attribute a = it.next();
            String localName = a.getName().getLocalPart();
            if (localName.equals("nodeCode") || localName.equals("templateCriteria") || localName.equals("visibility") || localName.equals("ref") || localName.equals("targetRef")) continue;
            this.writer.writeAttribute(a.getName().getNamespaceURI(), a.getName().getLocalPart(), a.getValue());
        }
        this.writer.writeAttribute("id", UUID.randomUUID().toString());
    }

    private void handleProcess(StartElement s) throws XMLStreamException {
        this.writer.writeStartElement(s.getName().getPrefix(), "template", s.getName().getNamespaceURI());
        Iterator<Attribute> it = s.getAttributes();
        while (it.hasNext()) {
            Attribute a = it.next();
            String localName = a.getName().getLocalPart();
            if (this.incrementTargetName && localName.equals(NAME)) {
                this.writer.writeAttribute(a.getName().getNamespaceURI(), a.getName().getLocalPart(), a.getValue() + "_2");
                continue;
            }
            if (localName.equals("nodeCode") || localName.equals("templateCriteria") || localName.equals("visibility") || localName.equals("ref") || localName.equals("targetRef")) continue;
            if (a.getName().getLocalPart().equals(TARGET)) {
                this.writer.writeAttribute(a.getName().getNamespaceURI(), "process", a.getValue());
                continue;
            }
            this.writer.writeAttribute(a.getName().getNamespaceURI(), a.getName().getLocalPart(), a.getValue());
        }
    }

    private void handleTag(StartElement s) throws XMLStreamException {
        this.writer.writeStartElement(s.getName().getPrefix(), s.getName().getLocalPart(), s.getName().getNamespaceURI());
        this.inTag = true;
    }

    private void handleConstraint(StartElement s) throws XMLStreamException {
        this.writer.writeStartElement(s.getName().getPrefix(), s.getName().getLocalPart(), s.getName().getNamespaceURI());
        Iterator<Attribute> it = s.getAttributes();
        while (it.hasNext()) {
            Attribute a = it.next();
            String localName = a.getName().getLocalPart();
            if (localName.equals(TYPE) || localName.equals(MESSAGE) || localName.equals(STATUS)) continue;
            this.writer.writeAttribute(a.getName().getNamespaceURI(), a.getName().getLocalPart(), a.getValue());
        }
    }

    private void handleClause(StartElement s) throws XMLStreamException {
        this.writer.writeStartElement(s.getName().getPrefix(), s.getName().getLocalPart(), s.getName().getNamespaceURI());
        Attribute expression = null;
        String messageValue = null;
        Iterator<Attribute> it = s.getAttributes();
        while (it.hasNext()) {
            Attribute a = it.next();
            String localName = a.getName().getLocalPart();
            if (!localName.equals("internalExpression") && !localName.equals(STATUS)) {
                if (localName.equals("expression")) {
                    expression = a;
                } else {
                    this.writer.writeAttribute(a.getName().getNamespaceURI(), a.getName().getLocalPart(), a.getValue());
                }
            }
            if (!localName.equals(MESSAGE)) continue;
            messageValue = a.getValue();
        }
        if (messageValue != null) {
            this.handleMessageHint(messageValue);
        }
        if (expression != null) {
            this.writer.writeStartElement("", "expression", "");
            this.writer.writeCharacters(expression.getValue());
            this.writer.writeEndElement();
        }
    }

    private void handleMessageHint(String messageValue) throws XMLStreamException {
        int start = messageValue.indexOf("%position{");
        int end = messageValue.indexOf("}position%");
        if (start != -1 && end != -1) {
            String templateHelper;
            String sizes = messageValue.substring(start + 10, end);
            String[] c = sizes.split(";");
            Integer x = null;
            if (c.length > 0) {
                try {
                    x = Integer.valueOf(c[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            Integer y = null;
            if (c.length > 1) {
                try {
                    y = Integer.valueOf(c[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            Integer height = null;
            if (c.length > 2) {
                try {
                    height = Integer.valueOf(c[2]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            Integer width = null;
            if (c.length > 3) {
                try {
                    width = Integer.valueOf(c[3]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (x != null && y != null) {
                this.writer.writeStartElement(ANNOTATION);
                this.writer.writeAttribute(NAME, "node.location");
                this.writer.writeAttribute(VALUE, "{" + String.valueOf(x) + ";" + String.valueOf(y) + "}");
                this.writer.writeAttribute(CATEGORY, "com.indy.map.helpers.diagram");
                this.writer.writeEndElement();
            }
            if (width != null || height != null) {
                this.writer.writeStartElement(ANNOTATION);
                this.writer.writeAttribute(NAME, "node.size");
                if (height == null) {
                    height = -1;
                }
                if (width == null) {
                    width = -1;
                }
                this.writer.writeAttribute(VALUE, "{" + String.valueOf(width) + ";" + String.valueOf(height) + "}");
                this.writer.writeAttribute(CATEGORY, "com.indy.map.helpers.diagram");
                this.writer.writeEndElement();
            }
            start = messageValue.indexOf("%template{");
            end = messageValue.indexOf("}template%");
            if (start != -1 && end != -1 && (templateHelper = messageValue.substring(start + 10, end)) != null) {
                this.writer.writeStartElement(ANNOTATION);
                this.writer.writeAttribute(NAME, "template.load");
                this.writer.writeAttribute(VALUE, templateHelper);
                this.writer.writeAttribute(CATEGORY, "com.indy.map.helpers.semantic");
                this.writer.writeEndElement();
            }
        }
    }

    private void handleVariable(StartElement s) throws XMLStreamException {
        this.writer.writeStartElement(s.getName().getPrefix(), s.getName().getLocalPart(), s.getName().getNamespaceURI());
        Iterator<Attribute> it = s.getAttributes();
        while (it.hasNext()) {
            Attribute a = it.next();
            String localName = a.getName().getLocalPart();
            if (localName.equals(TYPE) || localName.equals(NAME) || localName.equals(MESSAGE) || localName.equals(STATUS)) continue;
            this.writer.writeAttribute(a.getName().getNamespaceURI(), a.getName().getLocalPart(), a.getValue());
        }
    }

    private void handleDatastore(StartElement s) throws XMLStreamException {
        boolean isTarget = s.getName().getLocalPart().equals(TARGET);
        this.writer.writeStartElement(s.getName().getPrefix(), DATASTORE, s.getName().getNamespaceURI());
        this.currentDataStoreId = s.getAttributeByName(ID).getValue();
        Attribute name = null;
        Attribute alias = null;
        String messageValue = null;
        boolean controlDefined = false;
        Iterator<Attribute> it = s.getAttributes();
        while (it.hasNext()) {
            Attribute a = it.next();
            String localName = a.getName().getLocalPart();
            if (!(localName.equals(CONNECTION) || localName.equals(MESSAGE) || localName.equals(STATUS) || localName.equals(TYPE))) {
                if (isTarget) {
                    if (localName.equals(NAME)) {
                        name = a;
                        continue;
                    }
                } else {
                    if (localName.equals(NAME)) {
                        name = a;
                        continue;
                    }
                    if (localName.equals(ALIAS)) {
                        alias = a;
                        continue;
                    }
                }
                if (localName.equals("control")) {
                    controlDefined = true;
                }
                this.writer.writeAttribute(a.getName().getNamespaceURI(), a.getName().getLocalPart(), a.getValue());
                if (isTarget && localName.equals("ref")) {
                    this.currentTargetContainerRefId = a.getValue();
                }
            }
            if (!localName.equals(MESSAGE)) continue;
            messageValue = a.getValue();
        }
        if (alias != null) {
            if (isTarget && this.incrementTargetName) {
                this.writer.writeAttribute(alias.getName().getNamespaceURI(), ALIAS, alias.getValue() + "_2");
            } else {
                this.writer.writeAttribute(alias.getName().getNamespaceURI(), ALIAS, alias.getValue());
            }
        } else if (name != null) {
            if (isTarget && this.incrementTargetName) {
                this.writer.writeAttribute(name.getName().getNamespaceURI(), ALIAS, name.getValue() + "_2");
            } else {
                this.writer.writeAttribute(name.getName().getNamespaceURI(), ALIAS, name.getValue());
            }
        }
        if (isTarget && name != null) {
            this.currentTargetContainerName = name.getValue();
            if (!controlDefined) {
                this.writer.writeAttribute(name.getName().getNamespaceURI(), "control", "true");
            }
        }
        if (name != null) {
            this.writer.writeAttribute(name.getName().getNamespaceURI(), "subExpression", "[A]");
        }
        if (messageValue != null) {
            this.handleMessageHint(messageValue);
        }
    }

    private void handleTrgField(StartElement s) throws XMLStreamException {
        this.writer.writeStartElement(s.getName().getPrefix(), "field", s.getName().getNamespaceURI());
        Attribute expression = null;
        Attribute location = null;
        Attribute aggregate = null;
        Iterator<Attribute> it = s.getAttributes();
        while (it.hasNext()) {
            Attribute a = it.next();
            String localName = a.getName().getLocalPart();
            if (!(localName.equals(MANDATORY) || localName.equals("internalMapping") || localName.equals(POSITION) || localName.equals(PRECISION) || localName.equals(SIZE) || localName.equals(TYPE) || localName.equals(MESSAGE) || localName.equals(FULL_NAME) || localName.equals(STATUS))) {
                if (localName.equals("mapping")) {
                    expression = a;
                } else if (localName.equals("aggregate")) {
                    aggregate = a;
                } else if (localName.equals(LOCATION)) {
                    location = a;
                } else {
                    this.writer.writeAttribute(a.getName().getNamespaceURI(), a.getName().getLocalPart(), a.getValue());
                }
            }
            if (this.isHierarchical || !localName.equals("expand") && !localName.equals("parent") && (!localName.equals(FULL_NAME) || !a.getValue().contains("/"))) continue;
            this.isHierarchical = true;
        }
        this.writer.writeStartElement(s.getName().getPrefix(), "expression", s.getName().getNamespaceURI());
        this.writer.writeAttribute("id", s.getAttributeByName(ID).getValue() + "_expression");
        this.writer.writeAttribute("setDescriptorRef", this.currentDataStoreId + "_setDesc");
        if (location != null) {
            this.writer.writeAttribute(location.getName().getPrefix(), location.getName().getNamespaceURI(), location.getName().getLocalPart(), location.getValue());
        }
        if (aggregate != null) {
            this.writer.writeAttribute(aggregate.getName().getPrefix(), aggregate.getName().getNamespaceURI(), aggregate.getName().getLocalPart(), aggregate.getValue());
        }
        this.writer.writeStartElement("expression");
        if (expression != null) {
            this.writer.writeCData(expression.getValue());
        }
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }

    private void handleSrcField(StartElement s) throws XMLStreamException {
        this.writer.writeStartElement(s.getName().getPrefix(), "field", s.getName().getNamespaceURI());
        Iterator<Attribute> it = s.getAttributes();
        while (it.hasNext()) {
            Attribute a = it.next();
            String localName = a.getName().getLocalPart();
            if (localName.equals(POSITION) || localName.equals(PRECISION) || localName.equals(SIZE) || localName.equals(TYPE) || localName.equals(MESSAGE) || localName.equals(MANDATORY) || localName.equals(FULL_NAME) || localName.equals(STATUS) || localName.equals(LOCATION)) continue;
            this.writer.writeAttribute(a.getName().getNamespaceURI(), a.getName().getLocalPart(), a.getValue());
        }
    }

    private void handleEndDocument() throws XMLStreamException {
        this.writer.writeEndDocument();
    }

    private void handleStartDocument() throws XMLStreamException {
        this.writer.writeStartDocument();
    }
}

