/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.validation;

import com.indy.gmf.proc.ActionProcess;
import com.indy.map.DataSet;
import com.indy.map.Datastore;
import com.indy.map.Expression;
import com.indy.map.Field;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.IMetaData;
import com.indy.map.IReferencable;
import com.indy.map.Join;
import com.indy.map.JoinLocation;
import com.indy.map.Map;
import com.indy.map.MapPackage;
import com.indy.map.Outliner;
import com.indy.map.Template;
import com.indy.map.api.IMetaDataInformationsProvider;
import com.indy.map.compute.graph.Edge;
import com.indy.map.compute.graph.Graph;
import com.indy.map.compute.graph.Vertice;
import com.indy.map.custom.commands.UpdateInstanceCommand;
import com.indy.map.messages.Messages;
import com.indy.map.ref.RContainer;
import com.indy.map.ref.RDatastore;
import com.indy.map.ref.RExpression;
import com.indy.map.ref.RLoadSet;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RProblem;
import com.indy.map.ref.RTargetSet;
import com.indy.map.ref.RTemplate;
import com.indy.map.util.SourceSetHelper;
import com.indy.map.validation.ProblemValidationStatus;
import com.stambia.md.MdNode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ContainerConstraintVisitor {
    Logger logger = LogManager.getLogger(ContainerConstraintVisitor.class);
    boolean isTarget;
    boolean isSource;
    boolean isMultiSet;
    EObject containerConnectionOnRef;
    Map map;
    RMap refMap;
    RTargetSet targetSet;
    RLoadSet loadSet;
    Set<ProblemValidationStatus.ProblemEntry> problems = new HashSet<ProblemValidationStatus.ProblemEntry>();
    IContainer container;

    public ContainerConstraintVisitor(IContainer container) {
        this.container = container;
    }

    private void checkMissingDataset() {
        if (this.container.getDataset() == null) {
            this.problems.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_NO_DATASET, null));
        }
    }

    private void checkReservedWords() {
        IMetaData md;
        EObject eObject;
        IContainer iContainer = this.container;
        if (iContainer instanceof IMetaData && (eObject = (md = (IMetaData)((Object)iContainer)).getRef()) instanceof MdNode) {
            MdNode mdNode = (MdNode)eObject;
            try {
                Collection c;
                Object o = mdNode.evaluateXpathExpressionMdSetCached("INTERNAL_RESERVED_WORDS");
                if (o instanceof Collection && (c = (Collection)o).stream().anyMatch(e -> this.container.getAlias().toString().equalsIgnoreCase(e.toString()))) {
                    this.problems.add(new ProblemValidationStatus.ProblemEntry(RProblem.WARNING_ALIAS_MATCHES_RESERVED_WORD, null));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void checkAliasUnicity() {
        this.map.getContainer().stream().filter(c -> c != this.container && c.getAlias().toString().equals(this.container.getAlias().toString())).findFirst().ifPresent(c -> {
            boolean bl = this.problems.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_CONTAINER_ALIAS_NOT_UNIQUE, null));
        });
    }

    private void checkSupportedAsSourceOrTarget() {
        if (!(this.container instanceof Datastore)) {
            return;
        }
        if (this.isTarget && !this.container.getAPI().getMdEvaluator().supportTargetMapping(this.container, IMetaDataInformationsProvider.EvaluationLocation.ON_REF)) {
            this.problems.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_DATASTORE_TECH_NO_TARGET, null));
        }
        if (this.isSource && !this.container.getAPI().getMdEvaluator().supportSourceMapping(this.container, IMetaDataInformationsProvider.EvaluationLocation.ON_REF)) {
            this.problems.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_DATASTORE_TECH_NO_SOURCE, null));
        }
    }

    private void checkHasTargetConnection() {
        if (this.isTarget && this.containerConnectionOnRef == null) {
            this.problems.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_TARGET_WITHOUT_CONNECTION, null));
        }
    }

    private void checkSubExpression(RContainer ref) {
        if (!this.isMultiSet) {
            return;
        }
        if (ref.getSubExpressionTree() == null || this.container.getSubExpression() == null || this.container.getSubExpression().isEmpty()) {
            this.problems.add(new ProblemValidationStatus.ProblemEntry(RProblem.WARNING_CONTAINER_SUBEXPRESSION, null));
        } else if (ref.getSubExpressionTree() != null && ref.getSubExpressionTree().missSetDescriptor(this.container)) {
            this.problems.add(new ProblemValidationStatus.ProblemEntry(RProblem.WARNING_CONTAINER_SUBEXPRESSION_MISS_SETDESCRIPTOR, null));
        }
    }

    private void checkDisjointedDataSets() {
        boolean checkAncestor4Disjonction;
        if (this.containerConnectionOnRef == null || !this.isTarget) {
            return;
        }
        boolean error = this.container.getAPI().getMdEvaluator().evaluateDisjointedDataSetError(this.container, IMetaDataInformationsProvider.EvaluationLocation.ON_REF);
        boolean warning = this.container.getAPI().getMdEvaluator().evaluateDisjointedDataSetWarning(this.container, IMetaDataInformationsProvider.EvaluationLocation.ON_REF);
        boolean bl = checkAncestor4Disjonction = this.container instanceof Datastore && ((RDatastore)((Datastore)this.container).getMapReference()).isHierarchical();
        if (checkAncestor4Disjonction) {
            checkAncestor4Disjonction = this.container.getAPI().getMdEvaluator().evaluateErrorWhenDisjointedDataSetHaveCommonMappedAncestor(this.container, IMetaDataInformationsProvider.EvaluationLocation.ON_REF);
        }
        if (!checkAncestor4Disjonction || !error && !warning) {
            return;
        }
        List<SourceSetHelper.SubSourceSet> subSS = SourceSetHelper.computeSubSourceSets(this.targetSet.getSourceSet());
        if (subSS == null) {
            return;
        }
        block2: for (SourceSetHelper.SubSourceSet s : subSS) {
            Set ds = s.getContainers().stream().map(c -> c.getDataset()).collect(Collectors.toSet());
            if (ds.size() <= 1) continue;
            for (DataSet d : ds) {
                boolean isJoined = ds.stream().anyMatch(d2 -> d2 != d && (d.getJoin4Child((DataSet)d2) != null || d.getJoin4Parent((DataSet)d2) != null));
                if (isJoined || this.targetSet.getSourceSet().contains(this.container)) continue;
                if (Boolean.TRUE.equals(error)) {
                    this.problems.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_DISJOINT_DATASET_ON_SUBSOURCESET, null));
                    continue block2;
                }
                if (!Boolean.TRUE.equals(warning)) continue block2;
                this.problems.add(new ProblemValidationStatus.ProblemEntry(RProblem.WARNING_DISJOINT_DATASET_ON_SUBSOURCESET, null));
                continue block2;
            }
        }
        try {
            if (!this.validateDisjonction(subSS)) {
                this.problems.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_DISJOINT_DATASET_WITH_MAPPED_ANCESTOR, null));
            }
        }
        catch (Exception ex) {
            this.logger.error(Messages.ContainerConstraint_1, (Throwable)ex);
        }
    }

    private boolean validateDisjonction(List<SourceSetHelper.SubSourceSet> subSS) {
        for (SourceSetHelper.SubSourceSet sub : subSS) {
            HashMap disjointedPairs = new HashMap();
            for (DataSet d : sub.getDataSets()) {
                sub.getDataSets().stream().filter(d2 -> d2 != d && d.getJoin4Child((DataSet)d2) == null && d.getJoin4Parent((DataSet)d2) == null).forEach(d2 -> {
                    boolean bl = disjointedPairs.computeIfAbsent(d, k -> new HashSet()).add(d2);
                });
            }
            if (disjointedPairs.isEmpty()) continue;
            Predicate<Field> fieldWithExpressionFilter = f -> {
                Expression e = f.getExpression(sub.getDesc());
                return e != null && e.getExpression() != null && !e.getExpression().trim().isEmpty();
            };
            HashMap targetFields = new HashMap();
            ((Datastore)this.container).getField().stream().filter(fieldWithExpressionFilter).forEach(f -> {
                Expression ex = f.getExpression(sub.getDesc());
                ((RExpression)ex.getMapReference()).getSourceRef().stream().filter(s -> s.getDataModel() instanceof ILogicalField).map(s -> ((IContainer)s.getDataModel().eContainer()).getDataset()).forEach(ds -> {
                    boolean bl = targetFields.computeIfAbsent(ds, k -> new HashSet()).add(f);
                });
            });
            for (Map.Entry en : disjointedPairs.entrySet()) {
                for (DataSet ds2 : (Set)en.getValue()) {
                    Set f1 = (Set)targetFields.get(en.getKey());
                    Set f2 = (Set)targetFields.get(ds2);
                    f1.removeAll(f2);
                    f2.removeAll(f1);
                    Set h1 = f1.stream().flatMap(f -> f.getAncestors().stream()).filter(fieldWithExpressionFilter).collect(Collectors.toSet());
                    Set h2 = f2.stream().flatMap(f -> f.getAncestors().stream()).filter(fieldWithExpressionFilter).collect(Collectors.toSet());
                    if (Collections.disjoint(h1, h2)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean hasPath(List<Join> joins, IContainer container) {
        Graph graph = new Graph();
        HashMap data = new HashMap();
        joins.stream().forEach(j -> {
            Vertice a = graph.createVertice(j.getLeft());
            Vertice b = graph.createVertice(j.getRight());
            data.put(a, j.getLeft());
            data.put(b, j.getRight());
            graph.createEdge(a, b);
        });
        for (Vertice v : graph.getVertex()) {
            int outNum = 0;
            for (Edge e : graph.getEdges()) {
                if (e.getEnd() == v) {
                    ++outNum;
                }
                if (outNum <= 1 || data.get(v) != container) continue;
                return false;
            }
        }
        return true;
    }

    private void checkLoadSetDirectPath() {
        if (this.containerConnectionOnRef == null || this.loadSet == null) {
            return;
        }
        AtomicBoolean res = new AtomicBoolean(true);
        try {
            if (!this.container.getAPI().getMdEvaluator().evaluateErrorOnLoadSetWhenNoDirectPath(this.container, IMetaDataInformationsProvider.EvaluationLocation.ON_REF)) {
                return;
            }
            List<Join> joins = this.map.getJoin().stream().filter(j -> j.getLocation() == JoinLocation.SRC && j.getLeft() != null && j.getRight() != null && this.loadSet.getContainer().contains((Object)j.getLeft()) && this.loadSet.getContainer().contains((Object)j.getRight())).toList();
            joins.stream().filter(j -> j.getRight() == this.container).findFirst().ifPresent(rightJoin -> res.set(this.hasPath(joins, this.container)));
            if (!res.get()) {
                this.problems.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_JOIN_LOADSET_NO_DIRECT_PATH, null));
            }
        }
        catch (Exception ex) {
            this.logger.error("Error during graph computation", (Throwable)ex);
        }
    }

    private void checkStageArea() {
        Template integrationTpl;
        MdNode md;
        EObject stagingArea;
        Datastore ds;
        IContainer iContainer = this.container;
        if (!(iContainer instanceof Datastore) || !(ds = (Datastore)iContainer).eIsSet((EStructuralFeature)MapPackage.eINSTANCE.getDatastore_StagingArea())) {
            return;
        }
        if (!this.isTarget) {
            this.problems.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_DATASTORE_STAGING_AREA_ON_SOURCE, null));
        } else {
            boolean hasLoadTemplate = this.map.getTemplateForTarget(ds).stream().anyMatch(t -> ((RTemplate)t.getMapReference()).getTemplateType() == RTemplate.Type.LOAD);
            if (!hasLoadTemplate) {
                this.problems.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_DATASTORE_STAGING_AREA_REQUIRE_LOAD_TEMPLATE, null));
            }
        }
        if (ds.getAPI().getMdEvaluator().hasWorkspaceCapability(ds, IMetaDataInformationsProvider.EvaluationLocation.ON_REF)) {
            this.problems.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_DATASTORE_STAGING_AREA_WITH_WKSP_CAPABILITY, null));
        }
        boolean supportLoad = true;
        if (ds.getTag().contains((Object)new QName("NO_LOAD"))) {
            supportLoad = false;
        }
        if ((stagingArea = ds.getStagingArea()).eIsProxy() || !(stagingArea instanceof MdNode) || (md = (MdNode)stagingArea).getLevel() == null) {
            this.problems.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_STAGING_AREA_NOT_RESOLVED, null));
            supportLoad = false;
        }
        if (supportLoad && (integrationTpl = this.map.getIntegrationTemplate(ds)).getProcess() instanceof ActionProcess && !UpdateInstanceCommand.checkTemplateSupportLoad(integrationTpl)) {
            supportLoad = false;
        }
        if (!supportLoad) {
            this.problems.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_DATASTORE_STAGING_AREA_WITH_NO_LOAD_TEMPLATE, null));
        }
    }

    private void checkOutlinerSharedLoad() {
        if (!(this.container instanceof Outliner)) {
            return;
        }
        if (this.map.getTemplate().stream().map(t -> (RTemplate)t.getMapReference()).anyMatch(r -> r.getTemplateType() == RTemplate.Type.LOAD && r.getRef().contains(this.container) && r.getTargetRef().size() > 1)) {
            this.problems.add(new ProblemValidationStatus.ProblemEntry(RProblem.WARNING_OUTLINER_USED_BY_MULTIPLE_DATASTORE_BY_SHARED_LOAD, null));
        }
    }

    public Set<ProblemValidationStatus.ProblemEntry> visit() {
        this.gatherInformations();
        RContainer ref = (RContainer)((IReferencable)((Object)this.container)).getMapReference();
        this.checkMissingDataset();
        this.checkReservedWords();
        this.checkAliasUnicity();
        this.checkSupportedAsSourceOrTarget();
        this.checkHasTargetConnection();
        this.checkSubExpression(ref);
        this.checkDisjointedDataSets();
        this.checkLoadSetDirectPath();
        this.checkStageArea();
        this.checkOutlinerSharedLoad();
        return this.problems;
    }

    private void gatherInformations() {
        this.map = (Map)this.container.eContainer();
        this.refMap = (RMap)this.map.getMapReference();
        this.targetSet = this.refMap.getTargetSetRef(this.container);
        this.isTarget = this.targetSet != null;
        this.isSource = !this.refMap.getSourceSetRef(this.container.getDataset()).isEmpty();
        this.loadSet = this.refMap.getLoadSet(this.container);
        this.isMultiSet = !this.container.getSetDescriptor().isEmpty();
        this.containerConnectionOnRef = this.container.getAPI().getMdEvaluator().evaluateConnection(this.container, IMetaDataInformationsProvider.EvaluationLocation.ON_REF);
    }
}

