/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.validation;

import com.indy.map.DataSet;
import com.indy.map.Datastore;
import com.indy.map.Expression;
import com.indy.map.Field;
import com.indy.map.IContainer;
import com.indy.map.IExpression;
import com.indy.map.ILogicalField;
import com.indy.map.Join;
import com.indy.map.Map;
import com.indy.map.MapLocation;
import com.indy.map.MapModelItem;
import com.indy.map.Query;
import com.indy.map.QueryField;
import com.indy.map.Template;
import com.indy.map.api.IMapAPI;
import com.indy.map.api.IMetaDataInformationsProvider;
import com.indy.map.compute.validator.ILinkValidator;
import com.indy.map.compute.validator.MappingValidator;
import com.indy.map.messages.Messages;
import com.indy.map.ref.RExpression;
import com.indy.map.ref.RLoadSet;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RProblem;
import com.indy.map.ref.RSourceItem;
import com.indy.map.ref.RSourceSet;
import com.indy.map.ref.RTargetSet;
import com.indy.map.ref.RUDFRef;
import com.indy.map.util.ClauseHelper;
import com.indy.map.util.TemplateCapabilityHelper;
import com.indy.map.validation.ClauseConstraint;
import com.indy.map.validation.ProblemValidationStatus;
import com.indy.map.validation.UDFVariableConflictState;
import com.indy.map.validation.parsers.ExpressionParserHelper;
import com.semarchy.xdi.designer.core.IExpressionParser;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.registry.UDF;
import com.stambia.md.MdNode;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ExpressionConstraintSourceVisitor
implements AutoCloseable {
    private static final String UNEXPECTED_ERROR = "unexpected";
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final IRegistryService registryService;
    private final UDFVariableConflictStateWrapper udfConflictWrapper;
    private IMapAPI api;
    private Map mapModel;
    Set<String> srcRefFullPaths = new HashSet<String>();
    boolean isAutoFeed = false;
    Set<String> ambiguousFullPaths = new HashSet<String>();
    Set<String> disabledFieldFullPath = new HashSet<String>();
    Set<String> invalidExtraStaticUsagePath = new HashSet<String>();
    boolean stageToStageOnDifferentConnectionOnSrc = false;
    boolean stageToStageOnDifferentConnectionOnWrk = false;
    Set<String> udfVariableConflictsMessages = new HashSet<String>();
    Set<String> udfMissingImplementationMessages = new HashSet<String>();
    Set<String> udfNotFound = new HashSet<String>();
    boolean mappedByOwnDataSet = false;
    boolean mappedByAncestor = false;
    StringBuilder validationErrorMessage = new StringBuilder();
    boolean errorTransformOnSrc = false;
    boolean warningTransformOnSrc = false;
    boolean errorSourceLocation = false;
    EObject srcFieldslastConnection;
    boolean multipleLoadSetOnSrc = false;
    EObject srcFieldsLoadSet;
    boolean missingTargetSet = false;
    boolean useMultipleConnectionsWhileOnSrc = false;
    boolean hasErrorTransformStagingLocation = false;
    boolean hasWarningTransformCapability = false;
    boolean useSrcSetFieldsOnTrg = false;
    boolean hasErrorIntegrationTplSupportTrgFielgUsage = false;
    boolean usingTrgFieldWhileNotOnTrg = false;
    boolean missingDataType = false;
    boolean warningBecauseNoJoinCapability = false;
    String parsingErrorMessage = null;
    boolean udfUsedOnTrgExpression = false;
    boolean usedFieldsFromTrg = false;

    public ExpressionConstraintSourceVisitor(Map mapModel, IRegistryService registryService) {
        this.registryService = registryService;
        this.udfConflictWrapper = this.createUDFVariableConflictState(mapModel);
        this.api = mapModel.getAPI();
        this.mapModel = mapModel;
    }

    @Override
    public void close() {
        if (this.udfConflictWrapper != null) {
            this.udfConflictWrapper.bundleCtx.ungetService(this.udfConflictWrapper.serviceRef);
        }
    }

    private UDFVariableConflictStateWrapper createUDFVariableConflictState(Map map) {
        try {
            String mappingUniqueId = map.getId() + "_" + map.hashCode();
            BundleContext bundleCtx = Platform.getBundle((String)"com.indy.gmf.map").getBundleContext();
            Collection c = bundleCtx.getServiceReferences(UDFVariableConflictState.class, "(service.pid=" + mappingUniqueId + ")");
            if (c != null && !c.isEmpty()) {
                ServiceReference serviceRef = (ServiceReference)c.iterator().next();
                UDFVariableConflictState varConflictState = (UDFVariableConflictState)bundleCtx.getService(serviceRef);
                return new UDFVariableConflictStateWrapper(varConflictState, bundleCtx, (ServiceReference<UDFVariableConflictState>)serviceRef);
            }
        }
        catch (Exception ex) {
            this.logger.error(UNEXPECTED_ERROR, (Throwable)ex);
        }
        return null;
    }

    private void checkAmbiguousFullpath(MapModelItem it) {
        String fullPath;
        if (it instanceof ILogicalField && (fullPath = ((ILogicalField)((Object)it)).getFullPath()) != null && !this.srcRefFullPaths.add(fullPath.toLowerCase())) {
            this.ambiguousFullPaths.add(fullPath);
        }
    }

    private void checkIsDisabledField(MapModelItem it) {
        if (it instanceof QueryField && !((ILogicalField)((Object)it)).isEnable()) {
            this.disabledFieldFullPath.add(((ILogicalField)((Object)it)).getFullPath());
        }
    }

    private void checkExtraStaticField(MapLocation expressionLocation, MapModelItem src) {
        if (expressionLocation != MapLocation.SRC && src instanceof Field && ((Field)src).isExtraStatic()) {
            boolean supportExtraStatic = false;
            Datastore parentContainer = (Datastore)src.eContainer();
            supportExtraStatic = parentContainer.getAPI().getMdEvaluator().supportExtraStaticFieldUsageOnWrk(parentContainer);
            if (!supportExtraStatic) {
                this.invalidExtraStaticUsagePath.add(((Field)src).getFullPath());
            }
        }
    }

    private void checkDifferentStagingConnection(Expression expression, MapModelItem src) {
        if (!(src instanceof ILogicalField)) {
            return;
        }
        ILogicalField sourceField = (ILogicalField)((Object)src);
        EObject srcStagingArea = ((IContainer)src.eContainer()).getAPI().getMdEvaluator().evaluateConnection((IContainer)sourceField.eContainer(), IMetaDataInformationsProvider.EvaluationLocation.ON_REF);
        EObject trgStagingArea = ((IContainer)expression.eContainer().eContainer()).getAPI().getMdEvaluator().evaluateConnection((IContainer)expression.eContainer().eContainer(), IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING);
        URI srcStagingAreaURI = null;
        if (srcStagingArea != null) {
            srcStagingAreaURI = srcStagingArea.eIsProxy() ? ((InternalEObject)srcStagingArea).eProxyURI() : EcoreUtil.getURI((EObject)srcStagingArea);
        }
        URI trgStagingAreaURI = null;
        if (trgStagingArea != null) {
            URI uRI = trgStagingAreaURI = trgStagingArea.eIsProxy() ? ((InternalEObject)trgStagingArea).eProxyURI() : EcoreUtil.getURI((EObject)trgStagingArea);
        }
        if (expression.eContainer().eContainer() instanceof Query && sourceField.eContainer() instanceof Query && !sourceField.isStageable() && srcStagingAreaURI != null && trgStagingAreaURI != null && !srcStagingAreaURI.equals(trgStagingAreaURI) && (((QueryField)expression.eContainer()).getMdNode() == null || expression.getLocation() != MapLocation.SRC)) {
            this.stageToStageOnDifferentConnectionOnSrc = true;
        }
        if (expression.getLocation() == MapLocation.WRK && srcStagingAreaURI != null && trgStagingAreaURI != null && !srcStagingAreaURI.equals(trgStagingAreaURI) && !sourceField.isStageable()) {
            this.stageToStageOnDifferentConnectionOnWrk = true;
        }
    }

    private void checkUDFUsage(RExpression ref, RSourceItem refSrc) {
        IRegistryService.IRegistry registry;
        Expression exp;
        if (!(refSrc instanceof RUDFRef)) {
            return;
        }
        MapModelItem mapModelItem = ref.getDataModel();
        if (mapModelItem instanceof Expression && (exp = (Expression)mapModelItem).getLocation() == MapLocation.TRG) {
            this.udfUsedOnTrgExpression = true;
        }
        if ((registry = this.registryService.getRegistry(UDF.class)) != null) {
            List udf = registry.find((IRegistryService.IRegistryMatcher)((RUDFRef)refSrc).getIdentifier());
            if (udf == null || udf.isEmpty()) {
                this.udfNotFound.add(((RUDFRef)refSrc).getIdentifier().getFullName());
            } else {
                ref.getContextualProductCode().stream().filter(productCode -> !((UDF)udf.get(0)).supportProduct(productCode)).forEach(productCode -> {
                    boolean bl = this.udfMissingImplementationMessages.add(NLS.bind((String)Messages.ExpressionConstraint_7, (Object)productCode, (Object)((UDF)udf.get(0)).getFunctionFullName()));
                });
                if (this.udfConflictWrapper != null) {
                    try {
                        this.udfConflictWrapper.wrappedState.check((UDF)udf.get(0));
                    }
                    catch (Exception e) {
                        this.udfVariableConflictsMessages.add(e.getMessage());
                    }
                }
            }
        }
    }

    private void validateRelations(MapModelItem srcIt, Expression expr) {
        if (!(srcIt instanceof ILogicalField)) {
            return;
        }
        ILinkValidator.ValidationStatus st = MappingValidator.INSTANCE.canCreateLink(srcIt.eContainer(), expr.eContainer().eContainer());
        if (st.isError()) {
            if (this.validationErrorMessage.length() > 0) {
                this.validationErrorMessage.append("\n");
            }
            this.validationErrorMessage.append("-");
            this.validationErrorMessage.append(st.getMessage());
            if (!this.isAutoFeed && ((IContainer)srcIt.eContainer()).getDataset() == ((IContainer)expr.eContainer().eContainer()).getDataset()) {
                this.isAutoFeed = true;
            }
        }
        if (this.validationErrorMessage.length() > 0) {
            if (this.isAutoFeed) {
                if (expr.getLocation() != MapLocation.TRG) {
                    this.mappedByOwnDataSet = true;
                }
            } else if (srcIt.eContainer() != expr.eContainer().eContainer()) {
                this.mappedByAncestor = true;
            }
        }
    }

    private void checkTransformationCapabilityOnSrc(MapModelItem it, MapLocation location, IExpression.MappingMode mappingMode) {
        if (location != MapLocation.SRC || mappingMode == IExpression.MappingMode.BIJECTIVE || !(it instanceof ILogicalField) || !((ILogicalField)((Object)it)).isStageable()) {
            return;
        }
        if (!this.api.getMdEvaluator().hasTransformOrWorkspaceCapability((IContainer)it.eContainer(), IMetaDataInformationsProvider.EvaluationLocation.ON_REF)) {
            this.errorTransformOnSrc = true;
        } else if (this.api.getMdEvaluator().hasWarningOnTransform((IContainer)it.eContainer(), IMetaDataInformationsProvider.EvaluationLocation.ON_REF)) {
            this.warningTransformOnSrc = true;
        }
    }

    private void checkConnections(MapModelItem it, MapLocation location, IExpression.MappingMode mappingMode) {
        if (location != MapLocation.SRC || IExpression.MappingMode.MULTI_FIELDS != mappingMode || !(it instanceof ILogicalField)) {
            return;
        }
        if (this.srcFieldsLoadSet == null) {
            this.srcFieldsLoadSet = ((RMap)((Map)it.eContainer().eContainer()).getMapReference()).getLoadSet((IContainer)it.eContainer());
        }
        EObject curConn = ((IContainer)it.eContainer()).getAPI().getMdEvaluator().evaluateConnection((IContainer)it.eContainer(), IMetaDataInformationsProvider.EvaluationLocation.ON_REF);
        if (this.srcFieldslastConnection == null) {
            this.srcFieldslastConnection = curConn;
        } else {
            if (!this.errorSourceLocation && curConn != null && !ClauseConstraint.connectionsEquals(curConn, this.srcFieldslastConnection)) {
                this.errorSourceLocation = true;
            }
            if (!this.multipleLoadSetOnSrc && this.srcFieldsLoadSet != null && curConn != null) {
                RLoadSet ls = ((RMap)((Map)it.eContainer().eContainer()).getMapReference()).getLoadSet((IContainer)it.eContainer());
                this.multipleLoadSetOnSrc = ls != this.srcFieldsLoadSet;
            }
        }
    }

    private void checkTargetSetAndConnectionOnSrc(Expression expr) {
        ILogicalField trgField = (ILogicalField)expr.eContainer();
        if (expr.getLocation() != MapLocation.SRC || !((RExpression)expr.getMapReference()).getSourceRef().isEmpty() || !trgField.isMapped()) {
            return;
        }
        boolean trgHasTransformCapability = this.api.getMdEvaluator().hasTransformOrWorkspaceCapability((IContainer)trgField.eContainer(), IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING);
        if (trgHasTransformCapability) {
            return;
        }
        RTargetSet trgSet = ((RMap)((Map)trgField.eContainer().eContainer()).getMapReference()).getTargetSetRef((IContainer)trgField.eContainer());
        if (trgSet == null) {
            this.missingTargetSet = this.missingTargetSet || trgSet == null;
        } else {
            HashSet srcConnectionsId = new HashSet();
            for (DataSet ds : trgSet.getSourceSet().getDataSet()) {
                ds.getContainer().stream().filter(c -> c != expr.eContainer().eContainer()).forEach(c -> {
                    String conId = c.getAPI().getMdEvaluator().evaluateConnectionId((IContainer)c, IMetaDataInformationsProvider.EvaluationLocation.ON_REF);
                    if (conId != null && srcConnectionsId.add(conId) && srcConnectionsId.size() > 1) {
                        this.useMultipleConnectionsWhileOnSrc = true;
                    }
                });
            }
        }
    }

    private void checkTransformCapabilityOnWrk(MapLocation location, IExpression.MappingMode mappingMode, Expression expr) {
        ILogicalField trgField = (ILogicalField)expr.eContainer();
        if (location != MapLocation.WRK || mappingMode == IExpression.MappingMode.BIJECTIVE || !trgField.isStageable() || expr.getExpression() == null || expr.getExpression().isEmpty()) {
            return;
        }
        if (!this.api.getMdEvaluator().hasTransformOrWorkspaceCapability((IContainer)trgField.eContainer(), IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING)) {
            this.hasErrorTransformStagingLocation = true;
        } else if (this.api.getMdEvaluator().hasWarningOnTransform((IContainer)trgField.eContainer(), IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING)) {
            this.hasWarningTransformCapability = true;
        }
    }

    private void checkSrcFromSourcesOnTrg(MapModelItem source, MapLocation location, Expression expr) {
        if (location != MapLocation.TRG || !(source instanceof ILogicalField)) {
            return;
        }
        IContainer expressionContainer = (IContainer)expr.eContainer().eContainer();
        this.useSrcSetFieldsOnTrg = this.useSrcSetFieldsOnTrg || expressionContainer != source.eContainer();
    }

    private void checkIntegrationTemplateSupportsUsingFieldFromTarget(MapModelItem srcIt, MapLocation location, Expression expr) {
        if (location != MapLocation.TRG || !(srcIt instanceof ILogicalField) && srcIt.eContainer() != expr.eContainer().eContainer()) {
            return;
        }
        if (this.hasErrorIntegrationTplSupportTrgFielgUsage) {
            return;
        }
        IContainer c = (IContainer)expr.eContainer().eContainer();
        Template integrationTemplate = this.mapModel.getIntegrationTemplate(c);
        this.hasErrorIntegrationTplSupportTrgFielgUsage = !TemplateCapabilityHelper.supportCapability(integrationTemplate, "template-feature-support", "targetColumnsInMappingExpression", false);
    }

    private void checkSrcItemFromTarget(MapModelItem srcIt, MapLocation location, Expression expr) {
        boolean bl = this.usedFieldsFromTrg = this.usedFieldsFromTrg || srcIt.eContainer() == expr.eContainer().eContainer();
        if (!(srcIt instanceof ILogicalField) || location == MapLocation.TRG) {
            return;
        }
        this.usingTrgFieldWhileNotOnTrg = this.usingTrgFieldWhileNotOnTrg || srcIt.eContainer() == expr.eContainer().eContainer();
    }

    private void checkMissingDataType(Expression expr) {
        ILogicalField trgField = (ILogicalField)expr.eContainer();
        this.missingDataType = this.missingDataType || trgField instanceof QueryField && expr.getLocation().equals((Object)MapLocation.SRC) && !trgField.isStageable();
    }

    private void checkJoinAndWorkspaceCapability(Expression expr) {
        ILogicalField trgField = (ILogicalField)expr.eContainer();
        RExpression refExpr = (RExpression)expr.getMapReference();
        if (refExpr == null || refExpr.getSourceRef().isEmpty() || expr.getAPI().getMdEvaluator().hasWorkspaceCapability((IContainer)trgField.eContainer(), IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING)) {
            return;
        }
        RSourceSet refSS = ((RMap)this.mapModel.getMapReference()).getInputSourceSet((IContainer)trgField.eContainer());
        if (refSS == null) {
            return;
        }
        for (DataSet ds : refSS.getDataSet()) {
            for (Join j : ds.getJoin()) {
                if (j.isInheritance() && j.getLeft() != null && !refSS.getDataSet().contains((Object)j.getLeft().getDataset()) || j.getRight() != null && !refSS.getDataSet().contains((Object)j.getRight().getDataset()) || ClauseHelper.hasRefOnSameConnection(j)) continue;
                this.warningBecauseNoJoinCapability = true;
                return;
            }
        }
    }

    private void checkParsingExpression(Expression expr) {
        if (expr.getExpression() == null || expr.getExpression().trim().isEmpty()) {
            return;
        }
        EObject con = ExpressionParserHelper.getContextConnection(expr);
        if (con instanceof MdNode) {
            try {
                IExpressionParser parser;
                String parserURL = ((MdNode)con).evaluateXpathExpressionCached("INTERNAL_EXPRESSION_PARSER", null);
                if (parserURL != null && (parser = ExpressionParserHelper.createParser(parserURL)) != null) {
                    this.parsingErrorMessage = parser.parse(expr.getExpression(), ExpressionParserHelper.getExpressionOptions());
                }
            }
            catch (Exception ex) {
                throw new ExceptionWrapper(ex);
            }
        }
    }

    public Set<ProblemValidationStatus.ProblemEntry> visit(Expression expr) {
        IExpression.MappingMode mappingMode = expr.getMappingMode();
        for (RSourceItem it : ((RExpression)expr.getMapReference()).getSourceRef()) {
            this.safeRun(() -> this.checkAmbiguousFullpath(it.getDataModel()));
            this.safeRun(() -> this.checkIsDisabledField(it.getDataModel()));
            this.safeRun(() -> this.checkExtraStaticField(expr.getLocation(), it.getDataModel()));
            this.safeRun(() -> this.checkDifferentStagingConnection(expr, it.getDataModel()));
            this.safeRun(() -> this.checkUDFUsage((RExpression)expr.getMapReference(), it));
            this.safeRun(() -> this.validateRelations(it.getDataModel(), expr));
            this.safeRun(() -> this.checkTransformationCapabilityOnSrc(it.getDataModel(), expr.getLocation(), mappingMode));
            this.safeRun(() -> this.checkConnections(it.getDataModel(), expr.getLocation(), mappingMode));
            this.safeRun(() -> this.checkSrcFromSourcesOnTrg(it.getDataModel(), expr.getLocation(), expr));
            this.safeRun(() -> this.checkIntegrationTemplateSupportsUsingFieldFromTarget(it.getDataModel(), expr.getLocation(), expr));
            this.safeRun(() -> this.checkSrcItemFromTarget(it.getDataModel(), expr.getLocation(), expr));
        }
        this.safeRun(() -> this.checkParsingExpression(expr));
        this.safeRun(() -> this.checkJoinAndWorkspaceCapability(expr));
        this.safeRun(() -> this.checkMissingDataType(expr));
        this.safeRun(() -> this.checkTargetSetAndConnectionOnSrc(expr));
        this.safeRun(() -> this.checkTransformCapabilityOnWrk(expr.getLocation(), mappingMode, expr));
        return this.computeProblems();
    }

    private void safeRun(Runnable run) {
        block4: {
            try {
                run.run();
            }
            catch (ExceptionWrapper e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.error(UNEXPECTED_ERROR, (Throwable)e.wrapped);
                }
            }
            catch (AssertionError | Exception | LinkageError e) {
                if (!this.logger.isDebugEnabled()) break block4;
                this.logger.error(UNEXPECTED_ERROR, (Throwable)e);
            }
        }
    }

    private Set<ProblemValidationStatus.ProblemEntry> computeProblems() {
        HashSet<ProblemValidationStatus.ProblemEntry> res = new HashSet<ProblemValidationStatus.ProblemEntry>();
        this.ambiguousFullPaths.stream().map(p -> new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_AMBIGOUS_SRC_REF_FULL_PATH, (String)p)).forEach(res::add);
        this.disabledFieldFullPath.stream().map(p -> new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_USING_DISABLED_FIELD, (String)p)).forEach(res::add);
        this.invalidExtraStaticUsagePath.stream().map(p -> new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_USING_EXTRA_FIELD, (String)p)).forEach(res::add);
        if (this.stageToStageOnDifferentConnectionOnSrc) {
            res.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_STAGING_CONNECTION_DIFFERENT, null));
        }
        if (this.stageToStageOnDifferentConnectionOnWrk) {
            res.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_WORK_LOCATION_STAGING, null));
        }
        this.udfNotFound.stream().map(p -> new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_UDF_NOT_FOUND, (String)p)).forEach(res::add);
        this.udfMissingImplementationMessages.stream().map(p -> new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_UDF_MISSING_PRODUCT_IMPLEMENTATION, (String)p)).forEach(res::add);
        this.udfVariableConflictsMessages.stream().map(p -> new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_VARIABLE_CONFLICT, (String)p)).forEach(res::add);
        if (this.mappedByOwnDataSet) {
            res.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_MAPPING_BY_OWN_DATASET, this.validationErrorMessage.toString()));
        } else if (this.mappedByAncestor) {
            res.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_MAPPING_AND_ANCESTOR_JOIN, this.validationErrorMessage.toString()));
        }
        if (this.errorTransformOnSrc) {
            res.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_TRANSFORM_SOURCE_LOCATION, null));
        } else if (this.warningTransformOnSrc) {
            res.add(new ProblemValidationStatus.ProblemEntry(RProblem.WARNING_TRANSFORM_CAPABILITIES, null));
        }
        if (this.errorSourceLocation) {
            res.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_SOURCE_LOCATION, null));
        }
        if (this.multipleLoadSetOnSrc) {
            res.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_SOURCE_LOCATION_MULTIPLE_LOAD_SET, null));
        }
        if (this.missingTargetSet) {
            res.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_NO_TARGETSET, null));
        }
        if (this.useMultipleConnectionsWhileOnSrc) {
            res.add(new ProblemValidationStatus.ProblemEntry(RProblem.WARNING_SOURCE_LOCATION, null));
        }
        if (this.hasErrorTransformStagingLocation) {
            res.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_TRANSFORM_STAGING_LOCATION, null));
        } else if (this.warningTransformOnSrc || this.hasWarningTransformCapability) {
            res.add(new ProblemValidationStatus.ProblemEntry(RProblem.WARNING_TRANSFORM_CAPABILITIES, null));
        }
        if (this.useSrcSetFieldsOnTrg) {
            res.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_FIELD_TARGET_LOCATION, null));
        }
        if (this.hasErrorIntegrationTplSupportTrgFielgUsage) {
            res.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_TEMPLATE_DOES_NOT_SUPPORT_TARGET_FIELD, null));
        }
        if (this.usingTrgFieldWhileNotOnTrg) {
            res.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_EXPRESSION_NOT_ON_TRG, null));
        }
        if (this.missingDataType) {
            res.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_SOURCE_LOCATION_WITHOUT_DATATYPE, null));
        }
        if (this.warningBecauseNoJoinCapability) {
            res.add(new ProblemValidationStatus.ProblemEntry(RProblem.WARNING_NO_WORKSPACE_CAPABILITY_AND_JOIN, null));
        }
        if (this.parsingErrorMessage != null) {
            res.add(new ProblemValidationStatus.ProblemEntry(RProblem.WARNING_SQL_PARSER_FAILURE, this.parsingErrorMessage));
        }
        if (this.udfUsedOnTrgExpression && this.usedFieldsFromTrg) {
            res.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_EXPRESSION_ON_TRG_USING_UDF_AND_FIELD, null));
        }
        return res;
    }

    private class ExceptionWrapper
    extends RuntimeException {
        final Exception wrapped;

        ExceptionWrapper(Exception ex) {
            this.wrapped = ex;
        }
    }

    private class UDFVariableConflictStateWrapper {
        UDFVariableConflictState wrappedState;
        BundleContext bundleCtx;
        ServiceReference<UDFVariableConflictState> serviceRef;

        public UDFVariableConflictStateWrapper(UDFVariableConflictState wrappedState, BundleContext bundleCtx, ServiceReference<UDFVariableConflictState> serviceRef) {
            this.wrappedState = wrappedState;
            this.bundleCtx = bundleCtx;
            this.serviceRef = serviceRef;
        }
    }
}

