/*
 * Decompiled with CFR 0.152.
 */
package com.indy.cross.ui.editor;

import com.indy.cross.ui.LineageUI;
import com.indy.cross.ui.Messages;
import com.indy.cross.ui.editor.CrossRefEditorInput;
import com.indy.cross.ui.editor.SearchBar;
import com.indy.ui.custom.out.search.AbstractSearchBar;
import com.indy.ui.custom.out.search.OutlineWithSearchBar;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.draw2d.parts.Thumbnail;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class CrossRefEditor
extends EditorPart
implements ITabbedPropertySheetPageContributor {
    public static final String PROPERTY_VIEW_CONTRIBUTOR_ID = "com.indy.cross.ui.editor";
    private LineageUI uiHelper = new LineageUI();
    private CrossRefEditorInput editorInput;
    private CustomOutlinePage outlinePage = null;
    private IPropertySheetPage propertyPage = null;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof CrossRefEditorInput)) {
            throw new PartInitException(Messages.CrossRefEditor_1);
        }
        this.editorInput = (CrossRefEditorInput)input;
        this.setInput(this.editorInput);
        this.setSite((IWorkbenchPartSite)site);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.uiHelper.createContent(parent);
        this.uiHelper.setInput(this.editorInput.getInput());
        this.getSite().setSelectionProvider((ISelectionProvider)this.uiHelper);
    }

    public void setFocus() {
        if (this.uiHelper != null && this.uiHelper.getMainControl() != null && !this.uiHelper.getMainControl().isDisposed()) {
            this.uiHelper.getMainControl().setFocus();
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IContentOutlinePage.class) {
            if (this.outlinePage == null) {
                this.outlinePage = new CustomOutlinePage();
            }
            return this.outlinePage;
        }
        if (adapter == IPropertySheetPage.class) {
            if (this.propertyPage == null) {
                this.propertyPage = new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
            }
            return this.propertyPage;
        }
        return super.getAdapter(adapter);
    }

    public String getContributorId() {
        return PROPERTY_VIEW_CONTRIBUTOR_ID;
    }

    private class BaseOutlinePage
    extends Page
    implements IContentOutlinePage {
        private Canvas overview;
        private Thumbnail thumbnail;

        public void dispose() {
            this.thumbnail.deactivate();
            super.dispose();
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            return null;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void setSelection(ISelection selection) {
        }

        public void createControl(Composite parent) {
            IFigure f;
            this.overview = new Canvas(parent, 0);
            LightweightSystem lws = new LightweightSystem(this.overview);
            IFigure c = f = CrossRefEditor.this.uiHelper.getDraw2DHelper().getRootFigure();
            while (c != null && !(c instanceof Viewport)) {
                c = c.getParent();
            }
            this.thumbnail = new ScrollableThumbnail((Viewport)c);
            this.thumbnail.setSource(f);
            lws.setContents((IFigure)this.thumbnail);
        }

        public Control getControl() {
            return this.overview;
        }

        public void setFocus() {
        }
    }

    private class CustomOutlinePage
    extends OutlineWithSearchBar {
        private Listener refreshlistener;

        CustomOutlinePage() {
            super((AbstractSearchBar)new SearchBar(CrossRefEditor.this.uiHelper));
            this.refreshlistener = new Listener(){

                public void handleEvent(Event event) {
                    CustomOutlinePage.this.getSearchBar().init(CustomOutlinePage.this.getViewerInput());
                }
            };
            CrossRefEditor.this.uiHelper.addRefreshListener(this.refreshlistener);
        }

        public void dispose() {
            CrossRefEditor.this.uiHelper.removeRefreshListener(this.refreshlistener);
            super.dispose();
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            BaseOutlinePage newPage = new BaseOutlinePage();
            this.setCurrentOutline(newPage);
        }

        public Object getViewerInput() {
            return CrossRefEditor.this.uiHelper.getDraw2DHelper().getNodes();
        }
    }
}

