/*
 * Decompiled with CFR 0.152.
 */
package com.indy.cross.ui.editor;

import com.indy.cross.ui.LineageTreeBuilder;
import com.indy.ui.custom.out.CustomResourceItemProviderAdapterFactory;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.registry.LevelCodeInfo;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.stambia.md.provider.MdItemProviderAdapterFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.swt.graphics.Image;

public class CrossRefLabelProvider
extends AdapterFactoryLabelProvider
implements ITableColorProvider {
    private static Image folderImage;
    private static Image projectImage;
    private static Image mappingImage;
    private static Image procImage;
    private static Image mdImage;
    private static URL mdLinkImageURL;

    static {
        try {
            mdLinkImageURL = new URL("platform:plugin/com.indy.md.ui.edit/icons/full/custom/16x16/shortcut16x16.png");
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        try {
            projectImage = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.eclipse.ui.ide/icons/full/obj16/prj_obj.png")).createImage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            folderImage = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.eclipse.ui.ide/icons/full/obj16/folder.png")).createImage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            mappingImage = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.gmf.map.editor/icons/full/obj16/MapModelFile.png")).createImage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            mdImage = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.md.ui.editor/icons/full/obj16/MdModelFile.gif")).createImage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            procImage = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.gmf.process.diagram.non_rcp/icons/obj16/ProcDiagramFile.png")).createImage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CrossRefLabelProvider() {
        super((AdapterFactory)new ComposedAdapterFactory());
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new MdItemProviderAdapterFactory());
        factories.add(new CustomResourceItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        this.setAdapterFactory((AdapterFactory)new ComposedAdapterFactory(factories));
    }

    public String getColumnText(Object object, int columnIndex) {
        return this.getText(object);
    }

    public Image getColumnImage(Object object, int columnIndex) {
        return this.getImage(object);
    }

    public Image getImage(Object object) {
        Object o = object;
        if (object instanceof IStructuredSelection && !((IStructuredSelection)object).isEmpty()) {
            o = ((IStructuredSelection)object).getFirstElement();
        }
        if (object instanceof IProject) {
            return projectImage;
        }
        if (object instanceof IFolder) {
            return folderImage;
        }
        if (object instanceof IFile) {
            if ("map".equals(((IFile)object).getFileExtension())) {
                return mappingImage;
            }
            if ("proc".equals(((IFile)object).getFileExtension())) {
                return procImage;
            }
            if ("md".equals(((IFile)object).getFileExtension())) {
                return mdImage;
            }
        }
        if (o instanceof LineageTreeBuilder.Node) {
            boolean isMdLink = ((LineageTreeBuilder.Node)o).isMdLink();
            String lvlCode = ((LineageTreeBuilder.Node)o).getLevelCode();
            if (lvlCode != null) {
                IRegistryService registryService = (IRegistryService)E4InjectorHelper.getService(IRegistryService.class);
                IRegistryService.IRegistry reg = registryService.getRegistry(LevelCodeInfo.class);
                if (reg != null) {
                    for (LevelCodeInfo i : reg.find((IRegistryService.IRegistryMatcher)new LevelCodeInfo.LevelCodeMatcher(lvlCode))) {
                        if (i.getImageURI() == null) continue;
                        if (isMdLink) {
                            ArrayList<Object> images = new ArrayList<Object>(2);
                            images.add(i.getImageURI());
                            images.add(mdLinkImageURL);
                            return ExtendedImageRegistry.INSTANCE.getImage((Object)new ComposedImage(images));
                        }
                        return ExtendedImageRegistry.INSTANCE.getImage((Object)i.getImageURI());
                    }
                }
            } else {
                o = ((LineageTreeBuilder.Node)o).getFileURI();
            }
        }
        if (o instanceof URI) {
            if ("map".equals(((URI)o).fileExtension())) {
                return mappingImage;
            }
            if ("proc".equals(((URI)o).fileExtension())) {
                return procImage;
            }
            return null;
        }
        if (o instanceof EObject) {
            return super.getImage(o);
        }
        return super.getImage(object);
    }

    public String getText(Object object) {
        Object o = object;
        if (object instanceof IStructuredSelection && !((IStructuredSelection)object).isEmpty()) {
            o = ((IStructuredSelection)object).getFirstElement();
        }
        if (o instanceof IResource) {
            return ((IResource)o).getName();
        }
        if (o instanceof LineageTreeBuilder.Node) {
            return ((LineageTreeBuilder.Node)o).getLabel();
        }
        if (o instanceof URI) {
            return URI.decode((String)((URI)o).trimFragment().lastSegment());
        }
        if (o instanceof EObject) {
            return URI.decode((String)super.getText(o));
        }
        return super.getText(object);
    }
}

