/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.uberbuilder;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class UberJarConfiguration {
    private File engineParametersFile;
    private File moduleFolder;
    private File baseRuntimeFolder;
    private File log4jConfigurationFile;
    private File additionalConfigurationFolder = null;
    private Set<File> deliveriesFile = new HashSet<File>();

    public UberJarConfiguration(File baseRuntimeFolder, File engineParametersFile) {
        this.baseRuntimeFolder = baseRuntimeFolder;
        this.engineParametersFile = engineParametersFile;
        this.setLog4jConfigurationFile(new File(this.baseRuntimeFolder, "properties/log4j2.xml"));
        this.setModuleFolder(new File(this.baseRuntimeFolder, "modules"));
    }

    public UberJarConfiguration addDelivery(File deliveryFile) {
        this.deliveriesFile.add(deliveryFile);
        return this;
    }

    public UberJarConfiguration setModuleFolder(File moduleFolder) {
        this.moduleFolder = moduleFolder;
        return this;
    }

    public UberJarConfiguration setAdditionalConfigurationFolder(File additionalConfigurationFolder) {
        this.additionalConfigurationFolder = additionalConfigurationFolder;
        return this;
    }

    public UberJarConfiguration setLog4jConfigurationFile(File log4jConfigurationFile) {
        this.log4jConfigurationFile = log4jConfigurationFile;
        return this;
    }

    public Collection<File> getDeliveriesFile() {
        return this.deliveriesFile;
    }

    public File getLog4jConfigurationFile() {
        return this.log4jConfigurationFile;
    }

    public File getBaseRuntimeFolder() {
        return this.baseRuntimeFolder;
    }

    public File getEngineParametersFile() {
        return this.engineParametersFile;
    }

    public File getModuleFolder() {
        return this.moduleFolder;
    }

    public File getAdditionalConfigurationFolder() {
        return this.additionalConfigurationFolder;
    }
}

