/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.runtime;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.tooling.runtime.LogHelper;
import org.eclipse.gmf.tooling.runtime.impl.ocl.tracker.activeocl.ActiveOclTrackerFactory;
import org.eclipse.gmf.tooling.runtime.ocl.tracker.OclTrackerFactory;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class GMFToolingRuntimePlugin
extends AbstractUIPlugin {
    public static final String ID = "org.eclipse.gmf.tooling.runtime";
    private static GMFToolingRuntimePlugin ourInstance;
    private Map<OclTrackerFactory.Type, OclTrackerFactory> myOclTrackerFactories;
    private LogHelper myLogHelper;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ourInstance = this;
        this.myOclTrackerFactories = this.loadOclTrackerFactories();
        this.myLogHelper = new LogHelper((Plugin)this);
    }

    public void stop(BundleContext context) throws Exception {
        ourInstance = null;
        super.stop(context);
    }

    public static GMFToolingRuntimePlugin getInstance() {
        return ourInstance;
    }

    public OclTrackerFactory getOclTrackerFactory() {
        OclTrackerFactory result = this.myOclTrackerFactories.get((Object)OclTrackerFactory.Type.ANY);
        if (result == null) {
            result = new ActiveOclTrackerFactory();
            this.myOclTrackerFactories.put(OclTrackerFactory.Type.ANY, result);
        }
        return result;
    }

    public OclTrackerFactory getOclTrackerFactory(OclTrackerFactory.Type type) {
        OclTrackerFactory result = this.myOclTrackerFactories.get((Object)type);
        return result != null ? result : this.getOclTrackerFactory();
    }

    public LogHelper getLogHelper() {
        return this.myLogHelper;
    }

    private Map<OclTrackerFactory.Type, OclTrackerFactory> loadOclTrackerFactories() {
        IConfigurationElement[] points;
        HashMap<OclTrackerFactory.Type, OclTrackerFactory> result = new HashMap<OclTrackerFactory.Type, OclTrackerFactory>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.gmf.tooling.runtime.ocl_tracker_factory");
        IConfigurationElement[] iConfigurationElementArray = points = extensionPoint.getConfigurationElements();
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                IConfigurationElement point = iConfigurationElementArray[n2];
                if ("oclTrackerFactory".equals(point.getName())) {
                    Object impl;
                    try {
                        impl = point.createExecutableExtension("class");
                    }
                    catch (CoreException e) {
                        this.myLogHelper.logStatus(e.getStatus());
                        break block7;
                    }
                    if (impl instanceof OclTrackerFactory) {
                        OclTrackerFactory factory = (OclTrackerFactory)impl;
                        result.put(factory.getImplementationType(), factory);
                        if (Boolean.valueOf(point.getAttribute("default")).booleanValue()) {
                            result.put(OclTrackerFactory.Type.ANY, factory);
                        }
                    }
                }
            }
            ++n2;
        }
        if (!result.containsKey((Object)OclTrackerFactory.Type.DEFAULT_GMFT)) {
            result.put(OclTrackerFactory.Type.DEFAULT_GMFT, new ActiveOclTrackerFactory());
        }
        return result;
    }
}

