/*
 * Decompiled with CFR 0.152.
 */
package com.indy.libraries.management.ui.wizard;

import com.indy.engine.core.module.IModuleService;
import com.indy.libraries.management.ui.wizard.Messages;
import com.indy.libraries.management.ui.wizard.ModuleControler;
import com.indy.libraries.management.ui.wizard.ModuleEditionPage;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.statushandlers.StatusManager;

public class ModuleWizard
extends Wizard {
    private ModuleControler controler;
    private IModuleService.IModule result;

    public ModuleWizard(final Collection<String> baseModuleIdFilter, final IModuleService.IModuleDescriptor desc, final boolean edit, boolean createMode) {
        this.controler = new ModuleControler(edit, createMode, desc){

            @Override
            public List<IModuleService.IBaseModule> getBaseModules() {
                List<IModuleService.IBaseModule> l = super.getBaseModules();
                Iterator<IModuleService.IBaseModule> it = l.iterator();
                while (it.hasNext()) {
                    IModuleService.IBaseModule m = it.next();
                    if (edit && desc != null) {
                        if (m.getInfo().getId().equals(desc.getBaseModuleInfo().getId())) continue;
                        it.remove();
                        continue;
                    }
                    if (baseModuleIdFilter == null || baseModuleIdFilter.contains(m.getInfo().getId())) continue;
                    it.remove();
                }
                return l;
            }

            @Override
            public List<IModuleService.IModuleDescriptor> getModules4Selection() {
                if (edit && desc != null) {
                    return Collections.singletonList(desc);
                }
                return super.getModules4Selection();
            }
        };
    }

    public void addPages() {
        ModuleEditionPage page = new ModuleEditionPage(this.controler, "primary");
        this.addPage((IWizardPage)page);
    }

    public boolean canFinish() {
        IWizardPage cur;
        IWizardContainer c = this.getContainer();
        if (c != null && (cur = c.getCurrentPage()) != null) {
            return cur.isPageComplete() && !cur.canFlipToNextPage() && !this.controler.isLibRequiredState();
        }
        return false;
    }

    public boolean performFinish() {
        try {
            this.result = this.controler.createOrUpdate();
            return this.result != null;
        }
        catch (Exception ex) {
            Status status = new Status(4, "com.indy.libraries.management.ui", Messages.ModuleWizard_1, ex.getCause());
            StatusManager.getManager().handle((IStatus)status, 5);
            return false;
        }
    }

    public IModuleService.IModule getResult() {
        return this.result;
    }

    public void setBaseModule(IModuleService.IBaseModule baseModule) {
        this.controler.setSelectedBaseModule(baseModule);
    }
}

