/*
 * Decompiled with CFR 0.152.
 */
package com.indy.libraries.management.ui.wizard;

import java.util.List;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class NiceList {
    private Font primaryFont;
    private Font secondaryFont;
    private TextProvider textProvider;
    private TableViewer viewer;

    public NiceList(TextProvider p) {
        this.textProvider = p;
    }

    public Control createControl(Composite parent, int type) {
        Table table = new Table(parent, type);
        table.setLinesVisible(true);
        FontDescriptor pDesc = FontDescriptor.createFrom((Font)parent.getFont()).setStyle(1);
        FontDescriptor sDesc = FontDescriptor.createFrom((Font)parent.getFont()).setStyle(2);
        this.primaryFont = pDesc.createFont((Device)parent.getDisplay());
        this.secondaryFont = sDesc.createFont((Device)parent.getDisplay());
        Listener paintListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 41: {
                        TableItem item = (TableItem)event.item;
                        event.gc.setFont(NiceList.this.primaryFont);
                        String text = NiceList.this.textProvider.getMainText(item.getData());
                        Point size = event.gc.textExtent(text);
                        event.width = size.x;
                        event.height = Math.max(event.height, size.y * 2);
                        event.gc.setFont(NiceList.this.secondaryFont);
                        text = NiceList.this.textProvider.getSecondaryText(item.getData());
                        size = event.gc.textExtent(text);
                        event.width = Math.max(size.x, event.width);
                        Image icon = NiceList.this.textProvider.getIcon(item.getData());
                        if (icon == null) break;
                        event.width += 18;
                        break;
                    }
                    case 42: {
                        TableItem item = (TableItem)event.item;
                        String text = NiceList.this.textProvider.getMainText(item.getData());
                        event.gc.setFont(NiceList.this.primaryFont);
                        Point size = event.gc.textExtent(text);
                        int offset2 = 0;
                        int iconOffSet = 0;
                        Image icon = NiceList.this.textProvider.getIcon(item.getData());
                        if (icon != null) {
                            iconOffSet = 20;
                            event.gc.drawImage(icon, event.x, event.y + offset2);
                        }
                        event.gc.setForeground(NiceList.this.textProvider.getColor(item.getData()));
                        event.gc.drawText(text, iconOffSet + event.x, event.y + offset2, true);
                        text = NiceList.this.textProvider.getSecondaryText(item.getData());
                        event.gc.setFont(NiceList.this.secondaryFont);
                        size = event.gc.textExtent(text);
                        event.gc.drawText(text, iconOffSet + event.x, event.y + offset2 + size.y, true);
                        break;
                    }
                    case 40: {
                        event.detail &= 0xFFFFFFEF;
                    }
                }
            }
        };
        table.addListener(41, paintListener);
        table.addListener(42, paintListener);
        table.addListener(40, paintListener);
        this.viewer = new TableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String s1 = NiceList.this.textProvider.getMainText(element);
                String s2 = NiceList.this.textProvider.getSecondaryText(element);
                if (s2 != null) {
                    if (s1.length() > s2.length()) {
                        return s1;
                    }
                    return s2;
                }
                return s1;
            }

            public String getToolTipText(Object element) {
                return NiceList.this.textProvider.getTooltip(element);
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                NiceList.this.primaryFont.dispose();
                NiceList.this.secondaryFont.dispose();
            }
        });
        return table;
    }

    public void setInput(List input) {
        this.viewer.setInput((Object)input);
        if (!input.isEmpty()) {
            this.viewer.setSelection((ISelection)new StructuredSelection(input.get(0)));
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.viewer.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.viewer.removeSelectionChangedListener(listener);
    }

    public void setSelection(Object select) {
        if (select != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection(select));
        }
    }

    public IStructuredSelection getSelection() {
        return this.viewer.getStructuredSelection();
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public static interface TextProvider {
        public String getMainText(Object var1);

        public String getSecondaryText(Object var1);

        public Color getColor(Object var1);

        public Image getIcon(Object var1);

        public String getTooltip(Object var1);
    }
}

