/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.text.editor.views;

import com.indy.ui.custom.out.CustomSelectionListener;
import com.indy.ui.custom.out.INoPropertySheetProvider;
import com.indy.ui.custom.out.IndyEventManager;
import com.indy.ui.custom.out.StyledTextLocationManager;
import com.indy.ui.custom.out.Util;
import com.indy.ui.custom.out.action.editor.TextViewerSupport;
import com.indy.ui.custom.out.common.TextViewerPositionBackup;
import com.indy.ui.custom.out.emf.IResourceLocker;
import com.indy.ui.custom.out.emf.SharingReadOnlyEditingDomainFactory;
import com.indy.ui.custom.out.services.IDropValidationService;
import com.indy.ui.custom.out.udf.ui.ViewUDFRegistryAction;
import com.indy.ui.text.editor.Activator;
import com.indy.ui.text.editor.Messages;
import com.indy.ui.text.editor.views.parsing.PartitionerProvider;
import com.indy.ui.text.editor.views.parsing.XPathViewerConfiguration;
import com.semarchy.xdi.designer.core.CodeCapability;
import com.semarchy.xdi.designer.core.models.IExpressionEditorCompliant;
import com.semarchy.xdi.designer.core.models.ISettableValueCommand;
import com.semarchy.xdi.designer.core.services.IGenerationService;
import com.semarchy.xdi.designer.core.services.IXPathEvaluationService;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.ParameterBuilder;
import com.stambia.md.MdNode;
import com.stambia.md.util.XPathExpressionHelper;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension6;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.IUndoManagerExtension;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CommandNotMappedException;
import org.eclipse.ui.actions.ContributedAction;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.operations.OperationHistoryActionHandler;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.ConfigurationElementSorter;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.IReadOnlyDependent;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextOperationAction;

public class TextView
extends ViewPart
implements INoPropertySheetProvider,
IPartListener {
    private Map<URI, String> mdNodeExpressionsBackup = Collections.synchronizedMap(new LinkedHashMap(50));
    private SourceViewer fSourceViewer;
    private IDocument doc;
    private ActivationCodeTrigger fActivationCodeTrigger;
    private Map fActions = new HashMap(10);
    private IAction action1;
    private IAction nativeEvalAction;
    private IAction evalAction;
    private SourceViewerConfiguration sourceViewerConfiguration;
    private WeakReference<EObject> eObject;
    private EStructuralFeature eStructuralFeature;
    private Composite parent;
    private WeakReference<IWorkbenchPart> ep;
    private CustomSelectionListener customSelectionListener;
    private IDocumentListener documentListener;
    private Action action2;
    private ViewUDFRegistryAction showUdfAction;
    private CodeStyleAction highlightSyntaxAction;
    private TextViewerPositionBackup positionBackup = new TextViewerPositionBackup(){

        protected String getKey(Object obj) {
            if (!(obj instanceof EObject)) {
                return null;
            }
            EObject e = (EObject)obj;
            String fileID = CacheHelper.extractEltID((EObject)e);
            String eltID = CacheHelper.extractEltID((EObject)e);
            return fileID + "/" + eltID;
        }
    };
    private FindReplaceAction findAction;
    private boolean dropedLastSelection = false;
    private boolean updatingFeature = false;
    private StyledTextLocationManager viewerLocationHelper = new StyledTextLocationManager();
    private Adapter featureAdapter = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (!TextView.this.locked && !TextView.this.updatingFeature && TextView.this.codeCapability != null && msg.getEventType() == 1 && msg.getFeature() != null && msg.getFeature().equals(TextView.this.codeCapability.getEStructuralFeature())) {
                Point pt = TextView.this.fSourceViewer.getTextWidget().getSelection();
                TextView.this.selectionChanged();
                int index = -1;
                index = pt.x < TextView.this.fSourceViewer.getTextWidget().getText().length() ? pt.x : TextView.this.fSourceViewer.getTextWidget().getText().length() - 1;
                if (index == -1) {
                    index = 0;
                }
                try {
                    String s = TextView.this.fSourceViewer.getTextWidget().getText(index, index);
                    if (s.equals("\n")) {
                        --index;
                    }
                    TextView.this.fSourceViewer.getTextWidget().setSelection(index);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    };
    private boolean locked = false;
    private FindHandler findAndReplaceHandler;
    private IHandlerActivation findActivation;
    IResourceLocker.IResourceLockerListener lockListener = new IResourceLocker.IResourceLockerListener(){

        private boolean isUriMatchEditedEObject(URI resourceURI) {
            Resource r;
            EObject eObject;
            EObject eObject2 = eObject = TextView.this.eObject == null ? null : (EObject)TextView.this.eObject.get();
            return eObject != null && (r = eObject.eResource()) != null && r.getURI().equals(resourceURI);
        }

        public void handleLockReleased(URI resourceURI, String editingDomainId) {
            if (TextView.this.fSourceViewer == null || TextView.this.fSourceViewer.getTextWidget() == null || TextView.this.fSourceViewer.getTextWidget().isDisposed()) {
                return;
            }
            if ("proc".equals(resourceURI.fileExtension()) && this.isUriMatchEditedEObject(resourceURI)) {
                EObject eObject;
                EObject eObject2 = eObject = TextView.this.eObject == null ? null : (EObject)TextView.this.eObject.get();
                if (eObject == null || eObject.eResource() == null) {
                    return;
                }
                TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)eObject);
                if (editingDomain != null && editingDomain.getID().equals(editingDomainId)) {
                    TextView.this.fSourceViewer.setEditable(false);
                    TextView.this.fSourceViewer.getTextWidget().setBackground(Display.getDefault().getSystemColor(22));
                }
            }
        }

        public void handleLockAcquired(URI resourceURI, String editingDomainId) {
            if (TextView.this.fSourceViewer == null || TextView.this.fSourceViewer.getTextWidget() == null || TextView.this.fSourceViewer.getTextWidget().isDisposed()) {
                return;
            }
            if ("proc".equals(resourceURI.fileExtension()) && this.isUriMatchEditedEObject(resourceURI)) {
                EObject eObject;
                EObject eObject2 = eObject = TextView.this.eObject == null ? null : (EObject)TextView.this.eObject.get();
                if (eObject == null || eObject.eResource() == null) {
                    return;
                }
                TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)eObject);
                if (editingDomain != null && editingDomain.getID() != null && editingDomain.getID().equals(editingDomainId)) {
                    TextView.this.fSourceViewer.setEditable(true);
                    TextView.this.fSourceViewer.getTextWidget().setBackground(null);
                }
            }
        }
    };
    private Highlighter highlighter = new Highlighter();
    private static final String CURRENT_LINE = "currentLine";
    private static final String CURRENT_LINE_COLOR = "currentLineColor";
    IndyEventManager.IndyEventListener iel = new IndyEventManager.IndyEventListener(){

        public void notify(Object event) {
            TextView.this.addTextInCurrentSelection((String)event, null);
        }
    };
    private boolean adpatToCommand = false;
    private IWorkbenchPart editorPart;
    private WeakReference<EObject> missEObject;
    private CodeCapability codeCapability;
    Timer timer = null;
    private TimerManager timerManager = new TimerManager();
    private static final String TAG_CONTRIBUTION_TYPE = "editorContribution";
    private WeakReference<TransactionalEditingDomain> currenEditingDomain = new WeakReference<Object>(null);

    public TextView() {
        SharingReadOnlyEditingDomainFactory.getInstance().addListener(this.lockListener);
    }

    public void createPartControl(Composite parent) {
        this.setTitleToolTip(this.getTitle());
        this.parent = parent;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.indy.ui.help.redirects/designer/expression-view");
        Composite main = new Composite(parent, 2048);
        main.setLayout((Layout)new FillLayout());
        this.parent = main;
        CompositeRuler ruler = new CompositeRuler();
        ruler.addDecorator(0, (IVerticalRulerColumn)new AnnotationRulerColumn(0));
        DefaultMarkerAnnotationAccess access = new DefaultMarkerAnnotationAccess();
        OverviewRuler overviewRuler = new OverviewRuler((IAnnotationAccess)access, 12, EditorsPlugin.getDefault().getSharedTextColors());
        LineNumberRulerColumn lineNumberRuler = new LineNumberRulerColumn();
        lineNumberRuler.setForeground(Display.getCurrent().getSystemColor(15));
        ruler.addDecorator(1, (IVerticalRulerColumn)lineNumberRuler);
        this.fSourceViewer = new SourceViewer(main, (IVerticalRuler)ruler, (IOverviewRuler)overviewRuler, true, 2818);
        this.fSourceViewer.getControl().setEnabled(false);
        this.fSourceViewer.getTextWidget().setBackground(Display.getDefault().getSystemColor(22));
        SourceViewerDecorationSupport fSourceViewerDecorationSupport = new SourceViewerDecorationSupport((ISourceViewer)this.fSourceViewer, (IOverviewRuler)overviewRuler, (IAnnotationAccess)access, EditorsPlugin.getDefault().getSharedTextColors());
        ArrayList l = new ArrayList(EditorsPlugin.getDefault().getMarkerAnnotationPreferences().getAnnotationPreferences());
        for (Object o : l) {
            if (!(o instanceof AnnotationPreference)) continue;
            AnnotationPreference an = (AnnotationPreference)o;
            fSourceViewerDecorationSupport.setAnnotationPreference(an);
            if (!an.contributesToHeader()) continue;
            overviewRuler.addHeaderAnnotationType(an.getAnnotationType());
        }
        fSourceViewerDecorationSupport.setCursorLinePainterPreferenceKeys(CURRENT_LINE, CURRENT_LINE_COLOR);
        fSourceViewerDecorationSupport.setCharacterPairMatcher((ICharacterPairMatcher)new DefaultCharacterPairMatcher(new char[]{'\'', '\'', '(', ')', '{', '}', '[', ']', '<', '>', '\"', '\"'}));
        fSourceViewerDecorationSupport.setMatchingCharacterPainterPreferenceKeys("matchingTagHighlight", "matchingTagIndicationColor");
        fSourceViewerDecorationSupport.setMatchingCharacterPainterPreferenceKeys("matchingTagHighlight", "matchingTagIndicationColor", "matchingTagHighlight", "matchingTagHighlight");
        fSourceViewerDecorationSupport.install(EditorsPlugin.getDefault().getPreferenceStore());
        this.doc = new Document();
        this.doc.set("");
        this.fSourceViewer.setDocument(this.doc, (IAnnotationModel)new AnnotationModel());
        this.fSourceViewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                if (TextView.this.findAction != null) {
                    TextView.this.findAction.update();
                }
            }
        });
        DefaultMarkerAnnotationAccess fAnnotationAccess = new DefaultMarkerAnnotationAccess();
        AnnotationPainter ap = new AnnotationPainter((ISourceViewer)this.fSourceViewer, (IAnnotationAccess)fAnnotationAccess);
        ap.addAnnotationType((Object)"ERROR_TYPE");
        ap.setAnnotationTypeColor((Object)"ERROR_TYPE", Display.getDefault().getSystemColor(3));
        this.fSourceViewer.addPainter((IPainter)ap);
        this.fSourceViewer.getTextWidget().addPaintListener((PaintListener)this.highlighter);
        this.fSourceViewer.getTextWidget().addMouseMoveListener((MouseMoveListener)this.highlighter);
        TextViewerSupport support = new TextViewerSupport((TextViewer)this.fSourceViewer, new MenuManager());
        Font font = new Font((Device)parent.getDisplay(), new FontData("Courier New", 10, 0));
        this.fSourceViewer.getTextWidget().setFont(font);
        StyledText control = this.fSourceViewer.getTextWidget();
        Transfer[] transferTypes = new Transfer[]{TextTransfer.getInstance()};
        ViewerDropAdapter vda = new ViewerDropAdapter((Viewer)this.fSourceViewer){
            Point selection;
            Pattern p;
            {
                this.p = Pattern.compile("\\[(.*?)\\]");
            }

            public void dropAccept(DropTargetEvent event) {
                super.dropAccept(event);
                this.selection = TextView.this.fSourceViewer.getTextWidget().getSelection();
            }

            public boolean performDrop(Object data) {
                boolean res;
                StringBuffer buf = new StringBuffer();
                int lastIndex = 0;
                Matcher m = this.p.matcher((String)data);
                while (m.find()) {
                    buf.append(((String)data).substring(lastIndex, m.start()));
                    lastIndex = m.end();
                }
                if (buf.length() == 0) {
                    buf.append((String)data);
                }
                TextView.this.dropedLastSelection = res = TextView.this.addTextInCurrentSelection(buf.toString(), this.selection);
                return res;
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                return TextTransfer.getInstance().isSupportedType(transferType);
            }

            public void drop(DropTargetEvent event) {
                IDropValidationService service = (IDropValidationService)PlatformUI.getWorkbench().getService(IDropValidationService.class);
                if (service != null) {
                    String str = (String)TextTransfer.getInstance().nativeToJava(event.currentDataType);
                    Matcher m = this.p.matcher(str);
                    while (m.find()) {
                        EObject o;
                        String s = m.group();
                        s = s.substring(1, s.length() - 1);
                        EObject eObject = TextView.this.eObject == null ? null : (EObject)TextView.this.eObject.get();
                        EObject eObject2 = o = eObject == null ? null : eObject.eResource().getEObject(s);
                        if (o != null && service.validate(o, eObject, false) != IDropValidationService.DropResult.NONE) continue;
                        return;
                    }
                }
                super.drop(event);
            }
        };
        DropTarget dropTarget = new DropTarget((Control)control, 7);
        dropTarget.setTransfer(transferTypes);
        dropTarget.addDropListener((DropTargetListener)vda);
        this.createActions();
        this.installServiceListener();
        this.installAddTextListener();
        this.hookContextMenu();
        this.contributeToActionBars();
        this.viewerLocationHelper.enable(this.fSourceViewer.getTextWidget());
        this.fSourceViewer.getTextWidget().addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.detail == 16) {
                    if (TextView.this.fSourceViewer.canDoOperation(8)) {
                        TextView.this.fSourceViewer.doOperation(8);
                    }
                    event.doit = false;
                } else if (event.detail == 8) {
                    if (TextView.this.fSourceViewer.canDoOperation(9)) {
                        TextView.this.fSourceViewer.doOperation(9);
                    }
                    event.doit = false;
                }
            }
        });
        this.fSourceViewer.prependVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent verifyEvent) {
                if (verifyEvent.keyCode == 9 && TextView.this.fSourceViewer.getSelectedRange().y > 0) {
                    verifyEvent.doit = false;
                }
            }
        });
    }

    protected void setSite(IWorkbenchPartSite site) {
        super.setSite(site);
        this.getSite().getPage().addPartListener((IPartListener)this);
    }

    private void installAddTextListener() {
        IndyEventManager.INSTANCE.addListener("AddTextListener", this.iel);
    }

    private boolean addTextInCurrentSelection(String text, Point location) {
        StyledText ctrl = this.fSourceViewer.getTextWidget();
        Point _selection = this.fSourceViewer.getTextWidget().getSelection();
        if (location != null && _selection.x >= location.x && _selection.y <= location.y) {
            _selection = location;
        }
        if (_selection.x > ctrl.getSize().x) {
            return false;
        }
        try {
            this.installDocumentListener();
            this.fSourceViewer.getDocument().replace(_selection.x, _selection.y - _selection.x, text);
            this.removeDocumentListener();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        ctrl.setFocus();
        ctrl.setSelection(_selection.x + text.length());
        return true;
    }

    private void selectionChanged() {
        EObject eObject;
        EObject eObject2 = eObject = this.eObject == null ? null : (EObject)this.eObject.get();
        if (eObject != null && this.codeCapability != null && this.codeCapability != null) {
            this.timerManager.join();
            this.eStructuralFeature = this.codeCapability.getEStructuralFeature();
            String txt = null;
            boolean selectionAll = false;
            if (this.eStructuralFeature != null) {
                try {
                    txt = (String)eObject.eGet(this.eStructuralFeature);
                    this.adpatToCommand = false;
                }
                catch (ClassCastException ex) {
                    this.adpatToCommand = true;
                }
            } else {
                this.adpatToCommand = false;
                String s = this.mdNodeExpressionsBackup.get(EcoreUtil.getURI((EObject)eObject));
                if (s == null) {
                    txt = "*";
                    selectionAll = true;
                } else {
                    txt = s;
                }
            }
            if (txt == null) {
                txt = "";
            }
            this.fSourceViewer.unconfigure();
            this.doc.set(txt);
            this.sourceViewerConfiguration = new XPathViewerConfiguration(this.codeCapability, this.highlightSyntaxAction.isChecked());
            IDocumentPartitioner partioner = PartitionerProvider.createPartitioner();
            this.doc.setDocumentPartitioner(partioner);
            if (partioner != null) {
                partioner.connect(this.doc);
            }
            this.highlighter.clear();
            if (this.fSourceViewer.getDocument() == null || this.fSourceViewer.getDocument() != this.doc) {
                this.fSourceViewer.setDocument(this.doc, (IAnnotationModel)new AnnotationModel());
            }
            this.fSourceViewer.configure(this.sourceViewerConfiguration);
            this.ep = new WeakReference<IEditorPart>(Workbench.getInstance().getActiveWorkbenchWindow().getActivePage().getActiveEditor());
            this.createUndoRedoActions();
            if (this.adpatToCommand) {
                this.fSourceViewer.getControl().setEnabled(Platform.getAdapterManager().getAdapter(this.eObject.get(), ISettableValueCommand.class) != null);
            } else {
                this.fSourceViewer.getControl().setEnabled(true);
            }
            this.fSourceViewer.getTextWidget().setBackground(null);
            this.fSourceViewer.getTextWidget().setSelection(0);
            if (selectionAll) {
                this.fSourceViewer.setSelectedRange(0, txt.length());
            }
            this.sourceViewerConfiguration.getUndoManager((ISourceViewer)this.fSourceViewer).connect((ITextViewer)this.fSourceViewer);
            this.findAction.update();
            this.viewerLocationHelper.setContext((Object)eObject);
            ISelection s = this.positionBackup.getPosition((Object)eObject);
            if (s != null) {
                this.fSourceViewer.setSelection(s);
            }
            return;
        }
        this.fSourceViewer.unconfigure();
        this.highlighter.clear();
        this.fSourceViewer.setDocument((IDocument)new Document(), (IAnnotationModel)new AnnotationModel());
        this.sourceViewerConfiguration = new SourceViewerConfiguration(){

            public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
                return null;
            }

            public IHyperlinkPresenter getHyperlinkPresenter(ISourceViewer sourceViewer) {
                return null;
            }
        };
        this.fSourceViewer.configure(this.sourceViewerConfiguration);
        if (!this.fSourceViewer.getControl().isDisposed()) {
            this.fSourceViewer.getControl().setEnabled(false);
            this.fSourceViewer.getTextWidget().setBackground(Display.getDefault().getSystemColor(22));
        }
        this.setTextIsLocked(false);
        this.findAction.update();
    }

    private void installServiceListener() {
        ISelectionService service = (ISelectionService)this.getSite().getService(ISelectionService.class);
        this.customSelectionListener = new CustomSelectionListener(){
            private IWorkbenchPart precEditorPart;

            public void partClosed(IWorkbenchPart part) {
                super.partClosed(part);
                if (TextView.this.ep != null && part == TextView.this.ep.get()) {
                    TextView.this.ep = new WeakReference<Object>(null);
                }
            }

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (!(part instanceof IEditorPart) && !"org.eclipse.ui.navigator.ProjectExplorer".equals(part.getSite().getId())) {
                    return;
                }
                EObject oldObj = this.getEObject();
                if (oldObj != null && TextView.this.fSourceViewer != null && !TextView.this.fSourceViewer.getControl().isDisposed()) {
                    TextView.this.positionBackup.setPosition((Object)oldObj, TextView.this.fSourceViewer.getSelection());
                }
                super.selectionChanged(part, selection);
                if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() > 1) {
                    this.eObject = null;
                    this.handleSelectionChanged();
                } else if (selection.isEmpty()) {
                    this.eObject = null;
                    this.handleSelectionChanged();
                }
            }

            public void handleSelectionChanged() {
                IWorkbenchPart part = this.getPart();
                if (part != this.precEditorPart) {
                    Util.isTextEditorLocked = false;
                    TextView.this.action2.setChecked(false);
                }
                if (!Util.isTextEditorLocked && Util.currentKeyPressed != 65536) {
                    TextView.this.setEObject(this.getEObject());
                    TextView.this.editorPart = this.getPart();
                    TextView.this.selectionChanged();
                } else if (TextView.this.editorPart == this.getPart()) {
                    TextView.this.missEObject = new WeakReference<EObject>(this.getEObject());
                    TextView.this.dropedLastSelection = false;
                }
                boolean isEditable = true;
                if (TextView.this.editorPart instanceof IDiagramWorkbenchPart) {
                    boolean bl = isEditable = ((IDiagramWorkbenchPart)TextView.this.editorPart).getDiagramEditPart() != null && ((IDiagramWorkbenchPart)TextView.this.editorPart).getDiagramEditPart().isEditModeEnabled();
                }
                if (TextView.this.codeCapability != null) {
                    isEditable = isEditable && TextView.this.codeCapability.isEditable();
                }
                TextView.this.fSourceViewer.setEditable((part instanceof IEditorPart || this.eObject != null && this.eObject.get() instanceof MdNode) && isEditable);
                if (TextView.this.fSourceViewer.isEditable()) {
                    TextView.this.fSourceViewer.getTextWidget().setBackground(null);
                } else {
                    TextView.this.fSourceViewer.getTextWidget().setBackground(Display.getDefault().getSystemColor(22));
                }
                this.precEditorPart = part;
            }

            protected void releasSpecializedResources(IWorkbenchPart part) {
                if (part == this.precEditorPart || part == TextView.this.editorPart) {
                    this.precEditorPart = null;
                    TextView.this.missEObject = null;
                    TextView.this.dropedLastSelection = false;
                    TextView.this.editorPart = null;
                    TextView.this.setEObject(null);
                    TextView.this.selectionChanged();
                }
            }
        };
        this.customSelectionListener.setListenFile(false);
        this.customSelectionListener.setService(service);
        service.addSelectionListener((ISelectionListener)this.customSelectionListener);
    }

    public void dispose() {
        this.positionBackup.dispose();
        this.viewerLocationHelper.dispose();
        this.currenEditingDomain = null;
        if (this.featureAdapter != null && this.featureAdapter.getTarget() != null) {
            this.featureAdapter.getTarget().eAdapters().remove((Object)this.featureAdapter);
        }
        this.getSite().getPage().removePartListener((IPartListener)this);
        SharingReadOnlyEditingDomainFactory.getInstance().removeListener(this.lockListener);
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        handlerService.deactivateHandler(this.findActivation);
        this.removeSelectionListener();
        this.removeDocumentListener();
        this.removeAddTextListener();
        super.dispose();
    }

    private void removeDocumentListener() {
        if (this.documentListener != null) {
            this.doc.removeDocumentListener(this.documentListener);
        }
        if (this.timerManager != null) {
            Display.getCurrent().syncExec(new Runnable(){

                @Override
                public void run() {
                    TextView.this.timerManager.join();
                }
            });
        }
    }

    private void removeAddTextListener() {
        IndyEventManager.INSTANCE.removeListener("AddTextListener", this.iel);
    }

    private void removeSelectionListener() {
        ISelectionService service = (ISelectionService)this.getSite().getService(ISelectionService.class);
        service.removeSelectionListener((ISelectionListener)this.customSelectionListener);
    }

    private IUndoContext getUndoContext() {
        IUndoManager undoManager;
        CommandStack stack;
        TransactionalEditingDomain domain;
        EObject obj;
        if (this.eObject != null && (obj = (EObject)this.eObject.get()) != null && (domain = TransactionUtil.getEditingDomain((EObject)obj)) != null && (stack = domain.getCommandStack()) instanceof IWorkspaceCommandStack) {
            return ((IWorkspaceCommandStack)stack).getDefaultUndoContext();
        }
        if (this.fSourceViewer instanceof ITextViewerExtension6 && (undoManager = this.fSourceViewer.getUndoManager()) instanceof IUndoManagerExtension) {
            return ((IUndoManagerExtension)undoManager).getUndoContext();
        }
        return null;
    }

    private void registerUndoRedoAction(String actionId, OperationHistoryActionHandler action) {
        IAction oldAction = this.getAction(actionId);
        if (oldAction instanceof OperationHistoryActionHandler) {
            ((OperationHistoryActionHandler)oldAction).dispose();
        }
        this.setAction(actionId, (IAction)action);
        IActionBars actionBars = null;
        if (this.getEditorSite() instanceof IEditorSite) {
            actionBars = ((IEditorSite)this.getEditorSite()).getActionBars();
        }
        if (actionBars != null) {
            actionBars.setGlobalActionHandler(actionId, (IAction)action);
        }
    }

    protected IWorkbenchSite getEditorSite() {
        IWorkbenchPart ep;
        IWorkbenchPart iWorkbenchPart = ep = this.ep == null ? null : (IWorkbenchPart)this.ep.get();
        if (ep != null) {
            return ep.getSite();
        }
        return null;
    }

    protected void createUndoRedoActions() {
        IUndoContext undoContext = this.getUndoContext();
        if (undoContext != null) {
            UndoActionHandler undoAction = new UndoActionHandler(this.getSite(), undoContext);
            undoAction.setActionDefinitionId("org.eclipse.ui.edit.undo");
            this.setAction(ITextEditorActionConstants.UNDO, (IAction)undoAction);
            RedoActionHandler redoAction = new RedoActionHandler(this.getSite(), undoContext);
            redoAction.setActionDefinitionId("org.eclipse.ui.edit.redo");
            this.setAction(ITextEditorActionConstants.REDO, (IAction)redoAction);
        } else {
            TextOperationAction action;
            ResourceBundle rb;
            String BUNDLE_FOR_CONSTRUCTED_KEYS;
            if (this.getAction(ITextEditorActionConstants.UNDO) == null) {
                BUNDLE_FOR_CONSTRUCTED_KEYS = "org.eclipse.ui.texteditor.ConstructedEditorMessages";
                rb = ResourceBundle.getBundle(BUNDLE_FOR_CONSTRUCTED_KEYS);
                action = new TextOperationAction(rb, "Editor.Undo.", (ITextEditor)new TextEditor(), 1);
                action.setHelpContextId(IAbstractTextEditorHelpContextIds.UNDO_ACTION);
                action.setActionDefinitionId("org.eclipse.ui.edit.undo");
                this.setAction(ITextEditorActionConstants.UNDO, (IAction)action);
            }
            if (this.getAction(ITextEditorActionConstants.REDO) == null) {
                BUNDLE_FOR_CONSTRUCTED_KEYS = "org.eclipse.ui.texteditor.ConstructedEditorMessages";
                rb = ResourceBundle.getBundle(BUNDLE_FOR_CONSTRUCTED_KEYS);
                action = new TextOperationAction(rb, "Editor.Redo.", (ITextEditor)new TextEditor(), 2);
                action.setHelpContextId(IAbstractTextEditorHelpContextIds.REDO_ACTION);
                action.setActionDefinitionId("org.eclipse.ui.edit.redo");
                this.setAction(ITextEditorActionConstants.REDO, (IAction)action);
            }
        }
    }

    private void installDocumentListener() {
        if (this.documentListener == null) {
            this.documentListener = new IDocumentListener(){

                public void documentAboutToBeChanged(DocumentEvent event) {
                }

                public void documentChanged(DocumentEvent event) {
                    if (TextView.this.timer != null) {
                        TextView.this.timer.cancel();
                        Iterator<UpdateObjectRunnable> it = TextView.this.timerManager.createdTasks.iterator();
                        while (it.hasNext()) {
                            UpdateObjectRunnable r = it.next();
                            if (r.started) continue;
                            it.remove();
                            --TextView.this.timerManager.currentTimerTasks;
                        }
                    }
                    TextView.this.timer = new Timer();
                    try {
                        TextView.this.timerManager.createTimeTask();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
        }
        this.doc.addDocumentListener(this.documentListener);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TextView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fSourceViewer.getControl());
        this.fSourceViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.fSourceViewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.setRemoveAllWhenShown(true);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add(this.action1);
        manager.add((IAction)this.action2);
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IAction)this.findAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.action2);
        manager.add((IAction)this.findAction);
        manager.add(this.nativeEvalAction);
        manager.add(this.evalAction);
        this.showUdfAction = new ViewUDFRegistryAction(this.fSourceViewer);
        manager.add((IAction)this.showUdfAction);
        manager.add((IContributionItem)new Separator());
        this.highlightSyntaxAction = new CodeStyleAction();
        manager.add((IAction)this.highlightSyntaxAction);
    }

    protected void createActions() {
        this.fActivationCodeTrigger = new ActivationCodeTrigger();
        this.fActivationCodeTrigger.install();
        this.action1 = new Action(Messages.TextView_27){

            public void run() {
                IContentAssistant ca = TextView.this.sourceViewerConfiguration.getContentAssistant((ISourceViewer)TextView.this.fSourceViewer);
                if (ca != null) {
                    ca.install((ITextViewer)TextView.this.fSourceViewer);
                    String string = ca.showPossibleCompletions();
                }
            }
        };
        this.action1.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction(Messages.TextView_28, this.action1);
        Util.isTextEditorLocked = false;
        this.action2 = new Action(Messages.TextView_29){

            public void run() {
                EObject missEObject;
                if (TextView.this.codeCapability == null) {
                    TextView.this.setTextIsLocked(false);
                } else {
                    TextView.this.setTextIsLocked(TextView.this.action2.isChecked());
                }
                EObject eObject = TextView.this.eObject == null ? null : (EObject)TextView.this.eObject.get();
                EObject eObject2 = missEObject = TextView.this.missEObject == null ? null : (EObject)TextView.this.missEObject.get();
                if (!TextView.this.action2.isChecked() && missEObject != null && missEObject != eObject) {
                    StructuredSelection ss = null;
                    DiagramGraphicalViewer viewer = null;
                    for (Object o : ((IStructuredSelection)TextView.this.editorPart.getSite().getSelectionProvider().getSelection()).toList()) {
                        if (!(o instanceof IGraphicalEditPart)) continue;
                        viewer = (DiagramGraphicalViewer)((IGraphicalEditPart)o).getRoot().getViewer();
                        List l = viewer.findEditPartsForElement(EMFCoreUtil.getProxyID((EObject)eObject), ShapeNodeEditPart.class);
                        ss = new StructuredSelection(l);
                    }
                    if (TextView.this.dropedLastSelection && ss != null) {
                        viewer.setSelection(ss);
                    } else {
                        TextView.this.setEObject(missEObject);
                        TextView.this.selectionChanged();
                    }
                }
            }
        };
        this.action2.setImageDescriptor(Activator.getImageDescriptor("/icons/lock-16x16.png"));
        this.action2.setToolTipText(Messages.TextView_29);
        this.action2.setChecked(false);
        this.action2.setAccelerator(262220);
        this.setAction(Messages.TextView_30, (IAction)this.action2);
        this.findAction = new FindReplaceAction(ResourceBundle.getBundle("org.eclipse.ui.texteditor.ConstructedTextEditorMessages"), null, (IWorkbenchPart)this);
        this.findAction.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
        this.findAction.setText(Messages.TextView_32);
        this.setAction(ITextEditorActionConstants.FIND, (IAction)this.findAction);
        try {
            this.findAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.eclipse.search/icons/full/eview16/searchres.png")));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        this.setAction(Messages.TextView_34, (IAction)this.findAction);
        this.nativeEvalAction = new Action(Messages.TextView_35){

            public void run() {
                MessageConsole m = Util.findConsole((String)"Xpath");
                m.activate();
                m.clearConsole();
                MdNode node = (MdNode)TextView.this.eObject.get();
                try {
                    String expression = TextView.this.fSourceViewer.getDocument().get();
                    Object result = node.evaluateMdSet(expression);
                    Throwable throwable = null;
                    Object var6_11 = null;
                    try (MessageConsoleStream mcs = m.newMessageStream();){
                        if (result instanceof List) {
                            for (Object o : (List)result) {
                                mcs.println(o.toString());
                            }
                        } else {
                            mcs.println(result.toString());
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    if (e.getCause() != null) {
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Xpath Error", (String)e.getCause().getMessage());
                    } else {
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Xpath Error", (String)e.getMessage());
                    }
                    try {
                        Throwable throwable = null;
                        Object var6_13 = null;
                        try (MessageConsoleStream stream = m.newMessageStream();){
                            stream.println(e.getMessage());
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException ex) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, "Exception while closing stream", ex);
                    }
                }
            }
        };
        this.evalAction = new Action(Messages.TextView_39){

            public void run() {
                String expression;
                MdNode node = (MdNode)TextView.this.eObject.get();
                String srcExpression = expression = TextView.this.fSourceViewer.getDocument().get();
                Object toEval = XPathExpressionHelper.INSTANCE.getXPathScript(node, expression);
                toEval = "string-join(" + (String)toEval + ",codepoints-to-string(10))";
                try {
                    String string = ((IXPathEvaluationService)E4InjectorHelper.getService(IXPathEvaluationService.class)).evaluate(node.eResource().getURI(), (String)toEval, ParameterBuilder.create(IXPathEvaluationService.Option.class, String.class).set((Object)IXPathEvaluationService.Option.EXPRESSION_SOURCE, (Object)srcExpression));
                }
                catch (IGenerationService.SynchronizerBusyException ex) {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"XPath Evaluation", (String)Messages.TextView_47);
                    return;
                }
            }
        };
    }

    public void setTextIsLocked(boolean value) {
        Util.isTextEditorLocked = value;
        this.action2.setChecked(value);
    }

    public void setAction(String actionID, IAction action) {
        Assert.isNotNull((Object)actionID);
        if (action == null) {
            action = (IAction)this.fActions.remove(actionID);
            if (action != null) {
                this.fActivationCodeTrigger.unregisterActionFromKeyActivation(action);
            }
        } else {
            if (action.getId() == null) {
                action.setId(actionID);
            }
            this.fActions.put(actionID, action);
            this.fActivationCodeTrigger.registerActionForKeyActivation(action);
        }
    }

    public IAction getAction(String actionID) {
        Assert.isNotNull((Object)actionID);
        IAction action = (IAction)this.fActions.get(actionID);
        if (action == null && (action = this.findContributedAction(actionID)) != null) {
            this.setAction(actionID, action);
        }
        return action;
    }

    private IAction findContributedAction(String actionID) {
        Object element;
        ArrayList<IConfigurationElement> actions = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui", "editorActions");
        int i = 0;
        while (i < elements.length) {
            element = elements[i];
            if (TAG_CONTRIBUTION_TYPE.equals(element.getName()) && this.getSite().getId().equals(element.getAttribute("targetID"))) {
                IConfigurationElement[] children = element.getChildren("action");
                int j = 0;
                while (j < children.length) {
                    IConfigurationElement child = children[j];
                    if (actionID.equals(child.getAttribute("actionID"))) {
                        actions.add(child);
                    }
                    ++j;
                }
            }
            ++i;
        }
        int actionSize = actions.size();
        if (actionSize > 0) {
            if (actionSize > 1) {
                Object[] actionArray = actions.toArray(new IConfigurationElement[actionSize]);
                ConfigurationElementSorter sorter = new ConfigurationElementSorter(){

                    public IConfigurationElement getConfigurationElement(Object object) {
                        return (IConfigurationElement)object;
                    }
                };
                sorter.sort(actionArray);
                element = actionArray[0];
            } else {
                element = (IConfigurationElement)actions.get(0);
            }
            try {
                return new ContributedAction((IServiceLocator)this.getSite(), element);
            }
            catch (CommandNotMappedException commandNotMappedException) {
                // empty catch block
            }
        }
        return null;
    }

    public void setFocus() {
        IWorkbenchPage page = Workbench.getInstance().getActiveWorkbenchWindow().getActivePage();
        IEditorPart editor = page != null ? page.getActiveEditor() : null;
        IWorkbenchPart active = page != null ? page.getActivePart() : null;
        this.parent.setFocus();
        if (editor == active) {
            if (editor != this && (this.eObject == null || this.eObject.get() == null || editor != this.editorPart)) {
                this.editorPart = editor;
                this.setEObject(this.getSelectedObject());
                if (!this.locked) {
                    this.selectionChanged();
                }
            }
        } else if (this.eObject == null || this.eObject.get() == null) {
            if (this.editorPart != editor && !"org.eclipse.ui.navigator.ProjectExplorer".equals(active.getSite().getId())) {
                this.editorPart = editor;
            }
            this.setEObject(this.getSelectedObject());
            if (!this.locked) {
                this.selectionChanged();
            }
        }
        this.fSourceViewer.getControl().setFocus();
    }

    public EObject getSelectedObject() {
        ISelection selection;
        ISelection iSelection = selection = this.editorPart != null && this.editorPart.getSite().getSelectionProvider() != null ? this.editorPart.getSite().getSelectionProvider().getSelection() : null;
        if (selection != null && selection instanceof IStructuredSelection) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            if (object instanceof IGraphicalEditPart) {
                EObject expression = (EObject)Platform.getAdapterManager().getAdapter(object, IExpressionEditorCompliant.class);
                if (expression != null) {
                    return expression;
                }
                EObject eo = ((IGraphicalEditPart)object).resolveSemanticElement();
                return eo;
            }
            if (object instanceof IAdaptable) {
                return (EObject)((IAdaptable)object).getAdapter(EObject.class);
            }
        }
        return null;
    }

    private void setEObject(EObject o) {
        EObject eObject;
        this.codeCapability = o != null ? (CodeCapability)Platform.getAdapterManager().getAdapter((Object)o, CodeCapability.class) : null;
        if (o == null) {
            this.currenEditingDomain = new WeakReference<Object>(null);
        } else {
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)o);
            if (this.currenEditingDomain.get() != domain) {
                this.currenEditingDomain = new WeakReference<TransactionalEditingDomain>(domain);
            }
        }
        this.getViewSite().getActionBars().getToolBarManager().update(true);
        EObject eObject2 = eObject = this.eObject == null ? null : (EObject)this.eObject.get();
        if (eObject != null) {
            eObject.eAdapters().remove((Object)this.featureAdapter);
        }
        this.eObject = new WeakReference<EObject>(o);
        this.evalAction.setEnabled(o instanceof MdNode);
        this.nativeEvalAction.setEnabled(o instanceof MdNode);
        if (this.codeCapability != null && o != null) {
            o.eAdapters().add((Object)this.featureAdapter);
        }
        if (this.codeCapability == null || this.codeCapability.getCodingStyleInfo() == CodeCapability.NONE) {
            this.highlightSyntaxAction.setEnabled(false);
        } else {
            this.highlightSyntaxAction.setEnabled(true);
        }
        this.showUdfAction.setAllowed(this.codeCapability != null && this.codeCapability.getCodingStyleInfo() == CodeCapability.MAPPING_SQL);
        this.getViewSite().getActionBars().getToolBarManager().update(true);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IContributedContentsView.class) {
            return new IContributedContentsView(){

                public IWorkbenchPart getContributingPart() {
                    return TextView.this.ep == null ? null : (IWorkbenchPart)TextView.this.ep.get();
                }
            };
        }
        if (IFindReplaceTarget.class.equals((Object)adapter) && this.fSourceViewer != null) {
            return this.fSourceViewer.getFindReplaceTarget();
        }
        return null;
    }

    public void partActivated(IWorkbenchPart part) {
        if (part == this) {
            this.installDocumentListener();
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this) {
            this.removeDocumentListener();
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
        if (part == this) {
            this.removeDocumentListener();
        }
    }

    public void partOpened(IWorkbenchPart part) {
    }

    static class ActionActivationCode {
        public String fActionId;
        public char fCharacter;
        public int fKeyCode = -1;
        public int fStateMask = -1;

        public ActionActivationCode(String actionId) {
            this.fActionId = actionId;
        }

        public boolean matches(VerifyEvent event) {
            return !(event.character != this.fCharacter || this.fKeyCode != -1 && event.keyCode != this.fKeyCode || this.fStateMask != -1 && event.stateMask != this.fStateMask);
        }
    }

    class ActivationCodeTrigger
    implements VerifyKeyListener {
        private boolean fIsInstalled = false;
        private IKeyBindingService fKeyBindingService;
        private List fActivationCodes = new ArrayList(2);

        ActivationCodeTrigger() {
        }

        public void verifyKey(VerifyEvent event) {
            ActionActivationCode code = null;
            int size = this.fActivationCodes.size();
            int i = 0;
            while (i < size) {
                IAction action;
                code = (ActionActivationCode)this.fActivationCodes.get(i);
                if (code.matches(event) && (action = TextView.this.getAction(code.fActionId)) != null) {
                    if (action instanceof IUpdate) {
                        ((IUpdate)action).update();
                    }
                    if (!action.isEnabled() && action instanceof IReadOnlyDependent) {
                        IReadOnlyDependent dependent = (IReadOnlyDependent)action;
                        boolean writable = dependent.isEnabled(true);
                        if (writable) {
                            event.doit = false;
                            return;
                        }
                    } else if (action.isEnabled()) {
                        event.doit = false;
                        action.run();
                        return;
                    }
                }
                ++i;
            }
        }

        public void install() {
            if (!this.fIsInstalled) {
                if (TextView.this.fSourceViewer instanceof ITextViewerExtension) {
                    SourceViewer e = TextView.this.fSourceViewer;
                    e.prependVerifyKeyListener((VerifyKeyListener)this);
                } else {
                    StyledText text = TextView.this.fSourceViewer.getTextWidget();
                    text.addVerifyKeyListener((VerifyKeyListener)this);
                }
                this.fKeyBindingService = TextView.this.getSite().getKeyBindingService();
                this.fIsInstalled = true;
            }
        }

        public void uninstall() {
            if (this.fIsInstalled) {
                StyledText text;
                if (TextView.this.fSourceViewer instanceof ITextViewerExtension) {
                    SourceViewer e = TextView.this.fSourceViewer;
                    e.removeVerifyKeyListener((VerifyKeyListener)this);
                } else if (TextView.this.fSourceViewer != null && (text = TextView.this.fSourceViewer.getTextWidget()) != null && !text.isDisposed()) {
                    text.removeVerifyKeyListener((VerifyKeyListener)TextView.this.fActivationCodeTrigger);
                }
                this.fIsInstalled = false;
                this.fKeyBindingService = null;
            }
        }

        public void registerActionForKeyActivation(IAction action) {
            if (this.fIsInstalled && action.getActionDefinitionId() != null) {
                this.fKeyBindingService.registerAction(action);
            }
        }

        public void unregisterActionFromKeyActivation(IAction action) {
            if (this.fIsInstalled && action.getActionDefinitionId() != null) {
                this.fKeyBindingService.unregisterAction(action);
            }
        }

        public void setScopes(String[] keyBindingScopes) {
            if (keyBindingScopes != null && keyBindingScopes.length > 0) {
                this.fKeyBindingService.setScopes(keyBindingScopes);
            }
        }
    }

    class CodeStyleAction
    extends Action {
        public CodeStyleAction() {
            super("", 2);
            this.setToolTipText(Messages.TextView_26);
            this.setImageDescriptor(Activator.getImageDescriptor("icons/syntax-coloring-16x16.png"));
            this.setChecked(true);
        }

        public void run() {
            if (TextView.this.codeCapability != null) {
                TextView.this.fSourceViewer.unconfigure();
                TextView.this.sourceViewerConfiguration = new XPathViewerConfiguration(TextView.this.codeCapability, this.isChecked());
                IDocumentPartitioner partioner = PartitionerProvider.createPartitioner();
                TextView.this.doc.setDocumentPartitioner(partioner);
                if (partioner != null) {
                    partioner.connect(TextView.this.doc);
                }
                TextView.this.highlighter.clear();
                TextView.this.fSourceViewer.setDocument(TextView.this.doc, (IAnnotationModel)new AnnotationModel());
                TextView.this.fSourceViewer.configure(TextView.this.sourceViewerConfiguration);
                TextView.this.getViewSite().getActionBars().getToolBarManager().update(true);
            }
        }
    }

    private class FindHandler
    extends AbstractHandler {
        private FindHandler() {
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            if (TextView.this.fSourceViewer != null && TextView.this.fSourceViewer.getDocument() != null) {
                TextView.this.findAction.run();
            }
            return null;
        }

        public boolean isEnabled() {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart() == TextView.this;
        }
    }

    class Highlighter
    implements MouseMoveListener,
    PaintListener {
        Point mouseLocation = null;
        Rectangle bounds = null;
        WeakReference<Annotation> ref = new WeakReference<Object>(null);
        Position oldPos = null;

        Highlighter() {
        }

        public void paintControl(PaintEvent e) {
            if (this.bounds != null) {
                e.gc.setLineWidth(0);
                e.gc.setLineStyle(1);
                e.gc.setAlpha(100);
                e.gc.setBackground(TextView.this.fSourceViewer.getTextWidget().getSelectionBackground());
                e.gc.fillRectangle(this.bounds);
                e.gc.setAlpha(255);
                e.gc.setForeground(e.display.getSystemColor(9));
                e.gc.drawLine(this.bounds.x, this.bounds.y + this.bounds.height, this.bounds.x + this.bounds.width, this.bounds.y + this.bounds.height);
            }
        }

        void clear() {
            this.mouseLocation = null;
            this.bounds = null;
            this.oldPos = null;
            this.ref = new WeakReference<Object>(null);
        }

        public void mouseMove(MouseEvent e) {
            this.mouseLocation = new Point(e.x, e.y);
            this.refreshDecoration();
        }

        private void refreshDecoration() {
            Annotation a;
            IAnnotationModel annoteModel = TextView.this.fSourceViewer.getAnnotationModel();
            if (annoteModel == null) {
                this.bounds = null;
                return;
            }
            Iterator it = annoteModel.getAnnotationIterator();
            while (it.hasNext()) {
                a = (Annotation)it.next();
                if (!"VARIABLE".equals(a.getType()) && !"UDF".equals(a.getType())) continue;
                Position p = annoteModel.getPosition(a);
                if (p.length <= 0) continue;
                Rectangle rect = null;
                try {
                    rect = TextView.this.fSourceViewer.getTextWidget().getTextBounds(p.offset, p.offset + p.length - 1);
                    if (this.mouseLocation == null || !rect.contains(this.mouseLocation)) continue;
                    if (a != this.ref.get() || !p.equals((Object)this.oldPos)) {
                        this.ref = new WeakReference<Annotation>(a);
                        this.bounds = rect;
                        --this.bounds.width;
                        --this.bounds.height;
                        if (this.oldPos != null) {
                            try {
                                TextView.this.fSourceViewer.getTextWidget().redrawRange(this.oldPos.offset, this.oldPos.length, true);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        TextView.this.fSourceViewer.getTextWidget().redrawRange(p.offset, p.length, true);
                        this.oldPos = p;
                    }
                    return;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            a = (Annotation)this.ref.get();
            if (a != null) {
                if (this.oldPos != null) {
                    try {
                        TextView.this.fSourceViewer.getTextWidget().redrawRange(this.oldPos.offset, this.oldPos.length, true);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                this.ref = new WeakReference<Object>(null);
                this.bounds = null;
            }
        }
    }

    private class TimerManager {
        private int currentTimerTasks = 0;
        private boolean joining = false;
        private List<UpdateObjectRunnable> createdTasks = new ArrayList<UpdateObjectRunnable>();

        private TimerManager() {
        }

        public void createTimeTask() throws Exception {
            if (this.joining) {
                throw new Exception("Cannot schedule while joining");
            }
            TextView.this.timer.schedule((TimerTask)new UpdateObjectRunnable(TextView.this.eObject, TextView.this.doc.get(), TextView.this.eStructuralFeature), 300L);
        }

        public void resetTimer() {
        }

        public void join() {
            this.joining = true;
            while (this.currentTimerTasks != 0) {
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.joining = false;
            TextView.this.timer = null;
        }
    }

    private class UpdateObjectRunnable
    extends TimerTask {
        boolean started = false;
        private WeakReference<EObject> object;
        private String val;
        private EStructuralFeature feature;

        UpdateObjectRunnable(WeakReference<EObject> object, String val, EStructuralFeature feature) {
            this.object = object;
            this.val = val;
            this.feature = feature;
            ++TextView.this.timerManager.currentTimerTasks;
            TextView.this.timerManager.createdTasks.add(this);
        }

        @Override
        public void run() {
            this.started = true;
            try {
                TextView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block19: {
                            try {
                                try {
                                    ((UpdateObjectRunnable)UpdateObjectRunnable.this).TextView.this.updatingFeature = true;
                                    if (UpdateObjectRunnable.this.feature != null) {
                                        EObject object = (EObject)UpdateObjectRunnable.this.object.get();
                                        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)object);
                                        if (ted == null && (ted = (TransactionalEditingDomain)((UpdateObjectRunnable)UpdateObjectRunnable.this).TextView.this.currenEditingDomain.get()) != null && object.eIsProxy()) {
                                            object = ted.getResourceSet().getEObject(((InternalEObject)object).eProxyURI(), true);
                                        }
                                        if (ted != null) {
                                            Command cmd = null;
                                            if (((UpdateObjectRunnable)UpdateObjectRunnable.this).TextView.this.adpatToCommand) {
                                                if (UpdateObjectRunnable.this.val != null && !UpdateObjectRunnable.this.val.isEmpty() && (cmd = (Command)Platform.getAdapterManager().getAdapter((Object)object, ISettableValueCommand.class)) != null) {
                                                    ((ISettableValueCommand)cmd).setFeatureNewValue((Object)UpdateObjectRunnable.this.val);
                                                    final ISettableValueCommand svc = (ISettableValueCommand)cmd;
                                                    ((ISettableValueCommand)cmd).setUndo(new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            (this).UpdateObjectRunnable.this.object = new WeakReference<EObject>(svc.getInitialTarget());
                                                            (this).UpdateObjectRunnable.this.feature = null;
                                                            ((UpdateObjectRunnable)(this).UpdateObjectRunnable.this).TextView.this.eStructuralFeature = null;
                                                            TextView.this.setEObject(svc.getInitialTarget());
                                                            ((UpdateObjectRunnable)(this).UpdateObjectRunnable.this).TextView.this.adpatToCommand = true;
                                                        }
                                                    });
                                                    ((ISettableValueCommand)cmd).setRedo(new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            (this).UpdateObjectRunnable.this.object = new WeakReference<EObject>(svc.getReplacementFeatureTarget());
                                                            (this).UpdateObjectRunnable.this.feature = svc.getReplacementFeature();
                                                            ((UpdateObjectRunnable)(this).UpdateObjectRunnable.this).TextView.this.eStructuralFeature = svc.getReplacementFeature();
                                                            TextView.this.setEObject(svc.getReplacementFeatureTarget());
                                                            ((UpdateObjectRunnable)(this).UpdateObjectRunnable.this).TextView.this.adpatToCommand = false;
                                                        }
                                                    });
                                                }
                                            } else {
                                                Object obj = object.eGet(UpdateObjectRunnable.this.feature);
                                                if (obj == null && !UpdateObjectRunnable.this.val.equals("") || obj != null && !obj.equals(UpdateObjectRunnable.this.val)) {
                                                    cmd = new SetCommand((EditingDomain)ted, object, UpdateObjectRunnable.this.feature, (Object)UpdateObjectRunnable.this.val);
                                                }
                                            }
                                            if (cmd != null) {
                                                ted.getCommandStack().execute(cmd);
                                            }
                                        } else {
                                            String mess = "";
                                            Resource r = null;
                                            if (object != null) {
                                                r = object.eResource();
                                            }
                                            Activator.getDefault().getLog().log((IStatus)new Status(2, "com.indy.ui.text.editor", "No EditingDomain for " + String.valueOf(r == null ? object.toString() : r.getURI())));
                                        }
                                        break block19;
                                    }
                                    EObject object = (EObject)UpdateObjectRunnable.this.object.get();
                                    if (object == null) break block19;
                                    if (((UpdateObjectRunnable)UpdateObjectRunnable.this).TextView.this.mdNodeExpressionsBackup.size() > 50 && ((UpdateObjectRunnable)UpdateObjectRunnable.this).TextView.this.mdNodeExpressionsBackup.get(EcoreUtil.getURI((EObject)object)) == null) {
                                        Map<URI, String> map = ((UpdateObjectRunnable)UpdateObjectRunnable.this).TextView.this.mdNodeExpressionsBackup;
                                        synchronized (map) {
                                            ((UpdateObjectRunnable)UpdateObjectRunnable.this).TextView.this.mdNodeExpressionsBackup.remove(((UpdateObjectRunnable)UpdateObjectRunnable.this).TextView.this.mdNodeExpressionsBackup.keySet().iterator().next());
                                        }
                                    }
                                    ((UpdateObjectRunnable)UpdateObjectRunnable.this).TextView.this.mdNodeExpressionsBackup.put(EcoreUtil.getURI((EObject)object), UpdateObjectRunnable.this.val);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    Activator.getDefault().getLog().log((IStatus)new Status(4, "com.indy.ui.text.editor", "Something went wrong while executing ExpressionEditor command in async mode", (Throwable)ex));
                                    ((UpdateObjectRunnable)UpdateObjectRunnable.this).TextView.this.updatingFeature = false;
                                }
                            }
                            finally {
                                ((UpdateObjectRunnable)UpdateObjectRunnable.this).TextView.this.updatingFeature = false;
                            }
                        }
                    }
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Activator.getDefault().getLog().log((IStatus)new Status(2, "com.indy.ui.text.editor", "Failed to execute ExpressionEditor command", (Throwable)ex));
            }
            TextView.this.timer.cancel();
            --TextView.this.timerManager.currentTimerTasks;
            TextView.this.timerManager.createdTasks.remove(this);
        }
    }
}

