/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.text.editor.views.parsing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class BindableCompletionProcessor
implements IContentAssistProcessor {
    private final IContextInformation[] NO_CONTEXTS = new IContextInformation[0];
    private final char[] PROPOSAL_ACTIVATION_CHARS = new char[]{':', '{'};
    private ICompletionProposal[] NO_COMPLETIONS = new ICompletionProposal[0];
    private List<String> bindableParameters;

    public BindableCompletionProcessor(List<String> bindableParameters) {
        this.bindableParameters = bindableParameters;
        Collections.sort(bindableParameters);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ArrayList<CompletionProposal> propList;
        block8: {
            String string;
            block7: {
                if (this.bindableParameters == null || this.bindableParameters.isEmpty()) {
                    return null;
                }
                String text = viewer.getDocument().get();
                string = text.substring(0, offset);
                if (string.equals("")) {
                    return this.NO_COMPLETIONS;
                }
                propList = new ArrayList<CompletionProposal>();
                int length = string.length();
                if (length < 1) {
                    return this.NO_COMPLETIONS;
                }
                if (string.charAt(length - 1) != '{') break block7;
                if (length - 2 < 0 || string.charAt(length - 2) != ':') break block8;
                for (String s : this.bindableParameters) {
                    CompletionProposal cmp = new CompletionProposal(s, offset, 0, s.length());
                    propList.add(cmp);
                }
                break block8;
            }
            int doubleDotIndex = string.lastIndexOf(":");
            if (doubleDotIndex != -1) {
                int endIndex;
                String paramString = null;
                if (doubleDotIndex + 1 < string.length() && string.charAt(doubleDotIndex + 1) == '{' && (paramString = (endIndex = string.substring(doubleDotIndex + 1).indexOf("}")) == -1 ? string.substring(doubleDotIndex + 2) : string.substring(doubleDotIndex + 2, endIndex)) != null) {
                    for (String s : this.bindableParameters) {
                        if (!s.toLowerCase().startsWith(paramString.toLowerCase())) continue;
                        CompletionProposal cmp = new CompletionProposal(s.substring(paramString.length()), offset, 0, string.length(), null, s, null, null);
                        propList.add(cmp);
                    }
                }
            }
        }
        return propList.toArray(new ICompletionProposal[propList.size()]);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return this.NO_CONTEXTS;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.PROPOSAL_ACTIVATION_CHARS;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return this.PROPOSAL_ACTIVATION_CHARS;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }
}

