/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.text.editor.views.parsing;

import com.indy.ui.text.editor.views.parsing.ScriptingRule;
import com.indy.ui.text.editor.views.parsing.StateRuleBasedPartitionScanner;
import com.indy.ui.text.editor.views.parsing.StateRuleBasedScanner;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.Token;

public class PartitionerProvider {
    public static String XPATH = "xPath";
    public static String XSL = "xsl";
    public static String NONE = "none";
    public static String ENSEMBLIST = "ensemblist";
    public static String IGNORED = "ignored";
    public static String SCRIPTING = "scripting";

    private static IPredicateRule getXPathRule(Object tokenData) {
        return new MultiLineRule("%x{", "}x%", (IToken)new Token(tokenData));
    }

    private static IPredicateRule getXSLRule(Object tokenData) {
        return new XSLPredicateRule(tokenData);
    }

    private static IPredicateRule getScripting(Object tokenData) {
        return new ScriptingRule(tokenData);
    }

    public static IDocumentPartitioner createPartitioner() {
        StateRuleBasedPartitionScanner scanner = new StateRuleBasedPartitionScanner();
        ArrayList<IPredicateRule> rules = new ArrayList<IPredicateRule>();
        HashSet<String> contentTypes = new HashSet<String>();
        rules.add(PartitionerProvider.getXSLRule(XSL));
        contentTypes.add(XSL);
        rules.add(PartitionerProvider.getXPathRule(XPATH));
        contentTypes.add(XPATH);
        contentTypes.add(IGNORED);
        rules.add(PartitionerProvider.getScripting(SCRIPTING));
        contentTypes.add(SCRIPTING);
        contentTypes.add("__dftl_partition_content_type");
        scanner.setDefaultReturnToken((IToken)new Token((Object)"__dftl_partition_content_type"));
        scanner.setPredicateRules(rules.toArray(new IPredicateRule[rules.size()]));
        return new FastPartitioner((IPartitionTokenScanner)scanner, contentTypes.toArray(new String[contentTypes.size()])){

            public ITypedRegion[] computePartitioning(int offset, int length, boolean includeZeroLengthPartitions) {
                ITypedRegion[] region = super.computePartitioning(offset, length, includeZeroLengthPartitions);
                ArrayList<ITypedRegion> curs = new ArrayList<ITypedRegion>();
                ITypedRegion prev = region[0];
                int i = 1;
                while (i < region.length) {
                    ITypedRegion r = region[i];
                    if (r.getType().equals(prev.getType())) {
                        prev = new TypedRegion(prev.getOffset(), prev.getLength() + r.getLength(), prev.getType());
                    } else {
                        curs.add(prev);
                        prev = r;
                    }
                    if (i == region.length - 1) {
                        curs.add(prev);
                    }
                    ++i;
                }
                if (curs.isEmpty() && region.length == 1) {
                    return region;
                }
                return curs.toArray(new ITypedRegion[curs.size()]);
            }
        };
    }

    private static class XSLPredicateRule
    implements IPredicateRule,
    StateRuleBasedScanner.IRuleWithState {
        Token xslToken;
        String end = "}xsl%";
        String start = "%xsl";
        int nestedCount = 0;

        public XSLPredicateRule(Object tokenData) {
            this.xslToken = new Token(tokenData);
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int n;
            int totalRead = 0;
            int n2 = -1;
            try {
                boolean opened = false;
                while ((n = scanner.read()) != -1) {
                    int i;
                    int k;
                    ++totalRead;
                    if (n == 37) {
                        boolean matchOpen = true;
                        k = 0;
                        i = 1;
                        while (i < this.start.length()) {
                            n = scanner.read();
                            ++k;
                            if (n == -1) {
                                throw new Exception();
                            }
                            if (n != this.start.charAt(i)) {
                                matchOpen = false;
                                break;
                            }
                            ++i;
                        }
                        if (matchOpen) {
                            while (n != -1 && n != 123) {
                                n = scanner.read();
                                ++k;
                            }
                            opened = true;
                            ++this.nestedCount;
                        }
                        totalRead += k;
                        continue;
                    }
                    if (n == 125) {
                        boolean matchClose = true;
                        k = 0;
                        i = 1;
                        while (i < this.end.length()) {
                            n = scanner.read();
                            ++k;
                            if (n == -1) {
                                throw new Exception();
                            }
                            if (n != this.end.charAt(i)) {
                                matchClose = false;
                                break;
                            }
                            ++i;
                        }
                        if (matchClose) {
                            --this.nestedCount;
                            if (this.nestedCount == 0) {
                                return this.xslToken;
                            }
                        }
                        totalRead += k;
                        continue;
                    }
                    if (opened) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception opened) {
                // empty catch block
            }
            int i = 0;
            while (i < totalRead) {
                scanner.unread();
                ++i;
            }
            if (n == -1) {
                return Token.EOF;
            }
            return Token.UNDEFINED;
        }

        public IToken getSuccessToken() {
            return this.xslToken;
        }

        public IToken evaluate(ICharacterScanner scanner, boolean resume) {
            return this.evaluate(scanner);
        }

        @Override
        public void cleanupState() {
            this.nestedCount = 0;
        }
    }
}

