/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.httprest.wizard;

import com.indy.addons.ScrolledCompositeWizardHelper;
import com.indy.addons.httprest.wizard.Messages;
import com.indy.addons.httprest.wizard.WizardControler;
import com.indy.md.ui.editor.reverse.MdDiffBuilder;
import com.indy.md.ui.editor.reverse.MdDiffNode;
import com.indy.md.ui.editor.reverse.MdDiffNodeUI;
import com.indy.md.ui.editor.ui.MdWizard;
import com.stambia.md.MdNode;
import com.stambia.md.custom.IncrementalReverser;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class HttpRestWizard
extends MdWizard {
    public static Image helpImage = null;
    private static final Logger logger = LogManager.getLogger(HttpRestWizard.class);
    private SecurityPage securityPage;
    private ReversePage reversePage;
    private WizardPage selectivePage;
    private WizardControler controler;
    MdDiffNodeUI diffNodeUI;
    Map<String, Boolean> reverseOptions = new HashMap<String, Boolean>();

    static {
        try {
            helpImage = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.eclipse.ui/icons/full/etool16/help_contents.png")).createImage();
        }
        catch (Exception ex) {
            logger.warn("Could not load help image", (Throwable)ex);
        }
    }

    public HttpRestWizard() {
        this(false);
    }

    public HttpRestWizard(boolean isCreation) {
        super(isCreation);
        this.setNeedsProgressMonitor(true);
        this.reverseOptions.put("com.stambia.http.rest.path", true);
        this.reverseOptions.put("com.stambia.http.rest.operation", true);
        this.reverseOptions.put("com.stambia.http.rest.parameters", true);
        this.reverseOptions.put("com.stambia.http.rest.parameter", true);
        this.reverseOptions.put("com.stambia.http.rest.headers", true);
        this.reverseOptions.put("com.stambia.http.rest.header", true);
        this.reverseOptions.put("com.stambia.http.rest.content", true);
        this.reverseOptions.put("com.stambia.http.rest.requestbody", true);
        this.reverseOptions.put("com.stambia.http.rest.responses", true);
        this.reverseOptions.put("com.stambia.http.rest.response", true);
        this.reverseOptions.put("com.stambia.json.rootObject", true);
        this.reverseOptions.put("com.stambia.json.rootArray", true);
        this.reverseOptions.put("com.stambia.json.rootValue", true);
        this.reverseOptions.put("com.stambia.json.array", true);
        this.reverseOptions.put("com.stambia.json.object", true);
        this.reverseOptions.put("com.stambia.json.value", true);
    }

    public void setNode(MdNode node) {
        super.setNode(node);
        this.controler = new WizardControler(node);
    }

    public void addPages() {
        this.securityPage = new SecurityPage();
        this.addPage((IWizardPage)this.securityPage);
        this.reversePage = new ReversePage();
        this.addPage((IWizardPage)this.reversePage);
        this.selectivePage = new WizardPage("DiffPage"){

            public void createControl(Composite parent) {
                TabbedPropertySheetWidgetFactory widgetFactory = new TabbedPropertySheetWidgetFactory();
                HttpRestWizard.this.diffNodeUI = new MdDiffNodeUI(widgetFactory);
                Composite main = widgetFactory.createComposite(parent, 0);
                main.setLayout((Layout)new GridLayout());
                ((GridLayout)main.getLayout()).verticalSpacing = 0;
                HttpRestWizard.this.diffNodeUI.createSearchBar(main).setLayoutData((Object)new GridData(4, 1, true, false));
                HttpRestWizard.this.diffNodeUI.createOptionComposite(main).setLayoutData((Object)new GridData(4, 1, true, false));
                HttpRestWizard.this.diffNodeUI.createToolbar(main).setLayoutData((Object)new GridData(4, 1, true, false));
                ((GridLayout)main.getLayout()).verticalSpacing = 0;
                main.setLayoutData((Object)new GridData(1808));
                CheckboxTreeViewer diffViewer = HttpRestWizard.this.diffNodeUI.createViewer(main);
                diffViewer.getControl().setLayoutData((Object)new GridData(1808));
                this.setControl((Control)main);
            }
        };
        this.addPage((IWizardPage)this.selectivePage);
        this.selectivePage.setDescription(Messages.HttpRestWizard_27);
        this.selectivePage.setTitle(Messages.HttpRestWizard_28);
        IWizardContainer c = this.getContainer();
        if (c instanceof WizardDialog) {
            ((WizardDialog)c).setMinimumPageSize(0, 330);
            ((WizardDialog)c).addPageChangingListener(new IPageChangingListener(){

                public void handlePageChanging(final PageChangingEvent event) {
                    if (event.getTargetPage() == HttpRestWizard.this.selectivePage) {
                        try {
                            HttpRestWizard.this.getContainer().run(true, false, new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) {
                                    String reverseUrl = (this).HttpRestWizard.this.controler.getBean().getReverseURL();
                                    if (reverseUrl == null || reverseUrl.length() == 0) {
                                        event.doit = false;
                                        return;
                                    }
                                    monitor.beginTask(Messages.HttpRestWizard_29, -1);
                                    (this).HttpRestWizard.this.controler.setProgressMonitor(monitor);
                                    HashSet ignoredAttributeComparison = new HashSet();
                                    HashMap<String, IncrementalReverser.DefaulteverseMatchingStrategy> nodeMatchingMap = new HashMap<String, IncrementalReverser.DefaulteverseMatchingStrategy>();
                                    nodeMatchingMap.put("com.stambia.http.rest.response", IncrementalReverser.DefaulteverseMatchingStrategy.ByAttribute);
                                    nodeMatchingMap.put("com.stambia.http.rest.operation", IncrementalReverser.DefaulteverseMatchingStrategy.ByAttribute);
                                    nodeMatchingMap.put("com.stambia.http.rest.path", IncrementalReverser.DefaulteverseMatchingStrategy.ByAttribute);
                                    nodeMatchingMap.put("com.stambia.http.rest.respinfo", IncrementalReverser.DefaulteverseMatchingStrategy.ByAttribute);
                                    nodeMatchingMap.put("com.stambia.http.rest.content", IncrementalReverser.DefaulteverseMatchingStrategy.ByOrderAmongstSiblingWithSameLevel);
                                    nodeMatchingMap.put("com.stambia.http.rest.multipart", IncrementalReverser.DefaulteverseMatchingStrategy.ByOrderAmongstSiblingWithSameLevel);
                                    try {
                                        final MdDiffNode diffNode = new MdDiffNode(null, HttpRestWizard.this.isCreation() ? null : HttpRestWizard.this.getNode(), (this).HttpRestWizard.this.controler.createReversedMdNode(true, true), ignoredAttributeComparison, false);
                                        MdDiffBuilder.buildTree((IncrementalReverser.DefaulteverseMatchingStrategy)IncrementalReverser.DefaulteverseMatchingStrategy.ByName, (MdDiffNode)diffNode, (Set)Collections.EMPTY_SET, ignoredAttributeComparison, nodeMatchingMap);
                                        Display.getDefault().syncExec(new Runnable(){

                                            @Override
                                            public void run() {
                                                ((this).this).HttpRestWizard.this.diffNodeUI.getViewerHelper().setInput((Object)new Object[]{diffNode});
                                            }
                                        });
                                    }
                                    catch (Exception ex) {
                                        StatusManager.getManager().handle((IStatus)new Status(4, "com.indy.addons.httprest", Messages.HttpRestWizard_36, (Throwable)ex), 5);
                                        event.doit = false;
                                    }
                                }
                            });
                        }
                        catch (Exception ex) {
                            if (ex instanceof InterruptedException) {
                                Thread.currentThread().interrupt();
                            }
                            StatusManager.getManager().handle((IStatus)new Status(4, "com.indy.addons.httprest", Messages.HttpRestWizard_36, (Throwable)ex), 5);
                            event.doit = false;
                        }
                    }
                }
            });
        }
    }

    public boolean performFinish() {
        MdNode newNode = null;
        try {
            HashMap<MdNode, MdNode> reversedMap = new HashMap<MdNode, MdNode>();
            if (this.getContainer().getCurrentPage() == this.securityPage) {
                for (String k : this.reverseOptions.keySet()) {
                    this.reverseOptions.put(k, Boolean.FALSE);
                }
                newNode = this.controler.createReversedMdNode(false, false);
            } else if (this.getContainer().getCurrentPage() == this.reversePage) {
                for (String k : this.reverseOptions.keySet()) {
                    this.reverseOptions.put(k, Boolean.FALSE);
                }
                newNode = this.controler.createReversedMdNode(false, true);
            } else {
                VisitHandler handler = new VisitHandler();
                handler.newToOldMap = reversedMap;
                ArrayList<String> toDelete = new ArrayList<String>();
                for (String s : this.reverseOptions.keySet()) {
                    if (this.reverseOptions.get(s) != Boolean.TRUE) continue;
                    toDelete.add(s);
                }
                MdDiffNodeUI.DiffState diffState = this.diffNodeUI.computeDiffState((MdDiffNodeUI.IVisitorHandler)handler, toDelete);
                newNode = diffState.getResultingMdNode();
            }
            reversedMap.put(newNode, this.getNode());
            TreeIterator it = newNode.eAllContents();
            while (it.hasNext()) {
                EObject o = (EObject)it.next();
                if (!(o instanceof MdNode)) continue;
                ((MdNode)o).setSubstituteContainer(null);
            }
            HashMap<String, IncrementalReverser.DefaulteverseMatchingStrategy> reverseModes = new HashMap<String, IncrementalReverser.DefaulteverseMatchingStrategy>();
            reverseModes.put("com.stambia.http.rest.operation", IncrementalReverser.DefaulteverseMatchingStrategy.ByAttribute);
            reverseModes.put("com.stambia.http.rest.path", IncrementalReverser.DefaulteverseMatchingStrategy.ByAttribute);
            reverseModes.put("com.stambia.http.rest.response", IncrementalReverser.DefaulteverseMatchingStrategy.ByAttribute);
            reverseModes.put("com.stambia.http.rest.respinfo", IncrementalReverser.DefaulteverseMatchingStrategy.ByAttribute);
            reverseModes.put("com.stambia.http.rest.content", IncrementalReverser.DefaulteverseMatchingStrategy.ByOrderAmongstSiblingWithSameLevel);
            reverseModes.put("com.stambia.http.rest.multipart", IncrementalReverser.DefaulteverseMatchingStrategy.ByOrderAmongstSiblingWithSameLevel);
            IncrementalReverser reverser = new IncrementalReverser(this.getNode().getSubstituteContainer(), reversedMap, Collections.EMPTY_LIST, true, null, this.reverseOptions, (IncrementalReverser.IReverseMatchingStrategy)IncrementalReverser.DefaulteverseMatchingStrategy.ByName, reverseModes, true);
            reverser.reverse();
        }
        catch (Exception ex) {
            StatusManager.getManager().handle((IStatus)new Status(4, "com.indy.addons.httprest", Messages.HttpRestWizard_44, (Throwable)ex), 1);
            return false;
        }
        return true;
    }

    private class ReversePage
    extends WizardPage {
        private Text url;
        private ComboViewer keystoreViewer;
        private ComboViewer trustStoreViewer;

        protected ReversePage() {
            super(Messages.HttpRestWizard_6);
            this.setTitle(this.getName());
        }

        public boolean isPageComplete() {
            return this.getErrorMessage() == null;
        }

        public void createControl(Composite parent) {
            ScrolledComposite scrolled = ScrolledCompositeWizardHelper.createScrolledComposite((Composite)parent);
            Composite main = new Composite((Composite)scrolled, 0);
            main.setLayout((Layout)new GridLayout(2, false));
            main.setLayoutData((Object)new GridData(4, 4, true, true));
            Label desc = new Label(main, 64);
            desc.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
            desc.setText(Messages.HttpRestWizard_7);
            Label l = new Label(main, 0);
            l.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
            l.setText(Messages.HttpRestWizard_8);
            ControlDecoration deco = new ControlDecoration((Control)l, 0x1020000);
            deco.setDescriptionText(Messages.HttpRestWizard_9);
            deco.setImage(helpImage);
            deco.setShowHover(true);
            deco.setShowOnlyOnFocus(false);
            this.url = new Text(main, 2048);
            this.url.setLayoutData((Object)new GridData(4, 1, true, false));
            this.url.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ((ReversePage)ReversePage.this).HttpRestWizard.this.controler.getBean().setReverseURL(ReversePage.this.url.getText());
                    ReversePage.this.setErrorMessage(((ReversePage)ReversePage.this).HttpRestWizard.this.controler.validateReverseURL());
                    ReversePage.this.getContainer().updateButtons();
                }
            });
            Button b = new Button(main, 8);
            b.setText("...");
            b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String currentFilePath = ((ReversePage)ReversePage.this).HttpRestWizard.this.controler.getBeanReverseURLFileFolderPath();
                    FileDialog fd = new FileDialog(ReversePage.this.getShell(), 4096);
                    fd.setFilterExtensions(new String[]{"*.json", "*.yaml", "*.yml", "*.txt", "*.*"});
                    fd.setFilterPath(currentFilePath);
                    String path = fd.open();
                    if (path != null) {
                        String fileURI = new File(path).toURI().toString();
                        ((ReversePage)ReversePage.this).HttpRestWizard.this.controler.setBeanReverseFileURL(fileURI);
                        ReversePage.this.url.setText(fileURI);
                    }
                }
            });
            Composite subMainComposite = new Composite(main, 0);
            subMainComposite.setLayout((Layout)new GridLayout(1, false));
            subMainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            l = new Label(subMainComposite, 0);
            l.setLayoutData((Object)new GridData());
            l.setText(Messages.HttpRestWizard_41);
            deco = new ControlDecoration((Control)l, 0x1020000);
            deco.setDescriptionText(Messages.HttpRestWizard_10);
            deco.setImage(helpImage);
            deco.setShowHover(true);
            deco.setShowOnlyOnFocus(false);
            ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            this.keystoreViewer = new ComboViewer(subMainComposite, 8);
            this.keystoreViewer.getControl().setLayoutData((Object)new GridData(4, 1, true, false));
            this.keystoreViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.keystoreViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
            this.keystoreViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Object keystore = event.getStructuredSelection().getFirstElement();
                    if (keystore instanceof MdNode) {
                        ((ReversePage)ReversePage.this).HttpRestWizard.this.controler.getBean().setKeystoreMdNode((MdNode)keystore);
                    } else {
                        ((ReversePage)ReversePage.this).HttpRestWizard.this.controler.getBean().setKeystoreMdNode(null);
                    }
                }
            });
            l = new Label(subMainComposite, 0);
            l.setLayoutData((Object)new GridData());
            l.setText(Messages.HttpRestWizard_42);
            deco = new ControlDecoration((Control)l, 0x1020000);
            deco.setDescriptionText(Messages.HttpRestWizard_11);
            deco.setImage(helpImage);
            deco.setShowHover(true);
            deco.setShowOnlyOnFocus(false);
            this.trustStoreViewer = new ComboViewer(subMainComposite, 8);
            this.trustStoreViewer.getControl().setLayoutData((Object)new GridData(4, 1, true, false));
            this.trustStoreViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.trustStoreViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
            this.trustStoreViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Object trustStore = event.getStructuredSelection().getFirstElement();
                    if (trustStore instanceof MdNode) {
                        ((ReversePage)ReversePage.this).HttpRestWizard.this.controler.getBean().setTrustStoreMdNode((MdNode)trustStore);
                    } else {
                        ((ReversePage)ReversePage.this).HttpRestWizard.this.controler.getBean().setTrustStoreMdNode(null);
                    }
                }
            });
            ScrolledCompositeWizardHelper.adaptToContent((ScrolledComposite)scrolled, (Composite)main);
            this.setControl((Control)scrolled);
            this.fillData();
        }

        private void fillData() {
            this.url.setText(HttpRestWizard.this.controler.getBean().getReverseURL());
            this.setErrorMessage(HttpRestWizard.this.controler.validateReverseURL());
            this.keystoreViewer.setInput(HttpRestWizard.this.controler.getAvailableKeyStoreAndTrustStoreNodes());
            if (HttpRestWizard.this.controler.getBean().getKeystoreMdNode() != null) {
                this.keystoreViewer.setSelection((ISelection)new StructuredSelection((Object)HttpRestWizard.this.controler.getBean().getKeystoreMdNode()));
            } else {
                this.keystoreViewer.setSelection((ISelection)new StructuredSelection((Object)"--- None ---"));
            }
            this.trustStoreViewer.setInput(HttpRestWizard.this.controler.getAvailableKeyStoreAndTrustStoreNodes());
            if (HttpRestWizard.this.controler.getBean().getTrustStoreMdNode() != null) {
                this.trustStoreViewer.setSelection((ISelection)new StructuredSelection((Object)HttpRestWizard.this.controler.getBean().getTrustStoreMdNode()));
            } else {
                this.trustStoreViewer.setSelection((ISelection)new StructuredSelection((Object)"--- None ---"));
            }
        }
    }

    private class SecurityPage
    extends WizardPage {
        private ComboViewer securityViewer;
        private ComboViewer proxyViewer;

        protected SecurityPage() {
            super(Messages.HttpRestWizard_0);
            this.setTitle(this.getName());
        }

        public void createControl(Composite parent) {
            ScrolledComposite scrolled = ScrolledCompositeWizardHelper.createScrolledComposite((Composite)parent);
            Composite main = new Composite((Composite)scrolled, 0);
            main.setLayout((Layout)new GridLayout());
            main.setLayoutData((Object)new GridData(4, 4, true, true));
            Label desc = new Label(main, 64);
            desc.setLayoutData((Object)new GridData(1, 1, true, false, 1, 2));
            desc.setText(Messages.HttpRestWizard_1);
            Label l = new Label(main, 0);
            l.setLayoutData((Object)new GridData());
            l.setText(Messages.HttpRestWizard_2);
            ControlDecoration deco = new ControlDecoration((Control)l, 0x1020000);
            deco.setDescriptionText(Messages.HttpRestWizard_3);
            deco.setImage(helpImage);
            deco.setShowHover(true);
            deco.setShowOnlyOnFocus(false);
            this.securityViewer = new ComboViewer(main, 8);
            this.securityViewer.getControl().setLayoutData((Object)new GridData(4, 1, true, false));
            this.securityViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            this.securityViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
            this.securityViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Object secu = event.getStructuredSelection().getFirstElement();
                    if (secu instanceof MdNode) {
                        ((SecurityPage)SecurityPage.this).HttpRestWizard.this.controler.getBean().setSecurityMdNode((MdNode)secu);
                    } else {
                        ((SecurityPage)SecurityPage.this).HttpRestWizard.this.controler.getBean().setSecurityMdNode(null);
                    }
                }
            });
            l = new Label(main, 0);
            l.setLayoutData((Object)new GridData());
            l.setText(Messages.HttpRestWizard_4);
            deco = new ControlDecoration((Control)l, 0x1020000);
            deco.setDescriptionText(Messages.HttpRestWizard_5);
            deco.setImage(helpImage);
            deco.setShowHover(true);
            deco.setShowOnlyOnFocus(false);
            this.proxyViewer = new ComboViewer(main, 8);
            this.proxyViewer.getControl().setLayoutData((Object)new GridData(4, 1, true, false));
            this.proxyViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.proxyViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
            this.proxyViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Object secu = event.getStructuredSelection().getFirstElement();
                    if (secu instanceof MdNode) {
                        ((SecurityPage)SecurityPage.this).HttpRestWizard.this.controler.getBean().setProxyMdNode((MdNode)secu);
                    } else {
                        ((SecurityPage)SecurityPage.this).HttpRestWizard.this.controler.getBean().setProxyMdNode(null);
                    }
                }
            });
            ScrolledCompositeWizardHelper.adaptToContent((ScrolledComposite)scrolled, (Composite)main);
            this.setControl((Control)scrolled);
            this.fillData();
        }

        private void fillData() {
            this.securityViewer.setInput((Object)HttpRestWizard.this.controler.getAvailableSecurityNodes());
            if (HttpRestWizard.this.controler.getBean().getSecurityMdNode() != null) {
                this.securityViewer.setSelection((ISelection)new StructuredSelection((Object)HttpRestWizard.this.controler.getBean().getSecurityMdNode()));
            } else {
                this.securityViewer.setSelection((ISelection)new StructuredSelection((Object)"--- None ---"));
            }
            this.proxyViewer.setInput((Object)HttpRestWizard.this.controler.getAvailableProxyNodes());
            if (HttpRestWizard.this.controler.getBean().getProxyMdNode() != null) {
                this.proxyViewer.setSelection((ISelection)new StructuredSelection((Object)HttpRestWizard.this.controler.getBean().getProxyMdNode()));
            } else {
                this.proxyViewer.setSelection((ISelection)new StructuredSelection((Object)"--- None ---"));
            }
        }
    }

    private class VisitHandler
    implements MdDiffNodeUI.IVisitorHandler {
        Map<MdNode, MdNode> newToOldMap;

        private VisitHandler() {
        }

        public void handleVisited(MdDiffNode diff, MdNode createdNode) {
            MdNode n;
            MdNode mdNode = n = diff.getState() == MdDiffNode.State.NEW ? diff.getNewNode() : diff.getOldNode();
            if (n.getDefType().equals("com.stambia.http.rest")) {
                this.newToOldMap.put(createdNode, diff.getOldNode());
            }
        }
    }
}

