/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.httprest.wizard;

import com.indy.addons.httprest.wizard.Messages;
import com.indy.addons.httprest.wizard.RestWizardBean;
import com.indy.addons.httprest.wizard.RestWizardControler;
import com.indy.connector.httprest.core.WebServiceExchange;
import com.indy.connector.httprest.core.WebServiceMetaData;
import com.indy.ui.custom.out.services.IExternalValueResolver;
import com.semarchy.xdi.base.core.auth.OAuth2Utils;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.engine.common.exceptions.SecretStatementException;
import com.stambia.httprest.impl.WebServiceInvokerImpl;
import com.stambia.md.Attribute;
import com.stambia.md.MdNode;
import com.stambia.md.util.MdAttributeReader;
import com.stambia.tech.Property;
import com.stambia.tech.PropertyType;
import com.stambia.tech.XpathExpression;
import java.io.StringReader;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class RuntimeHttpInvoker
implements RestWizardControler.IHttpInvoker {
    RestWizardControler controler;

    public RuntimeHttpInvoker(RestWizardControler controler) {
        this.controler = controler;
    }

    @Override
    public RestWizardControler.InvokeResult doSend(RestWizardControler.InvocationInput input) throws Exception {
        String props;
        MdNode securityNode;
        final WebServiceMetaData md = new WebServiceMetaData();
        md.baseUrl = this.controler.getBean().getHttpEndpoint();
        md.verb = this.controler.getBean().getHttpMethod();
        md.resource = this.controler.getBean().getHttpResourcePath();
        md.parameterByKey = new HashMap();
        md.enableCertificateVerification = this.controler.getBean().getEnableCertificateVerification();
        md.enableHostnameVerification = this.controler.getBean().getEnableHostnameVerification();
        if (this.controler.getAuthenticationMdNode() != null) {
            try {
                securityNode = this.controler.getAuthenticationMdNode();
                props = securityNode.evaluate("./internal:toJavaProperties()");
                Properties properties = new Properties();
                properties.load(new StringReader(props));
                XpathExpression exp = securityNode.getLevel().findXPathExpression("INTERNAL_AUTHENTICATION_TYPE");
                Object authType = null;
                if (exp != null) {
                    authType = securityNode.evaluateXpathExpressionCached("INTERNAL_AUTHENTICATION_TYPE", null);
                }
                if (authType == null) {
                    authType = securityNode.evaluate("name()");
                }
                properties.setProperty("type", (String)authType);
                for (Attribute a : securityNode.getAttribute()) {
                    Property prop = securityNode.getLevel().getAttributeByCode(a.getDefType());
                    if (prop == null || prop.getType() != PropertyType.PASSWORD) continue;
                    properties.setProperty(prop.getXmlName(), MdAttributeReader.readAttribute((String)prop.getCode(), (MdNode)securityNode));
                }
                md.securityParams = OAuth2Utils.convertPropertiesToMap((Properties)properties);
            }
            catch (Exception ex) {
                throw new Exception(Messages.RuntimeHttpInvoker_security_error, ex);
            }
        }
        if (this.controler.getAuthenticationProxyMdNode() != null) {
            try {
                securityNode = this.controler.getAuthenticationProxyMdNode();
                props = securityNode.evaluate("./internal:toJavaProperties()");
                Properties properties = new Properties();
                properties.load(new StringReader(props));
                for (Object a : securityNode.getAttribute()) {
                    Property prop = securityNode.getLevel().getAttributeByCode(a.getDefType());
                    if (prop == null || prop.getType() != PropertyType.PASSWORD) continue;
                    properties.setProperty(prop.getXmlName(), MdAttributeReader.readAttribute((String)prop.getCode(), (MdNode)securityNode));
                }
                md.proxyParams = OAuth2Utils.convertPropertiesToMap((Properties)properties);
            }
            catch (Exception ex) {
                throw new Exception(Messages.RuntimeHttpInvoker_security_error, ex);
            }
        }
        md.keyStoreParams = this.getStoreParams(this.controler.getKeyStoreMdNode());
        if (md.keyStoreParams == null || md.keyStoreParams.isEmpty()) {
            md.keyStoreParams = this.controler.getKeyStoreParams();
        }
        md.trustStoreParams = this.getStoreParams(this.controler.getTrustStoreMdNode());
        if (md.trustStoreParams == null || md.trustStoreParams.isEmpty()) {
            md.trustStoreParams = this.controler.getTrustStoreParams();
        }
        WebServiceExchange exchange = new WebServiceExchange();
        exchange.params = new HashMap();
        StringBuffer plainParameterAsInput = new StringBuffer();
        for (RestWizardBean.Parameter parameter : input.parameters) {
            if (!parameter.send.booleanValue()) continue;
            WebServiceMetaData.Parameter _p = new WebServiceMetaData.Parameter();
            _p.allowEmptyValue = parameter.allowEmptyValue == null ? true : parameter.allowEmptyValue;
            switch (parameter.type) {
                case HTTP_HEADER: {
                    _p.location = WebServiceMetaData.ParameterLocation.header;
                    exchange.params.put(parameter.name, parameter.value);
                    break;
                }
                case HTTP_METHOD: {
                    break;
                }
                case HTTP_URL_ENCODED: {
                    _p.location = WebServiceMetaData.ParameterLocation.query;
                    exchange.params.put(parameter.name, parameter.value);
                    break;
                }
                case HTTP_URL_REPLACEMENT: {
                    _p.location = WebServiceMetaData.ParameterLocation.path;
                    exchange.params.put(parameter.name, parameter.value);
                    break;
                }
                case MIME_CONTENT: {
                    if (parameter.name == null) break;
                    if (plainParameterAsInput.length() > 0) {
                        plainParameterAsInput.append("&");
                    }
                    plainParameterAsInput.append(URLEncoder.encode(parameter.name, "UTF-8"));
                    plainParameterAsInput.append("=");
                    if (parameter.value == null) break;
                    plainParameterAsInput.append(URLEncoder.encode(parameter.value, "UTF-8"));
                    break;
                }
                case HTTP_COOKIE: {
                    _p.location = WebServiceMetaData.ParameterLocation.cookie;
                    exchange.params.put(parameter.name, parameter.value);
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            md.parameterByKey.put(parameter.name, _p);
        }
        if (plainParameterAsInput.length() > 0) {
            input.input = plainParameterAsInput.toString();
        }
        md.defaultResponse = new WebServiceMetaData.WebServiceResponseMetaData();
        md.defaultResponse.content = new WebServiceMetaData.ContentMetadata();
        md.defaultResponse.content.mediaType = WebServiceMetaData.ContentType.AUTO;
        if (input.input != null && !input.input.isEmpty()) {
            md.request = new WebServiceMetaData.RequestBody();
            md.request.content = new WebServiceMetaData.ContentMetadata();
            md.request.content.mediaType = WebServiceMetaData.ContentType.AUTO;
            md.request.content.contentType = this.controler.getBean().getHttpInputContentType();
            exchange.request = Collections.singletonMap(null, input.input);
        }
        WebServiceInvokerImpl webServiceInvokerImpl = new WebServiceInvokerImpl(md, null, null);
        md.init();
        if (md.securityParams != null && "oauth2".equals(md.securityParams.get("type"))) {
            final String clientId = (String)md.securityParams.get("clientId");
            final String clientSecret = (String)md.securityParams.get("clientSecret");
            final String username = (String)md.securityParams.get("username");
            final String password = (String)md.securityParams.get("password");
            final IExternalValueResolver resolver = (IExternalValueResolver)E4InjectorHelper.getService(IExternalValueResolver.class);
            if (resolver.needResolution(new String[]{clientId, clientSecret, username, password})) {
                resolver.executeSecured(new IExternalValueResolver.SecuredRunner(){

                    public void run() throws Exception {
                        md.securityParams.put("clientId", resolver.resolve(clientId));
                        md.securityParams.put("clientSecret", resolver.resolve(clientSecret));
                        md.securityParams.put("username", resolver.resolve(username));
                        md.securityParams.put("password", resolver.resolve(password));
                    }

                    public Exception getFailure() {
                        return new SecretStatementException();
                    }
                });
            }
        }
        WebServiceExchange.WebServiceResponse resp = null;
        resp = webServiceInvokerImpl.handleRequest(md, exchange);
        String _encoding = "UTF-8";
        try {
            String t = (String)resp.headers.get("Content-type");
            if (t != null && t.contains("charset=")) {
                if ((t = t.substring(t.indexOf("charset=")).trim()).contains(";")) {
                    t = t.substring(0, t.indexOf(";"));
                }
                if (Charset.forName(t = t.replace("charset=", "")) != null) {
                    _encoding = t;
                }
            }
        }
        catch (Exception t) {
            // empty catch block
        }
        int responseCode = -1;
        boolean isError = false;
        try {
            responseCode = Integer.parseInt(resp.respInfos.statusCode);
            switch (responseCode) {
                case 203: 
                case 205: 
                case 303: 
                case 304: 
                case 400: 
                case 401: 
                case 402: 
                case 403: 
                case 404: 
                case 405: 
                case 406: 
                case 407: 
                case 408: 
                case 409: 
                case 410: 
                case 411: 
                case 412: 
                case 413: 
                case 414: 
                case 415: 
                case 500: 
                case 501: 
                case 502: 
                case 503: 
                case 504: 
                case 505: {
                    isError = true;
                }
            }
        }
        catch (Exception ex) {
            isError = true;
        }
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        HashMap<String, String> cookies = new HashMap<String, String>();
        if (resp.headers != null) {
            for (String k : resp.headers.keySet()) {
                headers.put(k, new ArrayList());
                ((List)headers.get(k)).add((String)resp.headers.get(k));
            }
        }
        if (resp.cookies != null) {
            for (String k : resp.cookies.keySet()) {
                cookies.put(k, (String)resp.cookies.get(k));
            }
        }
        RestWizardControler restWizardControler = this.controler;
        restWizardControler.getClass();
        RestWizardControler.InvokeResult res = new RestWizardControler.InvokeResult(restWizardControler, _encoding, ((String)resp.content).getBytes(_encoding), isError, headers, cookies, resp.respInfos.reasonPhrase, responseCode);
        return res;
    }

    private Map<String, Object> getStoreParams(MdNode mdNode) throws Exception {
        if (mdNode != null) {
            try {
                String props = mdNode.evaluate("./internal:toJavaProperties()");
                Properties p = new Properties();
                p.load(new StringReader(props));
                for (Attribute a : mdNode.getAttribute()) {
                    Property prop = mdNode.getLevel().getAttributeByCode(a.getDefType());
                    if (prop == null || prop.getType() != PropertyType.PASSWORD) continue;
                    p.setProperty(prop.getXmlName(), MdAttributeReader.readAttribute((String)prop.getCode(), (MdNode)mdNode));
                }
                return OAuth2Utils.convertPropertiesToMap((Properties)p);
            }
            catch (Exception ex) {
                throw new Exception(Messages.RuntimeHttpInvoker_keystore_trustore_error, ex);
            }
        }
        return null;
    }
}

