/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.jws;

import com.indy.addons.AttributeUtil;
import com.indy.addons.jws.JWSBean;
import com.indy.addons.jws.JWSTokenGenerator;
import com.stambia.md.MdNode;
import com.stambia.md.custom.IncrementalReverser;
import com.stambia.md.util.MdAttributeReader;
import com.stambia.md.util.MdFactoryHelper;
import java.util.ArrayList;
import java.util.HashMap;

public class JWSLinker {
    JWSBean bean = new JWSBean();
    private MdNode node;
    private boolean refreshBean = false;

    public void setNode(MdNode node) {
        this.node = node;
        this.refreshBean = true;
    }

    public JWSBean getBean() {
        if (this.refreshBean) {
            this.refreshBean();
            this.refreshBean = false;
        }
        return this.bean;
    }

    private void refreshBean() {
        this.bean.name = this.node.getName() != null && !this.node.getName().isEmpty() ? this.node.getName() : "";
        try {
            this.bean.payload = MdAttributeReader.readAttribute((String)"payload", (MdNode)this.node, (String)"");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bean.secret = MdAttributeReader.readAttribute((String)"secret", (MdNode)this.node, (String)"");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bean.serializationMode = JWSTokenGenerator.SerializationMode.valueOf(MdAttributeReader.readAttribute((String)"serializationMode", (MdNode)this.node, (String)""));
        }
        catch (Exception ex) {
            this.bean.serializationMode = JWSTokenGenerator.SerializationMode.COMPACT;
        }
        try {
            this.bean.token = MdAttributeReader.readAttribute((String)"jwsToken", (MdNode)this.node, (String)"");
        }
        catch (Exception ex) {
            this.bean.serializationMode = JWSTokenGenerator.SerializationMode.COMPACT;
        }
        for (MdNode c : this.node.getNode()) {
            if (!c.getDefType().equals("com.stambia.wsdl.jws.signature")) continue;
            JWSBean.JWSSignature s = new JWSBean.JWSSignature(c.getName());
            this.bean.signatures.add(s);
            try {
                s.protectedHeaders.putAll(MdAttributeReader.readAttributeMap((String)"protectedHeader", (MdNode)c));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                s.unprotectedHeaders.putAll(MdAttributeReader.readAttributeMap((String)"unprotectedHeader", (MdNode)c));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void updateMdNode() throws Exception {
        MdNode dummyNode = this.node.copy(0);
        dummyNode.setName(this.bean.name);
        dummyNode.setSubstituteContainer(this.node.getSubstituteContainer());
        AttributeUtil.setAttribute((String)"payload", (Object)this.bean.payload, (MdNode)dummyNode, (MdNode)this.node);
        AttributeUtil.setAttribute((String)"secret", (Object)this.bean.secret, (MdNode)dummyNode, (MdNode)this.node);
        AttributeUtil.setAttribute((String)"jwsToken", (Object)this.bean.token, (MdNode)dummyNode, (MdNode)this.node);
        AttributeUtil.setAttribute((String)"serializationMode", (Object)this.bean.serializationMode.getLabel(), (MdNode)dummyNode, (MdNode)this.node);
        for (JWSBean.JWSSignature s : this.bean.getSignatures()) {
            MdNode c = MdFactoryHelper.createMdNode((String)"com.stambia.wsdl.jws.signature");
            c.setName(s.getSignatureName());
            dummyNode.getNode().add((Object)c);
            AttributeUtil.setAttribute((String)"protectedHeader", s.getProtectedHeaders(), (MdNode)c, (MdNode)this.node);
            AttributeUtil.setAttribute((String)"unprotectedHeader", s.getUnprotectedHeaders(), (MdNode)c, (MdNode)this.node);
        }
        HashMap<MdNode, MdNode> reversedObject = new HashMap<MdNode, MdNode>();
        reversedObject.put(dummyNode, this.node);
        ArrayList nonDeletableAttributes = new ArrayList();
        IncrementalReverser ir = new IncrementalReverser(this.node.eContainer(), reversedObject, nonDeletableAttributes, false, null, null, (IncrementalReverser.IReverseMatchingStrategy)IncrementalReverser.DefaulteverseMatchingStrategy.ByName, null, true);
        ir.reverse();
    }
}

