/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.oauth2.wizard;

import com.indy.addons.AttributeUtil;
import com.indy.addons.httprest.Messages;
import com.indy.addons.oauth2.wizard.AuthorizationCodeGrantBean;
import com.indy.addons.oauth2.wizard.AuthorizationCodeGrantFlow;
import com.indy.addons.oauth2.wizard.ClientCredentialGrantFlow;
import com.indy.addons.oauth2.wizard.OAuth2Wizard;
import com.indy.addons.oauth2.wizard.ResourceOwnerGrantBean;
import com.indy.addons.oauth2.wizard.ResourceOwnerGrantFlow;
import com.semarchy.xdi.base.core.auth.OAuth2;
import com.stambia.md.MdNode;
import com.stambia.md.custom.IncrementalReverser;
import com.stambia.md.util.MdAttributeReader;
import com.stambia.md.util.MdFactoryHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourceOwnerLinker
implements OAuth2Wizard.ILinker {
    private static final Logger logger = LogManager.getLogger(ResourceOwnerLinker.class);
    private static final String UNEXPECTED_LOG_MESSAGE = "unexpected";
    private MdNode node;
    private boolean refreshBean = false;
    private ResourceOwnerGrantBean bean = new ResourceOwnerGrantBean();
    private String _originalTokenURI = "";
    boolean isClientCredentialFlow = false;
    private OAuth2Wizard.FlowType flowType;

    public ResourceOwnerLinker(OAuth2Wizard.FlowType flowType) {
        this.flowType = flowType;
    }

    @Override
    public OAuth2Wizard.FlowType getFlowType() {
        return this.flowType;
    }

    @Override
    public void setNode(MdNode node) {
        this.node = node;
        this.refreshBean = true;
    }

    @Override
    public Object getBean() {
        if (this.refreshBean) {
            this.refreshBean();
            this.refreshBean = false;
        }
        return this.bean;
    }

    public String executeFlow() throws Exception {
        AuthorizationCodeGrantFlow.AccessTokenResponse response = null;
        if (this.isClientCredentialFlow) {
            ClientCredentialGrantFlow flow = new ClientCredentialGrantFlow((ResourceOwnerGrantBean)this.getBean());
            response = flow.getToken();
        } else {
            ResourceOwnerGrantFlow flow = new ResourceOwnerGrantFlow((ResourceOwnerGrantBean)this.getBean());
            response = flow.getToken();
        }
        this.bean.responseInfo = response.allInfos;
        return response.token;
    }

    private void refreshBean() {
        this.bean.name = this.node.getName() != null && !this.node.getName().isEmpty() ? this.node.getName() : null;
        try {
            this.bean.tokenURI = MdAttributeReader.readAttribute((String)"tokenEndpoint", (MdNode)this.node, (String)"");
        }
        catch (Exception ex) {
            logger.debug(UNEXPECTED_LOG_MESSAGE, (Throwable)ex);
        }
        this._originalTokenURI = this.bean.tokenURI;
        try {
            this.bean.userName = MdAttributeReader.readAttribute((String)"username", (MdNode)this.node, (String)"");
        }
        catch (Exception ex) {
            logger.debug(UNEXPECTED_LOG_MESSAGE, (Throwable)ex);
        }
        try {
            this.bean.password = MdAttributeReader.readAttribute((String)"password", (MdNode)this.node, (String)"");
        }
        catch (Exception ex) {
            logger.debug(UNEXPECTED_LOG_MESSAGE, (Throwable)ex);
        }
        try {
            this.bean.clientId = MdAttributeReader.readAttribute((String)"clientId", (MdNode)this.node, (String)"");
        }
        catch (Exception ex) {
            logger.debug(UNEXPECTED_LOG_MESSAGE, (Throwable)ex);
        }
        try {
            this.bean.clientSecret = MdAttributeReader.readAttribute((String)"clientSecret", (MdNode)this.node, (String)"");
        }
        catch (Exception ex) {
            logger.debug(UNEXPECTED_LOG_MESSAGE, (Throwable)ex);
        }
        String clientCredentialPolicy = null;
        try {
            clientCredentialPolicy = MdAttributeReader.readAttribute((String)"sendClientCredentialsPolicy", (MdNode)this.node, (String)"");
        }
        catch (Exception ex) {
            logger.debug(UNEXPECTED_LOG_MESSAGE, (Throwable)ex);
        }
        if ("".equals(clientCredentialPolicy)) {
            Boolean includeClientSecret = null;
            Boolean includeClientId = null;
            try {
                includeClientSecret = Boolean.valueOf(MdAttributeReader.readAttribute((String)"useClientSecret4TokenGeneration", (MdNode)this.node, (String)""));
            }
            catch (Exception ex) {
                logger.debug(UNEXPECTED_LOG_MESSAGE, (Throwable)ex);
            }
            try {
                includeClientId = Boolean.valueOf(MdAttributeReader.readAttribute((String)"useClientId4TokenGeneration", (MdNode)this.node, (String)""));
            }
            catch (Exception ex) {
                logger.debug(UNEXPECTED_LOG_MESSAGE, (Throwable)ex);
            }
            clientCredentialPolicy = Boolean.TRUE.equals(includeClientId) ? (Boolean.TRUE.equals(includeClientSecret) ? OAuth2.CredentialMode.PARAMETER_CLIENT_ID_AND_SECRET.getLabel() : OAuth2.CredentialMode.PARAMETER_CLIENT_ID.getLabel()) : OAuth2.CredentialMode.NONE.getLabel();
        }
        this.bean.credentialMode = OAuth2.CredentialMode.fromLabel((String)clientCredentialPolicy);
        try {
            this.bean.scopes = new ArrayList<String>(MdAttributeReader.readAttributeList((String)"scope", (MdNode)this.node));
        }
        catch (Exception ex) {
            logger.debug(UNEXPECTED_LOG_MESSAGE, (Throwable)ex);
        }
        try {
            this.bean.authParams = new HashMap<String, String>(MdAttributeReader.readAttributeMap((String)"authorizationParameter", (MdNode)this.node));
        }
        catch (Exception ex) {
            logger.debug(UNEXPECTED_LOG_MESSAGE, (Throwable)ex);
        }
        try {
            this.bean.additionalHeaders = new HashMap<String, String>(MdAttributeReader.readAttributeMap((String)"additionalHttpHeaders", (MdNode)this.node));
        }
        catch (Exception ex) {
            logger.debug(UNEXPECTED_LOG_MESSAGE, (Throwable)ex);
        }
        this.isClientCredentialFlow = false;
        try {
            String s = MdAttributeReader.readAttribute((String)"flowType", (MdNode)this.node, (String)"");
            if (OAuth2Wizard.FlowType.CLIENT_CREDENTIALS_GRANT.getValue().equals(s)) {
                this.isClientCredentialFlow = true;
            }
        }
        catch (Exception ex) {
            logger.debug(UNEXPECTED_LOG_MESSAGE, (Throwable)ex);
        }
        try {
            this.bean.httpMethod = MdAttributeReader.readAttribute((String)"tokenEndpointHttpMethod", (MdNode)this.node);
        }
        catch (Exception ex) {
            this.bean.httpMethod = "POST";
        }
        if (this.bean.httpMethod == null) {
            this.bean.httpMethod = "POST";
        }
        this.bean.enableHostnameVerification = this.getAttributeBooleanValue("enableHostnameVerification");
        this.bean.enableCertificateVerification = this.getAttributeBooleanValue("enableCertificateVerification");
        this.bean.preconfs.clear();
        boolean b = this._originalTokenURI.equals(AuthorizationCodeGrantBean.salesForceConf.tokenEndPoint);
        this.bean.preconfs.add(new AuthorizationCodeGrantBean.Preconf(Messages.ResourceOwnerLinker_15, null, this._originalTokenURI, b, b));
        this.bean.preconfs.add(new AuthorizationCodeGrantBean.Preconf(Messages.ResourceOwnerLinker_16, "", "", false, false));
        this.bean.preconfs.add(AuthorizationCodeGrantBean.googleConf);
        this.bean.preconfs.add(AuthorizationCodeGrantBean.linkedInConf);
        this.bean.preconfs.add(AuthorizationCodeGrantBean.salesForceConf);
    }

    @Override
    public void dispose() {
        this.node = null;
    }

    @Override
    public void updateMdNode() throws Exception {
        MdNode dummyNode = MdFactoryHelper.createMdNode((String)this.node.getDefType());
        dummyNode.setName(this.bean.name);
        dummyNode.setSubstituteContainer(this.node.getSubstituteContainer());
        AttributeUtil.setAttribute((String)"clientId", (Object)this.bean.clientId, (MdNode)dummyNode, (MdNode)this.node);
        AttributeUtil.setAttribute((String)"clientSecret", (Object)this.bean.clientSecret, (MdNode)dummyNode, (MdNode)this.node);
        AttributeUtil.setAttribute((String)"password", (Object)this.bean.password, (MdNode)dummyNode, (MdNode)this.node);
        AttributeUtil.setAttribute((String)"username", (Object)this.bean.userName, (MdNode)dummyNode, (MdNode)this.node);
        AttributeUtil.setAttribute((String)"scope", this.bean.scopes, (MdNode)dummyNode, (MdNode)this.node);
        AttributeUtil.setAttribute((String)"tokenEndpoint", (Object)this.bean.tokenURI, (MdNode)dummyNode, (MdNode)this.node);
        AttributeUtil.setAttribute((String)"authorizationParameter", this.bean.authParams, (MdNode)dummyNode, (MdNode)this.node);
        AttributeUtil.setAttribute((String)"additionalHttpHeaders", this.bean.additionalHeaders, (MdNode)dummyNode, (MdNode)this.node);
        AttributeUtil.setAttribute((String)"sendClientCredentialsPolicy", (Object)this.bean.credentialMode.getLabel(), (MdNode)dummyNode, (MdNode)this.node);
        AttributeUtil.setAttribute((String)"tokenEndpointHttpMethod", (Object)this.bean.httpMethod, (MdNode)dummyNode, (MdNode)this.node);
        AttributeUtil.setAttribute((String)"flowType", (Object)this.flowType.getValue(), (MdNode)dummyNode, (MdNode)this.node);
        HashMap<MdNode, MdNode> reversedObject = new HashMap<MdNode, MdNode>();
        reversedObject.put(dummyNode, this.node);
        IncrementalReverser ir = new IncrementalReverser(this.node.eContainer(), reversedObject, Collections.EMPTY_LIST, false, null, null, (IncrementalReverser.IReverseMatchingStrategy)IncrementalReverser.DefaulteverseMatchingStrategy.ByName, null, true);
        ir.reverse();
    }

    @Override
    public boolean canFinish() {
        return true;
    }

    private boolean getAttributeBooleanValue(String attributeName) {
        try {
            String attributeValue = MdAttributeReader.readAttribute((String)attributeName, (MdNode)this.node);
            if (attributeValue != null && !attributeValue.isEmpty()) {
                return Boolean.valueOf(attributeValue);
            }
        }
        catch (Exception ex) {
            logger.debug(UNEXPECTED_LOG_MESSAGE, (Throwable)ex);
        }
        return false;
    }
}

