/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.navigator.editor;

import com.indy.engine.log.exchange.DeliveryMapWrapper;
import com.indy.engine.log.object.impl.EngineRuntimeHeader;
import com.indy.ui.common.editor.input.DeliveryEditorInput;
import com.indy.ui.utils.DeliveryUtils;
import com.stambia.ui.navigator.editor.Messages;
import com.stambia.ui.tools.Utils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public abstract class DeliveryEditorPage
extends FormPage {
    private FormToolkit toolkit;
    private ScrolledForm form;
    private String deliveryName;
    private String deliveryId;
    private String configurationCode;
    private Map<String, Object> inParameters;
    private Map<String, Object> outParameters = new HashMap<String, Object>();
    private Map<String, Object> variables = new HashMap<String, Object>();
    private String host;
    private int port;
    private Text sessionName;
    private String processId;
    private String userName;
    private Date deliveryDate;
    private String version;
    private String description;
    private int nbColumuns;
    private String user;
    private String password;
    private String repoDir;
    private String partName;
    private String refreshScheduleId;
    private Realm realm;
    private CCombo logUnitCbx;
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());

    public DeliveryEditorPage(FormEditor editor) {
        super(editor, UUID.randomUUID().toString(), "");
        DeliveryEditorInput editorInput;
        EngineRuntimeHeader runtime;
        this.partName = editor.getPartName();
        this.refreshScheduleId = "delivery_session_auto_refresh_" + this.getId();
        this.realm = Realm.getDefault();
        if (editor.getEditorInput() instanceof DeliveryEditorInput && (runtime = (EngineRuntimeHeader)(editorInput = (DeliveryEditorInput)editor.getEditorInput()).getRuntimes().get(0)) != null) {
            try {
                this.host = runtime.getHost();
                this.port = runtime.getPort();
                this.user = runtime.getUser();
                this.password = runtime.getPassword();
                this.deliveryName = editorInput.getName();
                this.repoDir = editorInput.getRepoDir();
                DeliveryMapWrapper delivWrapper = (DeliveryMapWrapper)editorInput.getDeliveryWrapper().values().iterator().next();
                if (delivWrapper != null) {
                    this.inParameters = delivWrapper.getParameters();
                    this.configurationCode = delivWrapper.getConfigurationCode();
                    this.deliveryId = delivWrapper.getDeliveryId();
                    this.processId = delivWrapper.getProcessId();
                    this.userName = delivWrapper.getBuildUser();
                    this.deliveryDate = delivWrapper.getDeliveryDate();
                    this.version = delivWrapper.getVersion();
                    this.description = delivWrapper.getDescription();
                    this.version = delivWrapper.getVersion();
                    this.description = delivWrapper.getDescription();
                }
            }
            catch (Exception e) {
                this.logger.warn("unexpected", (Throwable)e);
            }
        }
    }

    public abstract void handledViewerChanged(Viewer var1);

    public void dispose() {
        super.dispose();
    }

    public void setActive(boolean active) {
        super.setActive(active);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.form = this.getManagedForm().getForm();
        this.toolkit = this.getManagedForm().getToolkit();
        this.nbColumuns = this.inParameters != null ? (this.inParameters.isEmpty() ? 1 : 2) : 1;
        GridLayoutFactory.fillDefaults().numColumns(this.nbColumuns).applyTo(this.form.getBody());
        this.createHeaderSection();
        this.createBodySection(this.form.getBody());
    }

    public String getDeliveryName() {
        return this.deliveryName;
    }

    private void createHeaderSection() {
        this.form.getForm().setText(this.deliveryName);
        this.toolkit.decorateFormHeading(this.form.getForm());
        Action execute = new Action(Messages.DeliveryEditorPage_2, null){

            public void run() {
                DeliveryEditorPage.this.executeDelivery();
            }
        };
        this.form.getToolBarManager().add((IAction)execute);
        this.form.getToolBarManager().update(true);
        this.form.getForm().getHead().setBackground(null);
    }

    private void createBodySection(Composite parent) {
        Section section = Utils.createSection((FormToolkit)this.toolkit, (Composite)parent, (String)Messages.DeliveryEditorPage_3);
        section.setLayout((Layout)new GridLayout());
        section.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite comp = this.toolkit.createComposite((Composite)section);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createScheduleComposite(comp);
        if (this.inParameters != null && !this.inParameters.isEmpty()) {
            Section Parametersection = Utils.createSection((FormToolkit)this.toolkit, (Composite)parent, (String)Messages.DeliveryEditorPage_4);
            Parametersection.setLayout((Layout)new GridLayout());
            Parametersection.setLayoutData((Object)new GridData(-1, -1, false, false));
            Composite Parametercomp = this.toolkit.createComposite((Composite)Parametersection);
            Parametercomp.setLayout((Layout)new GridLayout());
            Parametercomp.setLayoutData((Object)new GridData());
            this.createParameterComposite(Parametercomp);
            Parametersection.setClient((Control)Parametercomp);
        }
        section.setClient((Control)comp);
    }

    private void createParameterComposite(Composite parent) {
        Composite comp = this.toolkit.createComposite(parent);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(1808));
        TreeMap<String, Object> sortedParameters = new TreeMap<String, Object>(this.inParameters);
        for (final String key : sortedParameters.keySet()) {
            this.toolkit.createLabel(comp, String.valueOf(key) + " :");
            String value = (String)((Map)sortedParameters.get(key)).get("value");
            this.variables.put("/*/" + key, value);
            final Text paramValue = this.toolkit.createText(comp, value);
            paramValue.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    DeliveryEditorPage.this.variables.remove("/*/" + key);
                    DeliveryEditorPage.this.variables.put("/*/" + key, paramValue.getText());
                }
            });
            paramValue.setLayoutData((Object)new GridData(100, -1));
        }
    }

    private void createScheduleComposite(Composite parent) {
        Composite comp = this.toolkit.createComposite(parent);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite left = this.toolkit.createComposite(comp);
        left.setLayout((Layout)new GridLayout(2, false));
        left.setLayoutData((Object)new GridData());
        this.toolkit.createLabel(left, Messages.DeliveryEditorPage_0);
        this.toolkit.createLabel(left, this.deliveryName);
        this.toolkit.createLabel(left, Messages.DeliveryEditorPage_14);
        new Text(left, 8).setText(this.deliveryId);
        this.toolkit.createLabel(left, Messages.DeliveryEditorPage_15);
        this.toolkit.createLabel(left, this.configurationCode);
        Composite right = this.toolkit.createComposite(comp);
        right.setLayout((Layout)new GridLayout(2, false));
        right.setLayoutData((Object)new GridData());
        if (this.userName != null) {
            this.toolkit.createLabel(right, Messages.DeliveryEditorPage_16);
            this.toolkit.createLabel(right, this.userName);
        }
        if (this.deliveryDate != null) {
            this.toolkit.createLabel(right, Messages.DeliveryEditorPage_17);
            this.toolkit.createLabel(right, this.deliveryDate.toString());
        }
        if (this.version != null) {
            this.toolkit.createLabel(right, Messages.DeliveryEditorPage_18);
            this.toolkit.createLabel(right, this.version);
        }
        if (this.description != null) {
            this.toolkit.createLabel(right, Messages.DeliveryEditorPage_19);
            Label label = this.toolkit.createLabel(right, this.description);
            label.setToolTipText(this.description);
        }
        Composite sessComp = this.toolkit.createComposite(comp);
        sessComp.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        sessComp.setLayoutData((Object)gd);
        this.toolkit.createLabel(sessComp, Messages.DeliveryEditorPage_20);
        this.sessionName = this.toolkit.createText(sessComp, "", 0);
        this.sessionName.setText(this.deliveryName);
        this.sessionName.setLayoutData((Object)new GridData(4, 4, true, false));
        String[] items = new String[]{"", "-3", "-2", "-1", "0", "100", "200", "300", "400"};
        Composite logComp = sessComp;
        logComp.setLayout((Layout)new GridLayout(2, false));
        logComp.setLayoutData((Object)gd);
        this.toolkit.createLabel(logComp, Messages.DeliveryEditorPage_1);
        this.logUnitCbx = new CCombo(logComp, 2056);
        this.logUnitCbx.setEditable(false);
        this.logUnitCbx.setEnabled(true);
        this.logUnitCbx.setItems(items);
        this.logUnitCbx.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    private void executeDelivery() {
        DeliveryUtils.executeDelivery((String)this.host, (int)this.port, (String)this.user, (String)this.password, (String)this.deliveryName, (String)this.sessionName.getText(), this.variables, (String[])this.configurationCode.split(" "), (String)this.repoDir, (String)"400");
    }

    public abstract void handleCurrentViewerSelection(Viewer var1);

    public abstract void handleRefresh();
}

